/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.disk;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileTimesView;
import jkcemu.base.FileTimesViewFactory;
import jkcemu.disk.DiskUtil;

public class DiskImgCreator {
    private FileTimesViewFactory ftvFactory;
    private boolean blockNum16Bit;
    private int blockSize;
    private int dirBlocks;
    private int begDirArea;
    private int begFileArea;
    private int dstDirPos;
    private int dstFilePos;
    private int blockNum;
    private int begTimeFile;
    private int dstTimeFile;
    private int endTimeFile;
    private Calendar calendar;
    private byte[] diskBuf;

    public DiskImgCreator(FileTimesViewFactory fileTimesViewFactory, int n, int n2, int n3, int n4, int n5, boolean bl, int n6, int n7, boolean bl2) throws IOException {
        this.ftvFactory = fileTimesViewFactory;
        this.blockNum16Bit = bl;
        this.blockSize = n6;
        this.dirBlocks = n7;
        this.diskBuf = new byte[n * n2 * n4 * n5];
        this.begDirArea = n3 * n * n4 * n5;
        this.begFileArea = this.begDirArea + this.dirBlocks * this.blockSize;
        this.dstDirPos = this.begDirArea;
        this.dstFilePos = this.begFileArea;
        this.blockNum = this.dirBlocks;
        this.begTimeFile = -1;
        this.dstTimeFile = -1;
        this.endTimeFile = -1;
        this.calendar = null;
        if (this.begDirArea > 0) {
            Arrays.fill(this.diskBuf, 0, Math.min(this.begDirArea, this.diskBuf.length), (byte)0);
        }
        if (this.begDirArea < this.diskBuf.length) {
            Arrays.fill(this.diskBuf, this.begDirArea, this.diskBuf.length, (byte)-27);
        }
        if (bl2) {
            byte[] byArray = new byte[this.dirBlocks * this.blockSize / 2];
            Arrays.fill(byArray, (byte)0);
            String string = "!!!TIME\u0092";
            int n8 = string.length();
            int n9 = 0;
            for (int i = 15; i < byArray.length; i += 16) {
                if (n9 >= n8) {
                    n9 = 0;
                }
                byArray[i] = (byte)string.charAt(n9++);
            }
            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
                this.begTimeFile = this.dstFilePos;
                this.addFile(0, "!!!TIME&.DAT", byteArrayInputStream, false, false, false, null);
                this.dstTimeFile = this.begTimeFile + 16;
                this.endTimeFile = this.dstFilePos;
            }
            this.calendar = Calendar.getInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(int n, String string, File file, boolean bl, boolean bl2, boolean bl3) throws IOException {
        if (string != null && file != null) {
            if (this.begTimeFile >= 0 && string.equals("!!!TIME&.DAT")) {
                throw new IOException("Bei einem Diskettenformat mit DateStamper-Unterst\u00fctzung\nwerden die Zeitstempel in der Datei !!!TIME&.DAT gespeichert.\nDiese Datei wird automatisch angelegt und kann deshalb\nnicht vom Anwender hinzugef\u00fcgt werden.");
            }
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                this.addFile(n, string, bufferedInputStream, bl, bl2, bl3, this.ftvFactory.getFileTimesView(file));
            }
            catch (Throwable throwable) {
                EmuUtil.closeSilent(bufferedInputStream);
                throw throwable;
            }
            EmuUtil.closeSilent(bufferedInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillSysTracks(File file) throws IOException {
        if (file != null) {
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                int n = 0;
                int n2 = ((InputStream)bufferedInputStream).read();
                while (n2 >= 0) {
                    if (n >= this.begDirArea) {
                        throw new IOException("Datei f\u00fcr Systemspuren ist zu gro\u00df!");
                    }
                    this.diskBuf[n++] = (byte)n2;
                    n2 = ((InputStream)bufferedInputStream).read();
                }
            }
            catch (Throwable throwable) {
                EmuUtil.closeSilent(bufferedInputStream);
                throw throwable;
            }
            EmuUtil.closeSilent(bufferedInputStream);
        }
    }

    public byte[] getPlainDiskByteBuffer() {
        if (this.begTimeFile >= 0 && this.begTimeFile < this.endTimeFile) {
            int n = this.begTimeFile;
            while (n < this.endTimeFile) {
                int n2 = 0;
                for (int i = 0; i < 127 && n < this.endTimeFile; ++i) {
                    n2 += this.diskBuf[n++] & 0xFF;
                }
                if (n >= this.endTimeFile) continue;
                this.diskBuf[n++] = (byte)n2;
            }
        }
        return this.diskBuf;
    }

    private int addDirEntry(int n, String string, boolean bl, boolean bl2, boolean bl3, FileTimesView fileTimesView, int n2) throws IOException {
        int n3;
        if (this.dstDirPos >= this.begFileArea) {
            throw new IOException("Directory voll");
        }
        int n4 = this.dstDirPos;
        this.diskBuf[this.dstDirPos++] = (byte)(n & 0xF);
        int[] nArray = new int[]{8, 3};
        int n5 = string.length();
        int n6 = 0;
        for (n3 = 0; n3 < nArray.length; ++n3) {
            char c;
            int n7;
            for (n7 = nArray[n3]; n6 < n5 && n7 > 0 && (c = string.charAt(n6++)) != '.'; --n7) {
                this.diskBuf[this.dstDirPos++] = (byte)c;
            }
            while (n7 > 0) {
                this.diskBuf[this.dstDirPos++] = 32;
                --n7;
            }
            if (n6 >= n5 || string.charAt(n6) != '.') continue;
            ++n6;
        }
        this.diskBuf[this.dstDirPos++] = (byte)(n2 & 0x1F);
        this.diskBuf[this.dstDirPos++] = 0;
        this.diskBuf[this.dstDirPos++] = (byte)(n2 >> 5 & 0x3F);
        if (bl) {
            int n8 = n4 + 9;
            this.diskBuf[n8] = (byte)(this.diskBuf[n8] | 0x80);
        }
        if (bl2) {
            int n9 = n4 + 10;
            this.diskBuf[n9] = (byte)(this.diskBuf[n9] | 0x80);
        }
        if (bl3) {
            int n10 = n4 + 11;
            this.diskBuf[n10] = (byte)(this.diskBuf[n10] | 0x80);
        }
        for (n3 = 0; n3 < 17; ++n3) {
            this.diskBuf[this.dstDirPos++] = 0;
        }
        if (this.dstTimeFile >= 0 && this.dstTimeFile < this.endTimeFile) {
            if (fileTimesView != null) {
                this.writeTimeEntry(fileTimesView.getCreationMillis());
                this.writeTimeEntry(fileTimesView.getLastAccessMillis());
                this.writeTimeEntry(fileTimesView.getLastModifiedMillis());
                ++this.dstTimeFile;
            } else {
                this.dstTimeFile += 16;
            }
        }
        return n4;
    }

    private void addFile(int n, String string, InputStream inputStream, boolean bl, boolean bl2, boolean bl3, FileTimesView fileTimesView) throws IOException {
        int n2 = 0;
        int n3 = inputStream.read();
        if (n3 >= 0) {
            int n4 = DiskUtil.getExtentsPerDirEntry(this.blockSize, this.blockNum16Bit);
            while (n3 >= 0) {
                int n5;
                int n6;
                int n7;
                int n8;
                if (n2 >= 2048) {
                    DiskImgCreator.throwFileTooBig(string);
                }
                int n9 = this.addDirEntry(n, string, bl, bl2, bl3, fileTimesView, n2);
                int n10 = n9 + 16;
                int n11 = n8 = this.dstFilePos;
                int n12 = n7 = this.blockNum16Bit ? 8 : 16;
                while (n7 > 0 && n3 >= 0) {
                    for (n6 = this.blockSize; n6 > 0 && n3 >= 0; --n6) {
                        if (this.dstFilePos >= this.diskBuf.length) {
                            throw new IOException("Das ausgew\u00e4hlten Diskettenformat bietet nicht gen\u00fcgend Platz.");
                        }
                        this.diskBuf[this.dstFilePos++] = (byte)n3;
                        n3 = inputStream.read();
                    }
                    n11 = this.dstFilePos;
                    n5 = this.dstFilePos + 127 & 0xFFFFFF80;
                    if (n5 > this.diskBuf.length) {
                        n5 = this.diskBuf.length;
                    }
                    while (n6 > 0 && this.dstFilePos < n5) {
                        this.diskBuf[this.dstFilePos++] = 26;
                        --n6;
                    }
                    while (n6 > 0 && this.dstFilePos < this.diskBuf.length) {
                        this.diskBuf[this.dstFilePos++] = 0;
                        --n6;
                    }
                    if (this.blockNum16Bit) {
                        this.diskBuf[n10++] = (byte)(this.blockNum & 0xFF);
                        this.diskBuf[n10++] = (byte)(this.blockNum >> 8 & 0xFF);
                        ++this.blockNum;
                        if (this.blockNum > 65535) {
                            DiskImgCreator.throwFileTooBig(string);
                        }
                    } else {
                        this.diskBuf[n10++] = (byte)this.blockNum++;
                        if (this.blockNum > 255) {
                            DiskImgCreator.throwFileTooBig(string);
                        }
                    }
                    --n7;
                }
                n6 = (n11 - n8 + 127) / 128;
                n5 = n6 % 128;
                if (n6 > 0 && n5 == 0) {
                    n5 = 128;
                }
                int n13 = (n6 + 127) / 128;
                int n14 = n2;
                if (n13 > 1 && n13 <= n4) {
                    n14 = n2 + n13 - 1;
                }
                this.diskBuf[n9 + 12] = (byte)(n14 & 0x1F);
                this.diskBuf[n9 + 14] = (byte)(n14 >> 5 & 0x3F);
                this.diskBuf[n9 + 15] = (byte)n5;
                n2 += n4;
            }
        } else {
            this.addDirEntry(n, string, bl, bl2, bl3, fileTimesView, n2);
        }
    }

    private static void throwFileTooBig(String string) throws IOException {
        throw new IOException(string + ": Datei zu gro\u00df!");
    }

    private static byte toBcdByte(int n) {
        return (byte)(n / 10 % 10 << 4 & 0xF0 | n % 10 & 0xF);
    }

    private void writeTimeEntry(Long l) {
        if (this.dstTimeFile + 4 < this.endTimeFile) {
            boolean bl = false;
            if (this.calendar != null && l != null) {
                this.calendar.clear();
                this.calendar.setTimeInMillis(l);
                int n = this.calendar.get(1);
                if (n >= 1978 && n < 2078) {
                    this.diskBuf[this.dstTimeFile++] = DiskImgCreator.toBcdByte(n);
                    this.diskBuf[this.dstTimeFile++] = DiskImgCreator.toBcdByte(this.calendar.get(2) + 1);
                    this.diskBuf[this.dstTimeFile++] = DiskImgCreator.toBcdByte(this.calendar.get(5));
                    this.diskBuf[this.dstTimeFile++] = DiskImgCreator.toBcdByte(this.calendar.get(11));
                    this.diskBuf[this.dstTimeFile++] = DiskImgCreator.toBcdByte(this.calendar.get(12));
                    bl = true;
                }
            }
            if (!bl) {
                this.dstTimeFile += 5;
            }
        }
    }
}

