/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.disk;

import java.io.File;
import java.util.Arrays;
import java.util.Calendar;
import jkcemu.base.FileTimesView;
import jkcemu.base.FileTimesViewFactory;

public class DateStamper {
    public static final String ENTRYNAME = "!!!TIME&DAT";
    public static final String FILENAME = "!!!TIME&.DAT";
    private static Calendar calendar = Calendar.getInstance();
    private FileTimesViewFactory ftvFactory;
    private byte[] dateTimeBytes;
    private int dateTimeLen;
    private int pos;

    public DateStamper(FileTimesViewFactory fileTimesViewFactory, int n, byte[] byArray) {
        this.ftvFactory = fileTimesViewFactory;
        this.dateTimeLen = n * 16;
        this.dateTimeBytes = byArray != null ? byArray : new byte[n * 16];
        if (this.dateTimeLen < this.dateTimeBytes.length) {
            Arrays.fill(this.dateTimeBytes, 0, this.dateTimeLen, (byte)0);
        } else {
            Arrays.fill(this.dateTimeBytes, (byte)0);
            this.dateTimeLen = this.dateTimeBytes.length;
        }
        String string = "!!!TIME\u0092";
        int n2 = string.length();
        int n3 = 0;
        for (int i = 15; i < this.dateTimeLen; i += 16) {
            if (n3 >= n2) {
                n3 = 0;
            }
            this.dateTimeBytes[i] = (byte)string.charAt(n3++);
        }
    }

    public void addFileTimes(File file) {
        FileTimesView fileTimesView = null;
        if (file != null) {
            fileTimesView = this.ftvFactory.getFileTimesView(file);
        }
        if (fileTimesView != null) {
            this.writeDateTimeEntry(fileTimesView.getCreationMillis());
            this.writeDateTimeEntry(fileTimesView.getLastAccessMillis());
            this.writeDateTimeEntry(fileTimesView.getLastModifiedMillis());
        } else {
            for (int i = 0; i < 15; ++i) {
                if (this.pos >= this.dateTimeLen || this.pos >= this.dateTimeBytes.length) continue;
                this.dateTimeBytes[this.pos++] = 0;
            }
        }
        ++this.pos;
    }

    public byte[] getDateTimeByteBuffer() {
        int n = 0;
        while (n < this.dateTimeLen) {
            int n2 = 0;
            for (int i = 0; i < 127 && n < this.dateTimeLen; ++i) {
                n2 += this.dateTimeBytes[n++] & 0xFF;
            }
            if (n >= this.dateTimeLen) continue;
            this.dateTimeBytes[n++] = (byte)n2;
        }
        return this.dateTimeBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getMillis(byte[] byArray, int n) {
        Long l = null;
        if (byArray != null && n >= 0 && n + 4 < byArray.length) {
            int n2 = DateStamper.fromBcdByte(byArray[n]);
            int n3 = DateStamper.fromBcdByte(byArray[n + 1]);
            int n4 = DateStamper.fromBcdByte(byArray[n + 2]);
            int n5 = DateStamper.fromBcdByte(byArray[n + 3]);
            int n6 = DateStamper.fromBcdByte(byArray[n + 4]);
            n2 = n2 >= 78 ? (n2 += 1900) : (n2 += 2000);
            if (n3 >= 1 && n3 <= 12 && n4 >= 1 && n4 <= 31 && n5 < 24 && n6 < 60) {
                boolean bl = true;
                if (n3 == 2) {
                    if (n2 % 4 == 0 && n2 % 100 != 0) {
                        if (n4 > 29) {
                            bl = false;
                        }
                    } else if (n4 > 28) {
                        bl = false;
                    }
                } else if ((n3 == 4 || n3 == 6 || n3 == 9 || n3 == 11) && n4 > 30) {
                    bl = false;
                }
                if (bl) {
                    Calendar calendar = DateStamper.calendar;
                    synchronized (calendar) {
                        DateStamper.calendar.clear();
                        DateStamper.calendar.set(n2, n3 - 1, n4, n5, n6);
                        l = DateStamper.calendar.getTimeInMillis();
                    }
                }
            }
        }
        return l;
    }

    private static int fromBcdByte(byte by) {
        return (by >> 4 & 0xF) * 10 + (by & 0xF);
    }

    private static byte toBcdByte(int n) {
        return (byte)(n / 10 % 10 << 4 & 0xF0 | n % 10 & 0xF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDateTimeEntry(Long l) {
        int n = Math.min(this.dateTimeLen, this.dateTimeBytes.length);
        if (this.pos + 4 < n) {
            boolean bl = false;
            if (l != null) {
                Calendar calendar = DateStamper.calendar;
                synchronized (calendar) {
                    DateStamper.calendar.clear();
                    DateStamper.calendar.setTimeInMillis(l);
                    int n2 = DateStamper.calendar.get(1);
                    if (n2 >= 1978 && n2 < 2078) {
                        this.dateTimeBytes[this.pos++] = DateStamper.toBcdByte(n2);
                        this.dateTimeBytes[this.pos++] = DateStamper.toBcdByte(DateStamper.calendar.get(2) + 1);
                        this.dateTimeBytes[this.pos++] = DateStamper.toBcdByte(DateStamper.calendar.get(5));
                        this.dateTimeBytes[this.pos++] = DateStamper.toBcdByte(DateStamper.calendar.get(11));
                        this.dateTimeBytes[this.pos++] = DateStamper.toBcdByte(DateStamper.calendar.get(12));
                        bl = true;
                    }
                }
            }
            if (!bl) {
                for (int i = 0; i < 15; ++i) {
                    this.dateTimeBytes[this.pos++] = 0;
                }
            }
        }
    }
}

