/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.disk;

import java.awt.Frame;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import jkcemu.base.EmuUtil;
import jkcemu.disk.AbstractFloppyDisk;
import jkcemu.disk.SectorData;
import jkcemu.disk.SectorID;

public class CPCDisk
extends AbstractFloppyDisk {
    private static final String FILE_HEADER_EXT = "EXTENDED CPC DSK File\r\nDisk-Info\r\n";
    private static final String FILE_HEADER_STD = "MV - CPCEMU Disk-File\r\nDisk-Info\r\n";
    private static final int MAX_SECTORS_PER_TRACK = 29;
    private static final String TRACK_HEADER = "Track-Info\r\n";
    private String fileName;
    private boolean resource;
    private boolean extendedFmt;
    private int trackSize;
    private FileLock fileLock;
    private RandomAccessFile raf;
    private Map<Integer, TrackData> side0;
    private Map<Integer, TrackData> side1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String export(AbstractFloppyDisk abstractFloppyDisk, File file) throws IOException {
        int n;
        SectorData[] sectorDataArray;
        int n2;
        int n3;
        int n4;
        StringBuilder stringBuilder = null;
        int n5 = abstractFloppyDisk.getCylinders();
        if (n5 < 0 || n5 > 255) {
            throw new IOException(String.format("%d Zylinder nicht unterst\u00fctzt", n5));
        }
        int n6 = abstractFloppyDisk.getSides();
        if (n6 < 1 || n6 > 2) {
            throw new IOException(String.format("%d Seiten nicht unterst\u00fctzt", n6));
        }
        int n7 = abstractFloppyDisk.getSectorsPerCylinder();
        if (n7 < 0 || n7 > 255) {
            throw new IOException(String.format("%d Sektoren pro Zylinder nicht unterst\u00fctzt", n7));
        }
        int n8 = abstractFloppyDisk.getSectorSize();
        int n9 = CPCDisk.getSectorSizeCode(n8);
        int n10 = abstractFloppyDisk.getDiskSize() * 5 / 4 + 16384;
        boolean bl = false;
        boolean bl2 = false;
        SectorData[][] sectorDataArrayArray = new SectorData[n5 * n6][];
        Arrays.fill((Object[])sectorDataArrayArray, null);
        int n11 = 0;
        for (int i = 0; i < n5; ++i) {
            for (n4 = 0; n4 < n6; ++n4) {
                n3 = abstractFloppyDisk.getSectorsOfCylinder(i, n4);
                if (n3 < 0 || n3 > 29) {
                    throw new IOException(String.format("Seite %d, Spur %d: %d Sektoren nicht unterst\u00fctzt", n4 + 1, i, n3));
                }
                if (n3 != n7) {
                    bl = true;
                }
                SectorData[] sectorDataArray2 = new SectorData[n3];
                for (n2 = 0; n2 < sectorDataArray2.length; ++n2) {
                    sectorDataArray = abstractFloppyDisk.getSectorByIndex(i, n4, n2);
                    if (sectorDataArray == null) {
                        throw new IOException(String.format("Seite %d, Spur %d: Sektor %d nicht gefunden", n4 + 1, i, n2 + 1));
                    }
                    if (sectorDataArray.checkError() || sectorDataArray.hasBogusID() || sectorDataArray.isDeleted()) {
                        if (stringBuilder == null) {
                            stringBuilder = new StringBuilder(1024);
                        }
                        stringBuilder.append(String.format("Seite %d, Spur %d, Sektor %d:", n4 + 1, i, sectorDataArray.getSectorNum()));
                        n = 0;
                        if (sectorDataArray.hasBogusID()) {
                            stringBuilder.append(" Sektor-ID generiert");
                            n = 1;
                        }
                        if (sectorDataArray.checkError()) {
                            if (n != 0) {
                                stringBuilder.append(',');
                            }
                            stringBuilder.append(" CRC-Fehler");
                            n = 1;
                        }
                        if (sectorDataArray.isDeleted()) {
                            if (n != 0) {
                                stringBuilder.append(',');
                            }
                            stringBuilder.append(" als gel\u00f6scht markiert");
                            n = 1;
                            bl2 = true;
                        }
                        stringBuilder.append('\n');
                    }
                    if (sectorDataArray.getSizeCode() != n9 || sectorDataArray.getDataLength() != n8) {
                        bl = true;
                    }
                    sectorDataArray2[n2] = sectorDataArray;
                }
                sectorDataArrayArray[n11++] = sectorDataArray2;
            }
        }
        if (!bl) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n10);
            try {
                n4 = 256 + n7 * n8;
                EmuUtil.writeASCII(byteArrayOutputStream, FILE_HEADER_STD);
                EmuUtil.writeFixLengthASCII(byteArrayOutputStream, "JKCEMU", 14, 0);
                byteArrayOutputStream.write(n5);
                byteArrayOutputStream.write(n6);
                byteArrayOutputStream.write(n4 & 0xFF);
                byteArrayOutputStream.write(n4 >> 8);
                for (n3 = byteArrayOutputStream.size(); n3 < 256; ++n3) {
                    byteArrayOutputStream.write(0);
                }
                for (n3 = 0; n3 < sectorDataArrayArray.length; ++n3) {
                    int n12 = n3 / n6;
                    n2 = n3 % n6;
                    sectorDataArray = sectorDataArrayArray[n3];
                    if (sectorDataArray.length != n7) {
                        bl = true;
                        break;
                    }
                    n = byteArrayOutputStream.size();
                    EmuUtil.writeFixLengthASCII(byteArrayOutputStream, TRACK_HEADER, 16, 0);
                    byteArrayOutputStream.write(n12);
                    byteArrayOutputStream.write(n2);
                    byteArrayOutputStream.write(0);
                    byteArrayOutputStream.write(0);
                    byteArrayOutputStream.write(n9);
                    byteArrayOutputStream.write(sectorDataArray.length);
                    byteArrayOutputStream.write(78);
                    byteArrayOutputStream.write(229);
                    for (SectorData sectorData : sectorDataArray) {
                        if (sectorData.getDataLength() != n8) {
                            bl = true;
                            break;
                        }
                        byteArrayOutputStream.write(sectorData.getCylinder());
                        byteArrayOutputStream.write(sectorData.getHead());
                        byteArrayOutputStream.write(sectorData.getSectorNum());
                        byteArrayOutputStream.write(n9);
                        byteArrayOutputStream.write(0);
                        byteArrayOutputStream.write(0);
                        byteArrayOutputStream.write(0);
                        byteArrayOutputStream.write(0);
                    }
                    for (int i = byteArrayOutputStream.size() - n; i < 256; ++i) {
                        byteArrayOutputStream.write(0);
                    }
                    SectorData[] sectorDataArray3 = sectorDataArray;
                    int n13 = sectorDataArray3.length;
                    for (int i = 0; i < n13; ++i) {
                        SectorData sectorData;
                        sectorData = sectorDataArray3[i];
                        int n14 = 0;
                        if (sectorData != null) {
                            n14 = sectorData.writeTo(byteArrayOutputStream, n8);
                        }
                        for (int j = n14; j < n8; ++j) {
                            byteArrayOutputStream.write(0);
                        }
                    }
                }
            }
            finally {
                EmuUtil.closeSilent(byteArrayOutputStream);
            }
            if (!bl) {
                OutputStream outputStream = null;
                try {
                    outputStream = EmuUtil.createOptionalGZipOutputStream(file);
                    byteArrayOutputStream.writeTo(outputStream);
                    outputStream.close();
                    outputStream = null;
                }
                finally {
                    EmuUtil.closeSilent(outputStream);
                }
            }
        }
        if (bl) {
            OutputStream outputStream = null;
            try {
                int n15;
                outputStream = EmuUtil.createOptionalGZipOutputStream(file);
                EmuUtil.writeASCII(outputStream, FILE_HEADER_EXT);
                EmuUtil.writeFixLengthASCII(outputStream, "JKCEMU", 14, 0);
                outputStream.write(n5);
                outputStream.write(n6);
                outputStream.write(0);
                outputStream.write(0);
                for (SectorData[] sectorDataArray4 : sectorDataArrayArray) {
                    int n16 = 0;
                    for (SectorData sectorData : sectorDataArray4) {
                        n16 += sectorData.getDataLength();
                    }
                    outputStream.write(n16 > 0 ? n16 + 511 >> 8 : 0);
                }
                for (n15 = 52 + sectorDataArrayArray.length; n15 < 256; ++n15) {
                    outputStream.write(0);
                }
                for (n15 = 0; n15 < sectorDataArrayArray.length; ++n15) {
                    n3 = n15 / n6;
                    int n17 = n15 % n6;
                    SectorData[] sectorDataArray5 = sectorDataArrayArray[n15];
                    EmuUtil.writeFixLengthASCII(outputStream, TRACK_HEADER, 16, 0);
                    outputStream.write(n3);
                    outputStream.write(n17);
                    outputStream.write(0);
                    outputStream.write(0);
                    outputStream.write(n9);
                    outputStream.write(sectorDataArray5.length);
                    outputStream.write(78);
                    outputStream.write(229);
                    SectorData[] sectorDataArray6 = sectorDataArray5;
                    int n18 = sectorDataArray6.length;
                    for (int i = 0; i < n18; ++i) {
                        SectorData sectorData = sectorDataArray6[i];
                        outputStream.write(sectorData.getCylinder());
                        outputStream.write(sectorData.getHead());
                        outputStream.write(sectorData.getSectorNum());
                        outputStream.write(n9);
                        outputStream.write(0);
                        outputStream.write(0);
                        int n19 = sectorData.getDataLength();
                        outputStream.write(n19 & 0xFF);
                        outputStream.write(n19 >> 8);
                    }
                    for (int i = sectorDataArray5.length; i < 29; ++i) {
                        for (n18 = 0; n18 < 8; ++n18) {
                            outputStream.write(0);
                        }
                    }
                    for (SectorData sectorData : sectorDataArray5) {
                        sectorData.writeTo(outputStream, sectorData.getDataLength());
                    }
                }
                outputStream.close();
                outputStream = null;
            }
            finally {
                EmuUtil.closeSilent(outputStream);
            }
        }
        if (stringBuilder != null) {
            stringBuilder.append("\nDie angezeigten Informationen k\u00f6nnen in einer CPC-Disk-Datei nicht gespeichert werden\nund sind deshalb in der erzeugten Datei nicht mehr enthalten.\n");
            if (bl2) {
                stringBuilder.append("\nGel\u00f6schte Sektoren werden in CPC-Disk-Dateien nicht unterst\u00fctzt\nund sind deshalb als normale Sektoren enthalten.\n");
            }
        }
        return stringBuilder != null ? stringBuilder.toString() : null;
    }

    public static boolean isCPCDiskFileHeader(byte[] byArray) {
        return CPCDisk.isDiskFileHeader(byArray, FILE_HEADER_STD) || CPCDisk.isDiskFileHeader(byArray, FILE_HEADER_EXT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CPCDisk newFile(Frame frame, File file) throws IOException {
        CPCDisk cPCDisk = null;
        FileLock fileLock = null;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            fileLock = EmuUtil.lockFile(file, randomAccessFile);
            randomAccessFile.setLength(0L);
            randomAccessFile.seek(0L);
            cPCDisk = new CPCDisk(frame, 0, 0, 0, 0, file.getPath(), false, false, 0, randomAccessFile, fileLock, null, null);
            if (cPCDisk != null) return cPCDisk;
        }
        catch (Throwable throwable) {
            if (cPCDisk != null) throw throwable;
            EmuUtil.releaseSilent(fileLock);
            EmuUtil.closeSilent(randomAccessFile);
            throw throwable;
        }
        EmuUtil.releaseSilent(fileLock);
        EmuUtil.closeSilent(randomAccessFile);
        return cPCDisk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CPCDisk openFile(Frame frame, File file) throws IOException {
        CPCDisk cPCDisk = null;
        FileLock fileLock = null;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            fileLock = EmuUtil.lockFile(file, randomAccessFile);
            cPCDisk = CPCDisk.createInstance(frame, null, randomAccessFile, fileLock, file.getPath(), false);
            if (cPCDisk != null) return cPCDisk;
        }
        catch (Throwable throwable) {
            if (cPCDisk != null) throw throwable;
            EmuUtil.releaseSilent(fileLock);
            EmuUtil.closeSilent(randomAccessFile);
            throw throwable;
        }
        EmuUtil.releaseSilent(fileLock);
        EmuUtil.closeSilent(randomAccessFile);
        return cPCDisk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CPCDisk readFile(Frame frame, File file) throws IOException {
        CPCDisk cPCDisk = null;
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            if (EmuUtil.isGZipFile(file)) {
                inputStream = new GZIPInputStream(inputStream);
            }
            cPCDisk = CPCDisk.createInstance(frame, inputStream, null, null, file.getPath(), false);
        }
        finally {
            if (cPCDisk == null) {
                EmuUtil.closeSilent(inputStream);
            }
        }
        return cPCDisk;
    }

    @Override
    public synchronized void closeSilent() {
        EmuUtil.releaseSilent(this.fileLock);
        EmuUtil.closeSilent(this.raf);
    }

    @Override
    public boolean formatTrack(int n, int n2, SectorID[] sectorIDArray, byte[] byArray) {
        boolean bl = false;
        n2 &= 1;
        if (this.raf != null && sectorIDArray != null && byArray != null && sectorIDArray.length > 0) {
            try {
                int n3;
                int n4;
                long l;
                if (n2 == 1 && this.getSides() < 2 && this.getCylinders() > 1) {
                    throw new IOException("Nachtr\u00e4gliches Formatieren der zweiten Seite nicht unterstuetzt");
                }
                int n5 = 511 + sectorIDArray.length * byArray.length & 0xFF00;
                if (this.getCylinders() == 0) {
                    int n6;
                    this.setCylinders(0);
                    this.setSides(0);
                    this.setSectorSize(0);
                    this.setSectorsPerCylinder(0);
                    this.extendedFmt = false;
                    this.trackSize = n5;
                    if (this.side0 != null) {
                        this.side0.clear();
                    }
                    if (this.side1 != null) {
                        this.side1.clear();
                    }
                    this.raf.setLength(0L);
                    this.raf.seek(0L);
                    this.raf.writeBytes(FILE_HEADER_STD);
                    this.raf.writeBytes("JKCEMU");
                    for (n6 = 0; n6 < 8; ++n6) {
                        this.raf.write(0);
                    }
                    this.raf.write(this.getCylinders());
                    this.raf.write(this.getSides());
                    this.raf.write(this.trackSize);
                    this.raf.write(this.trackSize >> 8);
                    for (n6 = 0; n6 < 204; ++n6) {
                        this.raf.write(0);
                    }
                }
                long l2 = 0L;
                int n7 = 0;
                TrackData trackData = this.getTrackData(n, n2);
                if (trackData != null) {
                    l2 = trackData.getTrackPos();
                    n7 = trackData.getTrackSize();
                }
                if ((l = l2) < 256L || n5 != n7) {
                    int n8;
                    if (n2 == 0) {
                        CPCDisk.clearSideFromCyl(this.side0, n);
                    } else {
                        CPCDisk.clearSideFromCyl(this.side0, n + 1);
                    }
                    CPCDisk.clearSideFromCyl(this.side1, n);
                    trackData = null;
                    if (this.extendedFmt) {
                        l = 256L;
                        if (this.side0 != null) {
                            n8 = n;
                            if (n2 == 1) {
                                ++n8;
                            }
                            for (n4 = 0; n4 < n8; ++n4) {
                                TrackData trackData2 = this.side0.get(n4);
                                if (trackData2 == null) continue;
                                l += (long)trackData2.getTrackSize();
                            }
                        }
                        if (this.side1 != null && this.getSides() > 1) {
                            for (n8 = 0; n8 < n; ++n8) {
                                TrackData trackData3 = this.side1.get(n8);
                                if (trackData3 == null) continue;
                                l += (long)trackData3.getTrackSize();
                            }
                        }
                    } else {
                        l = 256 + n * this.getSides() * this.trackSize + n2 * this.trackSize;
                        if (n5 != this.trackSize || byArray.length > 6144) {
                            int n9;
                            this.raf.seek(0L);
                            this.raf.writeBytes(FILE_HEADER_EXT);
                            this.raf.writeBytes("JKCEMU");
                            for (n8 = 0; n8 < 8; ++n8) {
                                this.raf.write(0);
                            }
                            this.raf.write(this.getCylinders());
                            this.raf.write(this.getSides());
                            this.raf.write(0);
                            this.raf.write(0);
                            n8 = this.getCylinders() * this.getSides();
                            n4 = n5 >> 8;
                            for (n9 = 0; n9 < n8; ++n9) {
                                this.raf.write(n4);
                            }
                            for (n9 = n8; n9 < 204; ++n9) {
                                this.raf.write(0);
                            }
                            this.extendedFmt = true;
                            this.trackSize = 0;
                        }
                    }
                }
                if (trackData == null) {
                    Map<Integer, TrackData> map = null;
                    if ((n2 & 1) != 0) {
                        if (this.side1 == null) {
                            this.side1 = new HashMap<Integer, TrackData>();
                        }
                        map = this.side1;
                    } else {
                        if (this.side0 == null) {
                            this.side0 = new HashMap<Integer, TrackData>();
                        }
                        map = this.side0;
                    }
                    trackData = new TrackData(l, n5);
                    map.put(n, trackData);
                }
                int n10 = CPCDisk.getSectorSizeCode(byArray.length);
                this.raf.seek(l);
                this.raf.writeBytes(TRACK_HEADER);
                for (n4 = 0; n4 < 4; ++n4) {
                    this.raf.write(0);
                }
                this.raf.write(n);
                this.raf.write(n2);
                this.raf.write(0);
                this.raf.write(0);
                this.raf.write(n10);
                this.raf.write(sectorIDArray.length);
                this.raf.write(78);
                this.raf.write(229);
                for (n4 = 0; n4 < sectorIDArray.length; ++n4) {
                    this.raf.write(sectorIDArray[n4].getCylinder());
                    this.raf.write(sectorIDArray[n4].getHead());
                    this.raf.write(sectorIDArray[n4].getSectorNum());
                    this.raf.write(sectorIDArray[n4].getSizeCode());
                    for (int i = 0; i < 4; ++i) {
                        this.raf.write(0);
                    }
                }
                for (n4 = sectorIDArray.length; n4 < 29; ++n4) {
                    for (int i = 0; i < 8; ++i) {
                        this.raf.write(0);
                    }
                }
                n4 = this.trackSize - 256;
                for (n3 = 0; n3 < sectorIDArray.length; ++n3) {
                    SectorID sectorID = sectorIDArray[n3];
                    SectorData sectorData = new SectorData(n3, sectorID.getCylinder(), sectorID.getHead(), sectorID.getSectorNum(), sectorID.getSizeCode(), byArray, 0, byArray.length);
                    sectorData.setDisk(this);
                    sectorData.setFilePortionLen(byArray.length);
                    sectorData.setFilePos(this.raf.getFilePointer());
                    this.raf.write(byArray);
                    n4 -= byArray.length;
                    trackData.add(sectorData);
                }
                while (n4 > 0) {
                    this.raf.write(0);
                    --n4;
                }
                if (n >= this.getCylinders()) {
                    this.setCylinders(n + 1);
                    this.raf.seek(48L);
                    this.raf.write(this.getCylinders());
                }
                int n11 = n3 = (n2 & 1) != 0 ? 2 : 1;
                if (n3 > this.getSides()) {
                    this.setSides(n3);
                    this.raf.seek(49L);
                    this.raf.write(this.getSides());
                }
                if (sectorIDArray.length > this.getSectorsPerCylinder()) {
                    this.setSectorsPerCylinder(sectorIDArray.length);
                }
                if (this.getSectorSize() == 0) {
                    this.setSectorSize(byArray.length);
                }
                if (this.extendedFmt) {
                    this.raf.seek(52 + n * this.getSides() + n2);
                    this.raf.write(n5 >> 8);
                }
                bl = true;
            }
            catch (IOException iOException) {
                bl = false;
                this.fireShowError("Formatieren fehlgeschlagen", iOException);
            }
        }
        return bl;
    }

    @Override
    public String getFileFormatText() {
        return "CPC-Disk-Datei";
    }

    @Override
    public synchronized SectorData getSectorByIndex(int n, int n2, int n3) {
        SectorData sectorData = null;
        List<SectorData> list = this.getSectorsOfCyl(n, n2);
        if (list != null && n3 >= 0 && n3 < list.size() && (sectorData = list.get(n3)) != null) {
            sectorData.setDisk(this);
        }
        return sectorData;
    }

    @Override
    public int getSectorsOfCylinder(int n, int n2) {
        List<SectorData> list = this.getSectorsOfCyl(n, n2);
        return list != null ? list.size() : 0;
    }

    @Override
    public boolean isReadOnly() {
        return this.raf == null;
    }

    @Override
    public void putSettingsTo(Properties properties, String string) {
        if (properties != null && this.fileName != null) {
            if (this.resource) {
                properties.setProperty(string + "resource", this.fileName);
            } else {
                properties.setProperty(string + "file", this.fileName);
            }
            properties.setProperty(string + "readonly", Boolean.toString(this.isReadOnly()));
        }
    }

    @Override
    public boolean writeSector(int n, int n2, SectorData sectorData, byte[] byArray, int n3, boolean bl) {
        boolean bl2 = false;
        if (this.raf != null && sectorData != null && byArray != null && !bl && sectorData.getDisk() == this) {
            int n4 = sectorData.getSectorNum();
            long l = sectorData.getFilePos();
            if (l >= 0L) {
                try {
                    if (n3 < sectorData.getFilePortionLen()) {
                        CPCDisk.throwSectorSpaceTooSmall(n, n2, sectorData.getSectorNum());
                    }
                    this.raf.seek(l);
                    this.raf.write(byArray, 0, n3);
                    sectorData.setData(bl, byArray, n3);
                    bl2 = true;
                }
                catch (IOException iOException) {
                    this.fireShowWriteError(n, n2, n4, iOException);
                    sectorData.setError(true);
                }
            }
        }
        return bl2;
    }

    private CPCDisk(Frame frame, int n, int n2, int n3, int n4, String string, boolean bl, boolean bl2, int n5, RandomAccessFile randomAccessFile, FileLock fileLock, Map<Integer, TrackData> map, Map<Integer, TrackData> map2) {
        super(frame, n, n2, n3, n4);
        this.fileName = string;
        this.resource = bl;
        this.raf = randomAccessFile;
        this.fileLock = fileLock;
        this.trackSize = n5;
        this.side0 = map;
        this.side1 = map2;
    }

    private static void clearSideFromCyl(Map<Integer, TrackData> map, int n) {
        Integer[] integerArray;
        int n2;
        Set<Integer> set;
        if (map != null && (set = map.keySet()) != null && (n2 = set.size()) > 0 && (integerArray = set.toArray(new Integer[n2])) != null) {
            for (Integer n3 : integerArray) {
                if (n3 < n) continue;
                map.remove(n3);
            }
        }
    }

    private static CPCDisk createInstance(Frame frame, InputStream inputStream, RandomAccessFile randomAccessFile, FileLock fileLock, String string, boolean bl) throws IOException {
        boolean bl2;
        byte[] byArray;
        long l;
        CPCDisk cPCDisk = null;
        if (inputStream == null) {
            inputStream = EmuUtil.createInputStream(randomAccessFile);
        }
        if ((l = (long)EmuUtil.read(inputStream, byArray = new byte[256])) == (long)byArray.length && ((bl2 = CPCDisk.isDiskFileHeader(byArray, FILE_HEADER_EXT)) || CPCDisk.isDiskFileHeader(byArray, FILE_HEADER_STD))) {
            int n = 0;
            int n2 = 0;
            int n3 = byArray[48] & 0xFF;
            int n4 = byArray[49] & 0xFF;
            int n5 = 0;
            if (!bl2) {
                n5 = EmuUtil.getWord(byArray, 50);
            }
            if (n3 > 0 && n4 > 0) {
                int n6;
                int n7 = n3 * n4;
                HashMap<Integer, TrackData> hashMap = null;
                HashMap hashMap2 = null;
                byte[] byArray2 = new byte[256];
                for (n6 = 0; n6 < n7; ++n6) {
                    int n8;
                    long l2 = l;
                    if (EmuUtil.read(inputStream, byArray2) != byArray2.length || !TRACK_HEADER.equals(new String(byArray2, 0, TRACK_HEADER.length(), "US-ASCII"))) break;
                    l += (long)byArray2.length;
                    int n9 = n5;
                    if (bl2) {
                        n9 = byArray[52 + n6] << 8 & 0xFF00;
                    }
                    int n10 = byArray2[16] & 0xFF;
                    int n11 = byArray2[17] & 0xFF;
                    int n12 = byArray2[20] & 0xFF;
                    if (n12 > 6) {
                        hashMap = null;
                        hashMap2 = null;
                        break;
                    }
                    int n13 = 128;
                    if (!bl2 && n12 == 6) {
                        n13 = 6144;
                    } else if (n12 > 0) {
                        n13 <<= n12;
                    }
                    if (n13 > n2) {
                        n2 = n13;
                    }
                    if ((n8 = byArray2[21] & 0xFF) > 29) {
                        hashMap = null;
                        hashMap2 = null;
                        break;
                    }
                    long l3 = l;
                    byte[] byArray3 = null;
                    if (n9 > 256) {
                        byArray3 = new byte[n9 - 256];
                        EmuUtil.read(inputStream, byArray3);
                        l += (long)byArray3.length;
                    }
                    if (n8 <= 0) continue;
                    if (n < n8) {
                        n = n8;
                    }
                    TrackData trackData = null;
                    HashMap<Integer, TrackData> hashMap3 = null;
                    if (n11 == 0) {
                        if (hashMap == null) {
                            hashMap = new HashMap<Integer, TrackData>();
                        }
                        hashMap3 = hashMap;
                    } else if (n11 == 1) {
                        if (hashMap2 == null) {
                            hashMap2 = new HashMap();
                        }
                        hashMap3 = hashMap2;
                    }
                    if (hashMap3 != null && byArray3 != null && (trackData = (TrackData)hashMap3.get(n10)) == null) {
                        trackData = new TrackData(l2, byArray3.length);
                        hashMap3.put(n10, trackData);
                    }
                    int n14 = 24;
                    int n15 = 0;
                    for (int i = 0; i < n8; ++i) {
                        int n16 = byArray2[n14++] & 0xFF;
                        int n17 = byArray2[n14++] & 0xFF;
                        int n18 = byArray2[n14++] & 0xFF;
                        int n19 = byArray2[n14++] & 0xFF;
                        if (bl2) {
                            n13 = EmuUtil.getWord(byArray2, n14 + 2);
                        }
                        n14 += 4;
                        if (byArray3 == null) continue;
                        SectorData sectorData = new SectorData(n6, n16, n17, n18, n19, byArray3, n15, Math.min(n13, byArray3.length - n15));
                        sectorData.setFilePortionLen(n13);
                        sectorData.setFilePos(l3);
                        trackData.add(sectorData);
                        n15 += n13;
                        l3 += (long)n13;
                    }
                }
                if (hashMap != null || hashMap2 != null) {
                    n6 = 1;
                    if (hashMap2 != null) {
                        ++n6;
                    }
                    cPCDisk = new CPCDisk(frame, n4, n3, n, n2, string, bl, bl2, n5, randomAccessFile, fileLock, hashMap, hashMap2);
                }
            }
        }
        if (cPCDisk == null) {
            throw new IOException("Datei ist keine CPC-Disk-Datei");
        }
        return cPCDisk;
    }

    private List<SectorData> getSectorsOfCyl(int n, int n2) {
        TrackData trackData;
        Map<Integer, TrackData> map;
        List<SectorData> list = null;
        Map<Integer, TrackData> map2 = map = (n2 & 1) != 0 ? this.side1 : this.side0;
        if (map != null && (trackData = map.get(n)) != null) {
            list = trackData.getSectorList();
        }
        return list;
    }

    private static int getSectorSizeCode(int n) {
        int n2 = 0;
        while (n > 128) {
            n = n >> 1 | n & 1;
            ++n2;
        }
        return n2;
    }

    private static boolean isDiskFileHeader(byte[] byArray, String string) {
        int n;
        boolean bl = false;
        if (byArray != null && byArray.length >= (n = string.length())) {
            try {
                bl = string.equals(new String(byArray, 0, n, "US-ASCII"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return bl;
    }

    private TrackData getTrackData(int n, int n2) {
        TrackData trackData = null;
        if (n2 == 0 && this.side0 != null) {
            trackData = this.side0.get(n);
        } else if (n2 == 0 && this.side0 != null) {
            trackData = this.side1.get(n);
        }
        return trackData;
    }

    public static class TrackData {
        private long trackPos;
        private int trackSize;
        private List<SectorData> sectors;

        public TrackData(long l, int n) {
            this.trackPos = l;
            this.trackSize = n;
            this.sectors = new ArrayList<SectorData>(29);
        }

        public void add(SectorData sectorData) {
            this.sectors.add(sectorData);
        }

        public void clear() {
            this.sectors.clear();
        }

        public List<SectorData> getSectorList() {
            return this.sectors;
        }

        public long getTrackPos() {
            return this.trackPos;
        }

        public int getTrackSize() {
            return this.trackSize;
        }
    }
}

