/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Component;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuMemView;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileFormat;
import jkcemu.base.SaveDlg;
import jkcemu.base.ScreenFrm;
import jkcemu.text.TextEditFrm;

public class SourceUtil {
    public static String getEDAS4Text(EmuMemView emuMemView, int n) {
        String string = null;
        int n2 = n + emuMemView.getMemWord(n) - 1;
        if (n2 >= 6 && emuMemView.getMemByte(n2, false) == 255 && emuMemView.getMemByte(n2 - 1, false) == 0) {
            int n3;
            StringBuilder stringBuilder = new StringBuilder(16384);
            n += 7;
            while (n < n2 && (n3 = emuMemView.getMemByte(n++, false)) != 255) {
                if (n3 == 0) {
                    stringBuilder.append('\n');
                    n += 2;
                    continue;
                }
                if (n3 < 32) {
                    for (int i = 0; i < n3; ++i) {
                        stringBuilder.append(' ');
                    }
                    continue;
                }
                stringBuilder.append((char)n3);
            }
            if (stringBuilder.length() > 0) {
                string = stringBuilder.toString();
            }
        }
        return string;
    }

    public static int getBasicEndAddr(EmuMemView emuMemView, int n) {
        int n2 = -1;
        int n3 = n;
        int n4 = EmuUtil.getBasicMemWord(emuMemView, n3);
        while (n4 > n3 + 5 && emuMemView.getBasicMemByte(n4 - 1) == 0) {
            n3 = n4;
            n4 = EmuUtil.getBasicMemWord(emuMemView, n3);
        }
        if (n3 > n) {
            n2 = n3 + 1;
        }
        return n2;
    }

    public static String getBasicProgram(EmuMemView emuMemView, int n, String[] stringArray) {
        return SourceUtil.getBasicProgram(emuMemView, n, stringArray, null);
    }

    public static String getBasicProgram(EmuMemView emuMemView, int n, String[] stringArray, String[] stringArray2) {
        StringBuilder stringBuilder = new StringBuilder(16384);
        int n2 = EmuUtil.getBasicMemWord(emuMemView, n);
        while (n2 > n + 5 && emuMemView.getBasicMemByte(n2 - 1) == 0) {
            int n3;
            stringBuilder.append(EmuUtil.getBasicMemWord(emuMemView, n += 2));
            n += 2;
            boolean bl = true;
            int n4 = 0;
            while (n < n2) {
                n3 = emuMemView.getBasicMemByte(n);
                if (n3 == 32) {
                    ++n4;
                    ++n;
                    continue;
                }
                if (n3 == 0 || n4 <= 0) break;
                for (int i = 0; i <= n4; ++i) {
                    stringBuilder.append(' ');
                }
                bl = false;
                break;
            }
            block3: while (n < n2 && (n3 = emuMemView.getBasicMemByte(n++)) != 0) {
                int n5;
                if (n3 == 34) {
                    if (bl) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append((char)n3);
                    while (n < n2 && (n3 = emuMemView.getBasicMemByte(n++)) != 0) {
                        stringBuilder.append((char)n3);
                        if (n3 != 34) continue;
                        continue block3;
                    }
                    continue;
                }
                String[] stringArray3 = stringArray;
                if (n3 == 255) {
                    n3 = emuMemView.getBasicMemByte(n++);
                    stringArray3 = stringArray2;
                }
                if (stringArray3 != null && n3 >= 128 && (n5 = n3 - 128) >= 0 && n5 < stringArray3.length) {
                    String string = stringArray3[n5];
                    if (string != null) {
                        int n6 = string.length();
                        if (n6 > 0) {
                            if (SourceUtil.isIdentifierChar(stringBuilder.charAt(stringBuilder.length() - 1)) && SourceUtil.isIdentifierChar(string.charAt(0))) {
                                stringBuilder.append(' ');
                            }
                            stringBuilder.append(string);
                            bl = SourceUtil.isIdentifierChar(string.charAt(n6 - 1));
                        }
                        n3 = 0;
                    } else {
                        stringBuilder.append((char)(n3 + 128));
                    }
                }
                if (n3 <= 0) continue;
                if (bl && (SourceUtil.isIdentifierChar(n3) || n3 == 39 || n3 == 34)) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append((char)n3);
                bl = false;
            }
            stringBuilder.append('\n');
            n = n2;
            n2 = EmuUtil.getBasicMemWord(emuMemView, n);
        }
        return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
    }

    public static String getTinyBasicProgram(EmuMemView emuMemView, int n, int n2) {
        String string = null;
        if (n2 > n) {
            int n3 = n2 - n;
            StringBuilder stringBuilder = new StringBuilder(n3 * 3 / 2);
            int n4 = n;
            while (n4 < n2 - 1) {
                int n5;
                stringBuilder.append(EmuUtil.getBasicMemWord(emuMemView, n4));
                n4 += 2;
                int n6 = 0;
                while (n4 < n2) {
                    n5 = emuMemView.getBasicMemByte(n4);
                    if (n5 == 32) {
                        ++n6;
                        ++n4;
                        continue;
                    }
                    if (n5 == 13) break;
                    for (int i = 0; i <= n6; ++i) {
                        stringBuilder.append(' ');
                    }
                }
                while (n4 < n2 && (n5 = emuMemView.getBasicMemByte(n4++)) != 13) {
                    if (n5 == 0) continue;
                    stringBuilder.append((char)n5);
                }
                stringBuilder.append('\n');
            }
            if (stringBuilder.length() > 0) {
                string = stringBuilder.toString();
            }
        }
        return string;
    }

    public static void openKCBasicProgram(ScreenFrm screenFrm, int n, String[] stringArray) {
        int n2;
        EmuThread emuThread = screenFrm.getEmuThread();
        if (n == 1025) {
            n2 = EmuUtil.getBasicMemWord(emuThread, 863);
            if (n2 > 0) {
                n = n2;
            }
        } else if (n == 11265 && (n2 = EmuUtil.getBasicMemWord(emuThread, 11103)) > 0) {
            n = n2;
        }
        String string = SourceUtil.getBasicProgram(emuThread, n, stringArray);
        if (string != null) {
            TextEditFrm textEditFrm = screenFrm.openText(string);
            if (textEditFrm != null && n != 1025 && n != 11265) {
                BaseDlg.showInfoDlg(textEditFrm, "Das BASIC-Programm befindet sich au\u00dferhalb\ndes standardm\u00e4\u00dfigen Adressbereichs.");
            }
        } else {
            SourceUtil.showNoBasic(screenFrm);
        }
    }

    public static void saveKCBasicProgram(ScreenFrm screenFrm, int n) {
        int n2;
        EmuThread emuThread = screenFrm.getEmuThread();
        if (n == 1025) {
            n2 = EmuUtil.getBasicMemWord(emuThread, 863);
            if (n2 > 0) {
                n = n2;
            }
        } else if (n == 11265 && (n2 = EmuUtil.getBasicMemWord(emuThread, 11103)) > 0) {
            n = n2;
        }
        n2 = SourceUtil.getBasicEndAddr(emuThread, n);
        if (n2 >= n) {
            if (n == 1025 || n == 11265) {
                new SaveDlg(screenFrm, n, n2, "KC-BASIC-Programm speichern", SaveDlg.BasicType.KCBASIC, EmuUtil.getKCBasicFileFilter()).setVisible(true);
            } else {
                BaseDlg.showErrorDlg((Component)screenFrm, "Es ist zwar ein BASIC-Programm vorhanden, jedoch befindet\nes sich au\u00dferhalb des standardm\u00e4\u00dfigen Adressbereichs.\nEs kann deshalb nicht auf diese Art und Weise gespeichert werden.");
            }
        } else {
            SourceUtil.showNoBasic(screenFrm);
        }
    }

    public static void updKCBasicSysCells(EmuThread emuThread, int n, int n2, Object object, int n3) {
        if (object != null) {
            int n4;
            int n5 = -1;
            if ((object.equals(FileFormat.KCBASIC_HEAD_PRG) || object.equals(FileFormat.KCBASIC_PRG) || object.equals(FileFormat.KCTAP_BASIC_PRG) || object.equals(FileFormat.BASIC_PRG)) && n == 1025 && n2 > 7 || object.equals(FileFormat.HEADERSAVE) && n3 == 66 && n <= 1025 && n + n2 > 1031) {
                n5 = 1025;
            } else if ((object.equals(FileFormat.KCBASIC_HEAD_PRG) || object.equals(FileFormat.KCBASIC_PRG) || object.equals(FileFormat.KCTAP_BASIC_PRG) || object.equals(FileFormat.BASIC_PRG)) && n == 11265 && n2 > 7 || object.equals(FileFormat.HEADERSAVE) && n3 == 66 && n <= 11265 && n + n2 > 11271) {
                n5 = 11265;
            }
            if (n5 >= 0 && (n4 = SourceUtil.getBasicEndAddr(emuThread, n5) + 1) > n5) {
                emuThread.setBasicMemWord(n - 42, n4);
                emuThread.setBasicMemWord(n - 40, n4);
                emuThread.setBasicMemWord(n - 38, n4);
            }
        }
    }

    private static boolean isIdentifierChar(int n) {
        return n >= 65 && n <= 90 || n >= 97 && n <= 122 || n >= 48 && n <= 57;
    }

    private static void showNoBasic(Component component) {
        BaseDlg.showErrorDlg(component, "Es ist kein BASIC-Programm im entsprechenden\nAdressbereich des Arbeitsspeichers vorhanden.");
    }
}

