/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.BaseFrm;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.base.HelpFrm;
import jkcemu.base.ProfileDlg;
import jkcemu.base.ScreenFrm;
import jkcemu.base.UserCancelException;
import jkcemu.base.UserInputException;
import jkcemu.emusys.a5105.A5105SettingsFld;
import jkcemu.emusys.ac1_llc2.AC1SettingsFld;
import jkcemu.emusys.ac1_llc2.LLC2SettingsFld;
import jkcemu.emusys.bcs3.BCS3SettingsFld;
import jkcemu.emusys.customsys.CustomSysSettingsFld;
import jkcemu.emusys.etc.KramerMCSettingsFld;
import jkcemu.emusys.etc.NANOSSettingsFld;
import jkcemu.emusys.etc.PCMSettingsFld;
import jkcemu.emusys.huebler.HueblerEvertMCSettingsFld;
import jkcemu.emusys.huebler.HueblerGraphicsMCSettingsFld;
import jkcemu.emusys.kc85.KC85SettingsFld;
import jkcemu.emusys.kccompact.KCcompactSettingsFld;
import jkcemu.emusys.lc80.LC80SettingsFld;
import jkcemu.emusys.llc1.LLC1SettingsFld;
import jkcemu.emusys.poly880.Poly880SettingsFld;
import jkcemu.emusys.z1013.Z1013SettingsFld;
import jkcemu.emusys.z9001.Z9001SettingsFld;
import jkcemu.emusys.zxspectrum.ZXSpectrumSettingsFld;
import jkcemu.net.KCNetSettingsFld;

public class SettingsFrm
extends BaseFrm
implements ChangeListener,
DocumentListener {
    private static final int MAX_MARGIN = 199;
    private static final String CARD_EMPTY = "empty";
    private static final String HELP_PAGE = "/help/settings.htm";
    private static SettingsFrm instance = null;
    private ScreenFrm screenFrm;
    private EmuThread emuThread;
    private File profileFile;
    private Map<String, AbstractButton> lafClass2Button;
    private SpinnerNumberModel spinnerModelMargin;
    private KCNetSettingsFld tabKCNet;
    private JPanel tabConfirm;
    private JPanel tabEtc;
    private JPanel tabLAF;
    private JPanel tabScreen;
    private JPanel tabSpeed;
    private JPanel tabSys;
    private JPanel panelSysOpt;
    private JCheckBox btnConfirmNMI;
    private JCheckBox btnConfirmReset;
    private JCheckBox btnConfirmPowerOn;
    private JCheckBox btnConfirmQuit;
    private JCheckBox btnClearRFsOnPowerOn;
    private JCheckBox btnReloadROMsOnPowerOn;
    private JComboBox<String> comboScreenRefresh;
    private CardLayout cardLayoutSysOpt;
    private String curSysOptCard;
    private JRadioButton btnSysA5105;
    private JRadioButton btnSysAC1;
    private JRadioButton btnSysBCS3;
    private JRadioButton btnSysC80;
    private JRadioButton btnSysCustomSys;
    private JRadioButton btnSysHC900;
    private JRadioButton btnSysHEMC;
    private JRadioButton btnSysHGMC;
    private JRadioButton btnSysKC85_1;
    private JRadioButton btnSysKC85_2;
    private JRadioButton btnSysKC85_3;
    private JRadioButton btnSysKC85_4;
    private JRadioButton btnSysKC85_5;
    private JRadioButton btnSysKC87;
    private JRadioButton btnSysKCcompact;
    private JRadioButton btnSysKramerMC;
    private JRadioButton btnSysLC80;
    private JRadioButton btnSysLLC1;
    private JRadioButton btnSysLLC2;
    private JRadioButton btnSysNANOS;
    private JRadioButton btnSysPCM;
    private JRadioButton btnSysPoly880;
    private JRadioButton btnSysSC2;
    private JRadioButton btnSysSLC1;
    private JRadioButton btnSysVCS80;
    private JRadioButton btnSysZ1013;
    private JRadioButton btnSysZ9001;
    private JRadioButton btnSysZXSpectrum;
    private A5105SettingsFld a5105SettingsFld;
    private AC1SettingsFld ac1SettingsFld;
    private CustomSysSettingsFld customSysSettingsFld;
    private BCS3SettingsFld bcs3SettingsFld;
    private HueblerEvertMCSettingsFld hemcSettingsFld;
    private HueblerGraphicsMCSettingsFld hgmcSettingsFld;
    private KC85SettingsFld hc900SettingsFld;
    private LLC1SettingsFld llc1SettingsFld;
    private LLC2SettingsFld llc2SettingsFld;
    private Z9001SettingsFld kc85_1_SettingsFld;
    private KC85SettingsFld kc85_2_SettingsFld;
    private KC85SettingsFld kc85_3_SettingsFld;
    private KC85SettingsFld kc85_4_SettingsFld;
    private KC85SettingsFld kc85_5_SettingsFld;
    private KCcompactSettingsFld kcCompactSettingsFld;
    private KramerMCSettingsFld kramerMCSettingsFld;
    private LC80SettingsFld lc80SettingsFld;
    private NANOSSettingsFld nanosSettingsFld;
    private PCMSettingsFld pcmSettingsFld;
    private Poly880SettingsFld poly880SettingsFld;
    private Z1013SettingsFld z1013SettingsFld;
    private Z9001SettingsFld kc87SettingsFld;
    private Z9001SettingsFld z9001SettingsFld;
    private ZXSpectrumSettingsFld zxSpectrumSettingsFld;
    private JRadioButton btnSpeedDefault;
    private JRadioButton btnSpeedValue;
    private JRadioButton btnSRAMInit00;
    private JRadioButton btnSRAMInitRandom;
    private JRadioButton btnFileDlgEmu;
    private JRadioButton btnFileDlgSwing;
    private JRadioButton btnFileDlgNative;
    private JCheckBox btnDirectCopyPaste;
    private JLabel labelSpeedUnit;
    private JTextField fldSpeed;
    private Document docSpeed;
    private NumberFormat fmtSpeed;
    private JTextField fldConfigDir;
    private JButton btnDeleteConfigDir;
    private JSlider sliderBrightness;
    private JSpinner spinnerMargin;
    private ButtonGroup grpLAF;
    private UIManager.LookAndFeelInfo[] lafs;
    private JButton btnApply;
    private JButton btnLoad;
    private JButton btnSave;
    private JButton btnHelp;
    private JButton btnClose;
    private JTabbedPane tabbedPane;

    public static void open(ScreenFrm screenFrm) {
        if (instance != null) {
            if (instance.getExtendedState() == 1) {
                instance.setExtendedState(0);
            }
        } else {
            instance = new SettingsFrm(screenFrm);
        }
        instance.toFront();
        instance.setVisible(true);
    }

    public void fireDataChanged() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SettingsFrm.this.setDataChanged();
            }
        });
    }

    public NumberFormat getSpeedFmt() {
        return this.fmtSpeed;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.sliderBrightness || object == this.spinnerMargin) {
            this.setDataChanged();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.docChanged(documentEvent);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.docChanged(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.docChanged(documentEvent);
    }

    @Override
    public boolean applySettings(Properties properties, boolean bl) {
        this.updFields(properties, UIManager.getLookAndFeel(), null);
        return super.applySettings(properties, bl);
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        try {
            Object object;
            if (eventObject != null && (object = eventObject.getSource()) != null) {
                if (object == this.btnApply) {
                    bl = true;
                    this.doApply();
                } else if (object == this.btnLoad) {
                    bl = true;
                    this.doLoad();
                } else if (object == this.btnSave) {
                    bl = true;
                    this.doSave();
                } else if (object == this.btnHelp) {
                    bl = true;
                    HelpFrm.open(HELP_PAGE);
                } else if (object == this.btnClose) {
                    bl = true;
                    this.doClose();
                } else if (object == this.btnDeleteConfigDir) {
                    bl = true;
                    this.doDeleteConfigDir();
                } else if (object == this.btnSysA5105 || object == this.btnSysAC1 || object == this.btnSysBCS3 || object == this.btnSysC80 || object == this.btnSysCustomSys || object == this.btnSysHC900 || object == this.btnSysHEMC || object == this.btnSysHGMC || object == this.btnSysKC85_1 || object == this.btnSysKC85_2 || object == this.btnSysKC85_3 || object == this.btnSysKC85_4 || object == this.btnSysKC85_5 || object == this.btnSysKC87 || object == this.btnSysKCcompact || object == this.btnSysKramerMC || object == this.btnSysLC80 || object == this.btnSysLLC1 || object == this.btnSysLLC2 || object == this.btnSysNANOS || object == this.btnSysPCM || object == this.btnSysPoly880 || object == this.btnSysSC2 || object == this.btnSysSLC1 || object == this.btnSysVCS80 || object == this.btnSysZ1013 || object == this.btnSysZ9001 || object == this.btnSysZXSpectrum) {
                    bl = true;
                    this.updSysOptCard();
                    this.setDataChanged();
                } else if (object == this.btnSpeedDefault || object == this.btnSpeedValue) {
                    bl = true;
                    this.updSpeedFieldsEnabled();
                    this.setDataChanged();
                } else if (object instanceof JCheckBox || object instanceof JComboBox || object instanceof JRadioButton) {
                    bl = true;
                    this.setDataChanged();
                }
            }
        }
        catch (UserInputException userInputException) {
            BaseDlg.showErrorDlg((Component)this, userInputException);
        }
        return bl;
    }

    @Override
    public void lookAndFeelChanged() {
        this.tabKCNet.lookAndFeelChanged();
        this.a5105SettingsFld.lookAndFeelChanged();
        this.ac1SettingsFld.lookAndFeelChanged();
        this.customSysSettingsFld.lookAndFeelChanged();
        this.hc900SettingsFld.lookAndFeelChanged();
        this.hemcSettingsFld.lookAndFeelChanged();
        this.hgmcSettingsFld.lookAndFeelChanged();
        this.kc85_1_SettingsFld.lookAndFeelChanged();
        this.kc85_2_SettingsFld.lookAndFeelChanged();
        this.kc85_3_SettingsFld.lookAndFeelChanged();
        this.kc85_4_SettingsFld.lookAndFeelChanged();
        this.kc85_5_SettingsFld.lookAndFeelChanged();
        this.llc1SettingsFld.lookAndFeelChanged();
        this.llc2SettingsFld.lookAndFeelChanged();
        this.z1013SettingsFld.lookAndFeelChanged();
        this.kc87SettingsFld.lookAndFeelChanged();
        this.z9001SettingsFld.lookAndFeelChanged();
        this.zxSpectrumSettingsFld.lookAndFeelChanged();
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl && !this.isVisible()) {
            this.updFields(Main.getProperties(), UIManager.getLookAndFeel(), Integer.toString(this.screenFrm.getScreenRefreshMillis()));
        }
        super.setVisible(bl);
    }

    private void doApply() throws UserInputException {
        Properties properties = new Properties();
        Properties properties2 = Main.getProperties();
        if (properties2 != null) {
            properties.putAll((Map<?, ?>)properties2);
        }
        JPanel jPanel = null;
        try {
            jPanel = this.tabConfirm;
            this.applyConfirm(properties);
            jPanel = this.tabEtc;
            this.applyEtc(properties);
            jPanel = this.tabKCNet;
            this.tabKCNet.applyInput(properties, this.tabbedPane.getSelectedComponent() == this.tabKCNet);
            jPanel = this.tabScreen;
            this.applyScreen(properties);
            jPanel = this.tabSpeed;
            this.applySpeed(properties);
            jPanel = this.tabSys;
            this.applySys(properties);
            jPanel = this.tabLAF;
            this.applyLAF(properties);
            Properties properties3 = Main.getProperties();
            if (properties3 != null) {
                properties3.putAll((Map<?, ?>)properties);
            } else {
                properties3 = properties;
            }
            this.emuThread.applySettings(properties3);
            Main.applyProfileToFrames(this.profileFile, properties3, false, this);
            if (!this.btnSpeedValue.isSelected()) {
                EmuSys emuSys = this.emuThread.getEmuSys();
                this.setSpeedValueFld(EmuThread.getDefaultSpeedKHz(properties));
            }
            this.btnApply.setEnabled(false);
            if (this.btnSave != null) {
                this.btnSave.setEnabled(true);
            }
        }
        catch (UserCancelException userCancelException) {
        }
        catch (UserInputException userInputException) {
            if (jPanel != null) {
                this.tabbedPane.setSelectedComponent(jPanel);
            }
            throw userInputException;
        }
    }

    private void doDeleteConfigDir() {
        File file = Main.getConfigDir();
        if (file != null && BaseDlg.showYesNoDlg(this, "M\u00f6chten Sie das JKCEMU-Konfigurationsverzeichnis l\u00f6schen?\nDabei gehen alle gespeicherten Einstellungen und Profile sowie eventuell\nselbst erfasste Stammdaten f\u00fcr die zu emulierenden Festplatten verloren.\nBeim n\u00e4chsten Start meldet sich der Emulator dann so,\nals w\u00fcrde er das erste mal gestartet werden.\n")) {
            File[] fileArray;
            boolean bl = false;
            boolean bl2 = true;
            if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    File file2 = fileArray[i];
                    if (file2.isDirectory()) {
                        bl2 = false;
                        break;
                    }
                    String string = file2.getName();
                    if (string == null || string.equals(".") || string.equals("..") || string.equals("harddisks.csv") || string.equals("jkcemu_win32.dll") || string.equals("jkcemu_win64.dll") || string.endsWith("lastdirs.xml") || string.startsWith("prf_") && string.endsWith(".xml")) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) {
                    bl2 = BaseDlg.showYesNoWarningDlg(this, "Das JKCEMU-Datenverzeichnis enth\u00e4lt Dateien und/oder Unterverzeichnisse,\ndie offensichtlich nicht von JKCEMU stammen.\nSoll das Verzeichnis trotzdem gel\u00f6scht werden?", "Warnung");
                }
                if (bl2) {
                    bl = SettingsFrm.deleteDir(file);
                }
            }
            if (bl2) {
                if (bl) {
                    if (this.btnDeleteConfigDir != null) {
                        this.btnDeleteConfigDir.setEnabled(false);
                    }
                    if (BaseDlg.showYesNoWarningDlg(this, "Wenn Sie sichergehen wollen,\ndass keine alten Einstellungen \u00fcbernommen werden,\nsollten Sie jetzt den Emulator beenden.\n\nM\u00f6chten Sie den Emulator jetzt beenden?", "Hinweis")) {
                        this.screenFrm.doQuit();
                    }
                } else {
                    BaseDlg.showErrorDlg((Component)this, "Das JKCEMU-Konfigurationsverzeichnis konnte nicht gel\u00f6scht werden.\nM\u00f6glicherweise sind einige Dateien durch den Emulator selbst gesperrt.\nSchlie\u00dfen Sie bitte JKCEMU und l\u00f6schen Sie das Verzeichnis per Hand.");
                    if (Desktop.isDesktopSupported()) {
                        try {
                            Desktop.getDesktop().open(file);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    private void doLoad() {
        Properties properties;
        ProfileDlg profileDlg = new ProfileDlg(this, "Profil laden", "Laden", Main.getProfileFile(), false);
        profileDlg.setVisible(true);
        File file = profileDlg.getSelectedProfile();
        if (file != null && (properties = Main.loadProperties(file)) != null) {
            this.updFields(properties, null, null);
            this.setDataChanged();
            this.profileFile = file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSave() {
        Properties properties = Main.getProperties();
        if (properties == null) {
            properties = new Properties();
        }
        ProfileDlg profileDlg = new ProfileDlg(this, "Profil speichern", "Speichern", this.profileFile, true);
        profileDlg.setVisible(true);
        File file = profileDlg.getSelectedProfile();
        if (file != null) {
            File file2;
            Object object;
            Frame[] frameArray = Frame.getFrames();
            if (frameArray != null) {
                for (int i = 0; i < frameArray.length; ++i) {
                    object = frameArray[i];
                    if (object == null || !(object instanceof BaseFrm)) continue;
                    ((BaseFrm)object).putSettingsTo(properties);
                }
            }
            if ((file2 = file.getParentFile()) != null && file2.exists() && this.btnDeleteConfigDir != null) {
                this.btnDeleteConfigDir.setEnabled(true);
            }
            object = null;
            try {
                object = new FileOutputStream(file);
                properties.storeToXML((OutputStream)object, "JKCEMU Profil");
                ((OutputStream)object).close();
                object = null;
                this.profileFile = file;
                Main.setProfile(this.profileFile, properties);
            }
            catch (IOException iOException) {
                BaseDlg.showErrorDlg((Component)this, "Die Einstellungen k\u00f6nnen nicht in die Datei\n'" + file.getPath() + "'\ngespeichert werden.");
            }
            finally {
                EmuUtil.closeSilent((Closeable)object);
            }
        }
    }

    private SettingsFrm(ScreenFrm screenFrm) {
        Serializable serializable;
        Object object;
        GridBagConstraints gridBagConstraints;
        this.setTitle("JKCEMU Einstellungen");
        Main.updIcon(this);
        this.screenFrm = screenFrm;
        this.emuThread = screenFrm.getEmuThread();
        this.lafClass2Button = new HashMap<String, AbstractButton>();
        this.profileFile = Main.getProfileFile();
        this.fmtSpeed = NumberFormat.getNumberInstance();
        if (this.fmtSpeed instanceof DecimalFormat) {
            ((DecimalFormat)this.fmtSpeed).applyPattern("#0.0##");
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0);
        this.tabbedPane = new JTabbedPane(1);
        this.add((Component)this.tabbedPane, gridBagConstraints2);
        this.tabSys = new JPanel(new BorderLayout());
        this.tabbedPane.addTab("System", this.tabSys);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.tabSys.add((Component)new JScrollPane(jPanel), "West");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btnSysA5105 = new JRadioButton("A5105 (BIC)", true);
        this.btnSysA5105.addActionListener(this);
        buttonGroup.add(this.btnSysA5105);
        jPanel.add((Component)this.btnSysA5105, gridBagConstraints3);
        this.btnSysAC1 = new JRadioButton("AC1", false);
        this.btnSysAC1.addActionListener(this);
        buttonGroup.add(this.btnSysAC1);
        gridBagConstraints3.insets.top = 0;
        ++gridBagConstraints3.gridy;
        jPanel.add((Component)this.btnSysAC1, gridBagConstraints3);
        this.btnSysBCS3 = new JRadioButton("BCS3", false);
        this.btnSysBCS3.addActionListener(this);
        buttonGroup.add(this.btnSysBCS3);
        ++gridBagConstraints3.gridy;
        jPanel.add((Component)this.btnSysBCS3, gridBagConstraints3);
        this.btnSysC80 = new JRadioButton("C-80", false);
        this.btnSysC80.addActionListener(this);
        buttonGroup.add(this.btnSysC80);
        ++gridBagConstraints3.gridy;
        jPanel.add((Component)this.btnSysC80, gridBagConstraints3);
        this.btnSysHC900 = new JRadioButton("HC900", false);
        this.btnSysHC900.addActionListener(this);
        buttonGroup.add(this.btnSysHC900);
        ++gridBagConstraints3.gridy;
        jPanel.add((Component)this.btnSysHC900, gridBagConstraints3);
        this.btnSysHEMC = new JRadioButton("H\u00fcbler/Evert-MC", false);
        this.btnSysHEMC.addActionListener(this);
        buttonGroup.add(this.btnSysHEMC);
        ++gridBagConstraints3.gridy;
        jPanel.add((Component)this.btnSysHEMC, gridBagConstraints3);
        this.btnSysHGMC = new JRadioButton("H\u00fcbler-Grafik-MC", false);
        this.btnSysHGMC.addActionListener(this);
        buttonGroup.add(this.btnSysHGMC);
        ++gridBagConstraints3.gridy;
        jPanel.add((Component)this.btnSysHGMC, gridBagConstraints3);
        this.btnSysKC85_1 = new JRadioButton("KC85/1", false);
        this.btnSysKC85_1.addActionListener(this);
        buttonGroup.add(this.btnSysKC85_1);
        ++gridBagConstraints3.gridy;
        jPanel.add((Component)this.btnSysKC85_1, gridBagConstraints3);
        this.btnSysKC85_2 = new JRadioButton("KC85/2", false);
        this.btnSysKC85_2.addActionListener(this);
        buttonGroup.add(this.btnSysKC85_2);
        ++gridBagConstraints3.gridy;
        jPanel.add((Component)this.btnSysKC85_2, gridBagConstraints3);
        this.btnSysKC85_3 = new JRadioButton("KC85/3", false);
        this.btnSysKC85_3.addActionListener(this);
        buttonGroup.add(this.btnSysKC85_3);
        ++gridBagConstraints3.gridy;
        jPanel.add((Component)this.btnSysKC85_3, gridBagConstraints3);
        this.btnSysKC85_4 = new JRadioButton("KC85/4", false);
        this.btnSysKC85_4.addActionListener(this);
        buttonGroup.add(this.btnSysKC85_4);
        ++gridBagConstraints3.gridy;
        jPanel.add((Component)this.btnSysKC85_4, gridBagConstraints3);
        this.btnSysKC85_5 = new JRadioButton("KC85/5", false);
        this.btnSysKC85_5.addActionListener(this);
        buttonGroup.add(this.btnSysKC85_5);
        ++gridBagConstraints3.gridy;
        jPanel.add((Component)this.btnSysKC85_5, gridBagConstraints3);
        this.btnSysKC87 = new JRadioButton("KC87", false);
        this.btnSysKC87.addActionListener(this);
        buttonGroup.add(this.btnSysKC87);
        ++gridBagConstraints3.gridy;
        jPanel.add((Component)this.btnSysKC87, gridBagConstraints3);
        this.btnSysKCcompact = new JRadioButton("KC compact", false);
        this.btnSysKCcompact.addActionListener(this);
        buttonGroup.add(this.btnSysKCcompact);
        ++gridBagConstraints3.gridy;
        jPanel.add((Component)this.btnSysKCcompact, gridBagConstraints3);
        this.btnSysKramerMC = new JRadioButton("Kramer-MC", false);
        this.btnSysKramerMC.addActionListener(this);
        buttonGroup.add(this.btnSysKramerMC);
        gridBagConstraints3.insets.top = 5;
        gridBagConstraints3.gridy = 0;
        ++gridBagConstraints3.gridx;
        jPanel.add((Component)this.btnSysKramerMC, gridBagConstraints3);
        this.btnSysLC80 = new JRadioButton("LC-80", false);
        this.btnSysLC80.addActionListener(this);
        buttonGroup.add(this.btnSysLC80);
        gridBagConstraints3.insets.top = 0;
        ++gridBagConstraints3.gridy;
        jPanel.add((Component)this.btnSysLC80, gridBagConstraints3);
        this.btnSysLLC1 = new JRadioButton("LLC1", false);
        this.btnSysLLC1.addActionListener(this);
        buttonGroup.add(this.btnSysLLC1);
        ++gridBagConstraints3.gridy;
        jPanel.add((Component)this.btnSysLLC1, gridBagConstraints3);
        this.btnSysLLC2 = new JRadioButton("LLC2", false);
        this.btnSysLLC2.addActionListener(this);
        buttonGroup.add(this.btnSysLLC2);
        ++gridBagConstraints3.gridy;
        jPanel.add((Component)this.btnSysLLC2, gridBagConstraints3);
        this.btnSysNANOS = new JRadioButton("NANOS", false);
        this.btnSysNANOS.addActionListener(this);
        buttonGroup.add(this.btnSysNANOS);
        ++gridBagConstraints3.gridy;
        jPanel.add((Component)this.btnSysNANOS, gridBagConstraints3);
        this.btnSysPCM = new JRadioButton("PC/M", false);
        this.btnSysPCM.addActionListener(this);
        buttonGroup.add(this.btnSysPCM);
        ++gridBagConstraints3.gridy;
        jPanel.add((Component)this.btnSysPCM, gridBagConstraints3);
        this.btnSysPoly880 = new JRadioButton("Poly-880", false);
        this.btnSysPoly880.addActionListener(this);
        buttonGroup.add(this.btnSysPoly880);
        ++gridBagConstraints3.gridy;
        jPanel.add((Component)this.btnSysPoly880, gridBagConstraints3);
        this.btnSysSC2 = new JRadioButton("SC2", false);
        this.btnSysSC2.addActionListener(this);
        buttonGroup.add(this.btnSysSC2);
        ++gridBagConstraints3.gridy;
        jPanel.add((Component)this.btnSysSC2, gridBagConstraints3);
        this.btnSysSLC1 = new JRadioButton("SLC1", false);
        this.btnSysSLC1.addActionListener(this);
        buttonGroup.add(this.btnSysSLC1);
        ++gridBagConstraints3.gridy;
        jPanel.add((Component)this.btnSysSLC1, gridBagConstraints3);
        this.btnSysVCS80 = new JRadioButton("VCS80", false);
        this.btnSysVCS80.addActionListener(this);
        buttonGroup.add(this.btnSysVCS80);
        ++gridBagConstraints3.gridy;
        jPanel.add((Component)this.btnSysVCS80, gridBagConstraints3);
        this.btnSysZ1013 = new JRadioButton("Z1013", false);
        this.btnSysZ1013.addActionListener(this);
        buttonGroup.add(this.btnSysZ1013);
        ++gridBagConstraints3.gridy;
        jPanel.add((Component)this.btnSysZ1013, gridBagConstraints3);
        this.btnSysZ9001 = new JRadioButton("Z9001", false);
        this.btnSysZ9001.addActionListener(this);
        buttonGroup.add(this.btnSysZ9001);
        ++gridBagConstraints3.gridy;
        jPanel.add((Component)this.btnSysZ9001, gridBagConstraints3);
        this.btnSysZXSpectrum = new JRadioButton("ZX Spectrum", false);
        this.btnSysZXSpectrum.addActionListener(this);
        buttonGroup.add(this.btnSysZXSpectrum);
        ++gridBagConstraints3.gridy;
        jPanel.add((Component)this.btnSysZXSpectrum, gridBagConstraints3);
        this.btnSysCustomSys = new JRadioButton("Benutzerdefinierter Computer", false);
        this.btnSysCustomSys.addActionListener(this);
        buttonGroup.add(this.btnSysCustomSys);
        gridBagConstraints3.insets.top = 10;
        gridBagConstraints3.insets.bottom = 5;
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy += 2;
        jPanel.add((Component)this.btnSysCustomSys, gridBagConstraints3);
        this.cardLayoutSysOpt = new CardLayout(5, 5);
        this.curSysOptCard = null;
        this.panelSysOpt = new JPanel(this.cardLayoutSysOpt);
        this.panelSysOpt.setBorder(BorderFactory.createTitledBorder("Optionen"));
        gridBagConstraints3.anchor = 10;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.gridheight = 0;
        gridBagConstraints3.gridy = 0;
        ++gridBagConstraints3.gridx;
        this.tabSys.add((Component)this.panelSysOpt, "Center");
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.panelSysOpt.add((Component)jPanel2, CARD_EMPTY);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0);
        jPanel2.add((Component)new JLabel("Keine Optionen verf\u00fcgbar"), gridBagConstraints4);
        this.a5105SettingsFld = new A5105SettingsFld(this, "jkcemu.a5105.");
        this.panelSysOpt.add((Component)this.a5105SettingsFld, "A5105");
        this.ac1SettingsFld = new AC1SettingsFld(this, "jkcemu.ac1.");
        this.panelSysOpt.add((Component)this.ac1SettingsFld, "AC1");
        this.bcs3SettingsFld = new BCS3SettingsFld(this, "jkcemu.bcs3.");
        this.panelSysOpt.add((Component)this.bcs3SettingsFld, "BCS3");
        this.customSysSettingsFld = new CustomSysSettingsFld(this, "jkcemu.customsys.");
        this.panelSysOpt.add((Component)this.customSysSettingsFld, "CUSTOMSYS");
        this.hc900SettingsFld = new KC85SettingsFld(this, "jkcemu.hc900.", 2);
        this.panelSysOpt.add((Component)this.hc900SettingsFld, "HC900");
        this.hemcSettingsFld = new HueblerEvertMCSettingsFld(this, "jkcemu.hemc.");
        this.panelSysOpt.add((Component)this.hemcSettingsFld, "HueblerEvertMC");
        this.hgmcSettingsFld = new HueblerGraphicsMCSettingsFld(this, "jkcemu.hgmc.");
        this.panelSysOpt.add((Component)this.hgmcSettingsFld, "HueblerGraphicsMC");
        this.kc85_1_SettingsFld = new Z9001SettingsFld(this, "jkcemu.kc85_1.", false);
        this.panelSysOpt.add((Component)this.kc85_1_SettingsFld, "KC85_1");
        this.kc85_2_SettingsFld = new KC85SettingsFld(this, "jkcemu.kc85_2.", 2);
        this.panelSysOpt.add((Component)this.kc85_2_SettingsFld, "KC85_2");
        this.kc85_3_SettingsFld = new KC85SettingsFld(this, "jkcemu.kc85_3.", 3);
        this.panelSysOpt.add((Component)this.kc85_3_SettingsFld, "KC85_3");
        this.kc85_4_SettingsFld = new KC85SettingsFld(this, "jkcemu.kc85_4.", 4);
        this.panelSysOpt.add((Component)this.kc85_4_SettingsFld, "KC85_4");
        this.kc85_5_SettingsFld = new KC85SettingsFld(this, "jkcemu.kc85_5.", 5);
        this.panelSysOpt.add((Component)this.kc85_5_SettingsFld, "KC85_5");
        this.kc87SettingsFld = new Z9001SettingsFld(this, "jkcemu.kc87.", true);
        this.panelSysOpt.add((Component)this.kc87SettingsFld, "KC87");
        this.kcCompactSettingsFld = new KCcompactSettingsFld(this, "jkcemu.kccompact.");
        this.panelSysOpt.add((Component)this.kcCompactSettingsFld, "KCcompact");
        this.kramerMCSettingsFld = new KramerMCSettingsFld(this, "jkcemu.kramermc.");
        this.panelSysOpt.add((Component)this.kramerMCSettingsFld, "KramerMC");
        this.lc80SettingsFld = new LC80SettingsFld(this, "jkcemu.lc80.");
        this.panelSysOpt.add((Component)this.lc80SettingsFld, "LC80");
        this.llc1SettingsFld = new LLC1SettingsFld(this, "jkcemu.llc1.");
        this.panelSysOpt.add((Component)this.llc1SettingsFld, "LLC1");
        this.llc2SettingsFld = new LLC2SettingsFld(this, "jkcemu.llc2.");
        this.panelSysOpt.add((Component)this.llc2SettingsFld, "LLC2");
        this.nanosSettingsFld = new NANOSSettingsFld(this, "jkcemu.nanos.");
        this.panelSysOpt.add((Component)this.nanosSettingsFld, "NANOS");
        this.pcmSettingsFld = new PCMSettingsFld(this, "jkcemu.pcm.");
        this.panelSysOpt.add((Component)this.pcmSettingsFld, "PCM");
        this.poly880SettingsFld = new Poly880SettingsFld(this, "jkcemu.poly880.");
        this.panelSysOpt.add((Component)this.poly880SettingsFld, "Poly880");
        this.z1013SettingsFld = new Z1013SettingsFld(this, "jkcemu.z1013.");
        this.panelSysOpt.add((Component)this.z1013SettingsFld, "Z1013");
        this.z9001SettingsFld = new Z9001SettingsFld(this, "jkcemu.z9001.", false);
        this.panelSysOpt.add((Component)this.z9001SettingsFld, "Z9001");
        this.zxSpectrumSettingsFld = new ZXSpectrumSettingsFld(this, "jkcemu.zxspectrum.");
        this.panelSysOpt.add((Component)this.zxSpectrumSettingsFld, "ZXSpectrum");
        this.tabSpeed = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Geschwindigkeit", this.tabSpeed);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.tabSpeed.add((Component)new JLabel("Geschwindigkeit des emulierten Systems:"), gridBagConstraints5);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.btnSpeedDefault = new JRadioButton("Begrenzen auf Originalgeschwindigkeit", true);
        this.btnSpeedDefault.addActionListener(this);
        buttonGroup2.add(this.btnSpeedDefault);
        gridBagConstraints5.insets.top = 0;
        gridBagConstraints5.insets.left = 50;
        ++gridBagConstraints5.gridy;
        this.tabSpeed.add((Component)this.btnSpeedDefault, gridBagConstraints5);
        this.btnSpeedValue = new JRadioButton("Begrenzen auf:", false);
        this.btnSpeedValue.addActionListener(this);
        buttonGroup2.add(this.btnSpeedValue);
        gridBagConstraints5.insets.bottom = 5;
        gridBagConstraints5.gridwidth = 1;
        ++gridBagConstraints5.gridy;
        this.tabSpeed.add((Component)this.btnSpeedValue, gridBagConstraints5);
        this.fldSpeed = new JTextField(5);
        this.docSpeed = this.fldSpeed.getDocument();
        if (this.docSpeed != null) {
            this.docSpeed.addDocumentListener(this);
        }
        gridBagConstraints5.insets.left = 5;
        ++gridBagConstraints5.gridx;
        this.tabSpeed.add((Component)this.fldSpeed, gridBagConstraints5);
        this.labelSpeedUnit = new JLabel("MHz");
        gridBagConstraints5.insets.left = 5;
        ++gridBagConstraints5.gridx;
        this.tabSpeed.add((Component)this.labelSpeedUnit, gridBagConstraints5);
        this.tabScreen = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Bildschirmausgabe", this.tabScreen);
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 10, 5), 0, 0);
        this.tabScreen.add((Component)new JLabel("Helligkeit [%]:"), gridBagConstraints6);
        this.sliderBrightness = new JSlider(0, 0, 100, 80);
        this.sliderBrightness.setMajorTickSpacing(20);
        this.sliderBrightness.setPaintLabels(true);
        this.sliderBrightness.setPaintTrack(true);
        this.sliderBrightness.setSnapToTicks(false);
        this.sliderBrightness.addChangeListener(this);
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.gridwidth = 0;
        ++gridBagConstraints6.gridx;
        this.tabScreen.add((Component)this.sliderBrightness, gridBagConstraints6);
        gridBagConstraints6.anchor = 13;
        gridBagConstraints6.fill = 0;
        gridBagConstraints6.weightx = 0.0;
        gridBagConstraints6.gridwidth = 1;
        gridBagConstraints6.gridx = 0;
        ++gridBagConstraints6.gridy;
        this.tabScreen.add((Component)new JLabel("Rand:"), gridBagConstraints6);
        this.spinnerModelMargin = new SpinnerNumberModel(20, 0, 199, 1);
        this.spinnerMargin = new JSpinner(this.spinnerModelMargin);
        this.spinnerMargin.addChangeListener(this);
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.fill = 2;
        ++gridBagConstraints6.gridx;
        this.tabScreen.add((Component)this.spinnerMargin, gridBagConstraints6);
        gridBagConstraints6.fill = 0;
        ++gridBagConstraints6.gridx;
        this.tabScreen.add((Component)new JLabel("Pixel"), gridBagConstraints6);
        gridBagConstraints6.anchor = 13;
        gridBagConstraints6.gridx = 0;
        ++gridBagConstraints6.gridy;
        this.tabScreen.add((Component)new JLabel("Aktualisierungszyklus:"), gridBagConstraints6);
        this.comboScreenRefresh = new JComboBox();
        this.comboScreenRefresh.setEditable(false);
        this.comboScreenRefresh.addItem("10");
        this.comboScreenRefresh.addItem("20");
        this.comboScreenRefresh.addItem("30");
        this.comboScreenRefresh.addItem("50");
        this.comboScreenRefresh.addItem("100");
        this.comboScreenRefresh.addItem("200");
        this.comboScreenRefresh.addActionListener(this);
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.fill = 2;
        ++gridBagConstraints6.gridx;
        this.tabScreen.add(this.comboScreenRefresh, gridBagConstraints6);
        gridBagConstraints6.fill = 0;
        ++gridBagConstraints6.gridx;
        this.tabScreen.add((Component)new JLabel("ms"), gridBagConstraints6);
        this.btnDirectCopyPaste = new JCheckBox("Direktes \"Kopieren & Einf\u00fcgen\" durch Dr\u00fccken der mittleren Maustaste", true);
        this.btnDirectCopyPaste.addActionListener(this);
        gridBagConstraints6.anchor = 10;
        gridBagConstraints6.insets.top = 10;
        gridBagConstraints6.gridwidth = 0;
        gridBagConstraints6.gridx = 0;
        ++gridBagConstraints6.gridy;
        this.tabScreen.add((Component)this.btnDirectCopyPaste, gridBagConstraints6);
        Font font = this.comboScreenRefresh.getFont();
        if (font != null) {
            this.spinnerMargin.setFont(font);
        }
        this.tabConfirm = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Best\u00e4tigungen", this.tabConfirm);
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.tabConfirm.add((Component)new JLabel("Folgende Aktionen m\u00fcssen in einem Dialog best\u00e4tigt werden:"), gridBagConstraints7);
        this.btnConfirmNMI = new JCheckBox("Nicht maskierbarer Interrupt (NMI)", true);
        this.btnConfirmNMI.addActionListener(this);
        gridBagConstraints7.insets.top = 0;
        gridBagConstraints7.insets.left = 50;
        ++gridBagConstraints7.gridy;
        this.tabConfirm.add((Component)this.btnConfirmNMI, gridBagConstraints7);
        this.btnConfirmReset = new JCheckBox("Emulator zur\u00fccksetzen (RESET)", false);
        this.btnConfirmReset.addActionListener(this);
        ++gridBagConstraints7.gridy;
        this.tabConfirm.add((Component)this.btnConfirmReset, gridBagConstraints7);
        this.btnConfirmPowerOn = new JCheckBox("Einschalten emulieren (Arbeitsspeicher l\u00f6schen)", false);
        this.btnConfirmPowerOn.addActionListener(this);
        ++gridBagConstraints7.gridy;
        this.tabConfirm.add((Component)this.btnConfirmPowerOn, gridBagConstraints7);
        this.btnConfirmQuit = new JCheckBox("Emulator beenden", false);
        this.btnConfirmQuit.addActionListener(this);
        gridBagConstraints7.insets.bottom = 5;
        ++gridBagConstraints7.gridy;
        this.tabConfirm.add((Component)this.btnConfirmQuit, gridBagConstraints7);
        this.tabLAF = null;
        this.grpLAF = new ButtonGroup();
        this.lafs = UIManager.getInstalledLookAndFeels();
        if (this.lafs != null && this.lafs.length > 1) {
            this.tabLAF = new JPanel(new GridBagLayout());
            this.tabbedPane.addTab("Erscheinungsbild", this.tabLAF);
            gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
            this.tabLAF.add((Component)new JLabel("Das Aussehen von JKCEMU k\u00f6nnen Sie durch Auswahl eines Erscheinungsbildes"), gridBagConstraints);
            gridBagConstraints.insets.top = 0;
            gridBagConstraints.insets.bottom = 5;
            ++gridBagConstraints.gridy;
            this.tabLAF.add((Component)new JLabel("an Ihren pers\u00f6nlichen Geschmack anpassen:"), gridBagConstraints);
            gridBagConstraints.insets.left = 50;
            gridBagConstraints.insets.bottom = 0;
            for (int i = 0; i < this.lafs.length; ++i) {
                object = this.lafs[i].getClassName();
                if (object == null) continue;
                serializable = new JRadioButton(this.lafs[i].getName());
                this.grpLAF.add((AbstractButton)serializable);
                ((AbstractButton)serializable).setActionCommand((String)object);
                ((AbstractButton)serializable).addActionListener(this);
                if (i == this.lafs.length - 1) {
                    gridBagConstraints.insets.bottom = 5;
                }
                ++gridBagConstraints.gridy;
                this.tabLAF.add((Component)serializable, gridBagConstraints);
                this.lafClass2Button.put((String)object, (AbstractButton)serializable);
            }
        }
        this.tabKCNet = new KCNetSettingsFld(this, "jkcemu.kcnet.");
        this.tabbedPane.addTab("Netzwerk", this.tabKCNet);
        this.tabEtc = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Sonstiges", this.tabEtc);
        gridBagConstraints = new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.tabEtc.add((Component)new JLabel("Dateiauswahldialog:"), gridBagConstraints);
        ButtonGroup buttonGroup3 = new ButtonGroup();
        this.btnFileDlgEmu = new JRadioButton("JKCEMU-Dateiauswahldialog verwenden", true);
        buttonGroup3.add(this.btnFileDlgEmu);
        this.btnFileDlgEmu.addActionListener(this);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.left = 50;
        ++gridBagConstraints.gridy;
        this.tabEtc.add((Component)this.btnFileDlgEmu, gridBagConstraints);
        this.btnFileDlgSwing = new JRadioButton("Java/Swing-Dateiauswahldialog verwenden", false);
        buttonGroup3.add(this.btnFileDlgSwing);
        this.btnFileDlgSwing.addActionListener(this);
        ++gridBagConstraints.gridy;
        this.tabEtc.add((Component)this.btnFileDlgSwing, gridBagConstraints);
        this.btnFileDlgNative = new JRadioButton("Dateiauswahldialog des Betriebssystems verwenden", false);
        buttonGroup3.add(this.btnFileDlgNative);
        this.btnFileDlgNative.addActionListener(this);
        ++gridBagConstraints.gridy;
        this.tabEtc.add((Component)this.btnFileDlgNative, gridBagConstraints);
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.left = 5;
        ++gridBagConstraints.gridy;
        this.tabEtc.add((Component)new JLabel("Statische RAM-Bereiche (SRAM) initialisieren mit:"), gridBagConstraints);
        object = new ButtonGroup();
        this.btnSRAMInit00 = new JRadioButton("Nullbytes", true);
        ((ButtonGroup)object).add(this.btnSRAMInit00);
        this.btnSRAMInit00.addActionListener(this);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.left = 50;
        ++gridBagConstraints.gridy;
        this.tabEtc.add((Component)this.btnSRAMInit00, gridBagConstraints);
        this.btnSRAMInitRandom = new JRadioButton("Zufallsmuster (entspricht Originalverhalten)", false);
        ((ButtonGroup)object).add(this.btnSRAMInitRandom);
        this.btnSRAMInitRandom.addActionListener(this);
        ++gridBagConstraints.gridy;
        this.tabEtc.add((Component)this.btnSRAMInitRandom, gridBagConstraints);
        this.btnClearRFsOnPowerOn = new JCheckBox("RAM-Floppies bei jedem \"Einschalten\" l\u00f6schen", false);
        this.btnClearRFsOnPowerOn.addActionListener(this);
        gridBagConstraints.insets.top = 15;
        gridBagConstraints.insets.left = 5;
        ++gridBagConstraints.gridy;
        this.tabEtc.add((Component)this.btnClearRFsOnPowerOn, gridBagConstraints);
        this.btnReloadROMsOnPowerOn = new JCheckBox("Eingebundene ROM-Dateien bei jedem \"Einschalten\" neu laden", false);
        this.btnReloadROMsOnPowerOn.addActionListener(this);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 5;
        ++gridBagConstraints.gridy;
        this.tabEtc.add((Component)this.btnReloadROMsOnPowerOn, gridBagConstraints);
        serializable = Main.getConfigDir();
        if (serializable != null) {
            gridBagConstraints.insets.top = 15;
            gridBagConstraints.insets.bottom = 0;
            ++gridBagConstraints.gridy;
            this.tabEtc.add((Component)new JLabel("JKCEMU-Konfigurationsverzeichnis (Einstellungen und Profile)"), gridBagConstraints);
            this.fldConfigDir = new JTextField();
            this.fldConfigDir.setEditable(false);
            this.fldConfigDir.setText(((File)serializable).getPath());
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets.top = 0;
            gridBagConstraints.insets.bottom = 5;
            gridBagConstraints.gridwidth = 1;
            ++gridBagConstraints.gridy;
            this.tabEtc.add((Component)this.fldConfigDir, gridBagConstraints);
            this.btnDeleteConfigDir = new JButton("L\u00f6schen");
            this.btnDeleteConfigDir.setEnabled(((File)serializable).exists());
            this.btnDeleteConfigDir.addActionListener(this);
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets.left = 0;
            ++gridBagConstraints.gridx;
            this.tabEtc.add((Component)this.btnDeleteConfigDir, gridBagConstraints);
        } else {
            this.fldConfigDir = null;
            this.btnDeleteConfigDir = null;
        }
        JPanel jPanel3 = new JPanel(new GridLayout(5, 1, 5, 5));
        gridBagConstraints2.anchor = 12;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        ++gridBagConstraints2.gridx;
        this.add((Component)jPanel3, gridBagConstraints2);
        this.btnApply = new JButton("\u00dcbernehmen");
        this.btnApply.setEnabled(false);
        this.btnApply.addActionListener(this);
        this.btnApply.addKeyListener(this);
        jPanel3.add(this.btnApply);
        this.btnLoad = new JButton("Profil laden...");
        this.btnLoad.addActionListener(this);
        this.btnLoad.addKeyListener(this);
        jPanel3.add(this.btnLoad);
        this.btnSave = new JButton("Profil speichern...");
        this.btnSave.addActionListener(this);
        this.btnSave.addKeyListener(this);
        jPanel3.add(this.btnSave);
        this.btnHelp = new JButton("Hilfe");
        this.btnHelp.addActionListener(this);
        this.btnHelp.addKeyListener(this);
        jPanel3.add(this.btnHelp);
        this.btnClose = new JButton("Schlie\u00dfen");
        this.btnClose.addActionListener(this);
        this.btnClose.addKeyListener(this);
        jPanel3.add(this.btnClose);
        this.updFields(Main.getProperties(), UIManager.getLookAndFeel(), Integer.toString(this.screenFrm.getScreenRefreshMillis()));
        if (!super.applySettings(Main.getProperties(), true)) {
            this.pack();
            this.setLocationByPlatform(true);
        }
        this.setResizable(true);
    }

    private void applyConfirm(Properties properties) {
        properties.setProperty("jkcemu.confirm.nmi", Boolean.toString(this.btnConfirmNMI.isSelected()));
        properties.setProperty("jkcemu.confirm.reset", Boolean.toString(this.btnConfirmReset.isSelected()));
        properties.setProperty("jkcemu.confirm.power_on", Boolean.toString(this.btnConfirmPowerOn.isSelected()));
        properties.setProperty("jkcemu.confirm.quit", Boolean.toString(this.btnConfirmQuit.isSelected()));
    }

    private void applyEtc(Properties properties) {
        String string = "jkcemu";
        if (this.btnFileDlgSwing.isSelected()) {
            string = "swing";
        } else if (this.btnFileDlgNative.isSelected()) {
            string = "native";
        }
        properties.setProperty("jkcemu.filedialog", string);
        properties.setProperty("jkcemu.sram.init", this.btnSRAMInit00.isSelected() ? "00" : "random");
        properties.setProperty("jkcemu.ramfloppy.clear_on_power_on", Boolean.toString(this.btnClearRFsOnPowerOn.isSelected()));
        properties.setProperty("jkcemu.external_rom.reload_on_power_on", Boolean.toString(this.btnReloadROMsOnPowerOn.isSelected()));
    }

    private void applyLAF(Properties properties) throws UserInputException {
        String string;
        ButtonModel buttonModel = this.grpLAF.getSelection();
        if (buttonModel != null && (string = buttonModel.getActionCommand()) != null && string.length() > 0) {
            boolean bl = true;
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            if (lookAndFeel != null && string.equals(lookAndFeel.getClass().getName())) {
                bl = false;
            }
            if (bl) {
                try {
                    UIManager.setLookAndFeel(string);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SettingsFrm.this.informLAFChanged();
                        }
                    });
                    properties.setProperty("jkcemu.laf.classname", string);
                }
                catch (Exception exception) {
                    throw new UserInputException("Das Erscheinungsbild kann nicht eingestellt werden.");
                }
            }
        }
    }

    private void applyScreen(Properties properties) {
        String string;
        properties.setProperty("jkcemu.brightness", String.valueOf(this.sliderBrightness.getValue()));
        Object object = this.spinnerMargin.getValue();
        properties.setProperty("jkcemu.screen.margin", object != null ? object.toString() : "0");
        object = this.comboScreenRefresh.getSelectedItem();
        if (object != null && (string = object.toString()) != null) {
            properties.setProperty("jkcemu.screen.refresh.ms", string);
        }
        properties.setProperty("jkcemu.copy_and_paste.direct", Boolean.toString(this.btnDirectCopyPaste.isSelected()));
    }

    private void applySpeed(Properties properties) throws UserInputException {
        if (this.btnSpeedValue.isSelected()) {
            boolean bl = false;
            String string = "Sie m\u00fcssen einen Wert f\u00fcr die max. Geschwindigkeit eingeben.";
            String string2 = this.fldSpeed.getText();
            if (string2 != null && !string2.isEmpty()) {
                string = "Die eingegebene max. Geschwindigkeit ist ung\u00fcltig.";
                try {
                    long l;
                    Number number = this.fmtSpeed.parse(string2);
                    if (number != null && (l = Math.round(number.doubleValue() * 1000.0)) > 0L) {
                        properties.setProperty("jkcemu.maxspeed.khz", String.valueOf(l));
                        bl = true;
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (!bl) {
                throw new UserInputException(string);
            }
        } else {
            properties.setProperty("jkcemu.maxspeed.khz", "default");
        }
    }

    private void applySys(Properties properties) throws UserCancelException, UserInputException {
        String string = "";
        if (this.btnSysA5105.isSelected()) {
            string = "A5105";
        } else if (this.btnSysAC1.isSelected()) {
            string = "AC1";
        } else if (this.btnSysBCS3.isSelected()) {
            string = "BCS3";
        } else if (this.btnSysC80.isSelected()) {
            string = "C80";
        } else if (this.btnSysCustomSys.isSelected()) {
            string = "CUSTOMSYS";
        } else if (this.btnSysHC900.isSelected()) {
            string = "HC900";
        } else if (this.btnSysHEMC.isSelected()) {
            string = "HueblerEvertMC";
        } else if (this.btnSysHGMC.isSelected()) {
            string = "HueblerGraphicsMC";
        } else if (this.btnSysKC85_1.isSelected()) {
            string = "KC85_1";
        } else if (this.btnSysKC85_2.isSelected()) {
            string = "KC85_2";
        } else if (this.btnSysKC85_3.isSelected()) {
            string = "KC85_3";
        } else if (this.btnSysKC85_4.isSelected()) {
            string = "KC85_4";
        } else if (this.btnSysKC85_5.isSelected()) {
            string = "KC85_5";
        } else if (this.btnSysKC87.isSelected()) {
            string = "KC87";
        } else if (this.btnSysKCcompact.isSelected()) {
            string = "KCcompact";
        } else if (this.btnSysKramerMC.isSelected()) {
            string = "KramerMC";
        } else if (this.btnSysLC80.isSelected()) {
            string = this.lc80SettingsFld.getModelSysName();
        } else if (this.btnSysLLC1.isSelected()) {
            string = "LLC1";
        } else if (this.btnSysLLC2.isSelected()) {
            string = "LLC2";
        } else if (this.btnSysNANOS.isSelected()) {
            string = "NANOS";
        } else if (this.btnSysPCM.isSelected()) {
            string = "PCM";
        } else if (this.btnSysPoly880.isSelected()) {
            string = "Poly880";
        } else if (this.btnSysSC2.isSelected()) {
            string = "SC2";
        } else if (this.btnSysSLC1.isSelected()) {
            string = "SLC1";
        } else if (this.btnSysVCS80.isSelected()) {
            string = "VCS80";
        } else if (this.btnSysZ1013.isSelected()) {
            string = this.z1013SettingsFld.getModelSysName();
        } else if (this.btnSysZ9001.isSelected()) {
            string = "Z9001";
        } else if (this.btnSysZXSpectrum.isSelected()) {
            string = "ZXSpectrum";
        }
        properties.setProperty("jkcemu.system", string);
        this.a5105SettingsFld.applyInput(properties, string.equals("A5105"));
        this.ac1SettingsFld.applyInput(properties, string.equals("AC1"));
        this.bcs3SettingsFld.applyInput(properties, string.equals("BCS3"));
        this.customSysSettingsFld.applyInput(properties, string.equals("CUSTOMSYS"));
        this.hc900SettingsFld.applyInput(properties, string.equals("HC900"));
        this.hemcSettingsFld.applyInput(properties, string.equals("HueblerEvertMC"));
        this.hgmcSettingsFld.applyInput(properties, string.equals("HueblerGraphicsMC"));
        this.kc85_1_SettingsFld.applyInput(properties, string.equals("KC85_1"));
        this.kc85_2_SettingsFld.applyInput(properties, string.equals("KC85_2"));
        this.kc85_3_SettingsFld.applyInput(properties, string.equals("KC85_3"));
        this.kc85_4_SettingsFld.applyInput(properties, string.equals("KC85_4"));
        this.kc85_5_SettingsFld.applyInput(properties, string.equals("KC85_5"));
        this.kc87SettingsFld.applyInput(properties, string.equals("KC87"));
        this.kcCompactSettingsFld.applyInput(properties, string.equals("KCcompact"));
        this.kramerMCSettingsFld.applyInput(properties, string.equals("KramerMC"));
        this.lc80SettingsFld.applyInput(properties, string.startsWith("LC80"));
        this.llc1SettingsFld.applyInput(properties, string.equals("LLC1"));
        this.llc2SettingsFld.applyInput(properties, string.equals("LLC2"));
        this.nanosSettingsFld.applyInput(properties, string.equals("NANOS"));
        this.pcmSettingsFld.applyInput(properties, string.equals("PCM"));
        this.poly880SettingsFld.applyInput(properties, string.equals("Poly880"));
        this.z1013SettingsFld.applyInput(properties, string.startsWith("Z1013"));
        this.z9001SettingsFld.applyInput(properties, string.equals("Z9001"));
        this.zxSpectrumSettingsFld.applyInput(properties, string.equals("ZXSpectrum"));
    }

    private static boolean deleteDir(File file) {
        boolean bl = file.delete();
        if (!bl) {
            bl = true;
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (int i = 0; bl && i < fileArray.length; ++i) {
                    boolean bl2 = false;
                    File file2 = fileArray[i];
                    String string = file2.getName();
                    if (string != null && (string.equals(".") || string.equals(".."))) {
                        bl2 = true;
                    }
                    if (bl2) continue;
                    bl = file2.isDirectory() ? SettingsFrm.deleteDir(file2) : (file2.isFile() ? file2.delete() : false);
                }
            }
            if (bl) {
                bl = file.delete();
            }
        }
        return bl;
    }

    private static boolean differs(String string, String string2) {
        if (string == null) {
            string = "";
        }
        return !string.equals(string2 != null ? string2 : "");
    }

    private void docChanged(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.docSpeed) {
            this.setDataChanged();
        }
    }

    private void informLAFChanged() {
        Frame[] frameArray = Frame.getFrames();
        if (frameArray != null) {
            for (int i = 0; i < frameArray.length; ++i) {
                Frame frame = frameArray[i];
                if (frame == null) continue;
                SwingUtilities.updateComponentTreeUI(frame);
                if (!(frame instanceof BaseFrm)) continue;
                ((BaseFrm)frame).lookAndFeelChanged();
                if (frame.isResizable()) continue;
                frame.pack();
            }
        }
    }

    private void setDataChanged() {
        this.btnApply.setEnabled(true);
        if (this.btnSave != null) {
            this.btnSave.setEnabled(false);
        }
    }

    private void setSpeedValueFld(int n) {
        this.fldSpeed.setText(this.fmtSpeed.format((double)n / 1000.0));
    }

    private void updFields(Properties properties, LookAndFeel lookAndFeel, String string) {
        Object object;
        int n;
        switch (EmuUtil.getProperty(properties, "jkcemu.system")) {
            case "AC1": {
                this.btnSysAC1.setSelected(true);
                break;
            }
            case "BCS3": {
                this.btnSysBCS3.setSelected(true);
                break;
            }
            case "C80": {
                this.btnSysC80.setSelected(true);
                break;
            }
            case "CUSTOMSYS": {
                this.btnSysCustomSys.setSelected(true);
                break;
            }
            case "HC900": {
                this.btnSysHC900.setSelected(true);
                break;
            }
            case "HueblerEvertMC": {
                this.btnSysHEMC.setSelected(true);
                break;
            }
            case "HueblerGraphicsMC": {
                this.btnSysHGMC.setSelected(true);
                break;
            }
            case "KC85_1": {
                this.btnSysKC85_1.setSelected(true);
                break;
            }
            case "KC85_2": {
                this.btnSysKC85_2.setSelected(true);
                break;
            }
            case "KC85_3": {
                this.btnSysKC85_3.setSelected(true);
                break;
            }
            case "KC85_4": {
                this.btnSysKC85_4.setSelected(true);
                break;
            }
            case "KC85_5": {
                this.btnSysKC85_5.setSelected(true);
                break;
            }
            case "KC87": {
                this.btnSysKC87.setSelected(true);
                break;
            }
            case "KCcompact": {
                this.btnSysKCcompact.setSelected(true);
                break;
            }
            case "KramerMC": {
                this.btnSysKramerMC.setSelected(true);
                break;
            }
            case "LC80_U505": 
            case "LC80_2716": 
            case "LC80_2": 
            case "LC80_E": 
            case "LC80_EX": {
                this.btnSysLC80.setSelected(true);
                break;
            }
            case "LLC1": {
                this.btnSysLLC1.setSelected(true);
                break;
            }
            case "LLC2": {
                this.btnSysLLC2.setSelected(true);
                break;
            }
            case "NANOS": {
                this.btnSysNANOS.setSelected(true);
                break;
            }
            case "PCM": {
                this.btnSysPCM.setSelected(true);
                break;
            }
            case "Poly880": {
                this.btnSysPoly880.setSelected(true);
                break;
            }
            case "SC2": {
                this.btnSysSC2.setSelected(true);
                break;
            }
            case "SLC1": {
                this.btnSysSLC1.setSelected(true);
                break;
            }
            case "VCS80": {
                this.btnSysVCS80.setSelected(true);
                break;
            }
            case "Z1013.01": 
            case "Z1013.12": 
            case "Z1013.16": 
            case "Z1013.64": {
                this.btnSysZ1013.setSelected(true);
                break;
            }
            case "Z9001": {
                this.btnSysZ9001.setSelected(true);
                break;
            }
            case "ZXSpectrum": {
                this.btnSysZXSpectrum.setSelected(true);
                break;
            }
            default: {
                this.btnSysA5105.setSelected(true);
            }
        }
        this.a5105SettingsFld.updFields(properties);
        this.ac1SettingsFld.updFields(properties);
        this.bcs3SettingsFld.updFields(properties);
        this.customSysSettingsFld.updFields(properties);
        this.hc900SettingsFld.updFields(properties);
        this.hemcSettingsFld.updFields(properties);
        this.hgmcSettingsFld.updFields(properties);
        this.kramerMCSettingsFld.updFields(properties);
        this.kc85_1_SettingsFld.updFields(properties);
        this.kc85_2_SettingsFld.updFields(properties);
        this.kc85_3_SettingsFld.updFields(properties);
        this.kc85_4_SettingsFld.updFields(properties);
        this.kc85_5_SettingsFld.updFields(properties);
        this.kc87SettingsFld.updFields(properties);
        this.kcCompactSettingsFld.updFields(properties);
        this.llc1SettingsFld.updFields(properties);
        this.llc2SettingsFld.updFields(properties);
        this.nanosSettingsFld.updFields(properties);
        this.pcmSettingsFld.updFields(properties);
        this.poly880SettingsFld.updFields(properties);
        this.lc80SettingsFld.updFields(properties);
        this.z1013SettingsFld.updFields(properties);
        this.z9001SettingsFld.updFields(properties);
        this.zxSpectrumSettingsFld.updFields(properties);
        this.updSysOptCard();
        boolean bl = false;
        int n2 = EmuThread.getDefaultSpeedKHz(properties);
        String string2 = EmuUtil.getProperty(properties, "jkcemu.maxspeed.khz").toLowerCase();
        if (!string2.isEmpty()) {
            try {
                n = Integer.parseInt(string2);
                if (n > 0 && n != n2) {
                    this.setSpeedValueFld(n);
                    this.btnSpeedValue.setSelected(true);
                    bl = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!bl) {
            this.setSpeedValueFld(n2);
            this.btnSpeedDefault.setSelected(true);
        }
        this.updSpeedFieldsEnabled();
        n = EmuUtil.getIntProperty(properties, "jkcemu.brightness", 80);
        if (n >= 0 && n <= 100) {
            this.sliderBrightness.setValue(n);
        }
        try {
            int n3 = EmuUtil.getIntProperty(properties, "jkcemu.screen.margin", 20);
            if (n3 >= 0 && n3 <= 199) {
                this.spinnerModelMargin.setValue(n3);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (string == null) {
            string = properties.getProperty("jkcemu.screen.refresh.ms");
        }
        if (string != null && (string = string.trim()).isEmpty()) {
            string = null;
        }
        if (string == null) {
            string = Integer.toString(ScreenFrm.getDefaultScreenRefreshMillis());
        }
        this.comboScreenRefresh.setSelectedItem(string);
        this.btnDirectCopyPaste.setSelected(EmuUtil.getBooleanProperty(properties, "jkcemu.copy_and_paste.direct", true));
        this.btnConfirmNMI.setSelected(EmuUtil.getBooleanProperty(properties, "jkcemu.confirm.nmi", true));
        this.btnConfirmReset.setSelected(EmuUtil.getBooleanProperty(properties, "jkcemu.confirm.reset", false));
        this.btnConfirmPowerOn.setSelected(EmuUtil.getBooleanProperty(properties, "jkcemu.confirm.power_on", false));
        this.btnConfirmQuit.setSelected(EmuUtil.getBooleanProperty(properties, "jkcemu.confirm.quit", false));
        String string3 = null;
        if (lookAndFeel != null) {
            string3 = lookAndFeel.getClass().getName();
        }
        if (lookAndFeel == null) {
            string3 = properties.getProperty("jkcemu.laf.classname");
        }
        if (string3 != null && (object = this.lafClass2Button.get(string3)) != null) {
            ((AbstractButton)object).setSelected(true);
        }
        this.tabKCNet.updFields(properties);
        switch (EmuUtil.getProperty(properties, "jkcemu.filedialog")) {
            case "native": {
                this.btnFileDlgNative.setSelected(true);
                break;
            }
            case "swing": {
                this.btnFileDlgSwing.setSelected(true);
                break;
            }
            default: {
                this.btnFileDlgEmu.setSelected(true);
            }
        }
        if (EmuUtil.getProperty(properties, "jkcemu.sram.init").equalsIgnoreCase("random")) {
            this.btnSRAMInitRandom.setSelected(true);
        } else {
            this.btnSRAMInit00.setSelected(true);
        }
        this.btnClearRFsOnPowerOn.setSelected(EmuUtil.getBooleanProperty(properties, "jkcemu.ramfloppy.clear_on_power_on", false));
        this.btnReloadROMsOnPowerOn.setSelected(EmuUtil.getBooleanProperty(properties, "jkcemu.external_rom.reload_on_power_on", false));
    }

    private void updSpeedFieldsEnabled() {
        boolean bl = this.btnSpeedValue.isSelected();
        this.fldSpeed.setEnabled(bl);
        this.labelSpeedUnit.setEnabled(bl);
    }

    private void updSysOptCard() {
        String string = CARD_EMPTY;
        if (this.btnSysA5105.isSelected()) {
            string = "A5105";
        } else if (this.btnSysAC1.isSelected()) {
            string = "AC1";
        } else if (this.btnSysBCS3.isSelected()) {
            string = "BCS3";
        } else if (this.btnSysCustomSys.isSelected()) {
            string = "CUSTOMSYS";
        } else if (this.btnSysHC900.isSelected()) {
            string = "HC900";
        } else if (this.btnSysHEMC.isSelected()) {
            string = "HueblerEvertMC";
        } else if (this.btnSysHGMC.isSelected()) {
            string = "HueblerGraphicsMC";
        } else if (this.btnSysKC85_1.isSelected()) {
            string = "KC85_1";
        } else if (this.btnSysKC85_2.isSelected()) {
            string = "KC85_2";
        } else if (this.btnSysKC85_3.isSelected()) {
            string = "KC85_3";
        } else if (this.btnSysKC85_4.isSelected()) {
            string = "KC85_4";
        } else if (this.btnSysKC85_5.isSelected()) {
            string = "KC85_5";
        } else if (this.btnSysKC87.isSelected()) {
            string = "KC87";
        } else if (this.btnSysKCcompact.isSelected()) {
            string = "KCcompact";
        } else if (this.btnSysKramerMC.isSelected()) {
            string = "KramerMC";
        } else if (this.btnSysLC80.isSelected()) {
            string = "LC80";
        } else if (this.btnSysNANOS.isSelected()) {
            string = "NANOS";
        } else if (this.btnSysPCM.isSelected()) {
            string = "PCM";
        } else if (this.btnSysPoly880.isSelected()) {
            string = "Poly880";
        } else if (this.btnSysLLC1.isSelected()) {
            string = "LLC1";
        } else if (this.btnSysLLC2.isSelected()) {
            string = "LLC2";
        } else if (this.btnSysZ1013.isSelected()) {
            string = "Z1013";
        } else if (this.btnSysZ9001.isSelected()) {
            string = "Z9001";
        } else if (this.btnSysZXSpectrum.isSelected()) {
            string = "ZXSpectrum";
        }
        this.cardLayoutSysOpt.show(this.panelSysOpt, string);
        this.curSysOptCard = string;
    }
}

