/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;
import jkcemu.base.HexDocument;
import jkcemu.base.LimitedDocument;
import jkcemu.base.UserInputException;

public class ReplyFileHeadDlg
extends BaseDlg
implements DocumentListener {
    private boolean approved = false;
    private int approvedBegAddr = 0;
    private int approvedEndAddr = 0;
    private int approvedStartAddr = 0;
    private char approvedScchFileType = '\u0000';
    private String approvedFileName = null;
    private HexDocument docBegAddr = null;
    private HexDocument docEndAddr;
    private HexDocument docStartAddr = null;
    private LimitedDocument docFileName;
    private JComboBox<String> comboScchFileType;
    private JTextField fldFileName = null;
    private JButton btnApprove;
    private JButton btnCancel;

    public ReplyFileHeadDlg(Window window, String string, String string2, String string3, Option ... optionArray) {
        super(window, string3);
        int[] nArray;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        if (optionArray != null) {
            for (int i = 0; i < optionArray.length; ++i) {
                if (i == 0) {
                    gridBagConstraints.insets.bottom = 0;
                } else if (i == optionArray.length - 1) {
                    gridBagConstraints.insets.bottom = 5;
                }
                int n = 0;
                String string4 = null;
                String string5 = null;
                JComponent jComponent = null;
                switch (optionArray[i]) {
                    case BEGIN_ADDRESS: {
                        string5 = "Anfangsadresse:";
                        this.docBegAddr = new HexDocument(4, string5);
                        jComponent = new JTextField(this.docBegAddr, "", 0);
                        break;
                    }
                    case END_ADDRESS: {
                        string5 = "Endadresse (optional):";
                        this.docEndAddr = new HexDocument(4, string5);
                        jComponent = new JTextField(this.docEndAddr, "", 0);
                        break;
                    }
                    case START_ADDRESS: {
                        string5 = "Startadresse (optional):";
                        this.docStartAddr = new HexDocument(4, string5);
                        jComponent = new JTextField(this.docStartAddr, "", 0);
                        break;
                    }
                    case FILE_NAME_6: 
                    case FILE_NAME_8: 
                    case FILE_NAME_16: {
                        if (string != null) {
                            int n2 = string.indexOf(46);
                            string4 = n2 > 1 ? string.substring(0, n2) : string;
                            string4 = string4.toUpperCase();
                        }
                        string5 = "Dateiname:";
                        n = optionArray[i] == Option.FILE_NAME_6 ? 6 : (optionArray[i] == Option.FILE_NAME_8 ? 8 : 16);
                        this.docFileName = new LimitedDocument(n);
                        this.docFileName.setAsciiOnly(true);
                        jComponent = this.fldFileName = new JTextField(this.docFileName, string4, n);
                        break;
                    }
                    case SCCH_FILE_TYPE: {
                        string5 = "Dateityp:";
                        this.comboScchFileType = new JComboBox<String>(new String[]{"P Programm", "D Daten", "B BASIC-Programm", "F BASIC-Feld"});
                        this.comboScchFileType.setEditable(false);
                        jComponent = this.comboScchFileType;
                    }
                }
                if (string5 == null || jComponent == null) continue;
                gridBagConstraints.fill = 0;
                gridBagConstraints.weightx = 0.0;
                this.add((Component)new JLabel(string5), gridBagConstraints);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 1.0;
                ++gridBagConstraints.gridx;
                this.add((Component)jComponent, gridBagConstraints);
                gridBagConstraints.gridx = 0;
                ++gridBagConstraints.gridy;
            }
        }
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.bottom = 5;
        this.add((Component)jPanel, gridBagConstraints);
        this.btnApprove = new JButton(string2);
        this.btnApprove.addActionListener(this);
        jPanel.add(this.btnApprove);
        this.btnCancel = new JButton("Abbrechen");
        this.btnCancel.addActionListener(this);
        jPanel.add(this.btnCancel);
        this.pack();
        this.setParentCentered();
        this.setResizable(false);
        if (string != null && (this.docBegAddr != null || this.docStartAddr != null) && (nArray = EmuUtil.extractAddressesFromFileName(string)) != null) {
            if (nArray.length > 0 && this.docBegAddr != null) {
                this.docBegAddr.setValue(nArray[0], 4);
            }
            if (nArray.length > 1 && this.docEndAddr != null) {
                this.docEndAddr.setValue(nArray[1], 4);
            }
            if (nArray.length > 2 && this.docStartAddr != null) {
                this.docStartAddr.setValue(nArray[2], 4);
            }
        }
        this.checkApprovedBtnEnabled();
        if (this.docBegAddr != null) {
            this.docBegAddr.addDocumentListener(this);
        }
        if (this.docEndAddr != null) {
            this.docEndAddr.addDocumentListener(this);
        }
        if (this.docFileName != null) {
            this.docFileName.addDocumentListener(this);
        }
    }

    public int getApprovedBeginAddress() {
        return this.approvedBegAddr;
    }

    public int getApprovedEndAddress() {
        return this.approvedEndAddr;
    }

    public String getApprovedFileName() {
        return this.approvedFileName;
    }

    public char getApprovedSCCHFileType() {
        return this.approvedScchFileType;
    }

    public int getApprovedStartAddress() {
        return this.approvedStartAddr;
    }

    public boolean wasApproved() {
        return this.approved;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.docChanged(documentEvent);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.docChanged(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.docChanged(documentEvent);
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        Object object;
        boolean bl = false;
        if (eventObject != null && (object = eventObject.getSource()) != null) {
            if (object == this.btnApprove) {
                bl = true;
                try {
                    Integer n;
                    if (this.docBegAddr != null) {
                        this.approvedBegAddr = this.docBegAddr.intValue();
                    }
                    if (this.docEndAddr != null) {
                        n = this.docEndAddr.getInteger();
                        this.approvedEndAddr = n != null ? n : -1;
                    }
                    if (this.docStartAddr != null) {
                        n = this.docStartAddr.getInteger();
                        this.approvedStartAddr = n != null ? n : -1;
                    }
                    if (this.fldFileName != null) {
                        this.approvedFileName = this.fldFileName.getText();
                        if (this.approvedFileName != null && this.approvedFileName.isEmpty()) {
                            this.approvedFileName = null;
                        }
                        if (this.approvedFileName == null) {
                            throw new UserInputException("Dateiname nicht angegeben");
                        }
                    }
                    if (this.comboScchFileType != null) {
                        String string;
                        int n2 = 80;
                        Object object2 = this.comboScchFileType.getSelectedItem();
                        if (object2 != null && (string = object2.toString()) != null && !string.isEmpty()) {
                            n2 = string.charAt(0);
                        }
                        this.approvedScchFileType = (char)n2;
                    }
                    this.approved = true;
                    this.doClose();
                }
                catch (Exception exception) {
                    ReplyFileHeadDlg.showErrorDlg((Component)this, exception);
                }
            } else if (object == this.btnCancel) {
                this.approved = false;
                bl = true;
                this.doClose();
            }
        }
        return bl;
    }

    private void checkApprovedBtnEnabled() {
        boolean bl = true;
        try {
            if (this.docBegAddr != null) {
                this.docBegAddr.intValue();
            }
            if (this.docFileName != null && this.docFileName.getLength() <= 0) {
                bl = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        this.btnApprove.setEnabled(bl);
    }

    private void docChanged(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (document != null && document == this.docBegAddr || document == this.docFileName) {
            this.checkApprovedBtnEnabled();
        }
    }

    public static enum Option {
        BEGIN_ADDRESS,
        END_ADDRESS,
        START_ADDRESS,
        FILE_NAME_6,
        FILE_NAME_8,
        FILE_NAME_16,
        SCCH_FILE_TYPE;

    }
}

