/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jkcemu.Main;
import jkcemu.base.AbstractSettingsFld;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileNameFld;
import jkcemu.base.SettingsFrm;
import jkcemu.base.UserInputException;

public class ROMFileSettingsFld
extends AbstractSettingsFld {
    private List<ChangeListener> changeListeners;
    private JLabel label;
    private FileNameFld fileNameFld;
    private JButton btnSelect;
    private JButton btnRemove;

    public ROMFileSettingsFld(SettingsFrm settingsFrm, String string, String string2) {
        super(settingsFrm, string);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.label = new JLabel(string2);
        this.add((Component)this.label, gridBagConstraints);
        this.fileNameFld = new FileNameFld();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        this.add((Component)this.fileNameFld, gridBagConstraints);
        this.btnSelect = this.createImageButton("/images/file/open.png", "ROM-Datei ausw\u00e4hlen");
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 5;
        ++gridBagConstraints.gridx;
        this.add((Component)this.btnSelect, gridBagConstraints);
        this.btnRemove = this.createImageButton("/images/file/delete.png", "ROM-Datei entfernen");
        this.btnRemove.setEnabled(false);
        ++gridBagConstraints.gridx;
        this.add((Component)this.btnRemove, gridBagConstraints);
        this.enableFileDrop(this.fileNameFld);
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList<ChangeListener>();
        }
        this.changeListeners.add(changeListener);
    }

    public File getFile() {
        return this.fileNameFld.getFile();
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(changeListener);
        }
    }

    public void setFile(File file) {
        if (this.fileNameFld.setFile(file)) {
            this.btnRemove.setEnabled(file != null && this.label.isEnabled());
            if (file != null) {
                Main.setLastFile(file, "rom");
            }
            this.fireDataChanged();
        }
    }

    public void setFileName(String string) {
        File file = null;
        if (string != null && !string.isEmpty()) {
            file = new File(string);
        }
        this.setFile(file);
    }

    public void setLabelText(String string) {
        this.label.setText(string);
    }

    @Override
    public void applyInput(Properties properties, boolean bl) throws UserInputException {
        File file = this.fileNameFld.getFile();
        EmuUtil.setProperty(properties, this.propPrefix + "file", file != null ? file.getPath() : null);
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object == this.btnSelect) {
            File file = this.selectFile("ROM-Datei ausw\u00e4hlen", "rom", this.fileNameFld.getFile(), EmuUtil.getROMFileFilter());
            if (file != null) {
                this.setFile(file);
            }
            bl = true;
        } else if (object == this.btnRemove) {
            this.setFile(null);
            this.btnRemove.setEnabled(false);
            bl = true;
        }
        return bl;
    }

    @Override
    protected boolean fileDropped(Component component, File file) {
        boolean bl = false;
        if (file != null) {
            this.setFile(file);
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fireDataChanged() {
        super.fireDataChanged();
        ROMFileSettingsFld rOMFileSettingsFld = this;
        synchronized (rOMFileSettingsFld) {
            if (this.changeListeners != null) {
                for (ChangeListener changeListener : this.changeListeners) {
                    changeListener.stateChanged(new ChangeEvent(this));
                }
            }
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.label.setEnabled(bl);
        this.fileNameFld.setEnabled(bl);
        this.btnSelect.setEnabled(bl);
        this.btnRemove.setEnabled(bl && this.fileNameFld.getFile() != null);
    }

    @Override
    public void updFields(Properties properties) {
        this.fileNameFld.setFileName(EmuUtil.getProperty(properties, this.propPrefix + "file"));
        this.btnRemove.setEnabled(this.label.isEnabled() && this.fileNameFld.getFile() != null);
    }
}

