/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;
import jkcemu.base.RAMFloppy;

public class RAMFloppyFld
extends JComponent
implements ActionListener {
    private Frame owner;
    private RAMFloppy ramFloppy;
    private JLabel labelUsedSize;
    private JButton btnLoad;
    private JButton btnSave;
    private JButton btnClear;
    private JComponent ledFld;
    private boolean ledState;
    private volatile int accessCounter;

    public RAMFloppyFld(Frame frame, RAMFloppy rAMFloppy) {
        this.owner = frame;
        this.ramFloppy = rAMFloppy;
        this.ledState = false;
        this.accessCounter = 0;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.add((Component)new JLabel("Gr\u00f6\u00dfe:"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Davon beschrieben:"), gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridy = 0;
        ++gridBagConstraints.gridx;
        this.add((Component)new JLabel(EmuUtil.formatSize(this.ramFloppy.getSize(), false, false)), gridBagConstraints);
        this.labelUsedSize = new JLabel();
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        this.add((Component)this.labelUsedSize, gridBagConstraints);
        Dimension dimension = new Dimension(30, 15);
        this.ledFld = new JPanel(){

            @Override
            public void paintComponent(Graphics graphics) {
                RAMFloppyFld.this.paintLED(graphics, this.getWidth(), this.getHeight());
            }
        };
        this.ledFld.setBorder(BorderFactory.createLoweredBevelBorder());
        this.ledFld.setOpaque(true);
        this.ledFld.setPreferredSize(dimension);
        this.ledFld.setMinimumSize(dimension);
        this.ledFld.setMaximumSize(dimension);
        gridBagConstraints.anchor = 13;
        ++gridBagConstraints.gridx;
        this.add((Component)this.ledFld, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridLayout(1, 3, 5, 5));
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel, gridBagConstraints);
        this.btnLoad = new JButton("Laden...");
        this.btnLoad.addActionListener(this);
        jPanel.add(this.btnLoad);
        this.btnSave = new JButton("Speichern...");
        this.btnSave.addActionListener(this);
        jPanel.add(this.btnSave);
        this.btnClear = new JButton("L\u00f6schen");
        this.btnClear.addActionListener(this);
        jPanel.add(this.btnClear);
        if (this.ramFloppy != null) {
            this.ramFloppy.setRAMFloppyFld(this);
        } else {
            this.btnClear.setEnabled(false);
            this.btnSave.setEnabled(false);
        }
        this.updFields();
    }

    public void checkLEDState() {
        boolean bl = false;
        if (this.accessCounter > 0) {
            --this.accessCounter;
            bl = true;
        }
        if (bl != this.ledState) {
            this.ledState = bl;
            this.ledFld.repaint();
        }
    }

    public void clear() {
        this.ramFloppy.clear();
        this.updFields();
    }

    public void fireRAMFloppyAccess() {
        this.accessCounter = 5;
    }

    public void fireRAMFloppyChanged() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RAMFloppyFld.this.updFields();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object != null) {
            if (object == this.btnClear) {
                this.doClear();
            } else if (object == this.btnLoad) {
                this.doLoad();
            } else if (object == this.btnSave) {
                this.doSave();
            }
        }
    }

    private void doClear() {
        if (this.ramFloppy != null && BaseDlg.showYesNoDlg(this, "M\u00f6chten Sie die RAM-Floppy l\u00f6schen?\nDabei gehen alle in ihr gespeicherten Daten verloren!")) {
            this.clear();
        }
    }

    private void doLoad() {
        File file;
        if (this.ramFloppy != null && (file = EmuUtil.showFileOpenDlg(this.owner, "RAM-Floppy laden", (file = this.ramFloppy.getFile()) != null ? file : Main.getLastDirFile("ramfloppy"), new FileFilter[0])) != null) {
            try {
                this.ramFloppy.load(file);
                Main.setLastFile(file, "ramfloppy");
            }
            catch (IOException iOException) {
                BaseDlg.showErrorDlg((Component)this, "Die RAM-Floppy kann nicht geladen werden.\n\n" + iOException.getMessage());
            }
        }
    }

    private void doSave() {
        File file;
        if (this.ramFloppy != null && (file = EmuUtil.showFileSaveDlg(this.owner, "RAM-Floppy speichern", (file = this.ramFloppy.getFile()) != null ? file : Main.getLastDirFile("ramfloppy"), new FileFilter[0])) != null) {
            try {
                this.ramFloppy.save(file);
                Main.setLastFile(file, "ramfloppy");
            }
            catch (IOException iOException) {
                BaseDlg.showErrorDlg((Component)this, "RAM-Floppy kann nicht gespeichert werden.\n\n" + iOException.getMessage());
            }
        }
    }

    private void paintLED(Graphics graphics, int n, int n2) {
        if (n > 0 && n2 > 0) {
            graphics.setColor(this.ledState ? Color.red : Color.gray);
            graphics.fillRect(0, 0, n, n2);
        }
    }

    private void updFields() {
        if (this.ramFloppy != null) {
            int n = this.ramFloppy.getUsedSize();
            this.labelUsedSize.setText(EmuUtil.formatSize(n, false, false));
            this.btnClear.setEnabled(n > 0);
            this.btnSave.setEnabled(this.ramFloppy.hasDataChanged());
        }
    }
}

