/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import jkcemu.base.FileTimesView;
import jkcemu.base.FileTimesViewFactory;

public class NIOFileTimesViewFactory
extends FileTimesViewFactory {
    @Override
    public FileTimesView getFileTimesView(final File file) {
        FileTimesView fileTimesView = null;
        try {
            final BasicFileAttributes basicFileAttributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            if (basicFileAttributes != null) {
                fileTimesView = new FileTimesView(){

                    @Override
                    public Long getCreationMillis() {
                        return NIOFileTimesViewFactory.toMillis(basicFileAttributes.creationTime());
                    }

                    @Override
                    public Long getLastAccessMillis() {
                        return NIOFileTimesViewFactory.toMillis(basicFileAttributes.lastAccessTime());
                    }

                    @Override
                    public Long getLastModifiedMillis() {
                        return NIOFileTimesViewFactory.toMillis(basicFileAttributes.lastModifiedTime());
                    }

                    @Override
                    public void setTimesInMillis(Long l, Long l2, Long l3) {
                        boolean bl = false;
                        try {
                            BasicFileAttributeView basicFileAttributeView = Files.getFileAttributeView(file.toPath(), BasicFileAttributeView.class, new LinkOption[0]);
                            if (basicFileAttributeView != null && basicFileAttributeView instanceof BasicFileAttributeView) {
                                basicFileAttributeView.setTimes(NIOFileTimesViewFactory.toFileTime(l3), NIOFileTimesViewFactory.toFileTime(l2), NIOFileTimesViewFactory.toFileTime(l));
                                bl = true;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (!bl && l3 != null) {
                            try {
                                file.setLastModified(l3);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                };
            }
        }
        catch (InvalidPathException invalidPathException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fileTimesView != null ? fileTimesView : super.getFileTimesView(file);
    }

    private static FileTime toFileTime(Long l) {
        return l != null ? FileTime.fromMillis(l) : null;
    }

    private static Long toMillis(FileTime fileTime) {
        return fileTime != null ? Long.valueOf(fileTime.toMillis()) : null;
    }
}

