/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jkcemu.Main;
import jkcemu.audio.AudioFrm;
import jkcemu.audio.AudioUtil;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileFormat;
import jkcemu.base.FileInfo;
import jkcemu.base.HelpFrm;
import jkcemu.base.HexDocument;
import jkcemu.base.LoadData;
import jkcemu.base.ScreenFrm;
import jkcemu.emusys.A5105;
import jkcemu.emusys.AC1;
import jkcemu.emusys.HueblerGraphicsMC;
import jkcemu.emusys.KC85;
import jkcemu.emusys.KramerMC;
import jkcemu.emusys.LLC2;
import jkcemu.emusys.Z1013;
import jkcemu.emusys.Z9001;

public class LoadDlg
extends BaseDlg
implements DocumentListener {
    public static final String PROP_KEEP_HEADER = "jkcemu.loadsave.header.keep";
    private static final String HELP_PAGE = "/help/loadsave.htm";
    private static final FileFormat[] fileFormats = new FileFormat[]{FileFormat.KCB, FileFormat.KCB_BLKN, FileFormat.KCB_BLKN_CKS, FileFormat.KCC, FileFormat.KCC_BLKN, FileFormat.KCC_BLKN_CKS, FileFormat.KCTAP_SYS, FileFormat.KCTAP_BASIC_PRG, FileFormat.KCBASIC_PRG, FileFormat.KCBASIC_HEAD_PRG, FileFormat.KCBASIC_HEAD_PRG_BLKN, FileFormat.KCBASIC_HEAD_PRG_BLKN_CKS, FileFormat.RBASIC_PRG, FileFormat.RMC, FileFormat.BASIC_PRG, FileFormat.HEADERSAVE, FileFormat.INTELHEX, FileFormat.BIN};
    private static final String textSelectFmt = "--- Bitte ausw\u00e4hlen ---";
    private static final String errMsgEmptyFile = "Die Datei enth\u00e4lt keine Daten,\ndie geladen werden k\u00f6nnten.";
    private static boolean suppressAudioMsg = false;
    private Frame owner;
    private ScreenFrm screenFrm;
    private boolean startEnabled;
    private File file;
    private byte[] fileBuf;
    private JLabel labelInfoBegAddr;
    private JLabel labelInfoEndAddr;
    private JLabel labelInfoStartAddr;
    private JLabel labelInfoType;
    private JLabel labelInfoDesc;
    private JLabel labelLoadBasicAddr;
    private JLabel labelLoadBegAddr;
    private JLabel labelLoadEndAddr;
    private JTextField fldInfoBegAddr;
    private JTextField fldInfoEndAddr;
    private JTextField fldInfoStartAddr;
    private JTextField fldInfoType;
    private JTextField fldInfoDesc;
    private JTextField fldLoadBegAddr;
    private JTextField fldLoadEndAddr;
    private JRadioButton btnLoadForRAMBasic;
    private JRadioButton btnLoadForROMBasic;
    private HexDocument docLoadBegAddr;
    private HexDocument docLoadEndAddr;
    private JCheckBox btnKeepHeader;
    private JComboBox<Object> comboFileFmt;
    private JButton btnLoad;
    private JButton btnStart;
    private JButton btnHelp;
    private JButton btnCancel;

    public static void loadFile(Frame frame, ScreenFrm screenFrm, File file, boolean bl, boolean bl2, boolean bl3) {
        byte[] byArray = null;
        FileInfo fileInfo = null;
        FileFormat fileFormat = null;
        boolean bl4 = false;
        boolean bl5 = AudioUtil.isAudioFile(file);
        if (!bl5 && (fileInfo = FileInfo.analyzeFile(byArray = LoadDlg.readFile(frame, file), file)) != null) {
            fileFormat = fileInfo.getFileFormat();
            bl4 = fileInfo.isTapeFile();
        }
        if (bl5 || bl4) {
            if (suppressAudioMsg) {
                AudioFrm.open(screenFrm).openFile(file, null, 0);
            } else {
                String string = "Die Datei kann nur \u00fcber eine Audiofunktion geladen werden.\nDazu m\u00fcssen Sie im emulierten System das Laden von Kassette\nund im Fenster Audio/Kassette das Abspielden der Datei starten.\n";
                JCheckBox jCheckBox = new JCheckBox("Diese Meldung zuk\u00fcnftig nicht mehr anzeigen", false);
                if (JOptionPane.showConfirmDialog(screenFrm, new Object[]{string, jCheckBox}, "Sound-/Tape-Datei", 2, 1) == 0) {
                    suppressAudioMsg = jCheckBox.isSelected();
                    AudioFrm.open(screenFrm).openFile(file, null, 0);
                }
            }
        } else {
            EmuThread emuThread = screenFrm.getEmuThread();
            EmuSys emuSys = screenFrm.getEmuSys();
            if (emuThread != null && emuSys != null && byArray != null) {
                Object object;
                Integer n = null;
                if (emuSys != null) {
                    n = emuSys.getLoadAddr();
                }
                boolean bl6 = false;
                if (n == null && !bl && fileFormat != null) {
                    int n2;
                    object = null;
                    try {
                        object = FileInfo.createLoadData(byArray, fileFormat);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (object != null && (n2 = ((LoadData)object).getBegAddr()) >= 0) {
                        boolean bl7 = emuSys instanceof A5105;
                        boolean bl8 = emuSys instanceof AC1;
                        boolean bl9 = emuSys instanceof LLC2;
                        boolean bl10 = emuSys instanceof HueblerGraphicsMC;
                        boolean bl11 = emuSys instanceof KC85;
                        boolean bl12 = emuSys instanceof KramerMC;
                        boolean bl13 = emuSys instanceof Z1013;
                        boolean bl14 = emuSys instanceof Z9001;
                        if (!bl3) {
                            ((LoadData)object).setStartAddr(-1);
                        }
                        if (fileFormat.equals(FileFormat.HEADERSAVE) && fileInfo.getFileType() != 67) {
                            ((LoadData)object).setStartAddr(-1);
                        }
                        if (((LoadData)object).getStartAddr() >= 0 && (bl7 && !fileFormat.equals(FileFormat.RMC) || (bl8 || bl10 || bl12 || bl9 || bl13) && !fileFormat.equals(FileFormat.HEADERSAVE) || bl11 && !fileFormat.equals(FileFormat.KCC) && !fileFormat.equals(FileFormat.KCTAP_KC85) && !fileFormat.equals(FileFormat.KCTAP_SYS) || bl14 && !fileFormat.equals(FileFormat.KCC) && !fileFormat.equals(FileFormat.KCTAP_Z9001) && !fileFormat.equals(FileFormat.KCTAP_SYS))) {
                            Object[] objectArray = new String[]{"Laden und Starten", "Nur Laden", "Abbrechen"};
                            JOptionPane jOptionPane = new JOptionPane("Der Dateityp enth\u00e4lt \u00fcblicherweise keine Programme f\u00fcr das gerade emulierte System.\nM\u00f6chten Sie trotzdem das in der Datei enthaltene Programm laden und starten?", 2);
                            jOptionPane.setOptions(objectArray);
                            jOptionPane.createDialog(frame, "Warnung").setVisible(true);
                            bl6 = true;
                            Object object2 = jOptionPane.getValue();
                            if (object2 != null) {
                                if (object2.equals(objectArray[0])) {
                                    bl6 = false;
                                } else if (object2.equals(objectArray[1])) {
                                    ((LoadData)object).setStartAddr(-1);
                                    bl6 = false;
                                }
                            }
                        }
                        if (!bl6) {
                            if (LoadDlg.confirmLoadDataInfo(frame, (LoadData)object)) {
                                emuThread.loadIntoMemory((LoadData)object);
                                Main.setLastFile(file, "software");
                                if (fileFormat.equals(FileFormat.HEADERSAVE) && bl13 && Main.getBooleanProperty(PROP_KEEP_HEADER, false) && ((LoadData)object).getOffset() == 32) {
                                    for (int i = 0; i < 32; ++i) {
                                        emuThread.setMemByte(224 + i, ((LoadData)object).getAbsoluteByte(i));
                                    }
                                }
                                LoadDlg.showLoadMsg(screenFrm, (LoadData)object);
                                LoadDlg.checkMultiTAPHandling(frame, screenFrm, file, byArray, fileInfo.getNextTAPOffset());
                            }
                            bl6 = true;
                        }
                    }
                }
                if (!bl6) {
                    object = new LoadDlg(frame, screenFrm, file, byArray, fileFormat != null ? fileFormat : FileFormat.BIN, n, bl2);
                    ((Dialog)object).setVisible(true);
                }
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updStartButton();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updStartButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updStartButton();
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        Object object;
        boolean bl = false;
        if (eventObject != null && (object = eventObject.getSource()) != null) {
            if (object == this.comboFileFmt) {
                bl = true;
                this.updFields();
            } else if (object == this.btnLoad || object == this.fldLoadEndAddr) {
                bl = true;
                this.doLoad(false);
            } else if (object == this.btnStart) {
                bl = true;
                this.doLoad(true);
            } else if (object == this.btnHelp) {
                bl = true;
                HelpFrm.open(HELP_PAGE);
            } else if (object == this.btnCancel) {
                bl = true;
                this.doClose();
            } else if (object instanceof JTextField) {
                bl = true;
                ((JTextField)object).transferFocus();
            }
        }
        return bl;
    }

    private LoadDlg(Frame frame, ScreenFrm screenFrm, File file, byte[] byArray, FileFormat fileFormat, Integer n, boolean bl) {
        super((Window)frame, "Datei laden");
        int[] nArray;
        Object object2;
        if (file != null && (object2 = file.getName()) != null) {
            this.setTitle(this.getTitle() + ": " + (String)object2);
        }
        this.owner = frame;
        this.screenFrm = screenFrm;
        this.file = file;
        this.fileBuf = byArray;
        this.startEnabled = bl;
        this.setLayout(new GridBagLayout());
        object2 = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Dateitformat und Kopfdaten"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        boolean bl2 = false;
        if (fileFormat != null) {
            if (fileFormat.equals(FileFormat.KCTAP_KC85) || fileFormat.equals(FileFormat.KCTAP_Z9001)) {
                fileFormat = FileFormat.KCTAP_SYS;
                bl2 = true;
            } else {
                for (FileFormat object3 : fileFormats) {
                    if (!object3.equals(fileFormat)) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        this.comboFileFmt = new JComboBox();
        this.comboFileFmt.setEditable(false);
        if (!bl2) {
            this.comboFileFmt.addItem(textSelectFmt);
        }
        for (FileFormat fileFormat2 : fileFormats) {
            this.comboFileFmt.addItem(fileFormat2);
        }
        if (bl2) {
            this.comboFileFmt.setSelectedItem(fileFormat);
        } else {
            this.comboFileFmt.setSelectedItem(textSelectFmt);
        }
        this.comboFileFmt.addActionListener(this);
        jPanel.add(this.comboFileFmt, gridBagConstraints);
        this.labelInfoBegAddr = new JLabel("Anfangsadresse:");
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.bottom = 2;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.labelInfoBegAddr, gridBagConstraints);
        this.labelInfoEndAddr = new JLabel("Endadresse:");
        gridBagConstraints.insets.top = 2;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.labelInfoEndAddr, gridBagConstraints);
        this.labelInfoStartAddr = new JLabel("Startadresse:");
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.labelInfoStartAddr, gridBagConstraints);
        this.labelInfoType = new JLabel("Typ:");
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.labelInfoType, gridBagConstraints);
        this.labelInfoDesc = new JLabel("Beschreibung:");
        gridBagConstraints.insets.bottom = 5;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.labelInfoDesc, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.bottom = 2;
        gridBagConstraints.gridy = 1;
        ++gridBagConstraints.gridx;
        this.fldInfoBegAddr = new JTextField();
        this.fldInfoBegAddr.setEditable(false);
        jPanel.add((Component)this.fldInfoBegAddr, gridBagConstraints);
        this.fldInfoEndAddr = new JTextField();
        this.fldInfoEndAddr.setEditable(false);
        gridBagConstraints.insets.top = 2;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.fldInfoEndAddr, gridBagConstraints);
        this.fldInfoStartAddr = new JTextField();
        this.fldInfoStartAddr.setEditable(false);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.fldInfoStartAddr, gridBagConstraints);
        this.fldInfoType = new JTextField();
        this.fldInfoType.setEditable(false);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.fldInfoType, gridBagConstraints);
        this.fldInfoDesc = new JTextField();
        this.fldInfoDesc.setEditable(false);
        gridBagConstraints.insets.bottom = 5;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.fldInfoDesc, gridBagConstraints);
        this.add((Component)jPanel, object2);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder("Ladeadressen"));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 2, 5), 0, 0);
        this.labelLoadBegAddr = new JLabel("Anfangsadresse:");
        jPanel2.add((Component)this.labelLoadBegAddr, gridBagConstraints2);
        this.docLoadBegAddr = new HexDocument(4, "Anfangsadresse");
        this.fldLoadBegAddr = new JTextField(this.docLoadBegAddr, "", 0);
        this.docLoadBegAddr.addDocumentListener(this);
        this.fldLoadBegAddr.addActionListener(this);
        this.fldLoadBegAddr.setEditable(true);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        ++gridBagConstraints2.gridx;
        jPanel2.add((Component)this.fldLoadBegAddr, gridBagConstraints2);
        if (n != null) {
            this.docLoadBegAddr.setValue(n, 4);
        }
        this.labelLoadEndAddr = new JLabel("Endadresse:");
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.insets.top = 2;
        gridBagConstraints2.insets.bottom = 5;
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        jPanel2.add((Component)this.labelLoadEndAddr, gridBagConstraints2);
        this.docLoadEndAddr = new HexDocument(4, "Endadresse");
        this.fldLoadEndAddr = new JTextField(this.docLoadEndAddr, "", 0);
        this.docLoadEndAddr.addDocumentListener(this);
        this.fldLoadEndAddr.addActionListener(this);
        this.fldLoadEndAddr.setEditable(true);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        ++gridBagConstraints2.gridx;
        jPanel2.add((Component)this.fldLoadEndAddr, gridBagConstraints2);
        this.labelLoadBasicAddr = new JLabel("KC-BASIC-Programm laden nach:");
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.insets.top = 5;
        gridBagConstraints2.insets.bottom = 2;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        jPanel2.add((Component)this.labelLoadBasicAddr, gridBagConstraints2);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btnLoadForROMBasic = new JRadioButton("0401h f\u00fcr ROM-BASIC", false);
        buttonGroup.add(this.btnLoadForROMBasic);
        gridBagConstraints2.insets.top = 2;
        gridBagConstraints2.insets.bottom = 0;
        gridBagConstraints2.insets.left = 40;
        ++gridBagConstraints2.gridy;
        jPanel2.add((Component)this.btnLoadForROMBasic, gridBagConstraints2);
        this.btnLoadForRAMBasic = new JRadioButton("2C01h f\u00fcr RAM-BASIC", true);
        buttonGroup.add(this.btnLoadForRAMBasic);
        gridBagConstraints2.insets.top = 0;
        gridBagConstraints2.insets.bottom = 5;
        ++gridBagConstraints2.gridy;
        jPanel2.add((Component)this.btnLoadForRAMBasic, gridBagConstraints2);
        this.btnKeepHeader = new JCheckBox("Kopfdaten nach 00E0-00FF laden");
        gridBagConstraints2.insets.top = 5;
        gridBagConstraints2.insets.left = 5;
        ++gridBagConstraints2.gridy;
        jPanel2.add((Component)this.btnKeepHeader, gridBagConstraints2);
        ++((GridBagConstraints)object2).gridy;
        this.add((Component)jPanel2, object2);
        JPanel jPanel3 = new JPanel(new GridLayout(this.startEnabled ? 4 : 3, 1, 5, 5));
        this.btnLoad = new JButton("Laden");
        this.btnLoad.addActionListener(this);
        this.btnLoad.addKeyListener(this);
        this.btnLoad.setEnabled(false);
        jPanel3.add(this.btnLoad);
        this.btnStart = null;
        if (this.startEnabled) {
            this.btnStart = new JButton("Starten");
            this.btnStart.addActionListener(this);
            this.btnStart.addKeyListener(this);
            this.btnStart.setEnabled(false);
            jPanel3.add(this.btnStart);
        }
        this.btnHelp = new JButton("Hilfe");
        this.btnHelp.addActionListener(this);
        this.btnHelp.addKeyListener(this);
        jPanel3.add(this.btnHelp);
        this.btnCancel = new JButton("Abbrechen");
        this.btnCancel.addActionListener(this);
        this.btnCancel.addKeyListener(this);
        jPanel3.add(this.btnCancel);
        ((GridBagConstraints)object2).anchor = 18;
        ((GridBagConstraints)object2).fill = 0;
        ((GridBagConstraints)object2).gridheight = 0;
        ((GridBagConstraints)object2).gridx = 1;
        ((GridBagConstraints)object2).gridy = 0;
        this.add((Component)jPanel3, object2);
        EmuSys emuSys = this.screenFrm.getEmuSys();
        if (emuSys != null) {
            this.btnKeepHeader.setSelected(emuSys instanceof Z1013 && Main.getBooleanProperty(PROP_KEEP_HEADER, false));
        }
        this.updFields();
        if (file != null && fileFormat != null && fileFormat.equals(FileFormat.BIN) && (nArray = EmuUtil.extractAddressesFromFileName(file.getName())) != null) {
            if (nArray.length > 0) {
                this.fldLoadBegAddr.setText(String.format("%04X", nArray[0]));
            }
            if (nArray.length > 1) {
                this.fldLoadEndAddr.setText(String.format("%04X", nArray[1]));
            }
        }
        this.pack();
        this.setParentCentered();
        this.setResizable(false);
    }

    private static void checkMultiTAPHandling(Window window, ScreenFrm screenFrm, File file, byte[] byArray, int n) {
        if (file != null && byArray != null && n > 0 && JOptionPane.showConfirmDialog(window, "Die Datei ist eine Multi-TAP-Datei, d.h., sie enth\u00e4lt mehrere Teildateien.\nEs wurde aber nur die erste Teildatei in den Arbeitsspeicher geladen.\n\nH\u00e4ufig versucht das in der ersten Teildatei enthaltene Programm,\ndie restlichen Teildateien von Kassette nachzuladen.\nSie k\u00f6nnen jetzt die Emulation des Kassettenrecorderanschlusses\nmit den restlichen Teildateien aktivieren,\nsodass das Nachladen auch im Emulator funktioniert.\n\nM\u00f6chten Sie das jetzt tun?", "Multi-TAP-Datei", 0, 2) == 0) {
            screenFrm.openAudioInFile(file, byArray, n);
        }
    }

    private static boolean confirmLoadDataInfo(Component component, LoadData loadData) {
        boolean bl = true;
        String string = loadData.getInfoMsg();
        if (string != null && !string.isEmpty() && JOptionPane.showConfirmDialog(component, string, "Achtung", 2, 2) != 0) {
            bl = false;
        }
        return bl;
    }

    private void doLoad(boolean bl) {
        EmuThread emuThread = this.screenFrm.getEmuThread();
        FileFormat fileFormat = this.getSelectedFileFormat();
        if (emuThread != null && fileFormat != null) {
            try {
                int n;
                int n2 = -1;
                int n3 = -1;
                int n4 = n3 - n2;
                if (this.docLoadBegAddr.getLength() > 0) {
                    n2 = this.docLoadBegAddr.intValue() & 0xFFFF;
                }
                if (this.docLoadEndAddr.getLength() > 0) {
                    n3 = this.docLoadEndAddr.intValue() & 0xFFFF;
                }
                LoadData loadData = FileInfo.createLoadData(this.fileBuf, fileFormat);
                if (FileInfo.isKCBasicProgramFormat(fileFormat)) {
                    loadData.relocateKCBasicProgram(this.btnLoadForRAMBasic.isSelected() ? 11265 : 1025);
                } else if (n2 >= 0) {
                    if (n2 != loadData.getBegAddr()) {
                        loadData.setStartAddr(-1);
                    }
                    loadData.setBegAddr(n2);
                    if (n3 >= 0 && (n = n3 - n2 + 1) < loadData.getLength()) {
                        loadData.setLength(n);
                        loadData.setStartAddr(-1);
                    }
                }
                if (loadData.getLength() < 1) {
                    throw new IOException(errMsgEmptyFile);
                }
                if (n2 < 0) {
                    n2 = loadData.getBegAddr();
                }
                if (n2 < 0) {
                    throw new IOException("Es ist nicht klar, wohin die Datei geladen werden soll.\nBitte Anfangsadresse im Bereich Ladeadressen ausf\u00fcllen!");
                }
                if (LoadDlg.confirmLoadDataInfo(this, loadData)) {
                    FileInfo fileInfo;
                    if (!this.startEnabled || !bl) {
                        loadData.setStartAddr(-1);
                    }
                    emuThread.loadIntoMemory(loadData);
                    Main.setLastFile(this.file, "software");
                    if (emuThread.getEmuSys() instanceof Z1013 && fileFormat.equals(FileFormat.HEADERSAVE) && this.btnKeepHeader.isSelected() && loadData.getOffset() == 32) {
                        for (n = 0; n < 32; ++n) {
                            emuThread.setMemByte(224 + n, loadData.getAbsoluteByte(n));
                        }
                    }
                    LoadDlg.showLoadMsg(this.screenFrm, loadData);
                    if ((fileFormat.equals(FileFormat.KCTAP_SYS) || fileFormat.equals(FileFormat.KCTAP_Z9001) || fileFormat.equals(FileFormat.KCTAP_KC85) || fileFormat.equals(FileFormat.KCTAP_BASIC_PRG)) && (fileInfo = FileInfo.analyzeFile(this.fileBuf, this.file)) != null && fileFormat.equals(fileInfo.getFileFormat())) {
                        LoadDlg.checkMultiTAPHandling(this, this.screenFrm, this.file, this.fileBuf, fileInfo.getNextTAPOffset());
                    }
                    this.doClose();
                }
            }
            catch (IOException iOException) {
                LoadDlg.showErrorDlg((Component)this, iOException);
            }
            catch (NumberFormatException numberFormatException) {
                LoadDlg.showErrorDlg((Component)this, numberFormatException);
            }
        }
    }

    private FileFormat getSelectedFileFormat() {
        FileFormat fileFormat = null;
        Object object = this.comboFileFmt.getSelectedItem();
        if (object != null && object instanceof FileFormat) {
            fileFormat = (FileFormat)object;
        }
        return fileFormat;
    }

    private static byte[] readFile(Component component, File file) {
        byte[] byArray = null;
        try {
            byArray = FileInfo.readFile(file);
        }
        catch (IOException iOException) {
            LoadDlg.showErrorDlg(component, "Datei kann nicht geladen werden.\n\n" + iOException.getMessage());
        }
        return byArray;
    }

    private static void showLoadMsg(ScreenFrm screenFrm, LoadData loadData) {
        if (loadData != null) {
            int n = loadData.getEndAddr();
            if (n > 65535) {
                n = 65535;
            }
            screenFrm.showStatusText(String.format("Datei nach %04X-%04X geladen", loadData.getBegAddr(), n));
        }
    }

    private void updFields() {
        EmuSys emuSys;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        String string = null;
        FileFormat fileFormat = this.getSelectedFileFormat();
        if (fileFormat != null) {
            bl = fileFormat.equals(FileFormat.HEADERSAVE);
            bl2 = fileFormat.equals(FileFormat.KCB);
            bl3 = fileFormat.equals(FileFormat.KCC);
            bl4 = fileFormat.equals(FileFormat.KCTAP_SYS) || fileFormat.equals(FileFormat.KCTAP_Z9001) || fileFormat.equals(FileFormat.KCTAP_KC85);
            bl5 = fileFormat.equals(FileFormat.KCTAP_BASIC_PRG);
            bl9 = fileFormat.equals(FileFormat.KCBASIC_PRG);
            bl8 = fileFormat.equals(FileFormat.KCBASIC_HEAD_PRG) || fileFormat.equals(FileFormat.KCBASIC_HEAD_PRG_BLKN) || fileFormat.equals(FileFormat.KCBASIC_HEAD_PRG_BLKN_CKS);
            bl10 = fileFormat.equals(FileFormat.RMC);
            bl11 = fileFormat.equals(FileFormat.BASIC_PRG) || fileFormat.equals(FileFormat.RBASIC_PRG);
            bl12 = fileFormat.equals(FileFormat.INTELHEX);
            bl13 = !fileFormat.equals(textSelectFmt);
            n = FileInfo.getBegAddr(this.fileBuf, fileFormat);
            if (n >= 0) {
                n2 = FileInfo.getEndAddr(this.fileBuf, fileFormat);
                n3 = FileInfo.getStartAddr(this.fileBuf, fileFormat);
            }
            n4 = FileInfo.getFileType(this.fileBuf, fileFormat);
            string = FileInfo.getFileDesc(this.fileBuf, fileFormat);
        }
        boolean bl14 = bl || bl2 || bl3 || bl4 || bl5 || bl8 || bl9 || bl11 || bl10 || bl12;
        this.labelInfoBegAddr.setEnabled(bl14);
        if (bl14 && n >= 0) {
            this.fldInfoBegAddr.setText(String.format("%04X", n));
        } else {
            this.fldInfoBegAddr.setText("");
        }
        boolean bl15 = bl || bl2 || bl3 || bl4 || bl5 || bl8 || bl9 || bl10;
        this.labelInfoEndAddr.setEnabled(bl15);
        if (bl15 && n2 >= 0) {
            this.fldInfoEndAddr.setText(String.format("%04X", n2));
        } else {
            this.fldInfoEndAddr.setText("");
        }
        boolean bl16 = bl || bl3 || bl4 || bl10;
        this.labelInfoStartAddr.setEnabled(bl16);
        if (bl16 && n3 >= 0) {
            this.fldInfoStartAddr.setText(String.format("%04X", n3));
        } else {
            this.fldInfoStartAddr.setText("");
        }
        this.labelInfoType.setEnabled(bl);
        if (bl && n4 >= 32 && n4 < 127) {
            this.fldInfoType.setText(Character.toString((char)n4));
        } else {
            this.fldInfoType.setText("");
        }
        boolean bl17 = bl || bl2 || bl3 || bl4 || bl5 || bl8;
        this.labelInfoDesc.setEnabled(bl17);
        if (bl17 && string != null) {
            this.fldInfoDesc.setText(string);
        } else {
            this.fldInfoDesc.setText("");
        }
        boolean bl18 = bl2 || bl5 || bl8 || bl9;
        boolean bl19 = bl13 && !bl18 && !bl11;
        this.labelLoadBegAddr.setEnabled(bl19);
        this.labelLoadEndAddr.setEnabled(bl19);
        this.fldLoadBegAddr.setEditable(bl19);
        this.fldLoadEndAddr.setEditable(bl19);
        this.labelLoadBasicAddr.setEnabled(bl18);
        this.btnLoadForRAMBasic.setEnabled(bl18);
        this.btnLoadForROMBasic.setEnabled(bl18);
        if (bl18) {
            if (this.screenFrm.getEmuSys().hasKCBasicInROM()) {
                this.btnLoadForROMBasic.setSelected(true);
            } else {
                this.btnLoadForRAMBasic.setSelected(true);
            }
        }
        if ((emuSys = this.screenFrm.getEmuSys()) != null) {
            this.btnKeepHeader.setEnabled(emuSys instanceof Z1013 && fileFormat.equals(FileFormat.HEADERSAVE));
        }
        this.btnLoad.setEnabled(bl13 && this.fileBuf.length > 0);
        this.updStartButton(bl13, n, n2, n3);
    }

    private void updStartButton(boolean bl, int n, int n2, int n3) {
        if (this.btnStart != null) {
            boolean bl2 = false;
            if (bl && this.startEnabled) {
                String string;
                if (n3 >= 0 && n3 >= n) {
                    bl2 = true;
                }
                if ((string = this.fldLoadBegAddr.getText()) != null && !string.isEmpty() && (this.docLoadBegAddr.intValue() & 0xFFFF) != n) {
                    bl2 = false;
                }
                if ((string = this.fldLoadEndAddr.getText()) != null && !string.isEmpty() && (this.docLoadEndAddr.intValue() & 0xFFFF) < n2) {
                    bl2 = false;
                }
            }
            this.btnStart.setEnabled(bl2);
        }
    }

    private void updStartButton() {
        if (this.btnStart != null) {
            boolean bl = false;
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            FileFormat fileFormat = this.getSelectedFileFormat();
            if (fileFormat != null) {
                boolean bl2 = bl = !fileFormat.equals(textSelectFmt);
                if (bl && (n = FileInfo.getBegAddr(this.fileBuf, fileFormat)) >= 0) {
                    n2 = FileInfo.getEndAddr(this.fileBuf, fileFormat);
                    n3 = FileInfo.getStartAddr(this.fileBuf, fileFormat);
                }
            }
            this.updStartButton(bl, n, n2, n3);
        }
    }
}

