/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.io.IOException;
import jkcemu.base.EmuMemView;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.FileFormat;
import jkcemu.base.FileInfo;

public class LoadData
implements EmuMemView {
    private byte[] data;
    private int offset;
    private int len;
    private int begAddr;
    private int startAddr;
    private int fileType;
    private FileFormat fileFmt;
    private String infoMsg;
    private FileInfo fileInfo;

    public LoadData(byte[] byArray, int n, int n2, int n3, int n4, FileFormat fileFormat) {
        this.data = byArray;
        this.offset = n;
        this.len = n2;
        this.begAddr = n3;
        this.startAddr = n4;
        this.fileFmt = fileFormat;
        this.fileType = -1;
        this.infoMsg = null;
    }

    public int getAbsoluteByte(int n) {
        int n2 = -1;
        if (this.data != null && n >= 0 && n < this.data.length && n < this.offset + this.len) {
            n2 = this.data[n] & 0xFF;
        }
        return n2;
    }

    public byte[] getByteArray() {
        return this.data;
    }

    public int getBegAddr() {
        return this.begAddr;
    }

    public int getEndAddr() {
        return this.begAddr + this.len - 1;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.len;
    }

    public int getFileType() {
        return this.fileType;
    }

    public String getInfoMsg() {
        return this.infoMsg;
    }

    public int getStartAddr() {
        return this.startAddr;
    }

    public void loadIntoMemory(EmuThread emuThread) {
        EmuSys emuSys;
        if (emuThread != null && this.data != null && (emuSys = emuThread.getEmuSys()) != null) {
            emuSys.loadIntoMem(this.begAddr, this.data, this.offset, this.len, this.fileFmt, this.fileType);
        }
    }

    public void relocateKCBasicProgram(int n) throws IOException {
        int n2;
        int n3 = n - this.begAddr;
        if (n3 != 0 && (n2 = Math.min(this.len, this.data.length - this.offset)) > 0) {
            int n4;
            byte[] byArray = new byte[n2];
            System.arraycopy(this.data, this.offset, byArray, 0, n2);
            int n5 = this.begAddr;
            do {
                n4 = -1;
                int n6 = n5 - this.begAddr;
                if (n6 >= 0 && n6 + 1 < byArray.length && n6 + 1 < n2 && (n4 = (byArray[n6 + 1] & 0xFF) << 8 | byArray[n6] & 0xFF) > n5) {
                    int n7 = n4 + n3;
                    byArray[n6] = (byte)(n7 & 0xFF);
                    byArray[n6 + 1] = (byte)(n7 >> 8 & 0xFF);
                }
                if (n4 <= 0 || n4 > n5) continue;
                throw new IOException("Das KC-BASIC-Programm kann nicht auf die gew\u00fcnschte Adresse reloziert werden.");
            } while ((n5 = n4) > 0);
            this.begAddr = n;
            this.offset = 0;
            this.data = byArray;
        }
    }

    public void setBegAddr(int n) {
        this.begAddr = n;
    }

    public void setFileType(int n) {
        this.fileType = n;
    }

    public void setInfoMsg(String string) {
        this.infoMsg = string;
    }

    public void setLength(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n < this.len) {
            this.len = n;
        }
    }

    public void setStartAddr(int n) {
        this.startAddr = n;
    }

    @Override
    public int getBasicMemByte(int n) {
        return this.getAbsoluteByte(this.offset + n - this.begAddr);
    }

    @Override
    public int getMemByte(int n, boolean bl) {
        return this.getAbsoluteByte(this.offset + n - this.begAddr);
    }

    @Override
    public int getMemWord(int n) {
        return this.getMemByte(n + 1, false) << 8 | this.getMemByte(n, false);
    }
}

