/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;

public class ListFocusTraversalPolicy
extends FocusTraversalPolicy {
    private Component[] components;

    public ListFocusTraversalPolicy(Component ... componentArray) {
        this.components = componentArray;
    }

    @Override
    public Component getComponentAfter(Container container, Component component) {
        return this.getComponentByOffs(component, 1);
    }

    @Override
    public Component getComponentBefore(Container container, Component component) {
        return this.getComponentByOffs(component, -1);
    }

    @Override
    public Component getDefaultComponent(Container container) {
        return this.getFirstComponent(container);
    }

    @Override
    public Component getFirstComponent(Container container) {
        Component component = null;
        if (this.components != null && this.components.length > 0) {
            component = this.components[0];
        }
        return component;
    }

    @Override
    public Component getLastComponent(Container container) {
        Component component = null;
        if (this.components != null && this.components.length > 0) {
            component = this.components[this.components.length - 1];
        }
        return component;
    }

    private Component getComponentByOffs(Component component, int n) {
        Component component2 = null;
        if (this.components != null && this.components.length > 0) {
            int n2 = -1;
            for (int i = 0; i < this.components.length; ++i) {
                if (this.components[i] != component) continue;
                component2 = this.components[(i + n) % this.components.length];
                break;
            }
        }
        return component2;
    }
}

