/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class LimitedDocument
extends PlainDocument {
    private int maxLen;
    private boolean asciiOnly;
    private boolean swapCase;

    public LimitedDocument(int n) {
        this.maxLen = n;
        this.asciiOnly = false;
        this.swapCase = false;
    }

    public LimitedDocument() {
        this(0);
    }

    public int getMaxLength() {
        return this.maxLen;
    }

    public void setAsciiOnly(boolean bl) {
        this.asciiOnly = bl;
    }

    public void setMaxLength(int n) {
        this.maxLen = n;
    }

    public void setSwapCase(boolean bl) {
        this.swapCase = bl;
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        int n2;
        char[] cArray;
        if (string != null && (this.asciiOnly || this.swapCase) && (cArray = string.toCharArray()) != null) {
            int n3 = 0;
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if (this.asciiOnly && (c < ' ' || c > '~')) continue;
                if (this.swapCase) {
                    if (Character.isUpperCase(c)) {
                        c = Character.toLowerCase(c);
                    } else if (Character.isLowerCase(c)) {
                        c = Character.toUpperCase(c);
                    }
                }
                cArray[n3++] = c;
            }
            string = n3 > 0 ? new String(cArray, 0, n3) : null;
        }
        if (string != null && (n2 = string.length()) > 0) {
            if (this.maxLen > 0 && n2 > this.maxLen - this.getLength()) {
                n2 = this.maxLen - this.getLength();
            }
            if (n2 > 0) {
                super.insertString(n, string.substring(0, n2), attributeSet);
            }
        }
    }
}

