/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.util.EventObject;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import jkcemu.Main;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.BaseFrm;
import jkcemu.base.EmuSys;
import jkcemu.base.HelpFrm;
import jkcemu.base.ScreenFrm;

public class KeyboardFrm
extends BaseFrm {
    private static final String HELP_PAGE = "/help/keyboard.htm";
    private ScreenFrm screenFrm;
    private AbstractKeyboardFld keyboardFld;
    private JMenuItem mnuClose;
    private JCheckBoxMenuItem mnuHoldShiftBtn;
    private JSeparator mnuHoldShiftSep;
    private JMenuItem mnuHelpContent;

    public KeyboardFrm(ScreenFrm screenFrm, EmuSys emuSys, AbstractKeyboardFld abstractKeyboardFld) {
        this.screenFrm = screenFrm;
        this.keyboardFld = abstractKeyboardFld;
        Main.updIcon(this);
        JMenu jMenu = new JMenu("Datei");
        jMenu.setMnemonic(68);
        this.mnuHoldShiftBtn = new JCheckBoxMenuItem("Shift- und Control-Tasten gedr\u00fcckt halten", this.keyboardFld.getHoldShift());
        this.mnuHoldShiftBtn.addActionListener(this);
        jMenu.add(this.mnuHoldShiftBtn);
        this.mnuHoldShiftSep = new JSeparator();
        jMenu.add(this.mnuHoldShiftSep);
        this.mnuClose = this.createJMenuItem("Schlie\u00dfen");
        jMenu.add(this.mnuClose);
        JMenu jMenu2 = new JMenu("?");
        this.mnuHelpContent = this.createJMenuItem("Hilfe...");
        jMenu2.add(this.mnuHelpContent);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        this.setJMenuBar(jMenuBar);
        this.setLayout(new BorderLayout());
        this.keyboardFld = abstractKeyboardFld;
        this.keyboardFld.setFocusable(true);
        this.keyboardFld.setFocusTraversalKeysEnabled(false);
        this.keyboardFld.addKeyListener(this);
        this.add((Component)this.keyboardFld, "Center");
        this.pack();
        if (!this.applySettings(Main.getProperties(), false)) {
            this.setScreenCentered();
        }
        this.setResizable(false);
        this.updWindowElements(emuSys);
    }

    public boolean accepts(EmuSys emuSys) {
        boolean bl = false;
        if (emuSys != null && this.keyboardFld.accepts(emuSys)) {
            try {
                this.keyboardFld.setEmuSys(emuSys);
                this.updWindowElements(emuSys);
                bl = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return bl;
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        Object object;
        boolean bl = false;
        if (eventObject != null && (object = eventObject.getSource()) != null) {
            if (object == this.mnuClose) {
                bl = true;
                this.doClose();
            } else if (object == this.mnuHoldShiftBtn) {
                bl = true;
                this.keyboardFld.setHoldShift(this.mnuHoldShiftBtn.isSelected());
            } else if (object == this.mnuHelpContent) {
                bl = true;
                HelpFrm.open(HELP_PAGE);
            }
        }
        return bl;
    }

    @Override
    public boolean doClose() {
        boolean bl = super.doClose();
        if (bl) {
            this.screenFrm.childFrameClosed(this);
        }
        return bl;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        boolean bl = false;
        if (keyEvent.getKeyCode() == 16 && this.keyboardFld.getSelectionChangeOnShiftOnly()) {
            bl = this.keyboardFld.changeShiftSelectionTo(true);
        }
        if (bl) {
            keyEvent.consume();
        } else {
            this.screenFrm.keyPressed(keyEvent);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        boolean bl = false;
        if (keyEvent.getKeyCode() == 16 && this.keyboardFld.getSelectionChangeOnShiftOnly()) {
            bl = this.keyboardFld.changeShiftSelectionTo(false);
        }
        if (bl) {
            keyEvent.consume();
        } else {
            this.screenFrm.keyReleased(keyEvent);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.screenFrm.keyTyped(keyEvent);
    }

    @Override
    public void resetFired() {
        this.keyboardFld.reset();
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == this) {
            Main.setWindowActivated(4);
        }
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == this) {
            Main.setWindowDeactivated(4);
        }
    }

    private void updWindowElements(EmuSys emuSys) {
        String string = this.keyboardFld.getKeyboardName();
        if (string != null) {
            this.setTitle(String.format("JKCEMU: %s", string));
        } else {
            this.setTitle(String.format("JKCEMU: %s Tastatur", emuSys.getTitle()));
        }
        boolean bl = this.keyboardFld.hasShiftKeys();
        this.mnuHoldShiftBtn.setVisible(bl);
        this.mnuHoldShiftSep.setVisible(bl);
    }
}

