/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class IntegerDocument
extends PlainDocument {
    private JTextComponent textComp;
    private Integer minValue;
    private Integer maxValue;

    public IntegerDocument(JTextComponent jTextComponent) {
        this.textComp = jTextComponent;
        this.minValue = null;
        this.maxValue = null;
        this.textComp.setDocument(this);
    }

    public IntegerDocument(JTextComponent jTextComponent, int n, int n2) {
        this(jTextComponent);
        this.minValue = n;
        this.maxValue = n2;
    }

    public IntegerDocument(JTextComponent jTextComponent, Integer n, Integer n2) {
        this(jTextComponent);
        this.minValue = n;
        this.maxValue = n2;
    }

    public void clear() {
        this.textComp.setText("");
    }

    public int intValue() throws NumberFormatException {
        String string = this.textComp.getText();
        if (string == null) {
            string = "";
        }
        return this.parseInt(string);
    }

    public Integer getInteger() throws NumberFormatException {
        Integer n = null;
        String string = this.textComp.getText();
        if (string != null && !(string = string.trim()).isEmpty()) {
            n = Integer.valueOf(string);
        }
        return n;
    }

    public void setValue(int n) {
        this.textComp.setText(String.valueOf(n));
    }

    public void setValue(Integer n) {
        if (n != null) {
            this.setValue((int)n);
        } else {
            this.clear();
        }
    }

    private int parseInt(String string) throws NumberFormatException {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.textComp.requestFocus();
            throw new NumberFormatException("Ung\u00fcltiges Format!\nBitte geben Sie eine Zahl ein.");
        }
        if (this.minValue != null && n < this.minValue) {
            this.textComp.requestFocus();
            throw new NumberFormatException("Wert zu klein, min. " + this.minValue.toString() + ".");
        }
        if (this.maxValue != null && n > this.maxValue) {
            this.textComp.requestFocus();
            throw new NumberFormatException("Wert zu gro\u00df, max. " + this.maxValue.toString() + ".");
        }
        return n;
    }
}

