/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import jkcemu.base.ByteDataSource;
import jkcemu.base.EmuUtil;

public class HexCharFld
extends JComponent
implements Scrollable {
    public static final int BYTES_PER_ROW = 16;
    public static final int MARGIN = 5;
    private static final int SEP_W = 20;
    private static final int PAD_Y = 1;
    private static final JComponent fontPrototypeFld = new JTextArea();
    private ByteDataSource dataSrc;
    private List<CaretListener> caretListeners;
    private Dimension prefScrollableVPSize;
    private boolean asciiSelected;
    private int caretPos;
    private int markPos;
    private int hRow;
    private int hChar;
    private int wChar;
    private int wHex;
    private int xHex;
    private int xAscii;
    private int visibleRows;
    private int visibleXLeft;
    private int visibleYTop;
    private int visibleWidth;
    private int visibleHeight;

    public HexCharFld(ByteDataSource byteDataSource) {
        this.dataSrc = byteDataSource;
        this.caretListeners = null;
        this.prefScrollableVPSize = null;
        this.asciiSelected = false;
        this.caretPos = -1;
        this.markPos = -1;
        this.hRow = 0;
        this.hChar = 0;
        this.wChar = 0;
        this.xHex = 0;
        this.xAscii = 0;
        this.visibleRows = 0;
        this.visibleXLeft = 0;
        this.visibleYTop = 0;
        this.visibleWidth = 0;
        this.visibleHeight = 0;
        Font font = fontPrototypeFld.getFont();
        font = font != null ? new Font("Monospaced", font.getStyle(), font.getSize()) : new Font("Monospaced", 0, 12);
        this.setFont(font);
        this.setBackground(SystemColor.text);
        this.setForeground(SystemColor.textText);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (HexCharFld.this.keyAction(keyEvent.getKeyCode(), keyEvent.isShiftDown())) {
                    keyEvent.consume();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                HexCharFld.this.mouseAction(mouseEvent.getX(), mouseEvent.getY(), false);
                mouseEvent.consume();
            }
        });
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                HexCharFld.this.mouseAction(mouseEvent.getX(), mouseEvent.getY(), true);
                mouseEvent.consume();
            }
        });
    }

    public synchronized void addCaretListener(CaretListener caretListener) {
        if (this.caretListeners == null) {
            this.caretListeners = new ArrayList<CaretListener>();
        }
        this.caretListeners.add(caretListener);
    }

    public synchronized void removeCaretListener(CaretListener caretListener) {
        if (this.caretListeners != null) {
            this.caretListeners.remove(caretListener);
        }
    }

    public void copySelectedBytesAsAscii() {
        int n = this.dataSrc.getDataLength();
        int n2 = -1;
        int n3 = -1;
        if (this.caretPos >= 0 && this.markPos >= 0) {
            n2 = Math.min(this.caretPos, this.markPos);
            n3 = Math.max(this.caretPos, this.markPos);
        } else {
            n2 = this.caretPos;
            n3 = this.caretPos;
        }
        if (n3 >= n) {
            n3 = n - 1;
        }
        if (n2 >= 0) {
            StringBuilder stringBuilder = new StringBuilder(n3 - n2 + 1);
            while (n2 <= n3) {
                int n4;
                stringBuilder.append((char)((n4 = this.dataSrc.getDataByte(n2++)) >= 32 && n4 < 127 ? n4 : 46));
            }
            if (stringBuilder.length() > 0) {
                EmuUtil.copyToClipboard(this, stringBuilder.toString());
            }
        }
    }

    public void copySelectedBytesAsHex() {
        int n = this.dataSrc.getDataLength();
        int n2 = -1;
        int n3 = -1;
        if (this.caretPos >= 0 && this.markPos >= 0) {
            n2 = Math.min(this.caretPos, this.markPos);
            n3 = Math.max(this.caretPos, this.markPos);
        } else {
            n2 = this.caretPos;
            n3 = this.caretPos;
        }
        if (n3 >= n) {
            n3 = n - 1;
        }
        if (n2 >= 0) {
            StringBuilder stringBuilder = new StringBuilder((n3 - n2 + 1) * 3);
            boolean bl = false;
            while (n2 <= n3) {
                if (bl) {
                    stringBuilder.append(' ');
                }
                int n4 = this.dataSrc.getDataByte(n2++);
                stringBuilder.append(EmuUtil.getHexChar(n4 >> 4));
                stringBuilder.append(EmuUtil.getHexChar(n4));
                bl = true;
            }
            if (stringBuilder.length() > 0) {
                EmuUtil.copyToClipboard(this, stringBuilder.toString());
            }
        }
    }

    public void copySelectedBytesAsDump() {
        int n = this.dataSrc.getDataLength();
        int n2 = -1;
        int n3 = -1;
        if (this.caretPos >= 0 && this.markPos >= 0) {
            n2 = Math.min(this.caretPos, this.markPos);
            n3 = Math.max(this.caretPos, this.markPos);
        } else {
            n2 = this.caretPos;
            n3 = this.caretPos;
        }
        if (n3 >= n) {
            n3 = n - 1;
        }
        if (n2 >= 0) {
            int n4 = n2 / 16;
            int n5 = n4 * 16;
            n4 = (n3 + 16 - 1) / 16;
            int n6 = n4 * 16;
            StringBuilder stringBuilder = new StringBuilder((n3 - n2) / 16 * 76);
            int n7 = this.dataSrc.getAddrOffset();
            String string = this.createAddrFmtString();
            while (n5 < n3) {
                int n8;
                int n9;
                stringBuilder.append(String.format(string, n7 + n5));
                stringBuilder.append("  ");
                for (n9 = 0; n9 < 16; ++n9) {
                    n8 = n5 + n9;
                    if (n8 < n) {
                        stringBuilder.append(String.format(" %02X", this.dataSrc.getDataByte(n8)));
                        continue;
                    }
                    stringBuilder.append("   ");
                }
                stringBuilder.append("   ");
                for (n9 = 0; n9 < 16 && (n8 = n5 + n9) < n; ++n9) {
                    char c = (char)this.dataSrc.getDataByte(n5 + n9);
                    if (c < ' ' || c > '\u007f') {
                        c = '.';
                    }
                    stringBuilder.append(c);
                }
                stringBuilder.append('\n');
                n5 += 16;
            }
            if (stringBuilder.length() > 0) {
                EmuUtil.copyToClipboard(this, stringBuilder.toString());
            }
        }
    }

    public String createAddrFmtString() {
        int n = this.dataSrc.getAddrOffset() + this.dataSrc.getDataLength() - 1;
        if (n < 0) {
            n = 0;
        }
        int n2 = 0;
        while (n > 0) {
            ++n2;
            n >>= 4;
        }
        return String.format("%%0%dX", n2 > 4 ? n2 : 4);
    }

    public int getCaretPosition() {
        return this.caretPos;
    }

    public int getCharWidth() {
        if (this.wChar == 0) {
            this.calcPositions();
        }
        return this.wChar;
    }

    public int getDataIndexAt(int n, int n2) {
        int n3 = -1;
        if (this.wChar > 0 && this.wHex > 0 && n2 > 5 && this.hRow > 0) {
            int n4;
            int n5 = -1;
            if (n >= this.xHex && n < this.xHex + 16 * this.wHex) {
                n4 = (n - this.xHex) % this.wHex;
                if (n4 < 2 * this.wChar) {
                    n5 = (n - this.xHex) / this.wHex;
                }
            } else if (n >= this.xAscii && n < this.xAscii + 16 * this.wChar) {
                n5 = (n - this.xAscii) / this.wChar;
            }
            if (n5 >= 0) {
                n4 = (n2 - 5) / this.hRow;
                n3 = n4 * 16 + n5;
            }
        }
        if (n3 > this.dataSrc.getDataLength()) {
            n3 = -1;
        }
        return n3;
    }

    public int getMarkPosition() {
        return this.markPos;
    }

    public int getDefaultPreferredWidth() {
        if (this.wChar == 0) {
            this.calcPositions();
        }
        return this.xAscii + 16 * this.wChar + 5;
    }

    public int getRowHeight() {
        return this.hRow;
    }

    public void refresh() {
        this.setCaretPosition(-1, false);
        Container container = this.getParent();
        if (container != null && container instanceof JViewport) {
            ((JViewport)container).setView(null);
            ((JViewport)container).setView(this);
        }
        this.invalidate();
        this.repaint();
    }

    public void setCaretPosition(int n, boolean bl) {
        if (n < 0 && n >= this.dataSrc.getDataLength()) {
            n = -1;
            bl = false;
        }
        boolean bl2 = this.caretPos != n;
        this.caretPos = n;
        if (!bl) {
            this.markPos = n;
        }
        this.scrollCaretToVisible();
        this.repaint();
        if (bl2) {
            this.fireCaretListeners();
        }
    }

    public void setSelection(int n, int n2) {
        if (n < 0 && n >= this.dataSrc.getDataLength()) {
            n = -1;
            n2 = -1;
        }
        boolean bl = this.caretPos != n;
        this.caretPos = n2;
        this.markPos = n;
        this.scrollCaretToVisible();
        this.repaint();
        if (bl) {
            this.fireCaretListeners();
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = this.prefScrollableVPSize;
        return dimension != null ? dimension : this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        int n3 = 0;
        if (n2 < 0) {
            n3 = this.visibleRows * this.hRow;
        } else if (n2 > 0) {
            n3 = this.wChar;
        }
        return n3;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        boolean bl = false;
        Container container = this.getParent();
        if (container != null && container instanceof JViewport && container.getHeight() > this.getPreferredSize().height) {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        boolean bl = false;
        Container container = this.getParent();
        if (container != null && container instanceof JViewport && container.getWidth() > this.getPreferredSize().width) {
            bl = true;
        }
        return bl;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        int n3 = 0;
        if (n2 < 0) {
            n3 = this.hRow;
        } else if (n2 > 0) {
            n3 = this.wChar;
        }
        return n3;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = null;
        if (this.isPreferredSizeSet()) {
            dimension = super.getPreferredSize();
        } else {
            int n = 0;
            int n2 = 0;
            int n3 = this.dataSrc.getDataLength();
            if (n3 > 0) {
                int n4 = (n3 + 16 - 1) / 16;
                n = n4 * this.hRow + 10;
                n2 = this.getDefaultPreferredWidth();
            }
            dimension = new Dimension(n2, n);
        }
        return dimension;
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.getWidth();
        int n6 = this.getHeight();
        if (n5 > 0 && n6 > 0) {
            Rectangle rectangle;
            Container container = this.getParent();
            if (container != null && container instanceof JViewport && (rectangle = ((JViewport)container).getViewRect()) != null) {
                n2 += rectangle.x;
                n3 += rectangle.y;
                n5 = rectangle.width;
                n6 = rectangle.height;
                n4 = rectangle.y;
            }
            graphics.setColor(this.getBackground());
            graphics.setPaintMode();
            graphics.fillRect(n2, n3, n5, n6);
            int n7 = this.dataSrc.getDataLength();
            if (n7 > 0 && this.hRow > 0) {
                if (this.wChar == 0) {
                    this.calcPositions();
                }
                graphics.setFont(this.getFont());
                int n8 = -1;
                int n9 = -1;
                if (this.caretPos >= 0 && this.markPos >= 0) {
                    n8 = Math.min(this.caretPos, this.markPos);
                    n9 = Math.max(this.caretPos, this.markPos);
                } else {
                    n8 = this.caretPos;
                    n9 = this.caretPos;
                }
                int n10 = (n4 - 5) / this.hRow * 16;
                int n11 = n10 / 16 * this.hRow;
                if (n11 < 0) {
                    n11 = 0;
                }
                n11 += 5;
                n11 += this.hChar;
                int n12 = this.dataSrc.getAddrOffset();
                String string = this.createAddrFmtString();
                while (n10 < n7 && n11 < n3 + n6 + this.hChar) {
                    char c;
                    int n13;
                    int n14;
                    ++n;
                    graphics.setColor(this.getForeground());
                    graphics.drawString(String.format(string, n12 + n10), 5, n11);
                    int n15 = this.xHex;
                    for (n14 = 0; n14 < 16 && (n13 = n10 + n14) < n7; ++n14) {
                        if (n13 >= n8 && n13 <= n9) {
                            c = '\u0002';
                            if (n14 < 15 && n13 < n9) {
                                c = '\u0003';
                            }
                            graphics.setColor(SystemColor.textHighlight);
                            graphics.fillRect(n15, n11 - this.hChar + 2, c * this.wChar, this.hRow);
                            graphics.setColor(SystemColor.textHighlightText);
                        } else {
                            graphics.setColor(this.getForeground());
                        }
                        graphics.drawString(String.format("%02X", this.dataSrc.getDataByte(n13)), n15, n11);
                        n15 += this.wHex;
                    }
                    n15 = this.xAscii;
                    for (n14 = 0; n14 < 16 && (n13 = n10 + n14) < n7; ++n14) {
                        c = (char)this.dataSrc.getDataByte(n10 + n14);
                        if (c < ' ' || c >= '\u007f') {
                            c = '.';
                        }
                        if (n13 >= n8 && n13 <= n9) {
                            graphics.setColor(SystemColor.textHighlight);
                            graphics.fillRect(n15, n11 - this.hChar + 2, this.wChar, this.hRow);
                            graphics.setColor(SystemColor.textHighlightText);
                        } else {
                            graphics.setColor(this.getForeground());
                        }
                        graphics.drawString(Character.toString(c), n15, n11);
                        n15 += this.wChar;
                    }
                    n11 += this.hRow;
                    n10 += 16;
                }
                if (n < 1) {
                    n = 1;
                }
            }
        }
        this.visibleRows = n;
        this.visibleXLeft = n2;
        this.visibleYTop = n3;
        this.visibleWidth = n5;
        this.visibleHeight = n6;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.hChar = font.getSize();
        this.hRow = this.hChar + 1;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        fontPrototypeFld.updateUI();
        Font font = fontPrototypeFld.getFont();
        if (font != null) {
            this.setFont(font);
        }
    }

    private void calcPositions() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics != null) {
            this.wChar = fontMetrics.stringWidth("0");
            this.wHex = 3 * this.wChar;
            this.xHex = 5 + 6 * this.wChar + 20;
            this.xAscii = this.xHex + 16 * this.wHex + 20;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCaretListeners() {
        if (this.caretListeners != null) {
            List<CaretListener> list = this.caretListeners;
            synchronized (list) {
                HexCharFld hexCharFld = this;
                final int n = this.caretPos;
                final int n2 = this.markPos;
                CaretEvent caretEvent = new CaretEvent(hexCharFld){

                    @Override
                    public int getDot() {
                        return n;
                    }

                    @Override
                    public int getMark() {
                        return n2;
                    }
                };
                for (CaretListener caretListener : this.caretListeners) {
                    caretListener.caretUpdate(caretEvent);
                }
            }
        }
    }

    private boolean keyAction(int n, boolean bl) {
        boolean bl2 = false;
        int n2 = this.dataSrc.getDataLength();
        if (this.caretPos >= 0 && this.caretPos < n2) {
            bl2 = true;
            int n3 = 0;
            switch (n) {
                case 37: {
                    n3 = -1;
                    break;
                }
                case 39: {
                    n3 = 1;
                    break;
                }
                case 38: {
                    n3 = -16;
                    break;
                }
                case 40: {
                    n3 = 16;
                    break;
                }
                case 33: {
                    n3 = -(this.visibleRows * 16);
                    break;
                }
                case 34: {
                    n3 = this.visibleRows * 16;
                    break;
                }
                case 36: 
                case 65368: {
                    n3 = -this.caretPos;
                    break;
                }
                case 35: {
                    n3 = n2 - this.caretPos - 1;
                    break;
                }
                default: {
                    bl2 = false;
                }
            }
            if (n3 != 0) {
                int n4 = this.caretPos + n3;
                if (Math.abs(n3) > 1) {
                    if (n4 < 0) {
                        n4 += (1 - n4 / 16) * 16;
                    } else if (n4 >= n2) {
                        n4 -= (1 + (n4 - n2) / 16) * 16;
                    }
                }
                if (n4 >= 0 && n4 < n2) {
                    this.setCaretPosition(n4, bl);
                }
            }
        }
        return bl2;
    }

    private void mouseAction(int n, int n2, boolean bl) {
        int n3 = this.getDataIndexAt(n, n2);
        if (n3 >= 0) {
            this.asciiSelected = n >= this.xAscii && n < this.xAscii + this.wChar * 16;
            this.setCaretPosition(n3, bl);
        }
        this.requestFocus();
    }

    private void scrollCaretToVisible() {
        Container container;
        if (this.caretPos >= 0 && this.caretPos < this.dataSrc.getDataLength() && (container = this.getParent()) != null && container instanceof JViewport) {
            Point point;
            Point point2 = null;
            int n = this.caretPos % 16;
            int n2 = 0;
            int n3 = this.wChar;
            if (this.asciiSelected) {
                n2 = this.xAscii + n * this.wChar;
            } else {
                n2 = this.xHex + n * this.wHex;
                n3 += this.wChar;
            }
            int n4 = 5 + this.caretPos / 16 * this.hRow;
            if (n2 < this.visibleXLeft) {
                Point point3 = ((JViewport)container).getViewPosition();
                if (point3 != null) {
                    point2 = new Point(n2, point3.y);
                }
            } else if (n2 + n3 > this.visibleXLeft + this.visibleWidth) {
                Point point4 = ((JViewport)container).getViewPosition();
                if (point4 != null) {
                    point2 = new Point(n2 - this.visibleWidth + n3, point4.y);
                }
            } else if (n4 - this.hChar < this.visibleYTop) {
                Point point5 = ((JViewport)container).getViewPosition();
                if (point5 != null) {
                    point2 = new Point(point5.x, n4 - this.hChar);
                }
            } else if (n4 > this.visibleYTop + this.visibleHeight && (point = ((JViewport)container).getViewPosition()) != null) {
                point2 = new Point(point.x, n4 - this.visibleHeight + this.hChar);
            }
            if (point2 != null) {
                if (point2.x < 0) {
                    point2.x = 0;
                }
                if (point2.y < 0) {
                    point2.y = 0;
                }
                ((JViewport)container).setViewPosition(point2);
            }
        }
    }
}

