/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.Document;
import jkcemu.Main;
import jkcemu.base.AbstractFileWorker;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileInfo;
import jkcemu.base.FileRemover;
import jkcemu.base.FileSelectRenderer;

public class FileSelectDlg
extends BaseDlg
implements AbstractFileWorker.PathListener,
DocumentListener,
DropTargetListener,
FocusListener,
ListSelectionListener {
    private static final String defaultStatusText = "Bereit";
    private Mode mode;
    private boolean startSelected;
    private boolean loadWithOptionsSelected;
    private boolean loadable;
    private boolean startable;
    private List<FileFilter> fileFilters;
    private File curDir;
    private File selectedFile;
    private List<File> selectedFiles;
    private FileSystemView fsv;
    private JList<File> list;
    private JScrollPane scrollPane;
    private JTextField fldFileName;
    private JComboBox<String> comboFileType;
    private JComboBox<DirItem> comboDir;
    private JButton btnCreateDir;
    private JButton btnGoUp;
    private JButton btnApprove;
    private JButton btnStart;
    private JButton btnLoadWithOptions;
    private JButton btnCancel;
    private JLabel labelStatus;
    private JPopupMenu mnuPopup;
    private JMenuItem mnuCreateDir;
    private JMenuItem mnuDelete;
    private JMenuItem mnuGoUp;
    private JMenuItem mnuRefresh;
    private JMenuItem mnuRename;
    private DefaultComboBoxModel<DirItem> modelDir;
    private Document docFileName;
    private List<DirItem> baseDirItems;
    private Cursor defaultCursor;
    private Cursor waitCursor;
    private String approveBtnText;

    public FileSelectDlg(Window window, Mode mode, boolean bl, boolean bl2, String string, File file, FileFilter ... fileFilterArray) {
        super(window, string);
        Object object;
        Object object2;
        Object object3;
        this.mode = mode;
        this.startSelected = false;
        this.loadWithOptionsSelected = false;
        this.loadable = false;
        this.startable = false;
        this.fileFilters = null;
        this.curDir = null;
        this.selectedFile = null;
        this.selectedFiles = null;
        this.fsv = FileSystemView.getFileSystemView();
        this.baseDirItems = new ArrayList<DirItem>();
        Object object4 = null;
        File[] fileArray = null;
        if (this.fsv != null) {
            fileArray = this.fsv.getRoots();
            object4 = this.fsv.getDefaultDirectory();
            if (object4 == null && (object3 = this.fsv.getHomeDirectory()) != null) {
                object4 = object3;
            }
        }
        if (fileArray == null) {
            fileArray = File.listRoots();
        }
        if (fileArray != null) {
            EmuUtil.sortFilesByName(fileArray);
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (!file2.isDirectory() || file2.isHidden()) continue;
                this.baseDirItems.add(new DirItem(file2, 0));
            }
        }
        if (this.fsv != null && fileArray != null && fileArray.length == 1 && ((File)(object3 = fileArray[0])).isDirectory()) {
            int n;
            boolean bl3 = Main.isUnixLikeOS();
            File file3 = null;
            object2 = this.fsv.getFiles(fileArray[0], true);
            if (object2 != null) {
                EmuUtil.sortFilesByName((File[])object2);
                for (n = ((File[])object2).length - 1; n >= 0; --n) {
                    object = object2[n];
                    if (this.fsv.isComputerNode((File)object)) {
                        this.addDirItem(this.baseDirItems, (File)object);
                        file3 = object;
                        if (!bl3) continue;
                        break;
                    }
                    if (bl3) continue;
                    this.addDirItem(this.baseDirItems, (File)object);
                }
            }
            if (!bl3 && file3 != null && file3.isDirectory() && (object2 = this.fsv.getFiles(file3, true)) != null) {
                EmuUtil.sortFilesByName((File[])object2);
                for (n = ((File[])object2).length - 1; n >= 0; --n) {
                    this.addDirItem(this.baseDirItems, object2[n]);
                }
            }
        }
        if (object4 == null && (object3 = System.getProperty("user.home")) != null && !((String)object3).isEmpty()) {
            object4 = new File((String)object3);
        }
        if (object4 != null) {
            this.addDirItem(this.baseDirItems, (File)object4);
        }
        this.setLayout(new GridBagLayout());
        object3 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 5), 0, 0);
        this.add((Component)new JLabel("Suchen in:"), object3);
        this.modelDir = new DefaultComboBoxModel();
        this.comboDir = new JComboBox<DirItem>(this.modelDir);
        this.comboDir.setEditable(false);
        this.comboDir.setRenderer(new FileSelectRenderer(this.fsv));
        this.comboDir.addActionListener(this);
        ((GridBagConstraints)object3).fill = 2;
        ((GridBagConstraints)object3).weightx = 1.0;
        ((GridBagConstraints)object3).insets.left = 5;
        ++((GridBagConstraints)object3).gridx;
        this.add(this.comboDir, object3);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setBorderPainted(false);
        jToolBar.setOrientation(0);
        jToolBar.setRollover(true);
        ((GridBagConstraints)object3).fill = 0;
        ((GridBagConstraints)object3).weightx = 0.0;
        ++((GridBagConstraints)object3).gridx;
        this.add((Component)jToolBar, object3);
        this.btnGoUp = this.createImageButton("/images/file/folder_up.png", "Eine Ebene h\u00f6her");
        jToolBar.add((Component)this.btnGoUp, object3);
        this.btnCreateDir = this.createImageButton("/images/file/createdir.png", "Neues Verzeichnis erstellen");
        jToolBar.add((Component)this.btnCreateDir, object3);
        this.list = new JList();
        this.list.setDragEnabled(false);
        this.list.setLayoutOrientation(1);
        this.list.setSelectionMode(this.mode.equals((Object)Mode.MULTIPLE_LOAD) ? 2 : 0);
        this.list.setVisibleRowCount(0);
        this.list.setCellRenderer(new FileSelectRenderer(this.fsv));
        this.list.addKeyListener(this);
        this.list.addMouseListener(this);
        this.list.addListSelectionListener(this);
        this.scrollPane = new JScrollPane(this.list);
        ((GridBagConstraints)object3).fill = 1;
        ((GridBagConstraints)object3).weightx = 1.0;
        ((GridBagConstraints)object3).weighty = 1.0;
        ((GridBagConstraints)object3).insets.top = 5;
        ((GridBagConstraints)object3).insets.left = 10;
        ((GridBagConstraints)object3).gridwidth = 3;
        ((GridBagConstraints)object3).gridx = 0;
        ++((GridBagConstraints)object3).gridy;
        this.add((Component)this.scrollPane, object3);
        ((GridBagConstraints)object3).fill = 0;
        ((GridBagConstraints)object3).weightx = 0.0;
        ((GridBagConstraints)object3).weighty = 0.0;
        ((GridBagConstraints)object3).gridwidth = 1;
        ++((GridBagConstraints)object3).gridy;
        this.add((Component)new JLabel("Dateiname:"), object3);
        this.fldFileName = new JTextField();
        this.fldFileName.addActionListener(this);
        this.fldFileName.addFocusListener(this);
        ((GridBagConstraints)object3).fill = 2;
        ((GridBagConstraints)object3).weightx = 1.0;
        ((GridBagConstraints)object3).insets.left = 5;
        ((GridBagConstraints)object3).gridwidth = 2;
        ++((GridBagConstraints)object3).gridx;
        this.add((Component)this.fldFileName, object3);
        ((GridBagConstraints)object3).fill = 0;
        ((GridBagConstraints)object3).weightx = 0.0;
        ((GridBagConstraints)object3).insets.top = 0;
        ((GridBagConstraints)object3).insets.left = 10;
        ((GridBagConstraints)object3).gridwidth = 1;
        ((GridBagConstraints)object3).gridx = 0;
        ++((GridBagConstraints)object3).gridy;
        this.add((Component)new JLabel("Dateityp:"), object3);
        this.comboFileType = new JComboBox();
        this.comboFileType.setEditable(false);
        this.comboFileType.addItem("Alle Dateien");
        if (fileFilterArray != null && fileFilterArray.length > 0) {
            this.fileFilters = new ArrayList<FileFilter>(fileFilterArray.length);
            for (int i = 0; i < fileFilterArray.length; ++i) {
                if (fileFilterArray[i] == null) continue;
                this.comboFileType.addItem(fileFilterArray[i].getDescription());
                this.fileFilters.add(fileFilterArray[i]);
            }
        }
        try {
            this.comboFileType.setSelectedIndex(this.comboFileType.getItemCount() == 2 ? 1 : 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.comboFileType.addActionListener(this);
        ((GridBagConstraints)object3).fill = 2;
        ((GridBagConstraints)object3).weightx = 1.0;
        ((GridBagConstraints)object3).insets.left = 5;
        ((GridBagConstraints)object3).gridwidth = 2;
        ++((GridBagConstraints)object3).gridx;
        this.add(this.comboFileType, object3);
        ((GridBagConstraints)object3).insets.left = 0;
        ((GridBagConstraints)object3).insets.right = 0;
        ((GridBagConstraints)object3).insets.top = 5;
        ((GridBagConstraints)object3).gridwidth = 0;
        ((GridBagConstraints)object3).gridx = 0;
        ++((GridBagConstraints)object3).gridy;
        this.add((Component)new JSeparator(), object3);
        this.labelStatus = new JLabel(defaultStatusText);
        ((GridBagConstraints)object3).insets.left = 10;
        ((GridBagConstraints)object3).insets.right = 10;
        ((GridBagConstraints)object3).insets.top = 0;
        ++((GridBagConstraints)object3).gridy;
        this.add((Component)this.labelStatus, object3);
        int n = 2;
        if (bl) {
            ++n;
        }
        if (bl2) {
            ++n;
        }
        object2 = new JPanel(new GridLayout(n, 1, 5, 5));
        ((GridBagConstraints)object3).anchor = 12;
        ((GridBagConstraints)object3).fill = 0;
        ((GridBagConstraints)object3).weightx = 0.0;
        ((GridBagConstraints)object3).insets.top = 10;
        ((GridBagConstraints)object3).insets.left = 5;
        ((GridBagConstraints)object3).gridwidth = 1;
        ((GridBagConstraints)object3).gridheight = 0;
        ((GridBagConstraints)object3).gridy = 0;
        ((GridBagConstraints)object3).gridx = 4;
        this.add((Component)object2, object3);
        this.approveBtnText = "\u00d6ffnen";
        if (this.isForSave()) {
            this.approveBtnText = "Speichern";
        } else if (bl2) {
            this.approveBtnText = "Laden";
        }
        this.btnApprove = new JButton(this.approveBtnText);
        this.btnApprove.addActionListener(this);
        this.btnApprove.addKeyListener(this);
        ((Container)object2).add(this.btnApprove);
        this.btnStart = null;
        if (bl) {
            this.btnStart = new JButton("Starten");
            this.btnStart.addActionListener(this);
            this.btnStart.addKeyListener(this);
            ((Container)object2).add(this.btnStart);
        }
        this.btnLoadWithOptions = null;
        if (bl2) {
            this.btnLoadWithOptions = new JButton("Laden mit...");
            this.btnLoadWithOptions.addActionListener(this);
            this.btnLoadWithOptions.addKeyListener(this);
            ((Container)object2).add(this.btnLoadWithOptions);
        }
        this.btnCancel = new JButton("Abbrechen");
        this.btnCancel.addActionListener(this);
        this.btnCancel.addKeyListener(this);
        ((Container)object2).add(this.btnCancel);
        this.mnuPopup = new JPopupMenu();
        this.mnuGoUp = new JMenuItem("Eine Ebene h\u00f6her");
        this.mnuGoUp.addActionListener(this);
        this.mnuPopup.add(this.mnuGoUp);
        this.mnuCreateDir = new JMenuItem("Verzeichnis erstellen...");
        this.mnuCreateDir.addActionListener(this);
        this.mnuPopup.add(this.mnuCreateDir);
        this.mnuPopup.addSeparator();
        this.mnuRename = new JMenuItem("Umbenennen...");
        this.mnuRename.setEnabled(false);
        this.mnuRename.addActionListener(this);
        this.mnuPopup.add(this.mnuRename);
        this.mnuDelete = new JMenuItem("L\u00f6schen");
        this.mnuDelete.setEnabled(false);
        this.mnuDelete.addActionListener(this);
        this.mnuPopup.add(this.mnuDelete);
        this.mnuPopup.addSeparator();
        this.mnuRefresh = new JMenuItem("Aktualisieren");
        this.mnuRefresh.addActionListener(this);
        this.mnuPopup.add(this.mnuRefresh);
        this.defaultCursor = this.list.getCursor();
        if (this.defaultCursor == null) {
            this.defaultCursor = Cursor.getDefaultCursor();
        }
        this.waitCursor = Cursor.getPredefinedCursor(3);
        if (file != null) {
            if (file.isDirectory()) {
                this.setCurDir(file, null);
            } else {
                File file4 = null;
                if (this.fsv != null) {
                    file4 = this.fsv.getParentDirectory(file);
                }
                if (file4 == null) {
                    file4 = file.getParentFile();
                }
                this.setCurDir((File)(file4 != null ? file4 : object4), null);
                this.fldFileName.setText(file.getName());
                object = Collections.singletonList(file);
                if (this.selectFiles((Collection<File>)object) == 0) {
                    this.filesSelected((List<File>)object);
                }
            }
        } else {
            this.setCurDir((File)object4, null);
        }
        this.docFileName = this.fldFileName.getDocument();
        if (this.docFileName != null) {
            this.docFileName.addDocumentListener(this);
            if (this.btnStart != null) {
                this.btnStart.setEnabled(false);
            }
            if (this.btnLoadWithOptions != null) {
                this.btnLoadWithOptions.setEnabled(false);
            }
        }
        this.updApproveBtn(false);
        new DropTarget(this.fldFileName, this).setActive(true);
        this.setSize(600, 400);
        this.setParentCentered();
        this.setResizable(true);
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public List<File> getSelectedFiles() {
        return this.selectedFiles;
    }

    public boolean isLoadWithOptionsSelected() {
        return this.loadWithOptionsSelected;
    }

    public boolean isStartSelected() {
        return this.startSelected;
    }

    @Override
    public void pathsPasted(Set<Path> set) {
    }

    @Override
    public void pathsRemoved(Set<Path> set) {
        this.updList(null);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.docChanged(documentEvent);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.docChanged(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.docChanged(documentEvent);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!EmuUtil.isFileDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        File file = EmuUtil.fileDrop(this, dropTargetDropEvent);
        if (file != null) {
            this.fldFileName.setText(file.getPath());
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary() && focusEvent.getComponent() == this.fldFileName) {
            final JList<File> jList = this.list;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    jList.clearSelection();
                }
            });
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.list) {
            this.loadable = false;
            this.startable = false;
            boolean bl = false;
            String string = null;
            List<File> list = this.list.getSelectedValuesList();
            for (File file : list) {
                if (file.isDirectory()) {
                    bl = true;
                    break;
                }
                String string2 = file.getName();
                if (string2 != null && string2.isEmpty()) {
                    string2 = null;
                }
                if (string != null) {
                    string = "";
                    continue;
                }
                string = string2;
            }
            if (!bl && string != null) {
                if (this.docFileName != null) {
                    this.docFileName.removeDocumentListener(this);
                    this.fldFileName.setText(string);
                    this.docFileName.addDocumentListener(this);
                } else {
                    this.fldFileName.setText(string);
                }
            }
            this.mnuDelete.setEnabled(!list.isEmpty());
            this.mnuRename.setEnabled(list.size() == 1);
            this.updApproveBtn(bl);
            String string3 = this.filesSelected(list);
            this.labelStatus.setText((String)(string3 != null ? string3 : defaultStatusText));
        }
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        Object object;
        boolean bl = false;
        if (eventObject != null && (object = eventObject.getSource()) != null) {
            if (object == this.comboDir || object == this.comboFileType) {
                bl = true;
                if (!this.isForSave()) {
                    this.fldFileName.setText("");
                }
                this.updList(null);
            } else if (object == this.list) {
                bl = true;
                this.doListAction(this.list.getSelectedIndex());
            } else if (object == this.btnGoUp || object == this.mnuGoUp) {
                bl = true;
                this.doGoUp();
            } else if (object == this.btnCreateDir || object == this.mnuCreateDir) {
                bl = true;
                this.doCreateDir();
            } else if (object == this.btnApprove) {
                bl = true;
                this.doApprove(false, false);
            } else if (object == this.btnStart) {
                bl = true;
                this.doApprove(true, false);
            } else if (object == this.btnLoadWithOptions) {
                bl = true;
                this.doApprove(false, true);
            } else if (object == this.fldFileName) {
                bl = true;
                this.doFileNameAction();
            } else if (object == this.btnCancel) {
                bl = true;
                this.doClose();
            } else if (object == this.mnuDelete) {
                bl = true;
                this.doDelete();
            } else if (object == this.mnuRefresh) {
                bl = true;
                this.doRefresh();
            } else if (object == this.mnuRename) {
                bl = true;
                this.doRename();
            }
        }
        return bl;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent != null && keyEvent.getKeyCode() == 10) {
            this.doApprove(false, false);
            keyEvent.consume();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this.list && mouseEvent.getClickCount() > 1 && mouseEvent.getButton() == 1) {
            int n;
            Point point = mouseEvent.getPoint();
            if (point != null && (n = this.list.locationToIndex(point)) >= 0) {
                this.doListAction(n);
            }
            mouseEvent.consume();
        } else {
            super.mouseClicked(mouseEvent);
        }
    }

    @Override
    protected boolean showPopup(MouseEvent mouseEvent) {
        boolean bl = false;
        Component component = mouseEvent.getComponent();
        if (component != null) {
            this.mnuPopup.show(component, mouseEvent.getX(), mouseEvent.getY());
            bl = true;
        }
        return bl;
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == this) {
            this.list.requestFocus();
        }
    }

    private void doApprove(boolean bl, boolean bl2) {
        String string;
        List<File> list = this.list.getSelectedValuesList();
        if (list.isEmpty() && this.curDir != null && (string = this.fldFileName.getText()) != null && !(string = string.trim()).isEmpty()) {
            File file = new File(string);
            if (!file.isAbsolute()) {
                file = this.fsv != null ? this.fsv.getChild(this.curDir, string) : new File(this.curDir, string);
            }
            list = Collections.singletonList(file);
        }
        this.approveFiles(list, bl, bl2);
    }

    private void doCreateDir() {
        File file;
        if (this.curDir != null && (file = EmuUtil.createDir(this, this.curDir)) != null) {
            this.setCurDir(file, null);
        }
    }

    private void doDelete() {
        List<File> list;
        int n;
        int n2 = this.list.getSelectedIndex();
        if (n2 >= 0 && (n = (list = this.list.getSelectedValuesList()).size()) > 0) {
            File file = null;
            try {
                ArrayList<Path> arrayList = new ArrayList<Path>(n);
                Iterator<File> iterator = list.iterator();
                while (iterator.hasNext()) {
                    File file2;
                    file = file2 = iterator.next();
                    arrayList.add(file2.toPath());
                }
                FileRemover.startRemove(this, arrayList, this, null);
            }
            catch (InvalidPathException invalidPathException) {
                String string = null;
                if (file != null) {
                    string = file.getPath();
                }
                if (string != null && string.isEmpty()) {
                    string = null;
                }
                string = string != null ? string + "\nkonnte nicht gel\u00f6scht werden." : "L\u00f6schen fehlgeschlagen";
                FileSelectDlg.showErrorDlg((Component)this, string);
            }
        }
    }

    private void doFileNameAction() {
        File file;
        String string;
        String string2;
        boolean bl = false;
        if (this.curDir != null && (string2 = this.fldFileName.getText()) != null && !(string2 = string2.trim()).isEmpty() && (string = (file = new File(string2)).getName()) != null && string.indexOf(63) < 0 && string.indexOf(42) < 0) {
            if (!file.isAbsolute()) {
                file = this.fsv != null ? this.fsv.getChild(this.curDir, string) : new File(this.curDir, string);
            }
            this.approveFiles(Collections.singletonList(file), false, true);
            bl = true;
        }
        this.updList(null);
    }

    private void doGoUp() {
        File file = null;
        if (this.curDir != null) {
            file = this.fsv != null ? this.fsv.getParentDirectory(this.curDir) : this.curDir.getParentFile();
        }
        this.setCurDir(file, this.curDir);
    }

    private void doListAction(int n) {
        File file;
        ListModel<File> listModel;
        if (n >= 0 && (listModel = this.list.getModel()) != null && n < listModel.getSize() && (file = listModel.getElementAt(n)) != null && file instanceof File) {
            this.approveFiles(Collections.singletonList(file), false, true);
        }
    }

    private void doRefresh() {
        this.updList(this.list.getSelectedValuesList());
    }

    private void doRename() {
        File file;
        List<File> list = this.list.getSelectedValuesList();
        if (list.size() == 1 && (file = EmuUtil.renameFile(this, list.get(0))) != null) {
            this.updList(Collections.singletonList(file));
        }
    }

    private DirItem addDirItem(List<DirItem> list, File file) {
        DirItem dirItem = null;
        if (file != null && file.isDirectory()) {
            ArrayList<File> arrayList = null;
            int n = -1;
            while (file != null && (n = FileSelectDlg.getIndexOf(list, file)) < 0) {
                if (arrayList == null) {
                    arrayList = new ArrayList<File>();
                }
                arrayList.add(file);
                if (this.fsv != null) {
                    file = this.fsv.getParentDirectory(file);
                    continue;
                }
                file = file.getParentFile();
            }
            int n2 = 0;
            if (n >= 0 && n < list.size()) {
                dirItem = list.get(n);
                n2 = dirItem.getLevel() + 1;
                ++n;
            }
            if (arrayList != null) {
                if (n >= list.size()) {
                    n = -1;
                }
                int n3 = arrayList.size();
                for (int i = n3 - 1; i >= 0; --i) {
                    dirItem = new DirItem((File)arrayList.get(i), n2++);
                    if (n >= 0) {
                        list.add(n++, dirItem);
                        continue;
                    }
                    list.add(dirItem);
                }
            }
        }
        return dirItem;
    }

    /*
     * WARNING - void declaration
     */
    private void approveFiles(List<File> list, boolean bl, boolean bl2) {
        if (list != null) {
            boolean bl3 = false;
            for (File object2 : list) {
                if (!object2.isDirectory()) continue;
                this.setCurDir(object2, null);
                bl3 = true;
                break;
            }
            if (!bl3 && !list.isEmpty()) {
                Object object = list.get(0);
                if (this.isForSave() && list.size() == 1) {
                    String string = ((File)object).getName();
                    if (string != null) {
                        if (string.startsWith("\"") && string.endsWith("\"")) {
                            void var6_10;
                            if (string.length() > 2) {
                                String string2 = string.substring(1, string.length() - 1);
                            } else {
                                String string3 = "";
                            }
                            object = FileSelectDlg.replaceName((File)object, (String)var6_10);
                        } else {
                            object = EmuUtil.completeFileExtension((File)object, this.getSelectedFileFilter());
                        }
                    }
                    if (!EmuUtil.confirmFileOverwrite(this, (File)object)) {
                        object = null;
                        list = null;
                    }
                }
                if (object != null) {
                    this.selectedFile = object;
                    this.selectedFiles = list;
                    this.startSelected = bl;
                    this.loadWithOptionsSelected = this.mode.equals((Object)Mode.LOAD) ? bl2 : false;
                    this.doClose();
                }
            }
        }
    }

    public static Pattern compileFileNameMask(String string) {
        int n;
        Pattern pattern = null;
        if (string != null && (n = string.length()) > 0) {
            int n2;
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder(n + 10);
            for (n2 = 0; n2 < n; ++n2) {
                bl = false;
                char c = string.charAt(n2);
                if (c == '*') {
                    stringBuilder.append(".*");
                    bl = true;
                }
                if (!bl && c == '?') {
                    stringBuilder.append(".");
                    bl = true;
                }
                if (!bl && "\\.[]()^$".indexOf(c) >= 0) {
                    stringBuilder.append('\\');
                    stringBuilder.append(c);
                    bl = true;
                }
                if (bl) continue;
                stringBuilder.append(c);
            }
            try {
                n2 = 32;
                if (!Main.isUnixLikeOS()) {
                    n2 |= 2;
                }
                pattern = Pattern.compile(stringBuilder.toString(), n2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return pattern;
    }

    private void docChanged(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.docFileName) {
            this.updApproveBtn(false);
        }
    }

    private String filesSelected(List<File> list) {
        FileInfo fileInfo;
        String string = null;
        File file = null;
        if (list != null && list.size() == 1 && (file = list.get(0)).isFile() && file.canRead() && (fileInfo = FileInfo.analyzeFile(file)) != null) {
            if (!fileInfo.isKCBasicProgramFormat() && fileInfo.getBegAddr() >= 0) {
                this.loadable = true;
                if (fileInfo.getStartAddr() >= 0) {
                    this.startable = true;
                }
            }
            string = fileInfo.getInfoText();
        }
        if (this.btnApprove != null) {
            this.btnApprove.setEnabled(this.mode.equals((Object)Mode.LOAD) && this.loadable || this.btnLoadWithOptions == null);
        }
        if (this.btnStart != null) {
            this.btnStart.setEnabled(this.mode.equals((Object)Mode.LOAD) && this.startable);
        }
        if (this.btnLoadWithOptions != null) {
            this.btnLoadWithOptions.setEnabled(this.mode.equals((Object)Mode.LOAD) && file != null);
        }
        if (string != null && string.isEmpty()) {
            string = null;
        }
        return string;
    }

    private void fireSetListData(final File file, final File[] fileArray, final List<File> list) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileSelectDlg.this.setListData(file, fileArray, list);
            }
        });
    }

    private static int getIndexOf(List<DirItem> list, File file) {
        int n = -1;
        if (list != null && file != null) {
            int n2 = 0;
            for (DirItem dirItem : list) {
                if (EmuUtil.equals(dirItem.getDirectory(), file)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        return n;
    }

    private FileFilter getSelectedFileFilter() {
        int n;
        FileFilter fileFilter = null;
        if (this.fileFilters != null && (n = this.comboFileType.getSelectedIndex() - 1) >= 0 && n < this.fileFilters.size()) {
            fileFilter = this.fileFilters.get(n);
        }
        return fileFilter;
    }

    private boolean isForSave() {
        return this.mode.equals((Object)Mode.SAVE);
    }

    private static File replaceName(File file, String string) {
        if (file != null) {
            File file2 = file.getParentFile();
            file = file2 != null ? new File(file2, string) : new File(string);
        }
        return file;
    }

    private int selectFiles(Collection<File> collection) {
        ListModel<File> listModel;
        int n = 0;
        this.list.clearSelection();
        if (collection != null && !collection.isEmpty() && (listModel = this.list.getModel()) != null) {
            String string;
            TreeSet<String> treeSet = new TreeSet<String>();
            for (File file : collection) {
                string = file.getPath();
                if (string == null) continue;
                if (treeSet == null) {
                    treeSet = new TreeSet();
                }
                treeSet.add(string);
            }
            int n2 = listModel.getSize();
            for (int i = 0; i < n2; ++i) {
                string = listModel.getElementAt(i).getPath();
                if (string == null || !treeSet.contains(string)) continue;
                this.list.addSelectionInterval(i, i);
                ++n;
            }
        }
        return n;
    }

    private void setCurDir(File file, File file2) {
        if (!this.isForSave()) {
            this.fldFileName.setText("");
        }
        this.comboDir.removeActionListener(this);
        DirItem dirItem = null;
        ArrayList<DirItem> arrayList = new ArrayList<DirItem>();
        arrayList.addAll(this.baseDirItems);
        if (file != null) {
            dirItem = this.addDirItem(arrayList, file);
        }
        this.modelDir.removeAllElements();
        for (DirItem dirItem2 : arrayList) {
            this.modelDir.addElement(dirItem2);
        }
        if (dirItem != null) {
            this.comboDir.setSelectedItem(dirItem);
        }
        this.updList(file2 != null ? Collections.singletonList(file2) : null);
        this.comboDir.addActionListener(this);
    }

    private void setListData(File file, File[] fileArray, final List<File> list) {
        Object object;
        if (this.curDir != null && file != null && fileArray != null && this.curDir.equals(file)) {
            String string;
            File file2;
            int n;
            EmuUtil.sortFilesByName(fileArray);
            object = this.getSelectedFileFilter();
            Pattern pattern = null;
            String string2 = this.fldFileName.getText();
            if (string2 != null && (string2.indexOf(42) >= 0 || string2.indexOf(63) >= 0) && (pattern = FileSelectDlg.compileFileNameMask(string2)) != null && object != null) {
                try {
                    this.comboFileType.removeActionListener(this);
                    this.comboFileType.setSelectedIndex(0);
                    this.comboFileType.addActionListener(this);
                    object = null;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            ArrayList<File> arrayList = new ArrayList<File>(fileArray.length > 1 ? fileArray.length : 1);
            for (n = 0; n < fileArray.length; ++n) {
                file2 = fileArray[n];
                if (!file2.isDirectory() || file2.isHidden() || (string = file2.getName()) == null || string.equals(".") || string.equals("..")) continue;
                arrayList.add(file2);
            }
            for (n = 0; n < fileArray.length; ++n) {
                file2 = fileArray[n];
                if (file2.isDirectory() || file2.isHidden()) continue;
                if (pattern != null) {
                    Matcher matcher;
                    string = file2.getName();
                    if (string == null || (matcher = pattern.matcher(string)) == null || !matcher.matches()) continue;
                    arrayList.add(file2);
                    continue;
                }
                if (object != null) {
                    if (!((FileFilter)object).accept(file2)) continue;
                    arrayList.add(file2);
                    continue;
                }
                arrayList.add(file2);
            }
            this.list.setListData((File[])arrayList.toArray(new File[arrayList.size()]));
            if (list != null && !list.isEmpty()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FileSelectDlg.this.selectFiles(list);
                    }
                });
            }
        }
        if (this.defaultCursor != null) {
            this.list.setCursor(this.defaultCursor);
            this.scrollPane.setCursor(this.defaultCursor);
            object = this.scrollPane.getViewport();
            if (object != null) {
                ((Component)object).setCursor(this.defaultCursor);
            }
        }
        this.labelStatus.setText(defaultStatusText);
    }

    private void updApproveBtn(boolean bl) {
        if (this.btnApprove != null) {
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            if (bl) {
                this.btnApprove.setText("\u00d6ffnen");
                bl2 = true;
            } else {
                boolean bl5;
                this.btnApprove.setText(this.approveBtnText);
                boolean bl6 = bl5 = this.list.getSelectedIndex() > 0;
                if (!bl5) {
                    if (this.docFileName != null) {
                        String string = this.fldFileName.getText();
                        if (string != null && !(string = string.trim()).isEmpty()) {
                            bl5 = true;
                        }
                    } else {
                        bl5 = true;
                    }
                }
                if (this.btnLoadWithOptions != null) {
                    bl2 = this.loadable;
                    bl3 = this.startable;
                    bl4 = bl5;
                } else {
                    bl2 = bl5;
                }
            }
            this.btnApprove.setEnabled(bl2);
            if (this.btnStart != null) {
                this.btnStart.setEnabled(bl3);
            }
            if (this.btnLoadWithOptions != null) {
                this.btnLoadWithOptions.setEnabled(bl4);
            }
        }
    }

    private void updList(final List<File> list) {
        this.curDir = null;
        Object object = this.comboDir.getSelectedItem();
        if (object != null && object instanceof DirItem) {
            this.curDir = ((DirItem)object).getDirectory();
        }
        this.list.setListData((File[])new File[0]);
        if (this.curDir != null) {
            this.btnCreateDir.setEnabled(true);
            this.mnuCreateDir.setEnabled(true);
            boolean bl = false;
            bl = this.fsv != null ? this.fsv.getParentDirectory(this.curDir) != null : this.curDir.getParentFile() != null;
            this.btnGoUp.setEnabled(bl);
            this.mnuGoUp.setEnabled(bl);
        } else {
            this.btnCreateDir.setEnabled(false);
            this.mnuCreateDir.setEnabled(false);
            this.btnGoUp.setEnabled(false);
            this.mnuGoUp.setEnabled(false);
        }
        final FileSystemView fileSystemView = this.fsv;
        final File file = this.curDir;
        if (this.curDir != null) {
            Object object2;
            if (this.defaultCursor != null && this.waitCursor != null) {
                this.list.setCursor(this.waitCursor);
                this.scrollPane.setCursor(this.waitCursor);
                object2 = this.scrollPane.getViewport();
                if (object2 != null) {
                    ((Component)object2).setCursor(this.waitCursor);
                }
            }
            this.labelStatus.setText("Lese Verzeichnis...");
            object2 = new Thread(Main.getThreadGroup(), "JKCEMU directory reader of file select dialog"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    File[] fileArray = null;
                    try {
                        fileArray = fileSystemView != null ? fileSystemView.getFiles(file, true) : file.listFiles();
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        FileSelectDlg.this.fireSetListData(file, fileArray, list);
                    }
                }
            };
            ((Thread)object2).start();
        }
    }

    public static class DirItem {
        private File dirFile;
        private int level;

        public DirItem(File file, int n) {
            this.dirFile = file;
            this.level = n;
        }

        public File getDirectory() {
            return this.dirFile;
        }

        public int getLevel() {
            return this.level;
        }
    }

    public static enum Mode {
        SAVE,
        LOAD,
        MULTIPLE_LOAD;

    }
}

