/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Window;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import jkcemu.base.AbstractFileWorker;

public class FileMover
extends AbstractFileWorker {
    private Path dstPath;
    private boolean dirFailed;

    public FileMover(Window window, Collection collection, Path path, AbstractFileWorker.PathListener pathListener, Collection<AbstractFileWorker> collection2) throws IOException {
        super(window, collection, pathListener, collection2);
        this.checkSrcPathsAgainstDstPath(path, collection, "Ein Verzeichnis kann nicht in sich selbst hinein verschoben werden.");
        this.dstPath = path;
        this.dirFailed = false;
    }

    @Override
    public String getFileFailedMsg(String string) {
        return string + "\nkann nicht verschoben werden.";
    }

    @Override
    public String getProgressDlgTitle() {
        return "Verschieben";
    }

    @Override
    public String getUncompletedWorkMsg() {
        return "Es konnten nicht alle Dateien, Verzeichnisse bzw.\nsymbolische Links verschoben werden.";
    }

    @Override
    protected void handleError(Path path, IOException iOException) {
        this.dirFailed = true;
        super.handleError(path, iOException);
    }

    @Override
    public FileVisitResult postVisitDirectory(Path path, IOException iOException) {
        if (!this.cancelled && !this.dirFailed) {
            try {
                Files.delete(path);
            }
            catch (NoSuchFileException noSuchFileException) {
            }
            catch (IOException iOException2) {
                String string = path.toString() + ":\nDas Quellverzeichnis konnte nicht" + " gel\u00f6scht werden.";
                String string2 = iOException2.getMessage();
                if (string2 != null && !string2.isEmpty()) {
                    string = string + "\n\n" + string2;
                }
                this.handleError(path, new IOException(string));
            }
        }
        return this.cancelled ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) {
        FileVisitResult fileVisitResult;
        block3: {
            fileVisitResult = FileVisitResult.CONTINUE;
            if (!this.cancelled) {
                this.curPath = path;
                Path path2 = this.resolveDst(path);
                try {
                    this.dirFailed = false;
                    Files.copy(path, path2, StandardCopyOption.COPY_ATTRIBUTES, LinkOption.NOFOLLOW_LINKS);
                    this.pathPasted(path2);
                }
                catch (IOException iOException) {
                    if (iOException instanceof FileAlreadyExistsException && Files.isDirectory(path2, new LinkOption[0])) break block3;
                    this.handleError(path, iOException);
                    if (this.cancelled) break block3;
                    fileVisitResult = FileVisitResult.SKIP_SUBTREE;
                }
            }
        }
        return this.cancelled ? FileVisitResult.TERMINATE : fileVisitResult;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
        if (!this.cancelled) {
            this.curPath = path;
            try {
                Path path2 = this.resolveDst(path);
                Files.move(path, this.resolveDst(path), StandardCopyOption.REPLACE_EXISTING);
                this.pathRemoved(path);
                this.pathPasted(path2);
            }
            catch (IOException iOException) {
                this.handleError(path, iOException);
            }
        }
        return this.cancelled ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
    }

    private Path resolveDst(Path path) {
        Path path2 = this.curParent;
        if (path2 != null) {
            path = path2.relativize(path);
        }
        return this.dstPath.resolve(path);
    }
}

