/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Window;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import jkcemu.base.AbstractFileWorker;

public class FileCopier
extends AbstractFileWorker {
    private Path dstPath;
    private volatile Boolean copyAllDirs;
    private volatile Boolean replaceAllFiles;

    public FileCopier(Window window, Collection collection, Path path, AbstractFileWorker.PathListener pathListener, Collection<AbstractFileWorker> collection2) throws IOException {
        super(window, collection, pathListener, collection2);
        this.checkSrcPathsAgainstDstPath(path, collection, "Ein Verzeichnis kann nicht in sich selbst hinein kopiert werden.");
        this.dstPath = path;
        this.copyAllDirs = null;
        this.replaceAllFiles = null;
    }

    @Override
    public String getFileFailedMsg(String string) {
        return string + "\nkann nicht kopiert werden.";
    }

    @Override
    public String getProgressDlgTitle() {
        return "Kopieren";
    }

    @Override
    public String getUncompletedWorkMsg() {
        return "Es konnten nicht alle Dateien, Verzeichnisse bzw.\nsymbolische Links kopiert werden.";
    }

    @Override
    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) {
        FileVisitResult fileVisitResult;
        block16: {
            fileVisitResult = FileVisitResult.CONTINUE;
            if (!this.cancelled) {
                this.curPath = path;
                Path path2 = this.resolveDst(path);
                try {
                    if (Files.isSameFile(path2, path)) {
                        fileVisitResult = FileVisitResult.SKIP_SUBTREE;
                    } else {
                        boolean bl = false;
                        boolean bl2 = false;
                        if (this.copyAllDirs != null) {
                            bl2 = this.copyAllDirs;
                        }
                        if (!bl2) {
                            bl = Files.exists(path2, LinkOption.NOFOLLOW_LINKS);
                        }
                        if (this.copyAllDirs == null && bl) {
                            switch (this.showJOptionPane("Das Verzeichnis '" + path2.toString() + "' existiert bereits.\n" + "M\u00f6chten Sie trotzdem in das" + " Verzeichnis hinein kopieren?", 2, "Zielverzeichnis bereits vorhanden", new String[]{"Kopieren", "Alle kopieren", "\u00dcberspringen", "Alle \u00fcberspringen", "Abbrechen"})) {
                                case 0: {
                                    bl2 = true;
                                    break;
                                }
                                case 1: {
                                    bl2 = true;
                                    this.copyAllDirs = Boolean.TRUE;
                                    break;
                                }
                                case 2: {
                                    bl2 = false;
                                    break;
                                }
                                case 3: {
                                    bl2 = false;
                                    this.copyAllDirs = Boolean.FALSE;
                                    break;
                                }
                                default: {
                                    this.cancelled = true;
                                }
                            }
                        }
                        if (!(this.cancelled || bl && !bl2)) {
                            Files.copy(path, path2, StandardCopyOption.COPY_ATTRIBUTES, LinkOption.NOFOLLOW_LINKS);
                            this.pathPasted(path2);
                        } else {
                            fileVisitResult = FileVisitResult.SKIP_SUBTREE;
                        }
                    }
                }
                catch (IOException iOException) {
                    if (iOException instanceof FileAlreadyExistsException && Files.isDirectory(path2, new LinkOption[0])) break block16;
                    this.handleError(path, iOException);
                    if (this.cancelled) break block16;
                    fileVisitResult = FileVisitResult.SKIP_SUBTREE;
                }
            }
        }
        return this.cancelled ? FileVisitResult.TERMINATE : fileVisitResult;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
        if (!this.cancelled) {
            this.curPath = path;
            try {
                Path path2 = this.resolveDst(path);
                if (!Files.isSameFile(path2, path)) {
                    boolean bl = false;
                    boolean bl2 = false;
                    if (this.replaceAllFiles != null) {
                        bl2 = this.replaceAllFiles;
                    }
                    if (!bl2) {
                        bl = Files.exists(path2, LinkOption.NOFOLLOW_LINKS);
                    }
                    if (this.replaceAllFiles == null && bl) {
                        switch (this.showJOptionPane("Die Datei '" + path2.toString() + "' existiert bereits.\n" + "M\u00f6chten Sie die Datei ersetzen?", 2, "Datei bereits vorhanden", new String[]{"Ersetzen", "Alle ersetzen", "Nicht ersetzen", "Alle nicht ersetzen", "Abbrechen"})) {
                            case 0: {
                                bl2 = true;
                                break;
                            }
                            case 1: {
                                bl2 = true;
                                this.replaceAllFiles = Boolean.TRUE;
                                break;
                            }
                            case 2: {
                                bl2 = false;
                                break;
                            }
                            case 3: {
                                bl2 = false;
                                this.replaceAllFiles = Boolean.FALSE;
                                break;
                            }
                            default: {
                                this.cancelled = true;
                            }
                        }
                    }
                    if (!(this.cancelled || bl && !bl2)) {
                        Files.copy(path, path2, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES, LinkOption.NOFOLLOW_LINKS);
                        this.pathPasted(path2);
                    }
                }
            }
            catch (IOException iOException) {
                this.handleError(path, iOException);
            }
        }
        return this.cancelled ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
    }

    private Path resolveDst(Path path) {
        Path path2 = this.curParent;
        if (path2 != null) {
            path = path2.relativize(path);
        }
        return this.dstPath.resolve(path);
    }
}

