/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Properties;
import jkcemu.Main;
import jkcemu.audio.AudioFrm;
import jkcemu.audio.AudioIO;
import jkcemu.audio.AudioIn;
import jkcemu.audio.AudioOut;
import jkcemu.base.AutoInputWorker;
import jkcemu.base.AutoLoader;
import jkcemu.base.BaseDlg;
import jkcemu.base.BaseFrm;
import jkcemu.base.EmuMemView;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuUtil;
import jkcemu.base.ErrorMsg;
import jkcemu.base.FileTimesViewFactory;
import jkcemu.base.LoadData;
import jkcemu.base.NIOFileTimesViewFactory;
import jkcemu.base.RAMFloppy;
import jkcemu.base.ScreenFrm;
import jkcemu.disk.FloppyDiskStationFrm;
import jkcemu.emusys.A5105;
import jkcemu.emusys.AC1;
import jkcemu.emusys.BCS3;
import jkcemu.emusys.C80;
import jkcemu.emusys.CustomSys;
import jkcemu.emusys.HueblerEvertMC;
import jkcemu.emusys.HueblerGraphicsMC;
import jkcemu.emusys.KC85;
import jkcemu.emusys.KCcompact;
import jkcemu.emusys.KramerMC;
import jkcemu.emusys.LC80;
import jkcemu.emusys.LLC1;
import jkcemu.emusys.LLC2;
import jkcemu.emusys.NANOS;
import jkcemu.emusys.PCM;
import jkcemu.emusys.Poly880;
import jkcemu.emusys.SC2;
import jkcemu.emusys.SLC1;
import jkcemu.emusys.VCS80;
import jkcemu.emusys.Z1013;
import jkcemu.emusys.Z9001;
import jkcemu.emusys.ZXSpectrum;
import jkcemu.joystick.JoystickFrm;
import jkcemu.joystick.JoystickThread;
import jkcemu.print.PrintMngr;
import jkcemu.text.TextUtil;
import z80emu.Z80CPU;
import z80emu.Z80IOSystem;
import z80emu.Z80Memory;

public class EmuThread
extends Thread
implements Z80IOSystem,
Z80Memory,
EmuMemView {
    public static final String PROP_SYSNAME = "jkcemu.system";
    public static final String PROP_EXT_ROM_RELOAD_ON_POWER_ON = "jkcemu.external_rom.reload_on_power_on";
    public static final boolean DEFAULT_EXT_ROM_RELOAD_ON_POWER_ON = false;
    public static final String PROP_MAXSPEED_KHZ = "jkcemu.maxspeed.khz";
    public static final String VALUE_MAXSPEED_KHZ_DEFAULT = "default";
    public static final String VALUE_MAXSPEED_KHZ_UNLIMITED = "unlimited";
    public static final String PROP_RF_CLEAR_ON_POWER_ON = "jkcemu.ramfloppy.clear_on_power_on";
    public static final boolean DEFAULT_RF_CLEAR_ON_POWER_ON = false;
    public static final String PROP_SRAM_INIT = "jkcemu.sram.init";
    public static final String VALUE_SRAM_INIT_00 = "00";
    public static final String VALUE_SRAM_INIT_RANDOM = "random";
    private ScreenFrm screenFrm;
    private Z80CPU z80cpu;
    private boolean willResetDone;
    private Object monitor;
    private FileTimesViewFactory fileTimesViewFactory;
    private JoystickFrm joyFrm;
    private JoystickThread[] joyThreads;
    private byte[] ram;
    private byte[] ramExtended;
    private RAMFloppy ramFloppy1;
    private RAMFloppy ramFloppy2;
    private PrintMngr printMngr;
    private volatile AudioIn tapeIn;
    private volatile AudioOut tapeOut;
    private volatile AudioOut soundOut;
    private volatile LoadData loadData;
    private volatile ResetLevel resetLevel;
    private volatile boolean emuRunning;
    private volatile EmuSys emuSys;
    private volatile Boolean iso646de;

    public EmuThread(ScreenFrm screenFrm, Properties properties) {
        super(Main.getThreadGroup(), "JKCEMU CPU");
        this.screenFrm = screenFrm;
        this.z80cpu = new Z80CPU(this, this);
        this.willResetDone = false;
        this.monitor = "a monitor object for synchronization";
        this.fileTimesViewFactory = new NIOFileTimesViewFactory();
        this.joyFrm = null;
        this.joyThreads = new JoystickThread[2];
        this.ram = new byte[65536];
        this.ramExtended = null;
        this.ramFloppy1 = new RAMFloppy();
        this.ramFloppy2 = new RAMFloppy();
        this.printMngr = new PrintMngr();
        this.tapeIn = null;
        this.tapeOut = null;
        this.soundOut = null;
        this.loadData = null;
        this.resetLevel = ResetLevel.POWER_ON;
        this.emuRunning = false;
        this.emuSys = null;
        Arrays.fill(this.joyThreads, null);
        this.applySettings(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public synchronized void applySettings(Properties properties) {
        Object object;
        BaseFrm baseFrm;
        boolean bl = false;
        EmuSys emuSys = this.emuSys;
        if (emuSys != null && emuSys.canApplySettings(properties)) {
            bl = true;
        }
        if (emuSys != null && bl) {
            emuSys.applySettings(properties);
        } else {
            if (emuSys != null) {
                emuSys.cancelPastingText();
                emuSys.die();
            }
            if ((baseFrm = AudioFrm.lazyGetInstance()) != null) {
                ((AudioFrm)baseFrm).willReset();
            }
            switch (EmuUtil.getProperty(properties, PROP_SYSNAME)) {
                case "AC1": {
                    emuSys = new AC1(this, properties);
                    break;
                }
                case "BCS3": {
                    emuSys = new BCS3(this, properties);
                    break;
                }
                case "C80": {
                    emuSys = new C80(this, properties);
                    break;
                }
                case "HueblerEvertMC": {
                    emuSys = new HueblerEvertMC(this, properties);
                    break;
                }
                case "HueblerGraphicsMC": {
                    emuSys = new HueblerGraphicsMC(this, properties);
                    break;
                }
                case "KC85_1": 
                case "KC87": 
                case "Z9001": {
                    emuSys = new Z9001(this, properties);
                    break;
                }
                case "HC900": 
                case "KC85_2": 
                case "KC85_3": 
                case "KC85_4": 
                case "KC85_5": {
                    emuSys = new KC85(this, properties);
                    break;
                }
                case "KCcompact": {
                    emuSys = new KCcompact(this, properties);
                    break;
                }
                case "KramerMC": {
                    emuSys = new KramerMC(this, properties);
                    break;
                }
                case "LC80_U505": 
                case "LC80_2716": 
                case "LC80_2": 
                case "LC80_E": 
                case "LC80_EX": {
                    emuSys = new LC80(this, properties);
                    break;
                }
                case "LLC1": {
                    emuSys = new LLC1(this, properties);
                    break;
                }
                case "LLC2": {
                    emuSys = new LLC2(this, properties);
                    break;
                }
                case "NANOS": {
                    emuSys = new NANOS(this, properties);
                    break;
                }
                case "PCM": {
                    emuSys = new PCM(this, properties);
                    break;
                }
                case "Poly880": {
                    emuSys = new Poly880(this, properties);
                    break;
                }
                case "SC2": {
                    emuSys = new SC2(this, properties);
                    break;
                }
                case "SLC1": {
                    emuSys = new SLC1(this, properties);
                    break;
                }
                case "VCS80": {
                    emuSys = new VCS80(this, properties);
                    break;
                }
                case "Z1013.01": 
                case "Z1013.12": 
                case "Z1013.16": 
                case "Z1013.64": {
                    emuSys = new Z1013(this, properties);
                    break;
                }
                case "ZXSpectrum": {
                    emuSys = new ZXSpectrum(this, properties);
                    break;
                }
                case "CUSTOMSYS": {
                    emuSys = new CustomSys(this, properties);
                    break;
                }
                default: {
                    emuSys = new A5105(this, properties);
                }
            }
            Object object2 = ResetLevel.POWER_ON;
            if (this.emuSys != null) {
                String string = this.emuSys.getTitle();
                object = emuSys.getTitle();
                if (string != null && object != null && string.equals(object)) {
                    object2 = ResetLevel.COLD_RESET;
                }
            }
            this.emuSys = emuSys;
            this.fireReset((ResetLevel)((Object)object2));
        }
        baseFrm = FloppyDiskStationFrm.getSharedInstance(this.screenFrm);
        if (baseFrm != null) {
            int n = emuSys.getSupportedFloppyDiskDriveCount();
            ((FloppyDiskStationFrm)baseFrm).setDriveCount(n);
            for (int i = 0; i < n; ++i) {
                emuSys.setFloppyDiskDrive(i, ((FloppyDiskStationFrm)baseFrm).getDrive(i));
            }
        }
        int n = emuSys.getSupportedJoystickCount();
        int n2 = 0;
        while (true) {
            if (n2 >= this.joyThreads.length) {
                this.updCPUSpeed(properties);
                this.iso646de = null;
                return;
            }
            object = null;
            JoystickThread[] joystickThreadArray = this.joyThreads;
            // MONITORENTER : this.joyThreads
            object = this.joyThreads[n2];
            if (object != null) {
                if (n2 >= n) {
                    ((JoystickThread)object).fireStop();
                    this.joyThreads[n2] = null;
                }
                object = null;
            } else if (n2 < n) {
                this.joyThreads[n2] = object = new JoystickThread(this, n2, false);
            }
            // MONITOREXIT : joystickThreadArray
            if (object != null) {
                ((Thread)object).start();
            }
            this.updJoystickFrm(n2);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeJoystickConnectState(int n) {
        JoystickThread joystickThread = null;
        JoystickThread[] joystickThreadArray = this.joyThreads;
        synchronized (this.joyThreads) {
            if (n >= 0 && n < this.joyThreads.length) {
                joystickThread = this.joyThreads[n];
                if (joystickThread != null) {
                    try {
                        joystickThread.fireStop();
                        joystickThread.join(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.joyThreads[n] = null;
                } else {
                    this.joyThreads[n] = joystickThread = new JoystickThread(this, n, true);
                    joystickThread.start();
                }
                this.updJoystickFrm(n);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void fireShowJoystickError(final String string) {
        final JoystickFrm joystickFrm = this.joyFrm;
        if (joystickFrm != null && string != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BaseDlg.showErrorDlg(joystickFrm, string);
                }
            });
        }
    }

    public static int getDefaultSpeedKHz(Properties properties) {
        int n = A5105.getDefaultSpeedKHz();
        String string = EmuUtil.getProperty(properties, PROP_SYSNAME);
        if (string != null) {
            switch (string) {
                case "AC1": {
                    n = AC1.getDefaultSpeedKHz();
                    break;
                }
                case "BCS3": {
                    n = BCS3.getDefaultSpeedKHz(properties);
                    break;
                }
                case "C80": {
                    n = C80.getDefaultSpeedKHz();
                    break;
                }
                case "HueblerEvertMC": {
                    n = HueblerEvertMC.getDefaultSpeedKHz();
                    break;
                }
                case "HueblerGraphicsMC": {
                    n = HueblerGraphicsMC.getDefaultSpeedKHz();
                    break;
                }
                case "HC900": 
                case "KC85_2": 
                case "KC85_3": 
                case "KC85_4": 
                case "KC85_5": {
                    n = KC85.getDefaultSpeedKHz(properties);
                    break;
                }
                case "KCcompact": {
                    n = KCcompact.getDefaultSpeedKHz();
                    break;
                }
                case "KramerMC": {
                    n = KramerMC.getDefaultSpeedKHz();
                    break;
                }
                case "LC80_U505": 
                case "LC80_2716": 
                case "LC80_2": 
                case "LC80_E": 
                case "LC80_EX": {
                    n = LC80.getDefaultSpeedKHz(properties);
                    break;
                }
                case "LLC1": {
                    n = LLC1.getDefaultSpeedKHz();
                    break;
                }
                case "LLC2": {
                    n = LLC2.getDefaultSpeedKHz();
                    break;
                }
                case "NANOS": {
                    n = NANOS.getDefaultSpeedKHz();
                    break;
                }
                case "PCM": {
                    n = PCM.getDefaultSpeedKHz();
                    break;
                }
                case "Poly880": {
                    n = Poly880.getDefaultSpeedKHz();
                    break;
                }
                case "SC2": {
                    n = SC2.getDefaultSpeedKHz();
                    break;
                }
                case "SLC1": {
                    n = SLC1.getDefaultSpeedKHz();
                    break;
                }
                case "VCS80": {
                    n = VCS80.getDefaultSpeedKHz();
                    break;
                }
                case "Z1013.01": 
                case "Z1013.12": 
                case "Z1013.16": 
                case "Z1013.64": {
                    n = Z1013.getDefaultSpeedKHz(properties);
                    break;
                }
                case "KC85_1": 
                case "KC87": 
                case "Z9001": {
                    n = Z9001.getDefaultSpeedKHz();
                    break;
                }
                case "ZXSpectrum": {
                    n = ZXSpectrum.getDefaultSpeedKHz(properties);
                    break;
                }
                case "CUSTOMSYS": {
                    n = CustomSys.getDefaultSpeedKHz(properties);
                }
            }
        }
        return n;
    }

    public EmuSys getEmuSys() {
        return this.emuSys;
    }

    public synchronized byte[] getExtendedRAM(int n) {
        byte[] byArray = null;
        if (n > 0) {
            if (this.ramExtended != null) {
                if (n > this.ramExtended.length) {
                    byArray = new byte[n];
                    Arrays.fill(byArray, (byte)0);
                    System.arraycopy(this.ramExtended, 0, byArray, 0, this.ramExtended.length);
                    this.ramExtended = byArray;
                } else {
                    byArray = this.ramExtended;
                }
            } else {
                byArray = new byte[n];
                Arrays.fill(byArray, (byte)0);
                this.ramExtended = byArray;
            }
        }
        return byArray;
    }

    public FileTimesViewFactory getFileTimesViewFactory() {
        return this.fileTimesViewFactory;
    }

    public Boolean getISO646DE() {
        return this.iso646de;
    }

    public PrintMngr getPrintMngr() {
        return this.printMngr;
    }

    public int getRAMByte(int n) {
        return this.ram[n & 0xFFFF] & 0xFF;
    }

    public RAMFloppy getRAMFloppy1() {
        return this.ramFloppy1;
    }

    public RAMFloppy getRAMFloppy2() {
        return this.ramFloppy2;
    }

    public AudioOut getSoundOut() {
        return this.soundOut;
    }

    public AudioIn getTapeIn() {
        return this.tapeIn;
    }

    public AudioOut getTapeOut() {
        return this.tapeOut;
    }

    public ScreenFrm getScreenFrm() {
        return this.screenFrm;
    }

    public Z80CPU getZ80CPU() {
        return this.z80cpu;
    }

    public void informWillReset() {
        if (!this.willResetDone) {
            this.willResetDone = true;
            Frame[] frameArray = Frame.getFrames();
            if (frameArray != null) {
                for (Frame frame : frameArray) {
                    if (!(frame instanceof BaseFrm)) continue;
                    ((BaseFrm)frame).willReset();
                }
            }
        }
    }

    public boolean isAudioLineOpen() {
        AudioIO[] audioIOArray;
        for (AudioIO audioIO : audioIOArray = new AudioIO[]{this.tapeIn, this.tapeOut, this.soundOut}) {
            if (audioIO == null || !audioIO.isLineOpen()) continue;
            return true;
        }
        return false;
    }

    public static boolean isColdReset(ResetLevel resetLevel) {
        return resetLevel == ResetLevel.POWER_ON || resetLevel == ResetLevel.POWER_ON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joystickThreadTerminated(JoystickThread joystickThread) {
        JoystickThread[] joystickThreadArray = this.joyThreads;
        synchronized (this.joyThreads) {
            for (int i = 0; i < this.joyThreads.length; ++i) {
                if (this.joyThreads[i] != joystickThread) continue;
                this.joyThreads[i] = null;
                this.updJoystickFrm(i);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        return this.emuSys != null ? this.emuSys.keyPressed(keyEvent.getKeyCode(), keyEvent.isControlDown(), keyEvent.isShiftDown()) : false;
    }

    public void keyReleased() {
        if (this.emuSys != null) {
            this.emuSys.keyReleased();
        }
    }

    public void keyTyped(char c) {
        if (this.emuSys != null) {
            if (this.emuSys.getSwapKeyCharCase()) {
                c = TextUtil.toReverseCase(c);
            }
            if (this.emuSys.getConvertKeyCharToISO646DE()) {
                this.emuSys.keyTyped(TextUtil.toISO646DE(c));
            } else {
                this.emuSys.keyTyped(c);
            }
        }
    }

    public boolean readTapeInPhase() {
        boolean bl = false;
        AudioIn audioIn = this.tapeIn;
        if (audioIn != null) {
            bl = audioIn.readPhase();
        }
        return bl;
    }

    public void setSoundOut(AudioOut audioOut) {
        this.soundOut = audioOut;
        EmuSys emuSys = this.emuSys;
        if (emuSys != null) {
            emuSys.soundOutFrameRateChanged(audioOut != null ? audioOut.getFrameRate() : 0);
        }
    }

    public void setTapeIn(AudioIn audioIn) {
        this.tapeIn = audioIn;
    }

    public void setTapeOut(AudioOut audioOut) {
        this.tapeOut = audioOut;
        EmuSys emuSys = this.emuSys;
        if (emuSys != null) {
            emuSys.tapeOutFrameRateChanged(audioOut != null ? audioOut.getFrameRate() : 0);
        }
    }

    public void setBasicMemWord(int n, int n2) {
        this.emuSys.setBasicMemByte(n, n2 & 0xFF);
        this.emuSys.setBasicMemByte(n + 1, n2 >> 8 & 0xFF);
    }

    public void setISO646DE(boolean bl) {
        this.iso646de = bl;
    }

    public void setJoystickAction(int n, int n2) {
        JoystickFrm joystickFrm;
        EmuSys emuSys = this.emuSys;
        if (emuSys != null) {
            emuSys.setJoystickAction(n, n2);
        }
        if ((joystickFrm = this.joyFrm) != null) {
            joystickFrm.setJoystickAction(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJoystickFrm(JoystickFrm joystickFrm) {
        this.joyFrm = joystickFrm;
        JoystickThread[] joystickThreadArray = this.joyThreads;
        synchronized (this.joyThreads) {
            for (int i = 0; i < this.joyThreads.length; ++i) {
                this.updJoystickFrm(i);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setMemWord(int n, int n2) {
        this.setMemByte(n, n2 & 0xFF);
        this.setMemByte(n + 1, n2 >> 8 & 0xFF);
    }

    public void setRAMByte(int n, int n2) {
        this.ram[n &= 0xFFFF] = (byte)n2;
    }

    public void updCPUSpeed(Properties properties) {
        int n = EmuThread.getDefaultSpeedKHz(properties);
        String string = EmuUtil.getProperty(properties, PROP_MAXSPEED_KHZ);
        if (string.equals(VALUE_MAXSPEED_KHZ_UNLIMITED)) {
            n = 0;
        } else if (!string.equals(VALUE_MAXSPEED_KHZ_DEFAULT) && !string.isEmpty()) {
            try {
                int n2 = Integer.parseInt(string);
                if (n2 > 0) {
                    n = n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.z80cpu.setMaxSpeedKHz(n);
    }

    public void writeSoundOutPhase(boolean bl) {
        AudioOut audioOut = this.soundOut;
        if (audioOut != null) {
            audioOut.writePhase(bl);
        }
    }

    public void writeSoundOutFrames(int n, int n2, int n3, int n4) {
        AudioOut audioOut = this.soundOut;
        if (audioOut != null) {
            audioOut.writeFrames(n, n2, n3, n4);
        }
    }

    public void writeSoundOutValue(int n, int n2, int n3) {
        AudioOut audioOut = this.soundOut;
        if (audioOut != null) {
            audioOut.writeValue(n, n2, n3);
        }
    }

    public void writeTapeOutPhase(boolean bl) {
        AudioOut audioOut = this.tapeOut;
        if (audioOut != null) {
            audioOut.writePhase(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireReset(ResetLevel resetLevel) {
        this.screenFrm.clearScreenSelection();
        EmuSys emuSys = this.emuSys;
        if (emuSys != null) {
            emuSys.cancelPastingText();
        }
        Object object = this.monitor;
        synchronized (object) {
            this.resetLevel = resetLevel;
            this.loadData = null;
            this.z80cpu.fireExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadIntoMemory(LoadData loadData) {
        if (loadData.getStartAddr() >= 0) {
            Object object = this.monitor;
            synchronized (object) {
                this.loadData = loadData;
                this.z80cpu.firePause(false);
                this.z80cpu.fireExit();
            }
        } else {
            loadData.loadIntoMemory(this);
        }
    }

    public void stopEmulator() {
        for (int i = 0; i < this.joyThreads.length; ++i) {
            JoystickThread joystickThread = this.joyThreads[i];
            if (joystickThread == null) continue;
            joystickThread.fireStop();
        }
        this.emuRunning = false;
        this.z80cpu.fireExit();
    }

    @Override
    public int getBasicMemByte(int n) {
        return this.emuSys.getBasicMemByte(n & 0xFFFF);
    }

    @Override
    public int readIOByte(int n, int n2) {
        int n3 = 255;
        if (this.emuSys != null) {
            n3 = this.emuSys.readIOByte(n, n2);
        }
        return n3;
    }

    @Override
    public void writeIOByte(int n, int n2, int n3) {
        if (this.emuSys != null) {
            this.emuSys.writeIOByte(n, n2, n3);
        }
    }

    @Override
    public int getMemByte(int n, boolean bl) {
        return this.emuSys.getMemByte(n & 0xFFFF, bl);
    }

    @Override
    public int getMemWord(int n) {
        return this.getMemByte(n + 1, false) << 8 | this.getMemByte(n, false);
    }

    @Override
    public int readMemByte(int n, boolean bl) {
        return this.emuSys.readMemByte(n & 0xFFFF, bl);
    }

    @Override
    public boolean setMemByte(int n, int n2) {
        return this.emuSys.setMemByte(n & 0xFFFF, n2);
    }

    @Override
    public void writeMemByte(int n, int n2) {
        this.emuSys.writeMemByte(n & 0xFFFF, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.emuRunning = true;
        while (this.emuRunning) {
            try {
                LoadData loadData = null;
                Object object = this.monitor;
                synchronized (object) {
                    loadData = this.loadData;
                    if (loadData != null) {
                        this.loadData = null;
                    } else if (this.resetLevel == ResetLevel.POWER_ON) {
                        Arrays.fill(this.ram, (byte)0);
                    }
                }
                if (loadData != null) {
                    int n;
                    loadData.loadIntoMemory(this);
                    this.z80cpu.setRegPC(loadData.getStartAddr());
                    if (this.emuSys != null && (n = this.emuSys.getAppStartStackInitValue()) > 0) {
                        this.z80cpu.setRegSP(n);
                    }
                } else {
                    Frame[] frameArray;
                    boolean bl = this.resetLevel == ResetLevel.COLD_RESET || this.resetLevel == ResetLevel.POWER_ON;
                    this.z80cpu.resetCPU(bl);
                    if (this.emuSys != null) {
                        this.emuSys.reset(this.resetLevel, Main.getProperties());
                        this.z80cpu.setRegPC(this.emuSys.getResetStartAddress(this.resetLevel));
                    }
                    this.printMngr.reset();
                    this.ramFloppy1.reset();
                    this.ramFloppy2.reset();
                    if (this.emuSys != null && this.resetLevel == ResetLevel.POWER_ON && Main.getBooleanProperty(PROP_RF_CLEAR_ON_POWER_ON, false)) {
                        if (this.emuSys.supportsRAMFloppy1() && this.ramFloppy1.getUsedSize() > 0) {
                            this.ramFloppy1.clear();
                        }
                        if (this.emuSys.supportsRAMFloppy2() && this.ramFloppy2.getUsedSize() > 0) {
                            this.ramFloppy2.clear();
                        }
                    }
                    boolean bl2 = bl;
                    if (!bl && this.emuSys != null) {
                        bl2 = this.emuSys.getAutoLoadInputOnSoftReset();
                    }
                    if (bl2) {
                        AutoLoader.start(this, Main.getProperties());
                        AutoInputWorker.start(this, Main.getProperties());
                    }
                    if ((frameArray = Frame.getFrames()) != null) {
                        final EmuThread emuThread = this;
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                for (Frame frame : frameArray) {
                                    if (!(frame instanceof BaseFrm)) continue;
                                    ((BaseFrm)frame).resetFired();
                                }
                                emuThread.willResetDone = false;
                            }
                        });
                    }
                }
                this.resetLevel = ResetLevel.NO_RESET;
                this.z80cpu.run();
            }
            catch (Exception exception) {
                this.emuRunning = false;
                EventQueue.invokeLater(new ErrorMsg(this.screenFrm, exception));
            }
        }
    }

    private void updJoystickFrm(final int n) {
        final JoystickFrm joystickFrm = this.joyFrm;
        if (joystickFrm != null && n >= 0 && n < this.joyThreads.length) {
            int n2 = 0;
            EmuSys emuSys = this.emuSys;
            if (emuSys != null) {
                n2 = emuSys.getSupportedJoystickCount();
            }
            final boolean bl = n < n2;
            final boolean bl2 = this.joyThreads[n] != null;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    joystickFrm.setJoystickState(n, bl, bl2);
                }
            });
        }
    }

    public static enum ResetLevel {
        NO_RESET,
        WARM_RESET,
        COLD_RESET,
        POWER_ON;

    }
}

