/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.io.File;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Arrays;
import java.util.Properties;
import jkcemu.Main;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.AbstractScreenDevice;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileFormat;
import jkcemu.base.ScreenFrm;
import jkcemu.base.UserCancelException;
import jkcemu.disk.FloppyDiskDrive;
import jkcemu.disk.FloppyDiskFormat;
import jkcemu.disk.FloppyDiskInfo;
import jkcemu.etc.Plotter;
import jkcemu.etc.VDIP;
import jkcemu.text.TextUtil;
import z80emu.Z80CPU;
import z80emu.Z80MaxSpeedListener;
import z80emu.Z80MemView;
import z80emu.Z80Memory;
import z80emu.Z80TStatesListener;

public abstract class EmuSys
extends AbstractScreenDevice
implements ImageObserver,
Runnable,
Z80MaxSpeedListener,
Z80TStatesListener {
    public static final String PROP_COLOR = "color";
    public static final String PROP_COUNT = "count";
    public static final String PROP_FDC_ENABLED = "fdc.enabled";
    public static final String PROP_FILE = "file";
    public static final String PROP_FONT_PREFIX = "font.";
    public static final String PROP_FONT_FILE = "font.file";
    public static final String PROP_BASIC_PREFIX = "basic.";
    public static final String PROP_OS_PREFIX = "os.";
    public static final String PROP_OS_FILE = "os.file";
    public static final String PROP_OS_VERSION = "os.version";
    public static final String PROP_ROM_PREFIX = "rom.";
    public static final String PROP_MODEL = "model";
    public static final String PROP_CATCH_PRINT_CALLS = "catch_print_calls";
    public static final String PROP_FIXED_SCREEN_SIZE = "fixed_screen_size";
    public static final String PROP_KCNET_ENABLED = "kcnet.enabled";
    public static final String PROP_ROMMEGA_ENABLED = "rom_mega.enabled";
    public static final String PROP_PASTE_FAST = "paste.fast";
    public static final String PROP_RF_PREFIX = "ramfloppy.";
    public static final String PROP_RF1_PREFIX = "ramfloppy.1.";
    public static final String PROP_RF2_PREFIX = "ramfloppy.2.";
    public static final String PROP_RTC_ENABLED = "rtc.enabled";
    public static final String PROP_VDIP_ENABLED = "vdip.enabled";
    public static final String VALUE_NONE = "none";
    public static final String VALUE_PREFIX_FILE = "file:";
    public static final int DEFAULT_PROMPT_AFTER_RESET_MILLIS_MAX = 500;
    public static final boolean DEFAULT_SWAP_KEY_CHAR_CASE = false;
    protected EmuThread emuThread;
    protected ScreenFrm screenFrm;
    protected String propPrefix;
    protected Thread pasteThread;
    protected volatile CharacterIterator pasteIter;
    protected volatile boolean soundOutPhase;
    protected volatile boolean tapeOutPhase;
    private int curSoundOutTStates;
    private int curTapeOutTStates;
    private int soundOutTStates;
    private int tapeOutTStates;
    private volatile int soundOutFrameRate;
    private volatile int tapeOutFrameRate;
    private static final int CHESSBOARD_SQUARE_WIDTH = 48;

    public EmuSys(EmuThread emuThread, Properties properties, String string) {
        super(properties);
        this.emuThread = emuThread;
        this.screenFrm = emuThread.getScreenFrm();
        this.pasteThread = null;
        this.pasteIter = null;
        this.propPrefix = string;
        this.curSoundOutTStates = 0;
        this.soundOutTStates = 0;
        this.soundOutFrameRate = 0;
        this.soundOutPhase = false;
        this.curTapeOutTStates = 0;
        this.tapeOutTStates = 0;
        this.tapeOutFrameRate = 0;
        this.tapeOutPhase = false;
    }

    public static void appendSpacesToCol(StringBuilder stringBuilder, int n, int n2) {
        for (int i = n + n2 - stringBuilder.length(); i > 0; --i) {
            stringBuilder.append(' ');
        }
    }

    public void appendStatusHTMLTo(StringBuilder stringBuilder, Z80CPU z80CPU) {
    }

    public boolean canApplySettings(Properties properties) {
        return false;
    }

    public AbstractKeyboardFld createKeyboardFld() throws UnsupportedOperationException, UserCancelException {
        throw new UnsupportedOperationException();
    }

    public void die() {
    }

    protected void fillRandom(byte[] byArray) {
        EmuUtil.fillRandom(byArray, 0);
    }

    protected void fireShowCharNotPasted(final CharacterIterator characterIterator) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                EmuSys.this.showCharNotPasted(characterIterator);
            }
        });
    }

    public int getAppStartStackInitValue() {
        return -1;
    }

    public boolean getAutoLoadInputOnSoftReset() {
        return true;
    }

    public int getBasicMemByte(int n) {
        return this.getMemByte(n, false);
    }

    public Chessman getChessman(int n, int n2) {
        return null;
    }

    protected boolean getConvertKeyCharToISO646DE() {
        return true;
    }

    public FloppyDiskFormat getDefaultFloppyDiskFormat() {
        return null;
    }

    public int getDefaultPromptAfterResetMillisMax() {
        return 500;
    }

    protected long getDelayMillisAfterPasteChar() {
        return 150L;
    }

    protected long getDelayMillisAfterPasteEnter() {
        return 250L;
    }

    protected long getHoldMillisPasteChar() {
        return 100L;
    }

    public String getHelpPage() {
        return null;
    }

    public Integer getLoadAddr() {
        return null;
    }

    public abstract int getMemByte(int var1, boolean var2);

    public int getMemWord(int n) {
        return this.getMemByte(n + 1, false) << 8 | this.getMemByte(n, false);
    }

    public int getResetStartAddress(EmuThread.ResetLevel resetLevel) {
        return 0;
    }

    public Plotter getPlotter() {
        return null;
    }

    public String getPropPrefix() {
        return this.propPrefix;
    }

    public AbstractScreenDevice getSecondScreenDevice() {
        return null;
    }

    public String getSecondSystemName() {
        return null;
    }

    public Z80CPU getSecondZ80CPU() {
        return null;
    }

    public Z80Memory getSecondZ80Memory() {
        return null;
    }

    public FloppyDiskInfo[] getSuitableFloppyDisks() {
        return null;
    }

    public int getSupportedFloppyDiskDriveCount() {
        return 0;
    }

    public int getSupportedJoystickCount() {
        return 0;
    }

    public boolean getSwapKeyCharCase() {
        return false;
    }

    public File getUSBMemStickDirectory() {
        VDIP vDIP = this.getVDIP();
        return vDIP != null ? vDIP.getMemStickDirectory() : null;
    }

    public boolean getUSBMemStickForceCurrentTimestamp() {
        VDIP vDIP = this.getVDIP();
        return vDIP != null ? vDIP.getMemStickForceCurrentTimestamp() : true;
    }

    public boolean getUSBMemStickForceLowerCaseFileNames() {
        VDIP vDIP = this.getVDIP();
        return vDIP != null ? vDIP.getMemStickForceLowerCaseFileNames() : false;
    }

    public boolean getUSBMemStickReadOnly() {
        VDIP vDIP = this.getVDIP();
        return vDIP != null ? vDIP.getMemStickReadOnly() : false;
    }

    protected VDIP getVDIP() {
        return null;
    }

    public boolean hasKCBasicInROM() {
        return false;
    }

    @Override
    public ScreenFrm getScreenFrm() {
        return this.screenFrm;
    }

    protected void initSRAM(byte[] byArray, Properties properties) {
        if (byArray != null) {
            if (EmuUtil.getProperty(properties, "jkcemu.sram.init").equalsIgnoreCase("random")) {
                this.fillRandom(byArray);
            } else {
                Arrays.fill(byArray, (byte)0);
            }
        }
    }

    public boolean isAutoScreenRefresh() {
        return false;
    }

    public boolean isPastingText() {
        return this.pasteThread != null;
    }

    protected boolean isReloadExtROMsOnPowerOnEnabled(Properties properties) {
        return EmuUtil.getBooleanProperty(properties, "jkcemu.external_rom.reload_on_power_on", false);
    }

    public boolean isSecondSystemRunning() {
        return false;
    }

    public void openBasicProgram() {
        this.showFunctionNotSupported();
    }

    public boolean keyPressed(int n, boolean bl, boolean bl2) {
        return false;
    }

    public void keyReleased() {
    }

    public boolean keyTyped(char c) {
        return false;
    }

    public void loadIntoSecondSystem(byte[] byArray, int n, int n2) {
    }

    public void loadIntoMem(int n, byte[] byArray, int n2, int n3, FileFormat fileFormat, int n4) {
        if (byArray != null) {
            int n5 = n;
            for (int i = n3; n2 < byArray.length && n5 < 65536 && i > 0; --i) {
                this.setMemByte(n5++, byArray[n2++]);
            }
            this.updSysCells(n, n3, fileFormat, n4);
        }
    }

    protected boolean pasteChar(char c) throws InterruptedException {
        boolean bl = false;
        switch (c) {
            case '\n': 
            case '\r': {
                bl = this.keyPressed(10, false, false);
                break;
            }
            case ' ': {
                bl = this.keyPressed(32, false, false);
                break;
            }
            default: {
                bl = this.keyTyped(c);
            }
        }
        if (bl) {
            long l = this.getHoldMillisPasteChar();
            if (l > 0L) {
                Thread.sleep(l);
            }
            this.keyReleased();
        }
        return bl;
    }

    protected byte[] readFontByProperty(Properties properties, String string, int n) {
        return properties != null ? EmuUtil.readFile(this.emuThread.getScreenFrm(), properties.getProperty(string), true, n, "Zeichensatzdatei") : null;
    }

    public int readIOByte(int n, int n2) {
        return 255;
    }

    public int readMemByte(int n, boolean bl) {
        return this.getMemByte(n, bl);
    }

    protected byte[] readResource(String string) {
        return EmuUtil.readResource(this.screenFrm, string);
    }

    protected byte[] readROMFile(String string, int n, String string2) {
        return EmuUtil.readFile(this.emuThread.getScreenFrm(), string, true, n, string2);
    }

    public static int reassStringBit7(Z80MemView z80MemView, int n, StringBuilder stringBuilder, boolean bl, int n2, int n3) {
        int n4 = 0;
        boolean bl2 = true;
        while (bl2) {
            int n5;
            int n6;
            int n7;
            int n8 = n;
            long l = 0L;
            boolean bl3 = false;
            for (n7 = 0; n7 < 5 && n8 <= 65535; ++n7, ++n8) {
                n6 = z80MemView.getMemByte(n8, false);
                if (n7 == 0) {
                    bl3 = n6 >= 32 && n6 < 127;
                } else if ((n6 >= 32 && n6 < 127) != bl3) break;
                l = l << 8 | (long)n6;
                if ((n6 & 0x80) == 0) continue;
                bl2 = false;
                break;
            }
            if (n8 > 65535) {
                bl2 = false;
            }
            if (n7 <= 0) continue;
            n6 = stringBuilder.length();
            if (!bl) {
                stringBuilder.append(String.format("%04X ", n));
            }
            long l2 = 0L;
            for (int i = 0; i < n7; ++i) {
                l2 = l2 << 8 | l & 0xFFL;
                l >>= 8;
            }
            long l3 = l2;
            if (!bl) {
                for (n5 = 0; n5 < n7; ++n5) {
                    stringBuilder.append(String.format(" %02X", (int)l2 & 0xFF));
                    l2 >>= 8;
                }
            }
            EmuSys.appendSpacesToCol(stringBuilder, n6, n2);
            stringBuilder.append("DB");
            EmuSys.appendSpacesToCol(stringBuilder, n6, n3);
            n5 = 1;
            boolean bl4 = false;
            for (int i = 0; i < n7; ++i) {
                int n9 = (int)l3 & 0xFF;
                if ((n9 & 0x80) != 0) {
                    if (bl4) {
                        stringBuilder.append('\'');
                        bl4 = false;
                    }
                    if (n5 != 0) {
                        n5 = 0;
                    } else {
                        stringBuilder.append(',');
                    }
                    if (n9 >= 160 && n9 < 255) {
                        stringBuilder.append("80H+'");
                        stringBuilder.append((char)(n9 & 0x7F));
                        stringBuilder.append('\'');
                    } else {
                        if (n9 >= 160) {
                            stringBuilder.append('0');
                        }
                        stringBuilder.append(String.format("%02XH", n9));
                    }
                } else if (n9 >= 32 && n9 < 127) {
                    if (!bl4) {
                        if (n5 != 0) {
                            n5 = 0;
                        } else {
                            stringBuilder.append(',');
                        }
                        stringBuilder.append('\'');
                        bl4 = true;
                    }
                    stringBuilder.append((char)n9);
                } else {
                    if (bl4) {
                        stringBuilder.append('\'');
                        bl4 = false;
                    }
                    if (n5 != 0) {
                        n5 = 0;
                    } else {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(String.format("%02XH", n9));
                }
                l3 >>= 8;
            }
            if (bl4) {
                stringBuilder.append('\'');
            }
            stringBuilder.append('\n');
            n += n7;
            n4 += n7;
        }
        return n4;
    }

    protected int reassSysCallTable(Z80MemView z80MemView, int n, int n2, String[] stringArray, StringBuilder stringBuilder, boolean bl, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9 = 0;
        String string = null;
        int n10 = z80MemView.getMemByte(n, true);
        switch (n10) {
            case 195: {
                string = "JP";
                break;
            }
            case 205: {
                string = "CALL";
            }
        }
        if (string != null && (n8 = z80MemView.getMemWord(n + 1)) >= n2 && (n7 = (n6 = n8 - n2) / 3) * 3 == n6 && n7 < stringArray.length) {
            int n11 = stringBuilder.length();
            if (!bl) {
                stringBuilder.append(String.format("%04X  %02X %02X %02X", n, n10, n8 & 0xFF, n8 >> 8));
            }
            EmuSys.appendSpacesToCol(stringBuilder, n11, n3);
            stringBuilder.append(string);
            EmuSys.appendSpacesToCol(stringBuilder, n11, n4);
            if (n8 >= 40960) {
                stringBuilder.append('0');
            }
            stringBuilder.append(String.format("%04XH", n8));
            EmuSys.appendSpacesToCol(stringBuilder, n11, n5);
            stringBuilder.append(';');
            stringBuilder.append(stringArray[n7]);
            stringBuilder.append('\n');
            n9 = 3;
        }
        return n9;
    }

    public int reassembleSysCall(Z80MemView z80MemView, int n, StringBuilder stringBuilder, boolean bl, int n2, int n3, int n4) {
        return 0;
    }

    public void reset(EmuThread.ResetLevel resetLevel, Properties properties) {
        this.curSoundOutTStates = 0;
        this.curTapeOutTStates = 0;
        this.soundOutPhase = false;
        this.tapeOutPhase = false;
    }

    public void saveBasicProgram() {
        this.showFunctionNotSupported();
    }

    public boolean setBasicMemByte(int n, int n2) {
        return this.setMemByte(n, n2);
    }

    public void setFloppyDiskDrive(int n, FloppyDiskDrive floppyDiskDrive) {
    }

    public void setJoystickAction(int n, int n2) {
    }

    public abstract boolean setMemByte(int var1, int var2);

    protected void showNoBasic() {
        BaseDlg.showErrorDlg((Component)this.screenFrm, "Es ist kein BASIC-Programm im entsprechenden\nAdressbereich des Arbeitsspeichers vorhanden.");
    }

    public void setUSBMemStickDirectory(File file) {
        VDIP vDIP = this.getVDIP();
        if (vDIP != null) {
            vDIP.setMemStickDirectory(file);
        }
    }

    public void setUSBMemStickForceCurrentTimestamp(boolean bl) {
        VDIP vDIP = this.getVDIP();
        if (vDIP != null) {
            vDIP.setMemStickForceCurrentTimestamp(bl);
        }
    }

    public void setUSBMemStickForceLowerCaseFileNames(boolean bl) {
        VDIP vDIP = this.getVDIP();
        if (vDIP != null) {
            vDIP.setMemStickForceLowerCaseFileNames(bl);
        }
    }

    public void setUSBMemStickReadOnly(boolean bl) {
        VDIP vDIP = this.getVDIP();
        if (vDIP != null) {
            vDIP.setMemStickReadOnly(bl);
        }
    }

    public void soundOutFrameRateChanged(int n) {
        this.soundOutFrameRate = n;
        this.updSoundOutTStates();
    }

    public boolean supportsAudio() {
        return this.supportsTapeIn() || this.supportsTapeOut() || this.supportsSoundOutMono() || this.supportsSoundOutStereo();
    }

    public boolean supportsChessboard() {
        return false;
    }

    public boolean supportsKeyboardFld() {
        return false;
    }

    public boolean supportsOpenBasic() {
        return false;
    }

    public boolean supportsPrinter() {
        return false;
    }

    public boolean supportsRAMFloppy1() {
        return false;
    }

    public boolean supportsRAMFloppy2() {
        return false;
    }

    public boolean supportsRAMFloppies() {
        return this.supportsRAMFloppy1() || this.supportsRAMFloppy2();
    }

    public boolean supportsSaveBasic() {
        return false;
    }

    public boolean supportsSoundOut8Bit() {
        return false;
    }

    public boolean supportsSoundOutMono() {
        return false;
    }

    public boolean supportsSoundOutStereo() {
        return false;
    }

    public boolean supportsTapeIn() {
        return false;
    }

    public boolean supportsTapeOut() {
        return false;
    }

    public boolean supportsUSB() {
        return this.getVDIP() != null;
    }

    public void tapeOutFrameRateChanged(int n) {
        this.tapeOutFrameRate = n;
        this.updTapeOutTStates();
    }

    public void updKeyboardMatrix(int[] nArray) {
    }

    public void updDebugScreen() {
    }

    public void updSysCells(int n, int n2, FileFormat fileFormat, int n3) {
    }

    public void writeIOByte(int n, int n2, int n3) {
    }

    public void writeMemByte(int n, int n2) {
        this.setMemByte(n, n2);
    }

    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return (n & 0x30) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            long l = 0L;
            boolean bl = true;
            while (this.pasteThread != null) {
                CharacterIterator characterIterator;
                if (l > 0L) {
                    Thread.sleep(l);
                }
                if ((characterIterator = this.pasteIter) == null) continue;
                char c = '\u0000';
                if (bl) {
                    this.keyReleased();
                    Thread.sleep(100L);
                    c = characterIterator.first();
                    bl = false;
                } else {
                    c = characterIterator.next();
                }
                if (c == '\uffff') {
                    this.cancelPastingText();
                    continue;
                }
                if (this.getConvertKeyCharToISO646DE()) {
                    c = TextUtil.toISO646DE(c);
                }
                if (this.pasteChar(c)) {
                    if (c == '\n' || c == '\r') {
                        l = this.getDelayMillisAfterPasteEnter();
                        continue;
                    }
                    l = this.getDelayMillisAfterPasteChar();
                    continue;
                }
                if (this.pasteThread == null) continue;
                this.cancelPastingText();
                this.fireShowCharNotPasted(characterIterator);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.screenFrm.firePastingTextFinished();
        }
    }

    @Override
    public void z80MaxSpeedChanged(Z80CPU z80CPU) {
        if (z80CPU == this.emuThread.getZ80CPU()) {
            this.updSoundOutTStates();
            this.updTapeOutTStates();
        }
    }

    @Override
    public void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        if (this.soundOutTStates > 0) {
            if (this.curSoundOutTStates > 0) {
                this.curSoundOutTStates -= n;
            } else {
                this.curSoundOutTStates = this.soundOutTStates;
                this.emuThread.writeSoundOutPhase(this.soundOutPhase);
            }
        }
        if (this.tapeOutTStates > 0) {
            if (this.curTapeOutTStates > 0) {
                this.curTapeOutTStates -= n;
            } else {
                this.curTapeOutTStates = this.tapeOutTStates;
                this.emuThread.writeTapeOutPhase(this.tapeOutPhase);
            }
        }
    }

    @Override
    public synchronized void cancelPastingText() {
        Thread thread = this.pasteThread;
        if (thread != null) {
            try {
                thread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.pasteThread = null;
        }
        if (this.pasteIter != null) {
            this.pasteIter = null;
            this.screenFrm.firePastingTextFinished();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                EmuSys.this.keyReleased();
            }
        });
    }

    @Override
    public EmuThread getEmuThread() {
        return this.emuThread;
    }

    @Override
    public synchronized void startPastingText(String string) {
        boolean bl = false;
        if (string != null && !string.isEmpty()) {
            this.cancelPastingText();
            this.pasteIter = new StringCharacterIterator(string);
            this.pasteThread = new Thread(Main.getThreadGroup(), this, "JKCEMU text paste");
            this.pasteThread.start();
            bl = true;
        }
        if (!bl) {
            this.screenFrm.firePastingTextFinished();
        }
    }

    private void showCharNotPasted(CharacterIterator characterIterator) {
        String string = "Text einf\u00fcgen";
        int n = characterIterator.getEndIndex() - characterIterator.getIndex() - 1;
        if (n > 0) {
            if (BaseDlg.showYesNoWarningDlg(this.screenFrm, String.format("Das Zeichen mit dem hexadezimalen Code %02X\nkann nicht eingef\u00fcgt werden.\nM\u00f6chten Sie die restlichen Zeichen einf\u00fcgen?", characterIterator.current()), string)) {
                StringBuilder stringBuilder = new StringBuilder(n);
                char c = characterIterator.next();
                while (c != '\uffff') {
                    stringBuilder.append(c);
                    c = characterIterator.next();
                }
                if (stringBuilder.length() > 0) {
                    this.startPastingText(stringBuilder.toString());
                }
            }
        } else {
            BaseDlg.showWarningDlg(this.screenFrm, String.format("Das letzte Zeichen (hexadezimaler Code %02X)\nkann nicht eingef\u00fcgt werden.", characterIterator.current()), string);
        }
    }

    private void showFunctionNotSupported() {
        BaseDlg.showErrorDlg((Component)this.screenFrm, "Diese Funktion steht f\u00fcr das gerade emulierte System\nnicht zur Verf\u00fcgung.");
    }

    private void updSoundOutTStates() {
        int n = this.soundOutFrameRate;
        this.soundOutTStates = n > 0 && this.supportsSoundOutMono() && !this.supportsSoundOutStereo() && !this.supportsSoundOut8Bit() ? Math.min(this.emuThread.getZ80CPU().getMaxSpeedKHz() * 300 / n, 1) : 0;
    }

    private void updTapeOutTStates() {
        int n = this.tapeOutFrameRate;
        this.tapeOutTStates = n > 0 && this.supportsTapeOut() ? Math.min(this.emuThread.getZ80CPU().getMaxSpeedKHz() * 100 / n, 1) : 0;
    }

    public static enum Chessman {
        WHITE_PAWN,
        WHITE_KNIGHT,
        WHITE_BISHOP,
        WHITE_ROOK,
        WHITE_QUEEN,
        WHITE_KING,
        BLACK_PAWN,
        BLACK_KNIGHT,
        BLACK_BISHOP,
        BLACK_ROOK,
        BLACK_QUEEN,
        BLACK_KING;

    }
}

