/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import javax.swing.JOptionPane;
import jkcemu.Main;
import jkcemu.base.EmuUtil;

public class DeviceIO {
    public static final String LIBNAME_WIN32 = "jkcemu_win32.dll";
    public static final String LIBNAME_WIN64 = "jkcemu_win64.dll";
    private static boolean libChecked = false;
    private static boolean libLoaded = false;

    public static RandomAccessDevice openDeviceForRandomAccess(String string, boolean bl) throws IOException {
        RandomAccessDevice randomAccessDevice = null;
        if (DeviceIO.checkUseLib()) {
            long[] lArray = new long[1];
            int n = DeviceIO.openDevice(string, bl, true, lArray);
            if (n != 0) {
                DeviceIO.throwErrMsg(n);
            }
            randomAccessDevice = new RandomAccessDevice(lArray[0]);
        } else {
            randomAccessDevice = new RandomAccessDevice(new RandomAccessFile(string, bl ? "r" : "rw"));
        }
        return randomAccessDevice;
    }

    public static java.io.InputStream openDeviceForSequentialRead(String string) throws IOException {
        java.io.InputStream inputStream = null;
        if (DeviceIO.checkUseLib()) {
            long[] lArray = new long[1];
            int n = DeviceIO.openDevice(string, true, false, lArray);
            if (n != 0) {
                DeviceIO.throwErrMsg(n);
            }
            inputStream = new InputStream(lArray[0]);
        } else {
            inputStream = new FileInputStream(string);
        }
        return inputStream;
    }

    public static java.io.OutputStream openDeviceForSequentialWrite(String string) throws IOException {
        java.io.OutputStream outputStream = null;
        if (DeviceIO.checkUseLib()) {
            long[] lArray = new long[1];
            int n = DeviceIO.openDevice(string, false, false, lArray);
            if (n != 0) {
                DeviceIO.throwErrMsg(n);
            }
            outputStream = new OutputStream(lArray[0]);
        } else {
            outputStream = new FileOutputStream(string);
        }
        return outputStream;
    }

    public static Joystick openJoystick(int n) {
        Joystick joystick = null;
        if (DeviceIO.checkUseLib()) {
            long[] lArray = new long[4];
            if (DeviceIO.getJoystickPos(n, lArray) == 0 && DeviceIO.getJoystickBounds(n, lArray) == 0) {
                joystick = new Joystick(n, null, lArray[0], lArray[1], lArray[2], lArray[3]);
            }
        } else {
            try {
                File file;
                String[] stringArray = new String[]{"/dev/js", "/dev/input/js", "/dev/usb/js"};
                for (int i = 0; !(i >= stringArray.length || (file = new File(String.format("%s%d", stringArray[i], n))).exists() && (joystick = new Joystick(n, new FileInputStream(file), 0L, 0L, 0L, 0L)) != null); ++i) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return joystick;
    }

    private static native int openDevice(String var0, boolean var1, boolean var2, long[] var3);

    private static native int readDevice(long var0, byte[] var2, int var3, int var4, int[] var5);

    private static native int writeDevice(long var0, byte[] var2, int var3, int var4, int[] var5);

    private static native int seekDevice(long var0, long var2);

    private static native int closeDevice(long var0);

    private static native int flushDevice(long var0);

    private static native String getErrorMsg(int var0);

    private static native int getJoystickBounds(int var0, long[] var1);

    private static native int getJoystickPos(int var0, long[] var1);

    private static float adjustToFloat(long l, long l2, long l3) {
        float f = 0.0f;
        if (l3 > l2) {
            if (l < l2) {
                l = l2;
            } else if (l > l3) {
                l = l3;
            }
            f = (float)(l - l2) / (float)(l3 - l2) * 2.0f - 1.0f;
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean checkUseLib() {
        if (!libChecked) {
            String string;
            if (File.separatorChar == '\\' && (string = System.getProperty("os.arch")) != null) {
                String string2 = null;
                if (string.indexOf("64") >= 0) {
                    string2 = LIBNAME_WIN64;
                } else if (string.indexOf("86") >= 0) {
                    string2 = LIBNAME_WIN32;
                }
                if (string2 != null) {
                    Object object;
                    Object object2;
                    File file = null;
                    URL uRL = DeviceIO.class.getResource("/lib/" + string2);
                    if (uRL != null) {
                        object2 = uRL.getProtocol();
                        object = uRL.getFile();
                        if (object2 != null && object != null && ((String)object2).equals("file") && ((String)object).length() > 3) {
                            File file2;
                            char c = Character.toUpperCase(((String)object).charAt(1));
                            if (((String)object).charAt(0) == '/' && c >= 'A' && c <= 'Z' && ((String)object).charAt(2) == ':') {
                                object = ((String)object).substring(1);
                            }
                            if (((String)object).indexOf(47) >= 0) {
                                ((String)object).replace('/', '\\');
                            }
                            if ((file2 = new File((String)object)).exists()) {
                                file = file2;
                            }
                        }
                    }
                    if (file == null && (object2 = Main.getConfigDir()) != null && !(file = new File((File)object2, string2)).exists() && uRL != null) {
                        try {
                            object = null;
                            FileOutputStream fileOutputStream = null;
                            try {
                                object = uRL.openStream();
                                fileOutputStream = new FileOutputStream(file);
                                int n = ((java.io.InputStream)object).read();
                                while (n >= 0) {
                                    ((java.io.OutputStream)fileOutputStream).write(n);
                                    n = ((java.io.InputStream)object).read();
                                }
                                ((java.io.OutputStream)fileOutputStream).close();
                                fileOutputStream = null;
                            }
                            catch (Throwable throwable) {
                                EmuUtil.closeSilent((Closeable)object);
                                EmuUtil.closeSilent(fileOutputStream);
                                throw throwable;
                            }
                            EmuUtil.closeSilent((Closeable)object);
                            EmuUtil.closeSilent(fileOutputStream);
                        }
                        catch (Exception exception) {
                            DeviceIO.showLibError("Die Bibliothek '" + file.getPath() + "' konnte nicht angelegt werden.", exception);
                            file = null;
                        }
                        if (file != null) {
                            JOptionPane.showMessageDialog(Main.getScreenFrm(), "Es wurde soeben im JKCEMU-Konfigurationsverzeichnis eine DLL f\u00fcr den Zugriff\nauf physische Diskettenlaufwerke, Joysticks und andere am Emulatorrechner\nangeschlossene Ger\u00e4te installiert.\nDie Benutzung dieser DLL und somit der Zugriff auf solche Ger\u00e4te ist aber erst\nnach Schlie\u00dfen und erneutem Starten des Emulators m\u00f6glich.", "Hinweis", 1);
                        }
                    }
                    if (file != null && !file.isAbsolute()) {
                        file = file.getAbsoluteFile();
                    }
                    if (file != null) {
                        try {
                            System.load(file.getPath());
                            libLoaded = true;
                        }
                        catch (Exception exception) {
                            DeviceIO.showLibErrorLoadFailed(file, exception);
                        }
                        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                            DeviceIO.showLibErrorLoadFailed(file, unsatisfiedLinkError);
                        }
                    }
                }
            }
            libChecked = true;
        }
        return libLoaded;
    }

    private static int readInternal(long l, byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (n2 > 0) {
            int[] nArray = new int[1];
            int n4 = DeviceIO.readDevice(l, byArray, n, n2, nArray);
            if (n4 == 0) {
                n3 = nArray[0] > 0 ? nArray[0] : -1;
            } else if (n4 == 1) {
                n3 = -1;
            } else {
                DeviceIO.throwErrMsg(n4);
            }
        }
        return n3;
    }

    private static void showLibError(String string, Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        stringBuilder.append(string);
        stringBuilder.append("\nDadurch ist der Zugriff auf physische Diskettenlaufwerke, Joysticks und andere\nam Emulatorrechner angeschlossene Ger\u00e4te nicht oder nur eingeschr\u00e4nkt m\u00f6glich.\nAnsonsten ist JKCEMU voll funktionsf\u00e4hig.\n\nDas Problem l\u00e4sst sich m\u00f6glicherweise l\u00f6sen, indem Sie in den Einstellungen,\nBereich Sonstiges, das Verzeichnis f\u00fcr Einstellungen und Profile l\u00f6schen\nund danach JKCEMU erneut starten.");
        String string2 = throwable.getMessage();
        if (string2 != null && !string2.isEmpty()) {
            stringBuilder.append("\n\nDetaillierte Fehlermeldung:\n");
            stringBuilder.append(string2);
        }
        JOptionPane.showMessageDialog(Main.getScreenFrm(), stringBuilder.toString(), "Fehler", 0);
    }

    private static void showLibErrorLoadFailed(File file, Throwable throwable) {
        DeviceIO.showLibError("Die Bibliothek '" + file.getPath() + "' konnte nicht geladen werden.", throwable);
    }

    private static void throwErrMsg(int n) throws IOException {
        String string = DeviceIO.getErrorMsg(n);
        if (string != null && string.isEmpty()) {
            string = null;
        }
        throw new IOException(string != null ? string : "Ein-/Ausgabefehler");
    }

    public static class RandomAccessDevice
    implements Closeable {
        private long handle;
        private RandomAccessFile raf;

        private RandomAccessDevice(long l) {
            this.handle = l;
            this.raf = null;
        }

        private RandomAccessDevice(RandomAccessFile randomAccessFile) {
            this.handle = -1L;
            this.raf = randomAccessFile;
        }

        @Override
        public void close() throws IOException {
            if (this.raf != null) {
                this.raf.close();
            } else {
                int n = DeviceIO.closeDevice(this.handle);
                if (n != 0) {
                    DeviceIO.throwErrMsg(n);
                }
            }
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = -1;
            n3 = this.raf != null ? this.raf.read(byArray, n, n2) : DeviceIO.readInternal(this.handle, byArray, n, n2);
            return n3;
        }

        public void seek(long l) throws IOException {
            if (this.raf != null) {
                this.raf.seek(l);
            } else {
                int n = DeviceIO.seekDevice(this.handle, l);
                if (n != 0) {
                    DeviceIO.throwErrMsg(n);
                }
            }
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.raf != null) {
                this.raf.write(byArray, n, n2);
            } else if (n2 > 0) {
                int[] nArray = new int[1];
                do {
                    int n3;
                    if ((n3 = DeviceIO.writeDevice(this.handle, byArray, n, n2, nArray)) != 0) {
                        DeviceIO.throwErrMsg(n3);
                    }
                    n += nArray[0];
                } while ((n2 -= nArray[0]) > 0);
            }
        }
    }

    public static class OutputStream
    extends java.io.OutputStream {
        private long handle;
        private byte[] singleByteBuf;

        private OutputStream(long l) throws IOException {
            this.handle = l;
            this.singleByteBuf = null;
        }

        @Override
        public void close() throws IOException {
            int n = DeviceIO.closeDevice(this.handle);
            if (n != 0) {
                DeviceIO.throwErrMsg(n);
            }
        }

        @Override
        public void flush() throws IOException {
            int n = DeviceIO.flushDevice(this.handle);
            if (n != 0) {
                DeviceIO.throwErrMsg(n);
            }
        }

        @Override
        public void write(int n) throws IOException {
            if (this.singleByteBuf == null) {
                this.singleByteBuf = new byte[1];
                this.singleByteBuf[0] = (byte)n;
            }
            this.write(this.singleByteBuf, 0, 1);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (n2 > 0) {
                int[] nArray = new int[1];
                do {
                    int n3;
                    if ((n3 = DeviceIO.writeDevice(this.handle, byArray, n, n2, nArray)) != 0) {
                        DeviceIO.throwErrMsg(n3);
                    }
                    n += nArray[0];
                } while ((n2 -= nArray[0]) > 0);
            }
        }
    }

    public static class InputStream
    extends java.io.InputStream {
        private long handle;
        private byte[] singleByteBuf;

        private InputStream(long l) throws IOException {
            this.handle = l;
            this.singleByteBuf = null;
        }

        @Override
        public void close() throws IOException {
            int n = DeviceIO.closeDevice(this.handle);
            if (n != 0) {
                DeviceIO.throwErrMsg(n);
            }
        }

        @Override
        public int read() throws IOException {
            if (this.singleByteBuf == null) {
                this.singleByteBuf = new byte[1];
            }
            return this.read(this.singleByteBuf, 0, 1) == 1 ? this.singleByteBuf[0] & 0xFF : -1;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return DeviceIO.readInternal(this.handle, byArray, n, n2);
        }

        @Override
        public long skip(long l) throws IOException {
            throw new IOException("DeviceIO.InputStream.skip(...) nicht implementiert");
        }
    }

    public static class Joystick
    implements Closeable {
        private int joyNum;
        private java.io.InputStream in;
        private long xMin;
        private long xMax;
        private long yMin;
        private long yMax;
        private long xLastRaw;
        private long yLastRaw;
        private float xAxis;
        private float yAxis;
        private int pressedBtns;
        private boolean active;
        private byte[] evtBuf;
        private long[] resultBuf;

        private Joystick(int n, java.io.InputStream inputStream, long l, long l2, long l3, long l4) {
            this.joyNum = n;
            this.in = inputStream;
            this.xMin = l;
            this.xMax = l2;
            this.yMin = l3;
            this.yMax = l4;
            this.xLastRaw = 0L;
            this.yLastRaw = 0L;
            this.xAxis = 0.0f;
            this.yAxis = 0.0f;
            this.pressedBtns = 0;
            this.active = true;
            if (this.in != null) {
                this.evtBuf = new byte[8];
                this.resultBuf = null;
            } else {
                this.evtBuf = null;
                this.resultBuf = new long[3];
            }
        }

        @Override
        public void close() throws IOException {
            if (this.in != null) {
                EmuUtil.closeSilent(this.in);
                this.in = null;
            }
            this.active = false;
        }

        public float getXAxis() {
            return this.xAxis;
        }

        public float getYAxis() {
            return this.yAxis;
        }

        public int getPressedButtons() {
            return this.pressedBtns;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean waitForEvent() {
            boolean bl = false;
            if (!this.active) return bl;
            if (this.in != null) {
                try {
                    do {
                        if (EmuUtil.read(this.in, this.evtBuf) == this.evtBuf.length) {
                            short s = (short)(this.evtBuf[5] << 8 & 0xFF00 | this.evtBuf[4] & 0xFF);
                            int n = this.evtBuf[6] & 0xFF;
                            int n2 = this.evtBuf[7] & 0xFF;
                            if ((n & 3) == 1) {
                                this.pressedBtns = s & 0xFFFF;
                                bl = true;
                            } else if ((n & 3) == 2) {
                                if (n2 == 0) {
                                    this.xAxis = (float)s / 32767.0f;
                                    bl = true;
                                } else if (n2 == 1) {
                                    this.yAxis = (float)s / 32767.0f;
                                    bl = true;
                                }
                            }
                        }
                        if (!this.active) return bl;
                    } while (!bl);
                    return bl;
                }
                catch (IOException iOException) {
                    this.active = false;
                }
                return bl;
            } else {
                if (!DeviceIO.checkUseLib()) return bl;
                do {
                    if (DeviceIO.getJoystickPos(this.joyNum, this.resultBuf) == 0) {
                        int n = (int)this.resultBuf[0];
                        long l = this.resultBuf[1];
                        long l2 = this.resultBuf[2];
                        if (n == this.pressedBtns && l == this.xLastRaw && l2 == this.yLastRaw) {
                            try {
                                Thread.sleep(20L);
                            }
                            catch (InterruptedException interruptedException) {
                                this.active = false;
                            }
                            continue;
                        }
                        this.pressedBtns = n;
                        this.xLastRaw = l;
                        this.yLastRaw = l2;
                        this.xAxis = DeviceIO.adjustToFloat(l, this.xMin, this.xMax);
                        this.yAxis = DeviceIO.adjustToFloat(l2, this.yMin, this.yMax);
                        bl = true;
                        continue;
                    }
                    this.active = false;
                } while (this.active && !bl);
            }
            return bl;
        }
    }
}

