/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import jkcemu.base.BaseDlg;

public class CancelableProgressDlg
extends BaseDlg {
    private Progressable progressable;
    private volatile boolean cancelled;
    private Timer timer;
    private JProgressBar progressBar;
    private JButton btnCancel;

    public CancelableProgressDlg(Window window, String string, Progressable progressable) {
        super(window, string);
        this.progressable = progressable;
        this.cancelled = false;
        this.timer = new Timer(200, this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.progressBar = new JProgressBar(0, 0, progressable.getProgressMax());
        this.progressBar.setPreferredSize(new Dimension(200, 14));
        this.add((Component)this.progressBar, gridBagConstraints);
        this.btnCancel = new JButton("Abbrechen");
        gridBagConstraints.insets.top = 10;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnCancel, gridBagConstraints);
        this.pack();
        this.setParentCentered();
        this.setResizable(false);
        this.btnCancel.addActionListener(this);
    }

    public void fireProgressFinished() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CancelableProgressDlg.this.progressFinished();
            }
        });
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object == this.timer) {
            bl = true;
            this.updProgressBar();
        } else if (object == this.btnCancel) {
            bl = true;
            this.doClose();
        }
        return bl;
    }

    @Override
    public boolean doClose() {
        boolean bl = super.doClose();
        if (bl) {
            this.cancelled = true;
        }
        return bl;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.timer.start();
        }
        super.setVisible(bl);
    }

    private void updProgressBar() {
        int n = this.progressable.getProgressValue();
        if (n < 0) {
            n = 0;
        } else if (n > this.progressBar.getMaximum()) {
            n = this.progressBar.getMaximum();
        }
        this.progressBar.setValue(n);
    }

    private void progressFinished() {
        this.timer.stop();
        boolean bl = this.cancelled;
        this.doClose();
        this.cancelled = bl;
    }

    public static interface Progressable {
        public int getProgressMax();

        public int getProgressValue();
    }
}

