/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.EventObject;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;

public class BaseFrm
extends JFrame
implements ActionListener,
MouseListener,
KeyListener,
WindowListener {
    public static final String PROP_WINDOW_X = "window.x";
    public static final String PROP_WINDOW_Y = "window.y";
    public static final String PROP_WINDOW_WIDTH = "window.width";
    public static final String PROP_WINDOW_HEIGHT = "window.height";
    public static final String PROP_WINDOW_ICONIFIED = "window.iconified";
    public static final String PROP_WINDOW_MAXIMIZED = "window.maximized";

    protected BaseFrm() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        Main.frameCreated(this);
    }

    public boolean applySettings(Properties properties, boolean bl) {
        boolean bl2 = false;
        if (properties != null && !this.isVisible()) {
            int n;
            String string = this.getSettingsPrefix();
            int n2 = EmuUtil.getIntProperty(properties, string + PROP_WINDOW_X, -1);
            int n3 = EmuUtil.getIntProperty(properties, string + PROP_WINDOW_Y, -1);
            if (n2 >= 0 && n3 >= 0) {
                n = EmuUtil.getIntProperty(properties, string + PROP_WINDOW_WIDTH, 0);
                int n4 = EmuUtil.getIntProperty(properties, string + PROP_WINDOW_HEIGHT, 0);
                if (bl && n > 0 && n4 > 0) {
                    this.setBounds(n2, n3, n, n4);
                } else {
                    this.setLocation(n2, n3);
                }
                bl2 = true;
            }
            n = 0;
            if (EmuUtil.getBooleanProperty(properties, string + PROP_WINDOW_ICONIFIED, false)) {
                n |= 1;
            }
            if (EmuUtil.getBooleanProperty(properties, string + PROP_WINDOW_MAXIMIZED, false)) {
                n |= 6;
            }
            this.setExtendedState(n != 0 ? n : 0);
        }
        return bl2;
    }

    protected JButton createImageButton(String string, String string2) {
        JButton jButton = EmuUtil.createImageButton(this, string, string2);
        jButton.addActionListener(this);
        return jButton;
    }

    protected JMenuItem createJMenuItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(this);
        return jMenuItem;
    }

    protected JMenuItem createJMenuItem(String string, String string2) {
        JMenuItem jMenuItem = this.createJMenuItem(string);
        jMenuItem.setActionCommand(string2);
        return jMenuItem;
    }

    protected JMenuItem createJMenuItem(String string, int n, int n2) {
        return this.createJMenuItem(string, KeyStroke.getKeyStroke(n, n2));
    }

    protected JMenuItem createJMenuItem(String string, KeyStroke keyStroke) {
        JMenuItem jMenuItem = this.createJMenuItem(string);
        jMenuItem.setAccelerator(keyStroke);
        return jMenuItem;
    }

    protected JMenuItem createJMenuItem(String string, String string2, KeyStroke keyStroke) {
        JMenuItem jMenuItem = this.createJMenuItem(string, string2);
        jMenuItem.setAccelerator(keyStroke);
        return jMenuItem;
    }

    protected JRadioButtonMenuItem createJRadioButtonMenuItem(ButtonGroup buttonGroup, String string, String string2, boolean bl, KeyStroke keyStroke) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string, bl);
        buttonGroup.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.setActionCommand(string2);
        jRadioButtonMenuItem.addActionListener(this);
        jRadioButtonMenuItem.setAccelerator(keyStroke);
        return jRadioButtonMenuItem;
    }

    public boolean doClose() {
        this.setVisible(false);
        this.dispose();
        return true;
    }

    public boolean doQuit() {
        return this.doClose();
    }

    public void fireRepaint() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BaseFrm.this.repaint();
            }
        });
    }

    public void fireShowErrorMsg(final String string) {
        final BaseFrm baseFrm = this;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BaseDlg.showErrorDlg(baseFrm, string);
            }
        });
    }

    public String getSettingsPrefix() {
        return this.getClass().getName() + ".";
    }

    public void lookAndFeelChanged() {
    }

    public void putSettingsTo(Properties properties) {
        if (properties != null) {
            Dimension dimension;
            String string = this.getSettingsPrefix();
            Point point = this.getLocation();
            if (point != null) {
                properties.setProperty(string + PROP_WINDOW_X, String.valueOf(point.x));
                properties.setProperty(string + PROP_WINDOW_Y, String.valueOf(point.y));
            }
            if (this.isResizable() && (dimension = this.getSize()) != null && dimension.width > 0 && dimension.height > 0) {
                properties.setProperty(string + PROP_WINDOW_WIDTH, String.valueOf(dimension.width));
                properties.setProperty(string + PROP_WINDOW_HEIGHT, String.valueOf(dimension.height));
            }
            int n = this.getExtendedState();
            EmuUtil.setProperty(properties, string + PROP_WINDOW_ICONIFIED, (n & 1) == 1);
            EmuUtil.setProperty(properties, string + PROP_WINDOW_MAXIMIZED, (n & 6) == 6);
        }
    }

    public void resetFired() {
    }

    public void setBoundsToDefaults() {
        Dimension dimension = this.getToolkit().getScreenSize();
        if (dimension != null) {
            this.setBounds(dimension.width / 4, dimension.height / 4, dimension.width / 2, dimension.height / 2);
        } else {
            this.setSize(200, 200);
        }
    }

    public void setScreenCentered() {
        Dimension dimension = this.getToolkit().getScreenSize();
        if (dimension != null) {
            Dimension dimension2 = this.getSize();
            int n = (dimension.width - dimension2.width) / 2;
            int n2 = (dimension.height - dimension2.height) / 2;
            this.setLocation(n >= 0 ? n : 0, n2 >= 0 ? n2 : 0);
        }
    }

    public void setWaitCursor(boolean bl) {
        Component component = this.getGlassPane();
        if (component != null) {
            component.setVisible(bl);
            component.setCursor(bl ? Cursor.getPredefinedCursor(3) : null);
        }
    }

    public void willReset() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.doActionInternal(actionEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.showPopupInternal(mouseEvent)) {
            mouseEvent.consume();
        } else if (mouseEvent.getClickCount() > 1 && this.doActionInternal(mouseEvent)) {
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.showPopupInternal(mouseEvent)) {
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.showPopupInternal(mouseEvent)) {
            mouseEvent.consume();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent != null && keyEvent.getKeyCode() == 10 && this.doActionInternal(keyEvent)) {
            keyEvent.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.doClose();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    protected boolean doAction(EventObject eventObject) {
        return false;
    }

    protected boolean showPopup(MouseEvent mouseEvent) {
        return false;
    }

    private boolean doActionInternal(EventObject eventObject) {
        boolean bl = false;
        this.setWaitCursor(true);
        try {
            bl = this.doAction(eventObject);
        }
        catch (Exception exception) {
            EmuUtil.exitSysError(this, null, exception);
        }
        this.setWaitCursor(false);
        return bl;
    }

    private boolean showPopupInternal(MouseEvent mouseEvent) {
        boolean bl = false;
        if (mouseEvent != null && mouseEvent.isPopupTrigger()) {
            bl = this.showPopup(mouseEvent);
        }
        return bl;
    }
}

