/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import jkcemu.base.AutoLoadEntry;

public class AutoLoadTableModel
extends AbstractTableModel {
    private static NumberFormat waitTimeFmt = null;
    private static String[] colNames = new String[]{"Wartezeit", "Ladeadresse", "Dateiname"};
    private List<AutoLoadEntry> rows;

    public AutoLoadTableModel() {
        if (waitTimeFmt == null && (waitTimeFmt = NumberFormat.getNumberInstance()) instanceof DecimalFormat) {
            ((DecimalFormat)waitTimeFmt).applyPattern("##0.0");
        }
        this.rows = new ArrayList<AutoLoadEntry>();
    }

    public void addRow(AutoLoadEntry autoLoadEntry) {
        int n = this.rows.size();
        this.rows.add(autoLoadEntry);
        this.fireTableRowsInserted(n, n);
    }

    public void addRows(Collection<AutoLoadEntry> collection) {
        if (collection != null && !collection.isEmpty()) {
            int n = this.rows.size();
            this.rows.addAll(collection);
            this.fireTableRowsInserted(n, this.rows.size() - 1);
        }
    }

    public void clear() {
        this.rows.clear();
        this.fireTableDataChanged();
    }

    public AutoLoadEntry getRow(int n) {
        return n >= 0 && n < this.rows.size() ? this.rows.get(n) : null;
    }

    public void removeRow(int n) {
        if (n >= 0 && n < this.rows.size()) {
            this.rows.remove(n);
            this.fireTableRowsDeleted(n, n);
        }
    }

    public void setRow(int n, AutoLoadEntry autoLoadEntry) {
        if (n >= 0 && n < this.rows.size()) {
            this.rows.set(n, autoLoadEntry);
            this.fireTableRowsUpdated(n, n);
        }
    }

    public static String toHex4(Integer n) {
        String string = null;
        if (n != null && n >= 0 && n <= 65535) {
            string = String.format("%04X", n & 0xFFFF);
        }
        return string;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return n >= 0 && n < colNames.length ? String.class : Object.class;
    }

    @Override
    public int getColumnCount() {
        return colNames.length;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getColumnName(int n) {
        if (n < 0) return "";
        if (n >= colNames.length) return "";
        String string = colNames[n];
        return string;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        String string = null;
        if (n >= 0 && n < this.rows.size() && n2 >= 0) {
            AutoLoadEntry autoLoadEntry;
            if (n2 < colNames.length && (autoLoadEntry = this.rows.get(n)) != null) {
                switch (n2) {
                    case 0: {
                        string = waitTimeFmt.format((double)autoLoadEntry.getMillisToWait() / 1000.0) + " s";
                        break;
                    }
                    case 1: {
                        string = AutoLoadTableModel.toHex4(autoLoadEntry.getLoadAddr());
                        break;
                    }
                    case 2: {
                        string = autoLoadEntry.getFileName();
                    }
                }
            }
        }
        return string;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }
}

