/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import jkcemu.base.EmuUtil;

public class AutoInputEntry {
    public static final String PROP_COUNT = "count";
    public static final String PROP_INPUT_TEXT = "input_text";
    public static final String PROP_REMARK = "remark";
    public static final String PROP_WAIT_MILLIS = "wait.millis";
    private int millisToWait;
    private String inputText;
    private String remark;

    public AutoInputEntry(int n, String string, String string2) {
        this.millisToWait = n;
        this.inputText = string;
        this.remark = string2;
    }

    public int getMillisToWait() {
        return this.millisToWait;
    }

    public String getInputText() {
        return this.inputText;
    }

    public String getRemark() {
        return this.remark;
    }

    public static List<AutoInputEntry> readEntries(Properties properties, String string) {
        int n;
        ArrayList<AutoInputEntry> arrayList = null;
        if (properties != null && string != null && (n = EmuUtil.getIntProperty(properties, string + PROP_COUNT, 0)) > 0) {
            arrayList = new ArrayList<AutoInputEntry>();
            for (int i = 0; i < n; ++i) {
                String string2 = String.format("%s%d.", string, i);
                String string3 = properties.getProperty(string2 + PROP_INPUT_TEXT);
                if (string3 == null || string3.isEmpty()) continue;
                try {
                    arrayList.add(new AutoInputEntry(EmuUtil.getIntProperty(properties, string2 + PROP_WAIT_MILLIS, 0), URLDecoder.decode(string3, "UTF-8"), properties.getProperty(string2 + PROP_REMARK)));
                    continue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        return arrayList;
    }
}

