/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.util.HashMap;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class AutoInputDocument
extends PlainDocument {
    private static char[][] codeMapping = new char[][]{{'\u0003', '\u220e'}, {'\b', '\u2190'}, {'\t', '\u2192'}, {'\n', '\u2193'}, {'\u000b', '\u2191'}, {'\r', '\u21b5'}, {'\u001b', '\u21b1'}, {'\u00f1', '\u2460'}, {'\u00f2', '\u2461'}, {'\u00f3', '\u2462'}, {'\u00f4', '\u2463'}, {'\u00f5', '\u2464'}, {'\u00f6', '\u2465'}, {'\u00f7', '\u2466'}, {'\u00f8', '\u2467'}, {'\u00f9', '\u2468'}, {'\u00fb', '\u246a'}, {'\u00fc', '\u246b'}};
    private static Map<Character, Character> raw2Visible = null;
    private static Map<Character, Character> visible2Raw = null;
    private boolean swapCase;

    public AutoInputDocument(boolean bl) {
        this.swapCase = bl;
    }

    public static String toRawText(String string) {
        String string2 = null;
        if (string != null) {
            int n = string.length();
            if (n > 0) {
                char[] cArray = new char[n];
                for (int i = 0; i < n; ++i) {
                    char c = string.charAt(i);
                    Character c2 = AutoInputDocument.getVisible2RawMap().get(Character.valueOf(c));
                    if (c2 != null) {
                        c = c2.charValue();
                    }
                    cArray[i] = c;
                }
                string2 = new String(cArray);
            } else {
                string2 = "";
            }
        }
        return string2;
    }

    public static String toVisibleText(String string) {
        String string2 = null;
        if (string != null) {
            int n = string.length();
            if (n > 0) {
                char[] cArray = new char[n];
                for (int i = 0; i < n; ++i) {
                    char c = string.charAt(i);
                    Character c2 = AutoInputDocument.getRaw2VisibleMap().get(Character.valueOf(c));
                    if (c2 != null) {
                        c = c2.charValue();
                    }
                    cArray[i] = c;
                }
                string2 = new String(cArray);
            } else {
                string2 = "";
            }
        }
        return string2;
    }

    public boolean getSwapCase() {
        return this.swapCase;
    }

    public void setSwapCase(boolean bl) {
        this.swapCase = bl;
    }

    @Override
    public synchronized void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        int n2;
        if (string != null && (n2 = string.length()) > 0) {
            StringBuilder stringBuilder = new StringBuilder(n2);
            for (int i = 0; i < n2; ++i) {
                char c = string.charAt(i);
                if (c >= ' ' && c <= '~') {
                    if (this.swapCase) {
                        if (c >= 'A' && c <= 'Z') {
                            c = Character.toLowerCase(c);
                        } else if (c >= 'a' && c <= 'z') {
                            c = Character.toUpperCase(c);
                        }
                    }
                    stringBuilder.append(c);
                    continue;
                }
                if (!AutoInputDocument.getVisible2RawMap().containsKey(Character.valueOf(c))) continue;
                stringBuilder.append(c);
            }
            if (stringBuilder.length() > 0) {
                super.insertString(n, stringBuilder.toString(), attributeSet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Character, Character> getRaw2VisibleMap() {
        Class<AutoInputDocument> clazz = AutoInputDocument.class;
        synchronized (AutoInputDocument.class) {
            if (raw2Visible == null) {
                raw2Visible = new HashMap<Character, Character>();
                for (int i = 0; i < codeMapping.length; ++i) {
                    raw2Visible.put(Character.valueOf(codeMapping[i][0]), Character.valueOf(codeMapping[i][1]));
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return raw2Visible;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Character, Character> getVisible2RawMap() {
        Class<AutoInputDocument> clazz = AutoInputDocument.class;
        synchronized (AutoInputDocument.class) {
            if (visible2Raw == null) {
                visible2Raw = new HashMap<Character, Character>();
                for (int i = 0; i < codeMapping.length; ++i) {
                    visible2Raw.put(Character.valueOf(codeMapping[i][1]), Character.valueOf(codeMapping[i][0]));
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return visible2Raw;
        }
    }
}

