/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.FileProgressInputStream;

public abstract class AbstractThreadDlg
extends BaseDlg
implements Runnable {
    protected boolean cancelled = false;
    protected int errorCount = 0;
    private Thread thread;
    private boolean autoClose = true;
    private JTextArea fldLog;
    private JProgressBar progressBar;
    private JButton btnClose;

    protected AbstractThreadDlg(Window window, String string, boolean bl) {
        super(window, Dialog.ModalityType.MODELESS);
        this.thread = new Thread(Main.getThreadGroup(), this, string);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0);
        this.fldLog = new JTextArea(10, 32);
        this.fldLog.setEditable(false);
        this.add((Component)new JScrollPane(this.fldLog, 20, 30), gridBagConstraints);
        if (bl) {
            this.progressBar = new JProgressBar(0);
            this.progressBar.setBorderPainted(true);
            this.progressBar.setStringPainted(false);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weighty = 0.0;
            ++gridBagConstraints.gridy;
            this.add((Component)this.progressBar, gridBagConstraints);
        } else {
            this.progressBar = null;
        }
        this.btnClose = new JButton("Abbrechen");
        this.btnClose.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnClose, gridBagConstraints);
        this.pack();
        this.setParentCentered();
        this.fldLog.setColumns(0);
        this.fldLog.setRows(0);
        final Thread thread = this.thread;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                thread.start();
            }
        });
    }

    protected void appendErrorToLog(Object object) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("  Fehler");
        if (object != null) {
            String string = null;
            string = object instanceof Exception ? ((Exception)object).getMessage() : object.toString();
            if (string != null && !string.isEmpty()) {
                stringBuilder.append(": ");
                stringBuilder.append(string);
            }
        }
        stringBuilder.append('\n');
        this.appendToLog(stringBuilder.toString());
        this.autoClose = false;
    }

    protected void appendIgnoredToLog() {
        this.appendToLog(" Ignoriert\n");
        this.autoClose = false;
    }

    protected void appendToLog(final String string) {
        if (!this.cancelled) {
            final JTextArea jTextArea = this.fldLog;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    jTextArea.append(string);
                }
            });
        }
    }

    protected void disableAutoClose() {
        this.autoClose = false;
    }

    protected abstract void doProgress();

    protected void incErrorCount() {
        ++this.errorCount;
    }

    protected FileProgressInputStream openInputFile(File file, int n) throws IOException {
        return new FileProgressInputStream(file, this.progressBar, n);
    }

    @Override
    public void run() {
        this.doProgress();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractThreadDlg.this.progressFinished();
            }
        });
    }

    @Override
    public boolean doAction(EventObject eventObject) {
        boolean bl = false;
        if (eventObject.getSource() == this.btnClose) {
            bl = true;
            this.cancelled = true;
            if (!this.thread.isAlive()) {
                this.doClose();
            }
        }
        return bl;
    }

    private void progressFinished() {
        this.btnClose.setText("Schlie\u00dfen");
        if (!this.cancelled && this.errorCount > 0) {
            if (this.progressBar != null) {
                this.progressBar.setMinimum(0);
                this.progressBar.setMaximum(1);
                this.progressBar.setValue(0);
            }
            this.fldLog.append("\n");
            this.fldLog.append(Integer.toString(this.errorCount));
            this.fldLog.append(" Fehler\n");
        } else if (this.autoClose) {
            this.doClose();
        }
    }
}

