/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Component;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.EventObject;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;
import jkcemu.base.SettingsFrm;
import jkcemu.base.UserCancelException;
import jkcemu.base.UserInputException;

public abstract class AbstractSettingsFld
extends JPanel
implements ActionListener,
DropTargetListener,
KeyListener {
    protected SettingsFrm settingsFrm;
    protected String propPrefix;

    protected AbstractSettingsFld(SettingsFrm settingsFrm, String string) {
        this.settingsFrm = settingsFrm;
        this.propPrefix = string;
    }

    public void applyInput(Properties properties, boolean bl) throws UserCancelException, UserInputException {
    }

    protected void checkFileReadable(File file) throws UserInputException {
        if (file != null && (file.isDirectory() || !file.canRead())) {
            throw new UserInputException(file.getPath() + ": Datei nicht lesbar");
        }
    }

    protected JButton createImageButton(String string, String string2) {
        JButton jButton = EmuUtil.createImageButton(this.settingsFrm, string, string2);
        jButton.addActionListener(this);
        jButton.addKeyListener(this);
        return jButton;
    }

    protected boolean doAction(EventObject eventObject) {
        return false;
    }

    protected void enableFileDrop(Component component) {
        new DropTarget(component, this).setActive(true);
    }

    protected boolean fileDropped(Component component, File file) {
        return false;
    }

    protected void fireDataChanged() {
        this.settingsFrm.fireDataChanged();
    }

    public void lookAndFeelChanged() {
    }

    protected File selectFile(String string, String string2, File file, FileFilter ... fileFilterArray) {
        File file2;
        File file3 = null;
        Window window = EmuUtil.getWindow(this);
        if (window != null && (file2 = EmuUtil.showFileOpenDlg(window, string, file != null ? file : Main.getLastDirFile(string2), fileFilterArray)) != null) {
            String string3 = null;
            if (file2.exists()) {
                if (file2.canRead()) {
                    file3 = file2;
                    Main.setLastFile(file2, string2);
                } else {
                    string3 = "Datei nicht lesbar";
                }
            } else {
                string3 = "Datei nicht gefunden";
            }
            if (string3 != null) {
                BaseDlg.showErrorDlg((Component)this, string3);
            }
        }
        return file3;
    }

    public void updFields(Properties properties) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.doActionInternal(actionEvent);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isEnabled() || !EmuUtil.isFileDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        File file;
        DropTargetContext dropTargetContext;
        boolean bl = false;
        if (this.isEnabled() && (dropTargetContext = dropTargetDropEvent.getDropTargetContext()) != null && (file = EmuUtil.fileDrop(this, dropTargetDropEvent)) != null) {
            bl = this.fileDropped(dropTargetContext.getComponent(), file);
        }
        if (bl) {
            dropTargetDropEvent.dropComplete(true);
        } else {
            dropTargetDropEvent.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isEnabled() || !EmuUtil.isFileDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent != null && keyEvent.getKeyCode() == 10 && this.doActionInternal(keyEvent)) {
            keyEvent.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    private boolean doActionInternal(EventObject eventObject) {
        boolean bl = false;
        this.settingsFrm.setWaitCursor(true);
        try {
            bl = this.doAction(eventObject);
        }
        catch (Exception exception) {
            EmuUtil.exitSysError(this, null, exception);
        }
        this.settingsFrm.setWaitCursor(false);
        return bl;
    }
}

