/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Properties;
import jkcemu.base.AbstractScreenFrm;
import jkcemu.base.CharRaster;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;

public abstract class AbstractScreenDevice {
    protected static final int BLACK = 0;
    protected static final int WHITE = 1;
    protected Color colorWhite;
    protected Color colorRedLight;
    protected Color colorRedDark;
    protected Color colorGreenLight;
    protected Color colorGreenDark;
    private static final int[] base7SegHXPoints = new int[]{0, 3, 31, 34, 31, 3, 0};
    private static final int[] base7SegHYPoints = new int[]{3, 0, 0, 3, 6, 6, 3};
    private static final int[] base7SegVXPoints = new int[]{3, 0, 4, 7, 10, 6, 3};
    private static final int[] base7SegVYPoints = new int[]{5, 2, -27, -30, -27, 2, 5};
    private static int[] tmp7SegXPoints = new int[base7SegHXPoints.length];
    private static int[] tmp7SegYPoints = new int[base7SegHYPoints.length];
    private volatile AbstractScreenFrm screenFrm;

    protected AbstractScreenDevice(Properties properties) {
        this.createColors(properties);
    }

    public void applySettings(Properties properties) {
        this.createColors(properties);
    }

    public void cancelPastingText() {
    }

    public boolean canExtractScreenText() {
        return false;
    }

    public int getBorderColorIndex() {
        return 0;
    }

    public int getBorderColorIndexByLine(int n) {
        return this.getBorderColorIndex();
    }

    protected static float getBrightness(Properties properties) {
        int n = EmuUtil.getIntProperty(properties, "jkcemu.brightness", 80);
        float f = 1.0f;
        f = n > 0 && n < 100 ? 1.0f - (float)Math.abs(Math.log10((double)(n + 10) / 110.0)) : (float)n / 100.0f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public Color getColor(int n) {
        return n == 1 ? this.colorWhite : Color.black;
    }

    public int getColorCount() {
        return 2;
    }

    public int getColorIndex(int n, int n2) {
        return 0;
    }

    public CharRaster getCurScreenCharRaster() {
        return null;
    }

    public abstract EmuThread getEmuThread();

    public static int getMaxRGBValue(Properties properties) {
        int n = 204;
        float f = AbstractScreenDevice.getBrightness(properties);
        if (f >= 0.0f && f <= 1.0f) {
            n = Math.round(255.0f * f);
        }
        return n;
    }

    protected int getScreenChar(CharRaster charRaster, int n, int n2) {
        return -1;
    }

    public AbstractScreenFrm getScreenFrm() {
        return this.screenFrm;
    }

    public abstract int getScreenHeight();

    public abstract int getScreenWidth();

    public String getScreenText() {
        CharRaster charRaster = this.getCurScreenCharRaster();
        return charRaster != null ? this.getScreenText(charRaster, 0, 0, charRaster.getColCount() - 1, charRaster.getRowCount() - 1) : null;
    }

    public String getScreenText(CharRaster charRaster, int n, int n2, int n3, int n4) {
        String string = null;
        if (n >= 0 && n2 >= 0) {
            int n5 = charRaster.getColCount();
            int n6 = charRaster.getRowCount();
            if (n5 > 0 && n6 > 0) {
                if (n4 >= n6) {
                    n4 = n6 - 1;
                }
                StringBuilder stringBuilder = new StringBuilder(n6 * (n5 + 1));
                int n7 = 0;
                while (n2 < n4 || n2 == n4 && n <= n3) {
                    int n8 = this.getScreenChar(charRaster, n, n2);
                    if (n8 == 0 || n8 == 32) {
                        if (n2 < n4) {
                            ++n7;
                        } else {
                            stringBuilder.append(' ');
                        }
                    } else {
                        while (n7 > 0) {
                            stringBuilder.append(' ');
                            --n7;
                        }
                        stringBuilder.append((char)(n8 > 0 ? n8 : 95));
                    }
                    if (++n < n5) continue;
                    stringBuilder.append('\n');
                    n7 = 0;
                    n = 0;
                    ++n2;
                }
                if (stringBuilder.length() > 0) {
                    string = stringBuilder.toString();
                }
            }
        }
        return string;
    }

    public abstract String getTitle();

    protected static void paint7SegDigit(Graphics graphics, int n, int n2, int n3, Color color, Color color2, int n4) {
        AbstractScreenDevice.paint7SegH(graphics, n + 14 * n4, n2 + 0 * n4, n4, (n3 & 1) != 0 ? color2 : color);
        AbstractScreenDevice.paint7SegV(graphics, n + 44 * n4, n2 + 35 * n4, n4, (n3 & 2) != 0 ? color2 : color);
        AbstractScreenDevice.paint7SegV(graphics, n + 40 * n4, n2 + 75 * n4, n4, (n3 & 4) != 0 ? color2 : color);
        AbstractScreenDevice.paint7SegH(graphics, n + 6 * n4, n2 + 80 * n4, n4, (n3 & 8) != 0 ? color2 : color);
        AbstractScreenDevice.paint7SegV(graphics, n + 0 * n4, n2 + 75 * n4, n4, (n3 & 0x10) != 0 ? color2 : color);
        AbstractScreenDevice.paint7SegV(graphics, n + 4 * n4, n2 + 35 * n4, n4, (n3 & 0x20) != 0 ? color2 : color);
        AbstractScreenDevice.paint7SegH(graphics, n + 10 * n4, n2 + 40 * n4, n4, (n3 & 0x40) != 0 ? color2 : color);
        graphics.setColor((n3 & 0x80) != 0 ? color2 : color);
        graphics.fillArc(n + 47 * n4, n2 + 80 * n4, 5 * n4, 5 * n4, 0, 360);
    }

    public boolean paintScreen(Graphics graphics, int n, int n2, int n3) {
        return false;
    }

    public void setScreenDirty(boolean bl) {
        AbstractScreenFrm abstractScreenFrm = this.screenFrm;
        if (abstractScreenFrm != null) {
            abstractScreenFrm.setScreenDirty(bl);
        }
    }

    public void setScreenFrm(AbstractScreenFrm abstractScreenFrm) {
        this.screenFrm = abstractScreenFrm;
    }

    public boolean shouldAskConvertScreenChar() {
        return false;
    }

    public void startPastingText(String string) {
    }

    public boolean supportsBorderColorByLine() {
        return false;
    }

    public boolean supportsCopyToClipboard() {
        return false;
    }

    public boolean supportsPasteFromClipboard() {
        return false;
    }

    private void createColors(Properties properties) {
        int n = AbstractScreenDevice.getMaxRGBValue(properties);
        this.colorWhite = new Color(n, n, n);
        this.colorRedLight = new Color(n, 0, 0);
        this.colorRedDark = new Color(n / 5, 0, 0);
        this.colorGreenLight = new Color(0, n, 0);
        this.colorGreenDark = new Color(0, n / 8, 0);
    }

    private static void paint7SegH(Graphics graphics, int n, int n2, int n3, Color color) {
        AbstractScreenDevice.paint7Seg(graphics, n, n2, n3, base7SegHXPoints, base7SegHYPoints, color);
    }

    private static void paint7SegV(Graphics graphics, int n, int n2, int n3, Color color) {
        AbstractScreenDevice.paint7Seg(graphics, n, n2, n3, base7SegVXPoints, base7SegVYPoints, color);
    }

    private static void paint7Seg(Graphics graphics, int n, int n2, int n3, int[] nArray, int[] nArray2, Color color) {
        if (color != null) {
            for (int i = 0; i < tmp7SegXPoints.length; ++i) {
                AbstractScreenDevice.tmp7SegXPoints[i] = n + nArray[i] * n3;
                AbstractScreenDevice.tmp7SegYPoints[i] = n2 + nArray2[i] * n3;
            }
            graphics.setColor(color);
            graphics.fillPolygon(tmp7SegXPoints, tmp7SegYPoints, tmp7SegXPoints.length);
        }
    }
}

