/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.audio;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class VolumeBar
extends JPanel {
    private static final int VOLUME_BAR_MAX = 1000;
    private Timer timer;
    private JProgressBar progressBar;
    private int minLimit = 0;
    private int maxLimit;
    private int minValue = this.maxLimit = 255;
    private int maxValue = this.minLimit;

    public VolumeBar(int n) {
        this.timer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VolumeBar.this.updVolumeBar();
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(5, 5, 5, 5), 0, 0);
        if (n == 0) {
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
        }
        this.progressBar = new JProgressBar(n, 0, 1000);
        this.add((Component)this.progressBar, gridBagConstraints);
    }

    public synchronized void setVolumeLimits(int n, int n2) {
        if (n < n2) {
            this.minLimit = n;
            this.maxLimit = n2;
            this.maxValue = n2;
            this.minValue = n;
            this.progressBar.setValue(0);
        }
    }

    public void setVolumeBarState(boolean bl) {
        if (bl) {
            this.timer.start();
        } else {
            this.progressBar.setValue(0);
            this.timer.stop();
        }
        this.progressBar.setEnabled(bl);
    }

    public synchronized void updVolume(int n) {
        if (n < this.minValue) {
            this.minValue = n;
        }
        if (n > this.maxValue) {
            this.maxValue = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updVolumeBar() {
        int n = 0;
        int n2 = 0;
        VolumeBar volumeBar = this;
        synchronized (volumeBar) {
            n2 = this.maxValue - this.minValue;
            this.minValue = this.maxLimit;
            this.maxValue = this.minLimit;
        }
        double d = (double)n2 / (double)(this.maxLimit - this.minLimit) * 100.0;
        if (d > 0.0) {
            n = (int)Math.round(Math.log(1.0 + d) * 1000.0 / 4.6);
            if (n < 0) {
                n = 0;
            } else if (n > 1000) {
                n = 1000;
            }
        }
        this.progressBar.setValue(n);
    }
}

