/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.audio;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jkcemu.Main;
import jkcemu.audio.AbstractAudioIOComponent;
import jkcemu.audio.AudioFile;
import jkcemu.audio.AudioFrm;
import jkcemu.audio.AudioIn;
import jkcemu.audio.AudioInFile;
import jkcemu.audio.AudioInLine;
import jkcemu.audio.VolumeBar;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileNameFld;

public class TapeInComponent
extends AbstractAudioIOComponent
implements ChangeListener,
DropTargetListener {
    private boolean wasEnabled = false;
    private boolean maxSpeedTriggered = false;
    private JRadioButton btnFromLine;
    private JRadioButton btnFromFile;
    private JRadioButton btnFromLastFile;
    private JRadioButton btnChannel0;
    private JRadioButton btnChannel1;
    private JCheckBox btnMonitor;
    private JLabel labelChannel;
    private JLabel labelFile;
    private JLabel labelProgress;
    private FileNameFld fldFile;
    private JTextField fldProgressPos;
    private JSlider progressSlider;
    private JButton btnFilePlay;
    private JButton btnFilePause;
    private JButton btnMaxSpeed;

    public TapeInComponent(AudioFrm audioFrm, EmuThread emuThread) {
        super(audioFrm, emuThread);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Funktion"));
        this.add((Component)jPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btnFromLine = new JRadioButton("Audiodaten vom Sound-System lesen (z.B. Mikrofon- oder Line-In-Anschluss)", true);
        buttonGroup.add(this.btnFromLine);
        jPanel.add((Component)this.btnFromLine, gridBagConstraints2);
        this.btnFromFile = new JRadioButton("Audiodaten aus Sound- oder Tape-Datei lesen");
        buttonGroup.add(this.btnFromFile);
        gridBagConstraints2.insets.top = 0;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.btnFromFile, gridBagConstraints2);
        this.btnFromLastFile = new JRadioButton("Letzte Sound- oder Tape-Datei noch einmal lesen");
        buttonGroup.add(this.btnFromLastFile);
        gridBagConstraints2.insets.bottom = 5;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.btnFromLastFile, gridBagConstraints2);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder("Optionen"));
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel2, gridBagConstraints);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.labelMixer = new JLabel("Ger\u00e4t:");
        jPanel2.add((Component)this.labelMixer, gridBagConstraints3);
        this.labelFrameRate = new JLabel("Abtastrate (Hz):");
        ++gridBagConstraints3.gridy;
        jPanel2.add((Component)this.labelFrameRate, gridBagConstraints3);
        this.labelChannel = new JLabel("Aktiver Kanal:");
        gridBagConstraints3.insets.bottom = 5;
        ++gridBagConstraints3.gridy;
        jPanel2.add((Component)this.labelChannel, gridBagConstraints3);
        this.comboMixer = this.audioFrm.createMixerComboBox();
        gridBagConstraints3.insets.top = 5;
        gridBagConstraints3.insets.bottom = 0;
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.gridy = 0;
        ++gridBagConstraints3.gridx;
        jPanel2.add((Component)this.comboMixer, gridBagConstraints3);
        this.comboFrameRate = this.audioFrm.createFrameRateComboBox();
        this.comboFrameRate.setEditable(false);
        ++gridBagConstraints3.gridy;
        jPanel2.add((Component)this.comboFrameRate, gridBagConstraints3);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.btnChannel0 = new JRadioButton("Links", true);
        buttonGroup2.add(this.btnChannel0);
        gridBagConstraints3.insets.bottom = 5;
        gridBagConstraints3.gridwidth = 1;
        ++gridBagConstraints3.gridy;
        jPanel2.add((Component)this.btnChannel0, gridBagConstraints3);
        this.btnChannel1 = new JRadioButton("Rechts");
        buttonGroup2.add(this.btnChannel1);
        ++gridBagConstraints3.gridx;
        jPanel2.add((Component)this.btnChannel1, gridBagConstraints3);
        this.btnMonitor = new JCheckBox("Mith\u00f6ren");
        gridBagConstraints3.anchor = 13;
        ++gridBagConstraints3.gridx;
        jPanel2.add((Component)this.btnMonitor, gridBagConstraints3);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder("Status"));
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel3, gridBagConstraints);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.labelFile = new JLabel("Datei:");
        jPanel3.add((Component)this.labelFile, gridBagConstraints4);
        this.labelFormat = new JLabel("Format:");
        ++gridBagConstraints4.gridy;
        jPanel3.add((Component)this.labelFormat, gridBagConstraints4);
        this.labelProgress = new JLabel("Fortschritt:");
        gridBagConstraints4.insets.bottom = 5;
        ++gridBagConstraints4.gridy;
        jPanel3.add((Component)this.labelProgress, gridBagConstraints4);
        this.fldFile = new FileNameFld();
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.insets.bottom = 0;
        gridBagConstraints4.gridwidth = 0;
        gridBagConstraints4.gridy = 0;
        ++gridBagConstraints4.gridx;
        jPanel3.add((Component)this.fldFile, gridBagConstraints4);
        this.fldFormat = new JTextField();
        this.fldFormat.setEditable(false);
        ++gridBagConstraints4.gridy;
        jPanel3.add((Component)this.fldFormat, gridBagConstraints4);
        this.fldProgressPos = new JTextField(7);
        this.fldProgressPos.setEditable(false);
        gridBagConstraints4.fill = 0;
        gridBagConstraints4.weightx = 0.0;
        gridBagConstraints4.insets.bottom = 5;
        gridBagConstraints4.gridwidth = 1;
        ++gridBagConstraints4.gridy;
        jPanel3.add((Component)this.fldProgressPos, gridBagConstraints4);
        this.progressSlider = new JSlider(0, 0, 1000, 0);
        this.progressSlider.setPaintLabels(false);
        this.progressSlider.setPaintTicks(false);
        this.progressSlider.setPaintTrack(true);
        this.progressSlider.setSnapToTicks(false);
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        ++gridBagConstraints4.gridx;
        jPanel3.add((Component)this.progressSlider, gridBagConstraints4);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        ++gridBagConstraints.gridx;
        this.add((Component)jPanel4, gridBagConstraints);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 0, 0, 0), 0, 0);
        JPanel jPanel5 = new JPanel(new GridLayout(5, 1, 5, 5));
        jPanel4.add((Component)jPanel5, gridBagConstraints5);
        this.btnEnable = new JButton("Aktivieren");
        jPanel5.add(this.btnEnable);
        this.btnDisable = new JButton("Deaktivieren");
        jPanel5.add(this.btnDisable);
        this.btnFilePlay = new JButton("Abspielen");
        jPanel5.add(this.btnFilePlay);
        this.btnFilePause = new JButton("Pause");
        jPanel5.add(this.btnFilePause);
        this.btnMaxSpeed = new JButton("Turbo");
        jPanel5.add(this.btnMaxSpeed);
        this.volumeBar = new VolumeBar(1);
        this.volumeBar.setBorder(BorderFactory.createTitledBorder("Pegel"));
        this.volumeBar.setPreferredSize(new Dimension(1, 1));
        gridBagConstraints5.insets.top = 20;
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.weighty = 1.0;
        ++gridBagConstraints5.gridy;
        jPanel4.add((Component)this.volumeBar, gridBagConstraints5);
        this.progressSlider.addChangeListener(this);
        this.btnEnable.addActionListener(this);
        this.btnDisable.addActionListener(this);
        this.btnFilePlay.addActionListener(this);
        this.btnFilePause.addActionListener(this);
        this.btnMaxSpeed.addActionListener(this);
        this.btnFromLine.addActionListener(this);
        this.btnFromFile.addActionListener(this);
        this.btnFromLastFile.addActionListener(this);
        this.btnChannel0.addActionListener(this);
        this.btnChannel1.addActionListener(this);
        this.btnMonitor.addActionListener(this);
        new DropTarget(this.fldFile, this).setActive(true);
        this.updFieldsEnabled();
    }

    public void openFile(File file, byte[] byArray, int n) {
        int n2;
        EmuSys emuSys;
        if (file != null && (emuSys = this.emuThread.getEmuSys()) != null && this.emuThread.getTapeIn() == null && emuSys.supportsTapeIn() && (n2 = this.audioFrm.getAndCheckSpeed()) > 0) {
            this.btnFromFile.setSelected(true);
            try {
                this.enableFile(n2, file, byArray, n);
            }
            catch (IOException iOException) {
                BaseDlg.showErrorDlg((Component)this, iOException);
            }
        }
    }

    public void resetFired() {
        if (this.emuThread.getTapeIn() != null) {
            this.willReset();
        }
        if (this.wasEnabled && this.emuThread.getTapeIn() == null) {
            File file;
            if (this.btnFromLine.isSelected()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            TapeInComponent.this.enableLine();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        TapeInComponent.this.updFieldsEnabled();
                    }
                });
            } else if ((this.btnFromFile.isSelected() || this.btnFromLastFile.isSelected()) && (file = this.fldFile.getFile()) != null) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            TapeInComponent.this.enableFile(file, null, 0);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        TapeInComponent.this.updFieldsEnabled();
                    }
                });
            }
        }
        this.updFieldsEnabled();
    }

    public void willReset() {
        boolean bl = this.wasEnabled = this.emuThread.getTapeIn() != null;
        if (this.wasEnabled) {
            this.doDisable();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        long l;
        AudioInFile audioInFile;
        AudioIn audioIn;
        if (changeEvent.getSource() == this.progressSlider && (audioIn = this.emuThread.getTapeIn()) != null && audioIn instanceof AudioInFile && (audioInFile = (AudioInFile)audioIn).supportsSetFramePos() && (l = audioInFile.getFrameCount()) > 0L) {
            int n = this.progressSlider.getMinimum();
            int n2 = this.progressSlider.getMaximum() - n;
            if (n2 > 0) {
                int n3 = this.progressSlider.getValue();
                try {
                    audioInFile.setFramePos(Math.round((double)(n3 - n) / (double)n2 * (double)l));
                    this.updProgressPos(audioInFile);
                }
                catch (IOException iOException) {
                    this.updProgressSlider(audioInFile);
                    BaseDlg.showErrorDlg((Component)this, "\u00c4ndern der Abspielposition bei\n dieser Datei nicht m\u00f6glich");
                }
            }
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (this.emuThread.getTapeIn() != null || !EmuUtil.isFileDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        File file;
        boolean bl = false;
        if (EmuUtil.isFileDrop(dropTargetDropEvent) && (file = EmuUtil.fileDrop(this, dropTargetDropEvent)) != null && file.isFile()) {
            this.openFile(file, null, 0);
            bl = true;
        }
        if (bl) {
            dropTargetDropEvent.dropComplete(true);
        } else {
            dropTargetDropEvent.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (this.emuThread.getTapeIn() != null || !EmuUtil.isFileDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public boolean doAction(ActionEvent actionEvent) {
        boolean bl = true;
        Object object = actionEvent.getSource();
        if (object == this.btnChannel0 || object == this.btnChannel1) {
            this.updChannel();
        } else if (object == this.btnMonitor) {
            if (this.btnMonitor.isSelected()) {
                this.setMaxSpeed(false);
            }
            this.updMonitorEnabled();
        } else if (object == this.btnFilePlay) {
            this.doPlay();
        } else if (object == this.btnFilePause) {
            this.doPause();
        } else if (object == this.btnMaxSpeed) {
            this.doMaxSpeed();
        } else {
            bl = super.doAction(actionEvent);
        }
        return bl;
    }

    @Override
    protected void doDisable() {
        AudioIn audioIn = this.emuThread.getTapeIn();
        this.emuThread.setTapeIn(null);
        if (this.maxSpeedTriggered) {
            this.setMaxSpeed(false);
        }
        if (audioIn != null) {
            audioIn.stopAudio();
            this.updFieldsEnabled();
        }
    }

    @Override
    protected void doEnable() {
        try {
            File file;
            if (this.btnFromLine.isSelected()) {
                this.enableLine();
            } else if (this.btnFromFile.isSelected()) {
                File file2 = EmuUtil.showFileOpenDlg(this.audioFrm, "Sound- oder Tape-Datei \u00f6ffnen", Main.getLastDirFile("audio"), AudioFile.getFileFilter(), EmuUtil.getTapeFileFilter());
                if (file2 != null) {
                    Main.setLastFile(file2, "audio");
                    this.enableFile(file2, null, 0);
                }
            } else if (this.btnFromLastFile.isSelected() && (file = this.fldFile.getFile()) != null) {
                this.enableFile(file, null, 0);
            }
        }
        catch (IOException iOException) {
            BaseDlg.showErrorDlg((Component)this, iOException);
        }
    }

    @Override
    public void fireProgressUpdate(final AudioInFile audioInFile) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TapeInComponent.this.updProgressSlider(audioInFile);
            }
        });
    }

    @Override
    protected void updFieldsEnabled() {
        AudioIn audioIn;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        Object var8_8 = null;
        File file = this.fldFile.getFile();
        EmuSys emuSys = this.emuThread.getEmuSys();
        if (emuSys != null) {
            bl = emuSys.supportsTapeIn();
        }
        if ((audioIn = this.emuThread.getTapeIn()) != null) {
            bl2 = true;
            bl4 = audioIn instanceof AudioInLine;
            bl3 = audioIn instanceof AudioInFile;
            bl5 = audioIn.isPause();
            bl6 = audioIn.isProgressUpdateEnabled();
            bl7 = audioIn.getChannels() > 1;
        } else {
            bl4 = this.btnFromLine.isSelected();
            bl3 = this.btnFromFile.isSelected() || this.btnFromLastFile.isSelected();
        }
        this.btnEnable.setEnabled(bl && !bl2);
        this.btnDisable.setEnabled(bl2);
        this.btnFilePlay.setEnabled(bl2 && bl3 && bl5);
        this.btnFilePause.setEnabled(bl2 && bl3 && !bl5);
        this.btnMaxSpeed.setEnabled(bl2 && bl3 && !bl5);
        this.btnFromLine.setEnabled(bl && !bl2);
        this.btnFromFile.setEnabled(bl && !bl2);
        this.btnFromLastFile.setEnabled(bl && !bl2 && file != null);
        if (this.btnFromLastFile.isSelected() && file == null) {
            this.btnFromFile.setSelected(true);
        }
        this.labelMixer.setEnabled(bl && !bl2 && bl4);
        this.comboMixer.setEnabled(bl && !bl2 && bl4);
        this.labelFrameRate.setEnabled(bl && !bl2 && bl4);
        this.comboFrameRate.setEnabled(bl && !bl2 && bl4);
        this.labelChannel.setEnabled(bl && (!bl2 || bl7));
        this.btnChannel0.setEnabled(bl && (!bl2 || bl7));
        this.btnChannel1.setEnabled(bl && (!bl2 || bl7));
        this.btnMonitor.setEnabled(bl);
        this.labelFile.setEnabled(bl2 && bl3);
        this.fldFile.setEnabled(bl2 && bl3);
        this.labelFormat.setEnabled(bl2);
        this.fldFormat.setEnabled(bl2);
        if (!bl6) {
            this.progressSlider.setValue(this.progressSlider.getMinimum());
            this.updProgressPos(null);
        }
        this.labelProgress.setEnabled(bl6);
        this.fldProgressPos.setEnabled(bl6);
        this.progressSlider.setEnabled(bl6);
        this.volumeBar.setVolumeBarState(bl2);
    }

    private void doMaxSpeed() {
        if (this.emuThread.getTapeIn() != null && this.emuThread.getZ80CPU().isBrakeEnabled()) {
            this.maxSpeedTriggered = true;
            this.setMaxSpeed(true);
        }
    }

    private void doPlay() {
        AudioIn audioIn = this.emuThread.getTapeIn();
        if (audioIn != null && audioIn instanceof AudioInFile) {
            ((AudioInFile)audioIn).setPause(false);
            this.btnFilePlay.setEnabled(false);
            this.btnFilePause.setEnabled(true);
            this.btnMaxSpeed.setEnabled(true);
        }
    }

    private void doPause() {
        AudioIn audioIn = this.emuThread.getTapeIn();
        if (audioIn != null && audioIn instanceof AudioInFile) {
            if (this.maxSpeedTriggered) {
                this.setMaxSpeed(false);
            }
            ((AudioInFile)audioIn).setPause(true);
            this.btnFilePlay.setEnabled(true);
            this.btnFilePause.setEnabled(false);
            this.btnMaxSpeed.setEnabled(false);
        }
    }

    private void enableFile(File file, byte[] byArray, int n) throws IOException {
        int n2;
        EmuSys emuSys = this.emuThread.getEmuSys();
        if (emuSys != null && this.emuThread.getTapeIn() == null && emuSys.supportsTapeIn() && (n2 = this.audioFrm.getAndCheckSpeed()) > 0) {
            this.enableFile(n2, file, byArray, n);
        }
    }

    private void enableFile(int n, File file, byte[] byArray, int n2) throws IOException {
        AudioInFile audioInFile = new AudioInFile(this, this.emuThread.getZ80CPU(), n, file, byArray, n2);
        this.fldFormat.setText(audioInFile.getFormatText());
        this.fldFile.setFile(file);
        this.emuThread.setTapeIn(audioInFile);
        this.updChannel();
        this.updFieldsEnabled();
        this.updMonitorEnabled();
    }

    private void enableLine() throws IOException {
        int n;
        EmuSys emuSys = this.emuThread.getEmuSys();
        if (emuSys != null && this.emuThread.getTapeIn() == null && emuSys.supportsTapeIn() && (n = this.audioFrm.getAndCheckSpeed()) > 0) {
            AudioInLine audioInLine = new AudioInLine(this, this.emuThread.getZ80CPU(), n, this.audioFrm.getSelectedFrameRate(this.comboFrameRate), this.audioFrm.getSelectedMixer(this.comboMixer));
            this.fldFormat.setText(audioInLine.getFormatText());
            this.emuThread.setTapeIn(audioInLine);
            this.updChannel();
            this.updFieldsEnabled();
        }
    }

    private void setMaxSpeed(boolean bl) {
        if (bl) {
            AudioIn audioIn = this.emuThread.getTapeIn();
            if (audioIn != null && audioIn instanceof AudioInFile) {
                boolean bl2 = this.btnMonitor.isSelected();
                if (bl2) {
                    this.btnMonitor.setSelected(false);
                    this.updMonitorEnabled();
                }
                if (this.audioFrm.getScreenFrm().setMaxSpeed(this, true)) {
                    this.btnMonitor.setEnabled(false);
                    this.btnMaxSpeed.setEnabled(false);
                } else if (bl2) {
                    this.btnMonitor.setSelected(true);
                    this.updMonitorEnabled();
                }
            }
        } else {
            this.audioFrm.getScreenFrm().setMaxSpeed(this, false);
            this.maxSpeedTriggered = false;
        }
    }

    private void updChannel() {
        AudioIn audioIn = this.emuThread.getTapeIn();
        if (audioIn != null) {
            int n = 0;
            if (this.btnChannel1.isSelected()) {
                n = 1;
            }
            if (n >= audioIn.getChannels()) {
                n = 0;
                this.btnChannel0.setSelected(true);
            }
            audioIn.setSelectedChannel(n);
        }
    }

    private void updMonitorEnabled() {
        boolean bl = false;
        boolean bl2 = this.btnMonitor.isSelected();
        AudioIn audioIn = this.emuThread.getTapeIn();
        if (audioIn != null) {
            boolean bl3 = false;
            bl = audioIn.isMonitorActive();
            if (bl != bl2) {
                if (bl2) {
                    audioIn.openMonitorLine();
                    bl = audioIn.isMonitorActive();
                    if (!bl) {
                        bl3 = true;
                    }
                } else {
                    audioIn.closeMonitorLine();
                }
            } else {
                bl = audioIn.isMonitorActive();
            }
            if (!bl && bl != bl2) {
                this.btnMonitor.setSelected(false);
            }
            if (bl3) {
                BaseDlg.showErrorDlg((Component)this, "Das Mith\u00f6ren ist nicht m\u00f6glich,\nda das \u00d6ffnen eines Audiokanals mit dem Format\nder Tape- bzw. Sound-Datei fehlgeschlagen ist.");
            }
        }
    }

    private void updProgressPos(AudioInFile audioInFile) {
        int n;
        int n2 = 0;
        if (audioInFile != null && (n = audioInFile.getFrameRate()) > 0 && (n2 = (int)(audioInFile.getFramePos() / (long)n)) < 0) {
            n2 = 0;
        }
        this.fldProgressPos.setText(String.format("%d:%02d:%02d", n2 / 3600, n2 / 60 % 60, n2 % 60));
    }

    private void updProgressSlider(AudioInFile audioInFile) {
        long l;
        int n = this.progressSlider.getMinimum();
        int n2 = this.progressSlider.getMaximum();
        int n3 = n;
        int n4 = n2 - n;
        if (n4 > 0 && audioInFile != null && (l = audioInFile.getFrameCount()) > 0L) {
            n3 = n + Math.round((float)audioInFile.getFramePos() / (float)l * (float)n4);
            if (n3 < n) {
                n3 = n;
            } else if (n3 > n2) {
                n3 = n2;
            }
        }
        this.progressSlider.removeChangeListener(this);
        this.progressSlider.setValue(n3);
        this.progressSlider.addChangeListener(this);
        this.updProgressPos(audioInFile);
    }
}

