/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.audio;

import java.io.IOException;
import java.io.RandomAccessFile;
import jkcemu.audio.AbstractPCMDataReader;

public class PCMDataFile
extends AbstractPCMDataReader {
    private RandomAccessFile raf;
    private boolean eof;
    private byte[] buf;
    private int bufLen;
    private int bufPos;
    private long bufOffs;

    public PCMDataFile(int n, int n2, int n3, boolean bl, boolean bl2, RandomAccessFile randomAccessFile, long l, long l2) throws IOException {
        super(n, n2, n3, bl, bl2, l, l2);
        this.raf = randomAccessFile;
        this.eof = false;
        this.buf = new byte[32768];
        this.bufLen = 0;
        this.bufPos = 0;
        this.bufOffs = l;
        this.raf.seek(l);
        long l3 = randomAccessFile.length();
        if (l3 < l + l2) {
            l2 = l3 - l;
        }
        this.frameCount = l2 / (long)this.bytesPerFrame;
        if (this.frameCount < 1L) {
            PCMDataFile.throwNoAudioData();
        }
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (!this.eof) {
            while (n2 > 0) {
                if (this.bufPos >= this.bufLen) {
                    this.bufLen = this.raf.read(this.buf);
                    this.bufPos = 0;
                    this.bufOffs += (long)this.bufLen;
                }
                if (this.bufPos >= this.bufLen) {
                    this.eof = true;
                    break;
                }
                byArray[n++] = this.buf[this.bufPos++];
                ++n3;
                --n2;
            }
        }
        return n3;
    }

    @Override
    public synchronized void setFramePos(long l) throws IOException {
        long l2 = this.pcmDataOffs + l * (long)this.bytesPerFrame;
        if (this.bufLen > 0 && l2 >= this.bufOffs && l2 < this.bufOffs + (long)this.bufLen) {
            this.bufPos = (int)(l2 - this.bufOffs);
        } else {
            this.bufOffs = l2;
            this.bufLen = 0;
            this.bufPos = 0;
        }
        this.eof = false;
    }

    @Override
    public boolean supportsSetFramePos() {
        return true;
    }
}

