/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.audio;

import java.io.IOException;
import java.io.InputStream;
import jkcemu.audio.PCMDataSource;

public class PCMConverterInputStream
extends InputStream {
    private static final int SIGNED_VALUE_1 = 100;
    private static final int SIGNED_VALUE_0 = -100;
    private PCMDataSource source;
    private boolean toSigned;
    private boolean toBigEndian;
    private byte[] inBuf;
    private int outBuf;
    private int bytesInOutBuf;
    private int valueOffs;

    public PCMConverterInputStream(PCMDataSource pCMDataSource, boolean bl, boolean bl2) {
        this.source = pCMDataSource;
        this.toSigned = bl;
        this.toBigEndian = bl2;
        this.inBuf = new byte[(pCMDataSource.getSampleSizeInBits() + 7) / 8];
        this.outBuf = 0;
        this.bytesInOutBuf = 0;
        this.valueOffs = 0;
        if (bl != pCMDataSource.isSigned()) {
            switch (this.inBuf.length) {
                case 1: {
                    this.valueOffs = 128;
                    break;
                }
                case 2: {
                    this.valueOffs = 32768;
                    break;
                }
                case 3: {
                    this.valueOffs = 0x800000;
                    break;
                }
                case 4: {
                    this.valueOffs = Integer.MIN_VALUE;
                }
            }
            if (bl) {
                this.valueOffs = -this.valueOffs;
            }
        }
    }

    public int getSampleSizeInBits() {
        return Math.max(8, this.source.getSampleSizeInBits());
    }

    public boolean isBigEndian() {
        return this.toBigEndian;
    }

    public boolean isSigned() {
        return this.toSigned;
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    @Override
    public synchronized int read() throws IOException {
        int n = -1;
        if (this.bytesInOutBuf <= 0 && this.source.read(this.inBuf, 0, this.inBuf.length) == this.inBuf.length) {
            int n2 = 0;
            if (this.source.getSampleSizeInBits() == 1) {
                n2 = this.inBuf[0] == 0 ? (this.toSigned ? -100 : 0) : (this.toSigned ? 100 : 200);
            } else {
                if (this.source.isBigEndian()) {
                    for (int i = 0; i < this.inBuf.length; ++i) {
                        n2 <<= 8;
                        n2 |= this.inBuf[i] & 0xFF;
                    }
                } else {
                    for (int i = this.inBuf.length - 1; i >= 0; --i) {
                        n2 <<= 8;
                        n2 |= this.inBuf[i] & 0xFF;
                    }
                }
                this.outBuf += this.valueOffs;
                if (this.toBigEndian) {
                    switch (this.inBuf.length) {
                        case 2: {
                            n2 = n2 << 8 & 0xFF00 | n2 >> 8 & 0xFF;
                            break;
                        }
                        case 3: {
                            n2 = n2 << 16 & 0xFF0000 | n2 & 0xFF00 | n2 >> 16 & 0xFF;
                            break;
                        }
                        case 4: {
                            n2 = n2 << 24 & 0xFF000000 | n2 << 8 & 0xFF0000 | n2 >> 8 & 0xFF00 | n2 >> 24 & 0xFF;
                        }
                    }
                }
            }
            this.outBuf = n2;
            this.bytesInOutBuf = this.inBuf.length;
        }
        if (this.bytesInOutBuf > 0) {
            n = this.outBuf & 0xFF;
            this.outBuf >>= 8;
            --this.bytesInOutBuf;
        }
        return n;
    }
}

