/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.audio;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import jkcemu.audio.AudioUtil;
import jkcemu.audio.BitSampleBuffer;
import jkcemu.audio.PCMDataSource;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileInfo;

public class CSWFile {
    private static final String[] fileExts = new String[]{"csw", "csw1"};
    private static FileFilter fileFilter = null;

    public static String[] getFileExtensions() {
        return fileExts;
    }

    public static String getFileExtensionText() {
        return "*.csw; *.csw1";
    }

    public static FileFilter getFileFilter() {
        if (fileFilter == null) {
            fileFilter = new FileNameExtensionFilter("CSW-Dateien (" + CSWFile.getFileExtensionText() + ")", fileExts);
        }
        return fileFilter;
    }

    public static BitSampleBuffer getBitSampleBuffer(byte[] byArray, int n) throws IOException {
        CSWFormat cSWFormat = CSWFile.parseHeader(byArray, n);
        BitSampleBuffer bitSampleBuffer = new BitSampleBuffer((int)cSWFormat.sampleRate, 32768);
        int n2 = cSWFormat.headerLen;
        int n3 = byArray.length - cSWFormat.headerLen;
        boolean bl = cSWFormat.initialPhase;
        while (n2 < byArray.length && n3 > 0) {
            int n4 = byArray[n2++] & 0xFF;
            --n3;
            if (n4 > 0) {
                bitSampleBuffer.addSamples(n4, bl);
                bl = !bl;
                continue;
            }
            if (n2 + 3 >= byArray.length && n3 > 3) break;
            long l = EmuUtil.getInt4LE(byArray, n2);
            if (l > Integer.MAX_VALUE) {
                EmuUtil.throwMysteriousData();
            }
            bitSampleBuffer.addSamples((int)l, bl);
            bl = !bl;
            n2 += 4;
            n3 -= 4;
        }
        return bitSampleBuffer;
    }

    public static PCMDataSource getPCMDataSource(byte[] byArray, int n) throws IOException {
        return CSWFile.getBitSampleBuffer(byArray, n).newReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(PCMDataSource pCMDataSource, File file) throws IOException {
        boolean bl;
        String string = file.getName();
        if (string == null) {
            string = "";
        }
        if (!(bl = (string = string.toLowerCase()).endsWith(".csw1")) && !string.endsWith(".csw")) {
            throw new IOException("Dateiformat nicht unterst\u00fctzt!\n\nUnterst\u00fctzte Dateiendungen sind *.csw und *.csw1");
        }
        int n = pCMDataSource.getFrameRate();
        if (bl && n > 65535) {
            throw new IOException("Die Abtastrate ist f\u00fcr eine CSW1-Datei zu gro\u00df.\nSpeichern Sie bitte die Datei mit der Endung *.csw,\ndamit sie im CSW2-Format erzeugt wird.");
        }
        if (pCMDataSource.getSampleSizeInBits() > 1 || pCMDataSource.getChannels() > 1) {
            throw new IOException("In einer CSW-Datei k\u00f6nnen nur 1-Bit-Mono-Audiodaten gespeichert werden.");
        }
        byte[] byArray = new byte[1];
        if (pCMDataSource.read(byArray, 0, 1) != byArray.length) {
            AudioUtil.throwNoAudioData();
        }
        boolean bl2 = byArray[0] != 0;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int n2;
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            EmuUtil.writeASCII(bufferedOutputStream, "Compressed Square Wave\u001a");
            if (bl) {
                ((OutputStream)bufferedOutputStream).write(1);
                ((OutputStream)bufferedOutputStream).write(1);
                ((OutputStream)bufferedOutputStream).write(n & 0xFF);
                ((OutputStream)bufferedOutputStream).write(n >> 8 & 0xFF);
                ((OutputStream)bufferedOutputStream).write(1);
                ((OutputStream)bufferedOutputStream).write(bl2 ? 1 : 0);
                for (n2 = 0; n2 < 3; ++n2) {
                    ((OutputStream)bufferedOutputStream).write(0);
                }
            } else {
                ((OutputStream)bufferedOutputStream).write(2);
                ((OutputStream)bufferedOutputStream).write(0);
                CSWFile.writeInt4(bufferedOutputStream, n);
                CSWFile.writeInt4(bufferedOutputStream, pCMDataSource.getFrameCount());
                ((OutputStream)bufferedOutputStream).write(1);
                ((OutputStream)bufferedOutputStream).write(bl2 ? 1 : 0);
                ((OutputStream)bufferedOutputStream).write(0);
                EmuUtil.writeFixLengthASCII(bufferedOutputStream, "JKCEMU", 16, 0);
            }
            n2 = 0;
            while (pCMDataSource.read(byArray, 0, 1) == byArray.length) {
                boolean bl3;
                boolean bl4 = bl3 = byArray[0] != 0;
                if (bl3 == bl2) {
                    ++n2;
                    continue;
                }
                CSWFile.writeSampleCount(bufferedOutputStream, n2);
                n2 = 1;
                bl2 = bl3;
            }
            CSWFile.writeSampleCount(bufferedOutputStream, n2);
            ((OutputStream)bufferedOutputStream).close();
            bufferedOutputStream = null;
        }
        catch (Throwable throwable) {
            EmuUtil.closeSilent(bufferedOutputStream);
            throw throwable;
        }
        EmuUtil.closeSilent(bufferedOutputStream);
    }

    private static CSWFormat parseHeader(byte[] byArray, int n) throws IOException {
        Object var2_2 = null;
        if (!FileInfo.isCswMagicAt(byArray, n)) {
            EmuUtil.throwUnsupportedFileFormat();
        }
        long l = 0L;
        long l2 = 0L;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if ((byArray[n + 23] & 0xFF) < 2) {
            l = EmuUtil.getWord(byArray, n + 25);
            n2 = byArray[n + 27] & 0xFF;
            n3 = byArray[n + 28] & 0xFF;
            n4 = 32;
        } else {
            l = EmuUtil.getInt4LE(byArray, n + 25);
            l2 = EmuUtil.getInt4LE(byArray, n + 29);
            n2 = byArray[n + 33] & 0xFF;
            n3 = byArray[n + 34] & 0xFF;
            n4 = 52 + (byArray[n + 35] & 0xFF);
        }
        if (l < 1L || l > 192000L) {
            throw new IOException("Ung\u00fcltige Abtastrate");
        }
        if (n2 != 1) {
            StringBuilder stringBuilder = new StringBuilder(256);
            stringBuilder.append("CSW-Kompressionsmethode ");
            if (n2 == 2) {
                stringBuilder.append("Z-RLE");
            } else {
                stringBuilder.append(n2);
            }
            stringBuilder.append(" nicht unterst\u00fctzt");
            throw new IOException(stringBuilder.toString());
        }
        return new CSWFormat(l, l2, (n3 & 1) != 0, n4);
    }

    private static void writeInt4(OutputStream outputStream, long l) throws IOException {
        outputStream.write((int)(l & 0xFFL));
        outputStream.write((int)(l >> 8 & 0xFFL));
        outputStream.write((int)(l >> 16 & 0xFFL));
        outputStream.write((int)(l >> 24));
    }

    private static void writeSampleCount(OutputStream outputStream, int n) throws IOException {
        if (n > 0) {
            if ((n & 0xFF) == n) {
                outputStream.write(n);
            } else {
                outputStream.write(0);
                CSWFile.writeInt4(outputStream, n);
            }
        }
    }

    private CSWFile() {
    }

    private static class CSWFormat {
        private long sampleRate;
        private long pulses;
        private boolean initialPhase;
        private int headerLen;

        private CSWFormat(long l, long l2, boolean bl, int n) {
            this.sampleRate = l;
            this.pulses = l2;
            this.initialPhase = bl;
            this.headerLen = n;
        }
    }
}

