/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.audio;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.EventObject;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.Timer;
import jkcemu.Main;
import jkcemu.audio.AbstractAudioFrm;
import jkcemu.audio.AudioFile;
import jkcemu.audio.AudioPlayer;
import jkcemu.audio.PCMDataSource;
import jkcemu.audio.PCMDataStream;
import jkcemu.audio.VolumeBar;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;
import jkcemu.base.HelpFrm;
import jkcemu.base.MyByteArrayOutputStream;

public class AudioRecorderFrm
extends AbstractAudioFrm
implements Runnable {
    private static final String TEXT_START = "Start";
    private static final String TEXT_STOP = "Stop";
    private static final String DEFAULT_STATUS_TEXT = "Bereit";
    private static final String HELP_PAGE = "/help/tools/audiorecorder.htm";
    private static AudioRecorderFrm instance = null;
    private AudioFormat audioFmt = null;
    private Thread audioThread = null;
    private Mixer mixer = null;
    private VolumeBar volumeBar;
    private MyByteArrayOutputStream dataBuf = null;
    private boolean dataSaved = true;
    private boolean suppressAskDataSaved = false;
    private volatile boolean recording = false;
    private volatile boolean recEnabled = false;
    private volatile long begMillis = -1L;
    private int frameRate = 0;
    private int sampleSizeInBits = 0;
    private int channels = 0;
    private volatile int dataLen = 0;
    private Timer timerDuration;
    private JLabel labelDuration;
    private JLabel labelDurationValue;
    private JLabel labelMixer;
    private JLabel labelFrameRate;
    private JLabel labelSampleSize;
    private JLabel labelVolume;
    private JComboBox<String> comboMixer;
    private JComboBox<Object> comboFrameRate;
    private JRadioButton btn8Bit;
    private JRadioButton btn16Bit;
    private JRadioButton btnMono;
    private JRadioButton btnStereo;
    private JButton btnStartStop;
    private JButton btnPlay;
    private JButton btnSave;
    private JButton btnHelp;
    private JButton btnClose;

    public static AudioRecorderFrm open() {
        if (instance != null) {
            if (instance.getExtendedState() == 1) {
                instance.setExtendedState(0);
            }
        } else {
            instance = new AudioRecorderFrm();
        }
        instance.toFront();
        instance.setVisible(true);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        Object object;
        Exception exception = null;
        TargetDataLine targetDataLine = null;
        if (this.frameRate > 0 && this.sampleSizeInBits > 0 && this.channels > 0 && this.dataBuf != null) {
            block23: {
                object = null;
                try {
                    Object object2;
                    int n;
                    int n2;
                    AudioFormat audioFormat = null;
                    boolean bl = false;
                    boolean bl2 = false;
                    for (n2 = 0; targetDataLine == null && n2 < 2; ++n2) {
                        for (n = 0; targetDataLine == null && n < 2; ++n) {
                            try {
                                bl = n == 1;
                                audioFormat = new AudioFormat(this.frameRate, this.sampleSizeInBits, this.channels, bl, n2 == 1);
                                object2 = new DataLine.Info(TargetDataLine.class, audioFormat);
                                if (this.mixer != null) {
                                    if (this.mixer.isLineSupported((Line.Info)object2)) {
                                        targetDataLine = (TargetDataLine)this.mixer.getLine((Line.Info)object2);
                                    }
                                } else if (AudioSystem.isLineSupported((Line.Info)object2)) {
                                    targetDataLine = (TargetDataLine)AudioSystem.getLine((Line.Info)object2);
                                }
                                if (targetDataLine == null) continue;
                                targetDataLine.open(audioFormat);
                                targetDataLine.flush();
                                targetDataLine.start();
                                this.recording = true;
                                continue;
                            }
                            catch (Exception exception2) {
                                this.close(targetDataLine);
                                targetDataLine = null;
                                audioFormat = null;
                                if (!(exception2 instanceof LineUnavailableException)) continue;
                                bl2 = true;
                            }
                        }
                    }
                    if (audioFormat != null && targetDataLine != null && (n2 = audioFormat.getFrameSize()) > 0) {
                        this.dataSaved = false;
                        this.dataLen = 0;
                        this.dataBuf.reset();
                        object = new GZIPOutputStream(this.dataBuf);
                        if (bl) {
                            this.volumeBar.setVolumeLimits(-128, 127);
                        } else {
                            this.volumeBar.setVolumeLimits(0, 255);
                        }
                        n = this.frameRate / 10;
                        if (n < 1) {
                            n = 1;
                        }
                        object2 = new byte[n2 * n];
                        int n3 = 0;
                        if (n2 > 1 && !audioFormat.isBigEndian()) {
                            n3 = n2 - 1;
                        }
                        this.audioFmt = audioFormat;
                        this.begMillis = System.currentTimeMillis();
                        while (this.recEnabled && targetDataLine.read((byte[])object2, 0, ((Object)object2).length) == ((Object)object2).length) {
                            ((FilterOutputStream)object).write((byte[])object2);
                            this.dataLen += ((Object)object2).length;
                            for (int i = n3; i < ((Object)object2).length; i += n2) {
                                if (bl) {
                                    this.volumeBar.updVolume((int)object2[i]);
                                    continue;
                                }
                                this.volumeBar.updVolume((int)(object2[i] & 0xFF));
                            }
                        }
                        ((GZIPOutputStream)object).finish();
                        ((DeflaterOutputStream)object).close();
                    }
                    if (this.dataLen != 0 || !bl2) break block23;
                    exception = new IOException("Der Audiokanal kann nicht ge\u00f6ffnet werden,\nda er bereits durch eine andere Anwendung benutzt wird.");
                }
                catch (Exception exception3) {
                    exception = exception3;
                    EmuUtil.closeSilent((Closeable)object);
                    this.close(targetDataLine);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    object = null;
                    this.dataLen = 0;
                    this.dataBuf.resetAndFreeMem();
                    System.gc();
                    exception = new IOException("Kein Speicher mehr f\u00fcr die Aufzeichnung\nder Audiodaten verf\u00fcgbar.");
                    {
                        catch (Throwable throwable) {
                            EmuUtil.closeSilent(object);
                            this.close(targetDataLine);
                            throw throwable;
                        }
                    }
                    EmuUtil.closeSilent((Closeable)object);
                    this.close(targetDataLine);
                }
            }
            EmuUtil.closeSilent((Closeable)object);
            this.close(targetDataLine);
        }
        object = this.recEnabled ? exception : null;
        EventQueue.invokeLater(new Runnable((Exception)object){
            final /* synthetic */ Exception val$retEx;
            {
                this.val$retEx = exception;
            }

            @Override
            public void run() {
                AudioRecorderFrm.this.recFinished(this.val$retEx);
            }
        });
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object == this.btnStartStop) {
            bl = true;
            this.doStartStop();
        } else if (object == this.btnPlay) {
            bl = true;
            this.doPlay();
        } else if (object == this.btnSave) {
            bl = true;
            this.doSave();
        } else if (object == this.btnHelp) {
            bl = true;
            HelpFrm.open(HELP_PAGE);
        } else if (object == this.btnClose) {
            bl = true;
            this.doClose();
        }
        return bl;
    }

    @Override
    public boolean doClose() {
        boolean bl = false;
        if (this.recEnabled) {
            this.doStartStop();
        }
        if (this.confirmDataSaved() && (bl = super.doClose())) {
            this.dataLen = 0;
            this.dataSaved = true;
            this.updDuration();
            Main.checkQuit(this);
        }
        return bl;
    }

    private AudioRecorderFrm() {
        this.setTitle("JKCEMU Audiorecorder");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.labelMixer = new JLabel("Ger\u00e4t:");
        this.add((Component)this.labelMixer, gridBagConstraints);
        this.labelFrameRate = new JLabel("Abtastrate (Hz):");
        ++gridBagConstraints.gridy;
        this.add((Component)this.labelFrameRate, gridBagConstraints);
        this.labelSampleSize = new JLabel("Aufl\u00f6sung:");
        ++gridBagConstraints.gridy;
        this.add((Component)this.labelSampleSize, gridBagConstraints);
        this.labelVolume = new JLabel("Pegel:");
        gridBagConstraints.gridy += 2;
        this.add((Component)this.labelVolume, gridBagConstraints);
        this.labelDuration = new JLabel("Aufgenommene Zeit:");
        this.labelDuration.setEnabled(false);
        gridBagConstraints.insets.bottom = 5;
        ++gridBagConstraints.gridy;
        this.add((Component)this.labelDuration, gridBagConstraints);
        this.comboMixer = this.createMixerComboBox();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.bottom = 0;
        ++gridBagConstraints.gridx;
        this.add(this.comboMixer, gridBagConstraints);
        this.comboFrameRate = this.createFrameRateComboBox();
        ++gridBagConstraints.gridy;
        this.add(this.comboFrameRate, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btn8Bit = new JRadioButton("8 Bit", false);
        this.btn8Bit.setAlignmentX(0.0f);
        buttonGroup.add(this.btn8Bit);
        jPanel.add(this.btn8Bit);
        jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.btn16Bit = new JRadioButton("16 Bit", true);
        this.btn16Bit.setAlignmentX(0.0f);
        buttonGroup.add(this.btn16Bit);
        jPanel.add(this.btn16Bit);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel2, gridBagConstraints);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.btnMono = new JRadioButton("Mono", false);
        this.btnMono.setAlignmentX(0.0f);
        buttonGroup2.add(this.btnMono);
        jPanel2.add(this.btnMono);
        jPanel2.add(Box.createRigidArea(new Dimension(10, 0)));
        this.btnStereo = new JRadioButton("Stereo", true);
        this.btnStereo.setAlignmentX(0.0f);
        buttonGroup2.add(this.btnStereo);
        jPanel2.add(this.btnStereo);
        this.volumeBar = new VolumeBar(0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.volumeBar, gridBagConstraints);
        this.labelDurationValue = new JLabel();
        this.labelDurationValue.setEnabled(false);
        gridBagConstraints.insets.bottom = 5;
        ++gridBagConstraints.gridy;
        this.add((Component)this.labelDurationValue, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridLayout(5, 1, 5, 5));
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.gridy = 0;
        ++gridBagConstraints.gridx;
        this.add((Component)jPanel3, gridBagConstraints);
        this.btnStartStop = new JButton(TEXT_START);
        jPanel3.add(this.btnStartStop);
        this.btnPlay = new JButton("Wiedergeben...");
        this.btnPlay.setEnabled(false);
        jPanel3.add(this.btnPlay);
        this.btnSave = new JButton("Speichern...");
        this.btnSave.setEnabled(false);
        jPanel3.add(this.btnSave);
        this.btnHelp = new JButton("Hilfe");
        jPanel3.add(this.btnHelp);
        this.btnClose = new JButton("Schlie\u00dfen");
        jPanel3.add(this.btnClose);
        this.pack();
        if (!this.applySettings(Main.getProperties(), false)) {
            this.setScreenCentered();
        }
        this.setResizable(false);
        this.updFieldsEnabled();
        this.btnStartStop.addActionListener(this);
        this.btnPlay.addActionListener(this);
        this.btnSave.addActionListener(this);
        this.btnHelp.addActionListener(this);
        this.btnClose.addActionListener(this);
        this.timerDuration = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AudioRecorderFrm.this.updDuration();
            }
        });
    }

    private void doStartStop() {
        if (this.recEnabled) {
            this.recEnabled = false;
            this.btnStartStop.setText(TEXT_START);
        } else if (this.audioThread == null) {
            if (this.confirmDataSaved()) {
                this.mixer = this.getSelectedMixer(this.comboMixer);
                this.frameRate = this.getSelectedFrameRate(this.comboFrameRate);
                if (this.frameRate <= 0) {
                    this.frameRate = 44100;
                }
                this.sampleSizeInBits = this.btn8Bit.isSelected() ? 8 : 16;
                int n = this.channels = this.btnMono.isSelected() ? 1 : 2;
                if (this.dataBuf != null) {
                    this.dataBuf.reset();
                } else {
                    this.dataBuf = new MyByteArrayOutputStream(0x100000);
                }
                this.dataLen = 0;
                this.dataSaved = false;
                this.btnPlay.setEnabled(false);
                this.btnSave.setEnabled(false);
                this.recEnabled = true;
                this.audioThread = new Thread(Main.getThreadGroup(), this, "JKCEMU sound recorder");
                this.audioThread.start();
                this.labelDuration.setEnabled(true);
                this.labelDurationValue.setEnabled(true);
                this.begMillis = -1L;
                this.updDuration();
                this.updFieldsEnabled();
                this.volumeBar.setVolumeBarState(true);
                this.timerDuration.start();
                this.btnStartStop.setText(TEXT_STOP);
            }
        } else {
            this.btnStartStop.setText(TEXT_STOP);
        }
    }

    private void doPlay() {
        if (this.audioFmt != null && this.dataBuf != null && this.dataLen > 0) {
            try {
                AudioPlayer.play(this, this.createPCMDataSource(), "Wiedergabe der Aufnahme...");
            }
            catch (Exception exception) {
                BaseDlg.showErrorDlg((Component)this, exception);
            }
        }
    }

    private void doSave() {
        File file;
        if (this.audioFmt != null && this.dataBuf != null && this.dataLen > 0 && (file = EmuUtil.showFileSaveDlg(this, "Sound-Datei speichern", Main.getLastDirFile("audio"), AudioFile.getFileFilter())) != null) {
            try {
                AudioFile.write(this.createPCMDataSource(), file);
                Main.setLastFile(file, "audio");
                this.dataSaved = true;
            }
            catch (Exception exception) {
                BaseDlg.showErrorDlg((Component)this, exception);
            }
        }
    }

    private void close(DataLine dataLine) {
        if (dataLine != null) {
            this.recording = false;
            dataLine.stop();
            dataLine.flush();
            dataLine.close();
        }
    }

    private boolean confirmDataSaved() {
        boolean bl = false;
        if (!this.suppressAskDataSaved && this.audioFmt != null && this.dataBuf != null && this.dataLen > 0 && !this.dataSaved) {
            Object[] objectArray = new String[]{"Speichern", "Verwerfen", "Abbrechen"};
            String string = "Was soll mit der noch nicht gespeicherten Aufnahme geschehen?";
            JCheckBox jCheckBox = new JCheckBox("Diesen Dialog zuk\u00fcnftig nicht mehr anzeigen");
            JOptionPane jOptionPane = new JOptionPane(new Object[]{string, jCheckBox}, 2);
            jOptionPane.setWantsInput(false);
            jOptionPane.setOptions(objectArray);
            jOptionPane.setInitialValue(objectArray[0]);
            this.setState(0);
            this.toFront();
            jOptionPane.createDialog(this, "Aufnahme nicht gespeichert").setVisible(true);
            Object object = jOptionPane.getValue();
            if (object != null) {
                if (object.equals(objectArray[0])) {
                    this.doSave();
                    bl = this.dataSaved;
                    this.suppressAskDataSaved = jCheckBox.isSelected();
                } else if (object.equals(objectArray[1])) {
                    this.suppressAskDataSaved = jCheckBox.isSelected();
                    this.dataSaved = true;
                    bl = true;
                }
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private PCMDataSource createPCMDataSource() throws IOException {
        return new PCMDataStream(Math.round(this.audioFmt.getSampleRate()), this.audioFmt.getSampleSizeInBits(), this.audioFmt.getChannels(), this.audioFmt.getEncoding() == AudioFormat.Encoding.PCM_SIGNED, this.audioFmt.isBigEndian(), new GZIPInputStream(this.dataBuf.newInputStream()), (long)this.dataLen);
    }

    private void setFrameRateState(boolean bl) {
        this.labelFrameRate.setEnabled(bl);
        this.comboFrameRate.setEnabled(bl);
    }

    private void setMixerState(boolean bl) {
        this.labelMixer.setEnabled(bl);
        this.comboMixer.setEnabled(bl);
    }

    private void recFinished(Exception exception) {
        this.volumeBar.setVolumeBarState(false);
        this.timerDuration.stop();
        this.recEnabled = false;
        this.audioThread = null;
        this.updDuration();
        this.updFieldsEnabled();
        boolean bl = false;
        if (this.dataLen > 0) {
            this.dataSaved = false;
            if (this.audioFmt != null && this.dataBuf != null) {
                bl = true;
            }
            if (exception != null) {
                BaseDlg.showErrorDlg((Component)this, exception);
            }
        } else {
            this.showError(exception != null ? exception.getMessage() : null);
        }
        this.labelDuration.setEnabled(bl);
        this.labelDurationValue.setEnabled(bl);
        this.btnStartStop.setText(TEXT_START);
        this.btnPlay.setEnabled(bl);
        this.btnSave.setEnabled(bl);
    }

    private void showError(String string) {
        if (string == null) {
            string = this.frameRate > 0 ? "Es konnte kein Audiokanal mit den angegebenen Optionen ge\u00f6ffnet werden." : "Es konnte kein Audiokanal ge\u00f6ffnet werden.";
        }
        BaseDlg.showErrorDlg((Component)this, string);
    }

    private void updDuration() {
        int n = -1;
        if (this.dataBuf != null) {
            if (this.recording && this.begMillis > 0L) {
                n = (int)((System.currentTimeMillis() - this.begMillis) / 1000L);
            } else if (this.audioFmt != null) {
                int n2 = (this.audioFmt.getSampleSizeInBits() + 7) / 8;
                n = this.dataLen / Math.round(this.audioFmt.getSampleRate()) / this.audioFmt.getChannels() / n2;
            }
        }
        String string = "";
        if (n >= 0) {
            int n3 = n / 60;
            string = n3 > 0 ? String.format("%d:%02d Minuten", n3, n) : (n == 1 ? "1 Sekunde" : String.format("%d Sekunden", n %= 60));
            this.labelDurationValue.setText(string);
            if (n3 >= 120) {
                this.recEnabled = false;
            }
        }
    }

    private void updFieldsEnabled() {
        boolean bl = this.audioThread == null;
        this.setMixerState(bl);
        this.setFrameRateState(bl);
        this.labelSampleSize.setEnabled(bl);
        this.btn8Bit.setEnabled(bl);
        this.btn16Bit.setEnabled(bl);
        this.btnMono.setEnabled(bl);
        this.btnStereo.setEnabled(bl);
        bl = !bl;
        this.labelVolume.setEnabled(bl);
        this.volumeBar.setEnabled(bl);
    }
}

