/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.audio;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import jkcemu.audio.AudioIOObserver;
import jkcemu.audio.AudioIn;
import jkcemu.audio.DataLineCloser;
import z80emu.Z80CPU;

public class AudioInLine
extends AudioIn {
    private static int[] frameRates = new int[]{44100, 48000, 32000, 22050};
    private volatile TargetDataLine dataLine = null;
    private byte[] frameBuf = null;
    private byte[] audioDataBuf = null;
    private int audioDataLen = 0;
    private int audioDataPos = 0;
    private int maxPauseTStates = 0;

    public AudioInLine(AudioIOObserver audioIOObserver, Z80CPU z80CPU, int n, int n2, Mixer mixer) throws IOException {
        super(audioIOObserver, z80CPU);
        TargetDataLine targetDataLine = null;
        if (n2 > 0) {
            targetDataLine = this.openTargetDataLine(mixer, n2);
        } else {
            int n3 = 0;
            while (targetDataLine == null) {
                if (n3 >= frameRates.length) break;
                targetDataLine = this.openTargetDataLine(mixer, frameRates[n3]);
                ++n3;
            }
        }
        if (targetDataLine == null) {
            throw new IOException("Der Audiokanal konnte nicht ge\u00f6ffnet werden.");
        }
        AudioFormat audioFormat = targetDataLine.getFormat();
        this.dataLine = targetDataLine;
        this.maxPauseTStates = n * 1000;
        this.tStatesPerFrame = (int)((float)n * 1000.0f / audioFormat.getSampleRate());
        this.setFormat(Math.round(audioFormat.getSampleRate()), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.isBigEndian(), audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED));
        this.frameBuf = new byte[audioFormat.getFrameSize()];
        int n4 = Math.round(audioFormat.getFrameRate());
        int n5 = this.dataLine.getBufferSize() / 32;
        if (n5 > n4 / 2) {
            n5 = n4 / 2;
        }
        if (n5 < 1) {
            n5 = 1;
        }
        this.audioDataBuf = new byte[n5 * this.frameBuf.length];
        this.audioDataPos = this.audioDataLen = 0;
    }

    @Override
    protected boolean currentDiffTStates(long l) {
        boolean bl = false;
        if (l > (long)this.maxPauseTStates) {
            this.minValue = 0;
            this.maxValue = 0;
        } else {
            this.z80cpu.setSpeedUnlimitedFor(l * 8L);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean isLineOpen() {
        return super.isLineOpen() || this.dataLine != null;
    }

    @Override
    protected byte[] readFrame() {
        int n = -1;
        TargetDataLine targetDataLine = this.dataLine;
        byte[] byArray = this.audioDataBuf;
        byte[] byArray2 = this.frameBuf;
        if (targetDataLine != null && byArray != null && byArray2 != null) {
            if (this.audioDataPos >= this.audioDataLen) {
                this.audioDataLen = targetDataLine.read(this.audioDataBuf, 0, this.audioDataBuf.length);
                this.audioDataPos = 0;
            }
            if (this.audioDataPos + byArray2.length <= this.audioDataLen) {
                System.arraycopy(byArray, this.audioDataPos, byArray2, 0, byArray2.length);
                this.audioDataPos += byArray2.length;
            }
        }
        return byArray2;
    }

    @Override
    public void stopAudio() {
        this.frameBuf = null;
        this.audioDataBuf = null;
        this.audioDataPos = 0;
        TargetDataLine targetDataLine = this.dataLine;
        this.dataLine = null;
        DataLineCloser.closeDataLine(targetDataLine);
    }

    private TargetDataLine openTargetDataLine(Mixer mixer, int n) throws IOException {
        TargetDataLine targetDataLine = this.openTargetDataLine(mixer, n, 2);
        if (targetDataLine == null) {
            targetDataLine = this.openTargetDataLine(mixer, n, 1);
        }
        return targetDataLine;
    }

    private TargetDataLine openTargetDataLine(Mixer mixer, int n, int n2) throws IOException {
        TargetDataLine targetDataLine = this.openTargetDataLine(mixer, n, n2, false);
        if (targetDataLine == null) {
            targetDataLine = this.openTargetDataLine(mixer, n, n2, true);
        }
        return targetDataLine;
    }

    private TargetDataLine openTargetDataLine(Mixer mixer, int n, int n2, boolean bl) throws IOException {
        TargetDataLine targetDataLine;
        block7: {
            AudioFormat audioFormat = new AudioFormat(n, 8, n2, true, bl);
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, audioFormat);
            targetDataLine = null;
            try {
                if (mixer != null) {
                    if (mixer.isLineSupported(info)) {
                        targetDataLine = (TargetDataLine)mixer.getLine(info);
                    }
                } else if (AudioSystem.isLineSupported(info)) {
                    targetDataLine = (TargetDataLine)AudioSystem.getLine(info);
                }
                if (targetDataLine != null) {
                    targetDataLine.open(audioFormat);
                    targetDataLine.flush();
                    targetDataLine.start();
                }
            }
            catch (Exception exception) {
                DataLineCloser.closeDataLine(targetDataLine);
                targetDataLine = null;
                if (!(exception instanceof LineUnavailableException)) break block7;
                throw new IOException("Der Audiokanal kann nicht ge\u00f6ffnet werden,\nda er bereits durch eine andere Anwendung benutzt wird.");
            }
        }
        return targetDataLine;
    }
}

