/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.audio;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import jkcemu.audio.AudioFile;
import jkcemu.audio.AudioIOObserver;
import jkcemu.audio.AudioIn;
import jkcemu.audio.CSWFile;
import jkcemu.audio.PCMDataSource;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileInfo;
import jkcemu.emusys.kc85.KCAudioCreator;
import jkcemu.emusys.zxspectrum.ZXSpectrumAudioCreator;
import z80emu.Z80CPU;

public class AudioInFile
extends AudioIn {
    private File file;
    private int offs;
    private boolean progressEnabled;
    private PCMDataSource pcmIn;
    private byte[] frameBuf;
    private long frameCnt;
    private long framePos;
    private int progressStepSize;
    private int progressStepCnt;
    private int speedKHz;
    private int eofNoiseFrames;
    private Random eofNoiseRandom;
    private volatile boolean pause;

    public AudioInFile(AudioIOObserver audioIOObserver, Z80CPU z80CPU, int n, File file, byte[] byArray, int n2) throws IOException {
        super(audioIOObserver, z80CPU);
        this.file = file;
        this.offs = n2;
        this.progressEnabled = false;
        this.pcmIn = null;
        this.frameBuf = null;
        this.frameCnt = 0L;
        this.framePos = 0L;
        this.progressStepSize = 0;
        this.progressStepCnt = 0;
        this.speedKHz = n;
        this.eofNoiseFrames = 0;
        this.eofNoiseRandom = null;
        this.pause = true;
        String string = null;
        try {
            String string2;
            boolean bl = false;
            if (byArray == null && file != null && file.isFile() && (string2 = file.getName()) != null) {
                bl = (string2 = string2.toLowerCase()).endsWith(".tap") || string2.endsWith(".tap.gz");
                byArray = EmuUtil.readFile(file, true, 0x1000000);
            }
            if (byArray != null) {
                if (FileInfo.isCswMagicAt(byArray, this.offs)) {
                    this.pcmIn = CSWFile.getPCMDataSource(byArray, 0);
                    this.frameCnt = this.pcmIn.getFrameCount();
                    this.framePos = 0L;
                    if (this.offs > 0) {
                        this.pcmIn = CSWFile.getPCMDataSource(byArray, this.offs);
                        this.framePos = this.frameCnt - this.pcmIn.getFrameCount();
                    }
                    string = "CSW-Datei";
                } else if (FileInfo.isKCTapMagicAt(byArray, this.offs)) {
                    this.pcmIn = new KCAudioCreator(true, 0, byArray, 0, byArray.length).newReader();
                    this.frameCnt = this.pcmIn.getFrameCount();
                    this.framePos = 0L;
                    if (this.offs > 0) {
                        this.pcmIn = new KCAudioCreator(true, 0, byArray, this.offs, byArray.length - this.offs).newReader();
                        this.framePos = this.frameCnt - this.pcmIn.getFrameCount();
                    }
                    string = "KC-TAP-Datei";
                } else {
                    boolean bl2 = FileInfo.isTzxMagicAt(byArray, this.offs);
                    if (bl || bl2) {
                        this.pcmIn = new ZXSpectrumAudioCreator(byArray, 0, byArray.length).newReader();
                        this.frameCnt = this.pcmIn.getFrameCount();
                        this.framePos = 0L;
                        if (this.offs > 0) {
                            this.pcmIn = new ZXSpectrumAudioCreator(byArray, this.offs, byArray.length - this.offs).newReader();
                            this.framePos = this.frameCnt - this.pcmIn.getFrameCount();
                        }
                        string = bl2 ? "CDT/TZX-Datei" : "ZX-TAP-Datei";
                    }
                }
            }
            if (this.pcmIn == null) {
                this.pcmIn = AudioFile.open(file, byArray);
                this.frameCnt = this.pcmIn.getFrameCount();
                this.framePos = 0L;
            }
            if (this.pcmIn == null) {
                throw new IOException();
            }
            if (this.frameCnt <= 0L) {
                throw new IOException("Die Datei enth\u00e4lt keine Daten");
            }
            this.setFormat(this.pcmIn.getFrameRate(), this.pcmIn.getSampleSizeInBits(), this.pcmIn.getChannels(), this.pcmIn.isSigned(), this.pcmIn.isBigEndian());
            if (string != null) {
                this.formatText = this.formatText != null ? string + ": " + this.formatText : string;
            }
            if (this.framePos < 0L) {
                this.framePos = 0L;
            }
            this.progressStepCnt = this.progressStepSize = (int)this.frameCnt / 200;
            this.progressEnabled = true;
            this.firstCall = true;
            this.observer.fireProgressUpdate(this);
            int n3 = (this.pcmIn.getSampleSizeInBits() + 7) / 8;
            this.frameBuf = new byte[n3 * this.pcmIn.getChannels()];
            this.tStatesPerFrame = (int)((float)n * 1000.0f / (float)this.pcmIn.getFrameRate());
        }
        catch (IOException iOException) {
            this.closeStreams();
            String string3 = iOException.getMessage();
            if (string3 != null && string3.isEmpty()) {
                string3 = null;
            }
            if (string3 != null) {
                throw iOException;
            }
            throw new IOException("Die Datei kann nicht ge\u00f6ffnet werden.");
        }
    }

    public File getFile() {
        return this.file;
    }

    public long getFrameCount() {
        return this.frameCnt;
    }

    public long getFramePos() {
        return this.framePos;
    }

    public int getSpeedKHz() {
        return this.speedKHz;
    }

    public void setFramePos(long l) throws IOException {
        PCMDataSource pCMDataSource = this.pcmIn;
        if (pCMDataSource != null) {
            if (l < 0L) {
                l = 0L;
            } else if (l > this.frameCnt) {
                l = this.frameCnt;
            }
            pCMDataSource.setFramePos(l);
            this.framePos = l;
        }
    }

    public void setPause(boolean bl) {
        this.pause = bl;
    }

    public boolean supportsSetFramePos() {
        PCMDataSource pCMDataSource = this.pcmIn;
        return pCMDataSource != null ? pCMDataSource.supportsSetFramePos() : false;
    }

    @Override
    public boolean isPause() {
        return this.pause;
    }

    @Override
    public boolean isProgressUpdateEnabled() {
        return this.progressEnabled;
    }

    @Override
    public void stopAudio() {
        this.closeMonitorLine();
        this.closeStreams();
        this.frameBuf = null;
        this.progressEnabled = false;
    }

    @Override
    protected boolean supportsMonitor() {
        return true;
    }

    @Override
    protected byte[] readFrame() {
        byte[] byArray = this.frameBuf;
        if (this.eofNoiseRandom != null && byArray != null) {
            this.eofNoiseRandom.nextBytes(byArray);
            if (this.eofNoiseFrames > 0) {
                --this.eofNoiseFrames;
            } else {
                this.observer.fireFinished(this, null);
            }
        } else {
            PCMDataSource pCMDataSource = this.pcmIn;
            if (pCMDataSource != null && byArray != null) {
                try {
                    if (pCMDataSource.read(byArray, 0, byArray.length) == byArray.length) {
                        if (this.isMonitorActive()) {
                            this.writeMonitorLine(byArray);
                        }
                        ++this.framePos;
                        if (this.progressStepCnt > 0) {
                            --this.progressStepCnt;
                        } else {
                            this.progressStepCnt = this.progressStepSize;
                            this.observer.fireProgressUpdate(this);
                        }
                    } else {
                        this.closeStreams();
                        this.eofNoiseFrames = this.frameRate / 20;
                        this.eofNoiseRandom = new Random(System.currentTimeMillis());
                    }
                }
                catch (IOException iOException) {
                    this.stopAudio();
                    this.observer.fireFinished(this, iOException.getMessage());
                }
            }
        }
        return byArray;
    }

    private void closeStreams() {
        EmuUtil.closeSilent(this.pcmIn);
        this.pcmIn = null;
    }
}

