/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.audio;

import jkcemu.audio.AudioIO;
import jkcemu.audio.AudioIOObserver;
import z80emu.Z80CPU;

public abstract class AudioIn
extends AudioIO {
    protected int minValue = 0;
    protected int maxValue = 0;
    private int adjustPeriodCnt = 0;
    private int adjustPeriodLen = 0;
    private int sampleNegMask = 0;
    private int sampleSignMask = 0;
    private int selectedChannel = 0;

    protected AudioIn(AudioIOObserver audioIOObserver, Z80CPU z80CPU) {
        super(audioIOObserver, z80CPU);
    }

    public boolean isPause() {
        return false;
    }

    public String getSpecialFormatText() {
        return null;
    }

    public boolean isProgressUpdateEnabled() {
        return false;
    }

    protected abstract byte[] readFrame();

    @Override
    protected void setFormat(int n, int n2, int n3, boolean bl, boolean bl2) {
        super.setFormat(n, n2, n3, bl, bl2);
        this.sampleSignMask = 0;
        if (this.dataSigned) {
            switch (this.bytesPerSample) {
                case 1: {
                    this.sampleSignMask = 128;
                    this.sampleNegMask = -256;
                    break;
                }
                case 2: {
                    this.sampleSignMask = 32768;
                    this.sampleNegMask = -65536;
                    break;
                }
                case 3: {
                    this.sampleSignMask = 0x800000;
                    this.sampleNegMask = -16777216;
                    break;
                }
                case 4: {
                    this.sampleSignMask = Integer.MIN_VALUE;
                }
            }
        }
        this.adjustPeriodLen = this.frameRate / 256;
        if (this.adjustPeriodLen < 1) {
            this.adjustPeriodLen = 1;
        }
        this.adjustPeriodCnt = this.adjustPeriodLen;
    }

    public void setSelectedChannel(int n) {
        this.selectedChannel = n;
    }

    public void stopAudio() {
    }

    public boolean readPhase() {
        if (this.tStatesPerFrame > 0) {
            if (this.firstCall) {
                this.firstCall = false;
                this.lastTStates = this.z80cpu.getProcessedTStates();
            } else {
                long l = this.z80cpu.getProcessedTStates();
                long l2 = Z80CPU.calcTStatesDiff(this.lastTStates, l);
                if (l2 > 0L) {
                    if (this.currentDiffTStates(l2)) {
                        int n = (int)(l2 / (long)this.tStatesPerFrame);
                        if (n > 0) {
                            int n2 = 0;
                            int n3 = 0;
                            int n4 = n;
                            while ((n2 = this.readSample()) >= 0) {
                                n3 = n2;
                                if (this.adjustPeriodCnt > 0) {
                                    --this.adjustPeriodCnt;
                                } else {
                                    this.adjustPeriodCnt = this.adjustPeriodLen;
                                    if (this.minValue < this.maxValue) {
                                        ++this.minValue;
                                    }
                                    if (this.maxValue > this.minValue) {
                                        --this.maxValue;
                                    }
                                }
                                if (this.dataSigned && (n3 & this.sampleSignMask) != 0) {
                                    n3 |= ~this.sampleNegMask;
                                }
                                if (n3 < this.minValue) {
                                    this.minValue = n3;
                                } else if (n3 > this.maxValue) {
                                    this.maxValue = n3;
                                }
                                this.observer.updVolume(n3);
                                if (--n4 > 0) continue;
                            }
                            if (n2 >= 0) {
                                int n5 = this.maxValue - this.minValue;
                                if (this.lastPhase) {
                                    if (n3 < this.minValue + n5 / 3) {
                                        this.lastPhase = false;
                                    }
                                } else if (n3 > this.maxValue - n5 / 3) {
                                    this.lastPhase = true;
                                }
                            }
                            this.lastTStates += (long)(n * this.tStatesPerFrame);
                        }
                    } else {
                        this.lastTStates = this.z80cpu.getProcessedTStates();
                    }
                }
            }
        }
        return this.lastPhase;
    }

    private int readSample() {
        int n;
        block4: {
            int n2;
            byte[] byArray;
            n = -1;
            if (this.isPause() || (byArray = this.readFrame()) == null || (n2 = this.selectedChannel * this.bytesPerSample) + this.bytesPerSample > byArray.length) break block4;
            n = 0;
            if (this.bigEndian) {
                for (int i = 0; i < this.bytesPerSample; ++i) {
                    n = n << 8 | byArray[n2 + i] & 0xFF;
                }
            } else {
                for (int i = this.bytesPerSample - 1; i >= 0; --i) {
                    n = n << 8 | byArray[n2 + i] & 0xFF;
                }
            }
        }
        return n;
    }
}

