/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.audio;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.EventObject;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import jkcemu.Main;
import jkcemu.audio.AbstractAudioFrm;
import jkcemu.audio.SoundOutComponent;
import jkcemu.audio.TapeInComponent;
import jkcemu.audio.TapeOutComponent;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuThread;
import jkcemu.base.HelpFrm;
import jkcemu.base.ScreenFrm;

public class AudioFrm
extends AbstractAudioFrm {
    private static final String HELP_PAGE = "/help/audio.htm";
    private static AudioFrm instance = null;
    private ScreenFrm screenFrm;
    private EmuThread emuThread;
    private Mixer.Info[] mixers;
    private int speedKHz;
    private JMenuItem mnuClose;
    private JMenuItem mnuHelpContent;
    private JTabbedPane tabbedPane;
    private TapeInComponent tabTapeIn;
    private TapeOutComponent tabTapeOut;
    private SoundOutComponent tabSoundOut;

    public int getAndCheckSpeed() {
        int n = this.emuThread.getZ80CPU().getMaxSpeedKHz();
        if (n <= 0) {
            BaseDlg.showErrorDlg((Component)this, "Sie m\u00fcssen die Geschwindigkeit des Emulators\nauf einen konkreten Wert begrenzen, da dieser\nals Zeitbasis f\u00fcr das AudioSystem dient.\n");
        }
        return n;
    }

    public ScreenFrm getScreenFrm() {
        return this.screenFrm;
    }

    public static AudioFrm lazyGetInstance() {
        return instance;
    }

    public static AudioFrm open(ScreenFrm screenFrm) {
        if (instance != null) {
            if (instance.getExtendedState() == 1) {
                instance.setExtendedState(0);
            }
        } else {
            instance = new AudioFrm(screenFrm);
        }
        instance.toFront();
        instance.setVisible(true);
        return instance;
    }

    public void openFile(File file, byte[] byArray, int n) {
        this.tabTapeIn.openFile(file, byArray, n);
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object == this.mnuClose) {
            bl = true;
            this.doClose();
        } else if (object == this.mnuHelpContent) {
            bl = true;
            HelpFrm.open(HELP_PAGE);
        }
        return bl;
    }

    @Override
    public void resetFired() {
        this.tabTapeIn.resetFired();
        this.tabTapeOut.resetFired();
        this.tabSoundOut.resetFired();
    }

    @Override
    public void willReset() {
        this.tabTapeIn.willReset();
        this.tabTapeOut.willReset();
        this.tabSoundOut.willReset();
    }

    private AudioFrm(ScreenFrm screenFrm) {
        this.screenFrm = screenFrm;
        this.emuThread = screenFrm.getEmuThread();
        this.mixers = AudioSystem.getMixerInfo();
        this.speedKHz = 0;
        this.setTitle("JKCEMU Audio/Kassette");
        Main.updIcon(this);
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("Datei");
        jMenu.setMnemonic(68);
        jMenuBar.add(jMenu);
        this.mnuClose = this.createJMenuItem("Schlie\u00dfen");
        jMenu.add(this.mnuClose);
        JMenu jMenu2 = new JMenu("?");
        jMenuBar.add(jMenu2);
        this.mnuHelpContent = this.createJMenuItem("Hilfe...");
        jMenu2.add(this.mnuHelpContent);
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane(1);
        this.add((Component)this.tabbedPane, "Center");
        this.tabTapeIn = new TapeInComponent(this, this.emuThread);
        this.tabbedPane.addTab("Eingang Kassette", this.tabTapeIn);
        this.tabTapeOut = new TapeOutComponent(this, this.emuThread);
        this.tabbedPane.addTab("Ausgang Kassette", this.tabTapeOut);
        this.tabSoundOut = new SoundOutComponent(this, this.emuThread);
        this.tabbedPane.addTab("Ausgang Sound-Generator/Lautsprecher", this.tabSoundOut);
        this.pack();
        this.setResizable(false);
        if (!this.applySettings(Main.getProperties(), false)) {
            this.setLocationByPlatform(true);
        }
    }
}

