/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.audio;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import jkcemu.audio.AudioUtil;
import jkcemu.audio.PCMConverterInputStream;
import jkcemu.audio.PCMDataBuffer;
import jkcemu.audio.PCMDataFile;
import jkcemu.audio.PCMDataInfo;
import jkcemu.audio.PCMDataSource;
import jkcemu.audio.PCMDataStream;
import jkcemu.base.EmuUtil;

public class AudioFile {
    private static final int SIGNED_VALUE_1 = 100;
    private static final int SIGNED_VALUE_0 = -100;
    private static final String[] fileExts = new String[]{"aif", "aiff", "aifc", "au", "wav", "aif.gz", "aiff.gz", "aifc.gz", "au.gz", "wav.gz"};
    private static FileFilter fileFilter = null;

    public static String[] getFileExtensions() {
        return fileExts;
    }

    public static String getFileExtensionText() {
        return "*.aif; *.aifc; *.aiff; *.au; *.wav; *.aif.gz; ...";
    }

    public static FileFilter getFileFilter() {
        if (fileFilter == null) {
            fileFilter = new FileNameExtensionFilter("Sound-Dateien (" + AudioFile.getFileExtensionText() + ")", fileExts);
        }
        return fileFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PCMDataInfo getInfo(File file) throws IOException {
        PCMDataInfo pCMDataInfo = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            byte[] byArray = new byte[4096];
            int n = 0;
            bufferedInputStream = EmuUtil.openBufferedOptionalGZipFile(file);
            n = EmuUtil.read(bufferedInputStream, byArray);
            if (n < byArray.length) {
                byArray = Arrays.copyOf(byArray, n);
            }
            if ((pCMDataInfo = AudioFile.processFile(byArray, null, null, null)) == null) {
                EmuUtil.throwUnsupportedFileFormat();
            }
        }
        catch (Throwable throwable) {
            EmuUtil.closeSilent(bufferedInputStream);
            throw throwable;
        }
        EmuUtil.closeSilent(bufferedInputStream);
        return pCMDataInfo;
    }

    public static String[] getSupportedFileExtensions() {
        return fileExts;
    }

    public static PCMDataSource open(File file) throws IOException {
        return AudioFile.open(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PCMDataSource open(File file, byte[] byArray) throws IOException {
        PCMDataInfo pCMDataInfo = null;
        IOException iOException = null;
        BufferedInputStream bufferedInputStream = null;
        RandomAccessFile randomAccessFile = null;
        try {
            byte[] byArray2 = null;
            int n = 0;
            if (byArray != null) {
                byArray2 = byArray;
                n = byArray.length;
            } else {
                long l = file.length();
                boolean bl = EmuUtil.isGZipFile(file);
                if (!bl && l > 0x1000000L) {
                    randomAccessFile = new RandomAccessFile(file, "r");
                    byArray2 = new byte[4096];
                    n = ((InputStream)bufferedInputStream).read(byArray2);
                    randomAccessFile.seek(0L);
                } else if (!bl || bl && l <= 0x1000000L) {
                    byArray2 = byArray = EmuUtil.readFile(file, true);
                    n = byArray.length;
                } else {
                    bufferedInputStream = EmuUtil.openBufferedOptionalGZipFile(file);
                    byArray2 = new byte[4096];
                    ((InputStream)bufferedInputStream).mark(byArray2.length);
                    n = EmuUtil.read(bufferedInputStream, byArray2);
                    ((InputStream)bufferedInputStream).reset();
                }
                if (n < byArray2.length) {
                    byArray2 = Arrays.copyOf(byArray2, n);
                }
            }
            pCMDataInfo = AudioFile.processFile(byArray2, byArray, randomAccessFile, bufferedInputStream);
            if (pCMDataInfo != null && !(pCMDataInfo instanceof PCMDataSource)) {
                pCMDataInfo = null;
            }
            if (pCMDataInfo != null) return (PCMDataSource)pCMDataInfo;
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            return (PCMDataSource)pCMDataInfo;
        }
        finally {
            if (pCMDataInfo == null) {
                EmuUtil.closeSilent(bufferedInputStream);
                EmuUtil.closeSilent(randomAccessFile);
                if (iOException != null) {
                    throw iOException;
                }
                EmuUtil.throwUnsupportedFileFormat();
            }
        }
        EmuUtil.closeSilent(bufferedInputStream);
        EmuUtil.closeSilent(randomAccessFile);
        if (iOException != null) {
            throw iOException;
        }
        EmuUtil.throwUnsupportedFileFormat();
        return (PCMDataSource)pCMDataInfo;
    }

    public static void write(PCMDataSource pCMDataSource, File file) throws IOException {
        String string = file.getName();
        if (string == null) {
            AudioFile.throwUnsupportedFileSuffix();
        }
        if ((string = string.toLowerCase()).endsWith(".aif") || string.endsWith(".aiff") || string.endsWith(".aif.gz") || string.endsWith(".aiff.gz")) {
            AudioFile.writeAIF(pCMDataSource, file, false);
        } else if (string.endsWith(".aifc") || string.endsWith(".aifc.gz")) {
            AudioFile.writeAIF(pCMDataSource, file, true);
        } else if (string.endsWith(".au") || string.endsWith(".au.gz")) {
            AudioFile.writeAU(pCMDataSource, file);
        } else if (string.endsWith(".wav") || string.endsWith(".wav.gz")) {
            AudioFile.writeWAV(pCMDataSource, file);
        } else {
            AudioFile.throwUnsupportedFileSuffix();
        }
    }

    private static long calcDataLen(PCMDataSource pCMDataSource) throws IOException {
        long l = (pCMDataSource.getSampleSizeInBits() + 7) / 8;
        long l2 = l * (long)pCMDataSource.getChannels() * pCMDataSource.getFrameCount();
        if (l2 < 1L) {
            AudioUtil.throwNoAudioData();
        }
        return l2;
    }

    private static void checkFormat(long l, long l2, long l3) throws IOException {
        if (l < 1000L || l > 192000L || l2 < 1L || l2 > 24L || l3 < 1L || l3 > 9L) {
            EmuUtil.throwMysteriousData();
        }
    }

    private static PCMDataInfo createPCMDataInfo(int n, int n2, int n3, boolean bl, boolean bl2, byte[] byArray, RandomAccessFile randomAccessFile, InputStream inputStream, long l, long l2) throws IOException {
        PCMDataInfo pCMDataInfo = null;
        if (byArray != null) {
            pCMDataInfo = new PCMDataBuffer(n, n2, n3, bl, bl2, byArray, l, l2);
        } else if (randomAccessFile != null) {
            pCMDataInfo = new PCMDataFile(n, n2, n3, bl, bl2, randomAccessFile, l, l2);
        } else if (inputStream != null) {
            if (l > 0L) {
                inputStream.skip(l);
            }
            pCMDataInfo = new PCMDataStream(n, n2, n3, bl, bl2, inputStream, l2);
        } else {
            int n4 = (n2 + 7) / 8;
            pCMDataInfo = new Info(n, n2, n3, bl, bl2, l2 / (long)n4 / (long)n3);
        }
        return pCMDataInfo;
    }

    private static float getFloat10BE(byte[] byArray, int n) {
        int n2;
        float f = 0.0f;
        if (byArray != null && n >= 0 && n + 9 < byArray.length && ((n2 = (int)EmuUtil.getInt4BE(byArray, n)) & 0x8000) != 0) {
            f = Float.intBitsToFloat(n2 & 0xF0000000 | n2 << 7 & 0xF800000 | n2 << 8 & 0x7FFF00);
        }
        return f;
    }

    private static PCMDataInfo processAIF(boolean bl, byte[] byArray, byte[] byArray2, RandomAccessFile randomAccessFile, InputStream inputStream) throws IOException {
        long l;
        PCMDataInfo pCMDataInfo = null;
        boolean bl2 = true;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 12;
        for (long i = EmuUtil.getInt4BE(byArray, 4) - 4L; i > 8L && n4 + 8 < byArray.length; i -= l) {
            l = EmuUtil.getInt4BE(byArray, n4 + 4) + 8L;
            if (EmuUtil.isTextAt("COMM", byArray, n4) && (bl && l >= 30L || !bl && l >= 26L)) {
                n3 = EmuUtil.getInt2BE(byArray, n4 + 8);
                l4 = EmuUtil.getInt4BE(byArray, n4 + 10);
                n2 = EmuUtil.getInt2BE(byArray, n4 + 14);
                n = Math.round(AudioFile.getFloat10BE(byArray, n4 + 16));
                if (bl) {
                    if (EmuUtil.isTextAt("NONE", byArray, n4 + 26)) {
                        bl2 = true;
                    } else if (EmuUtil.isTextAt("sowt", byArray, n4 + 26)) {
                        bl2 = false;
                    } else {
                        AudioFile.throwUnsupportedEncoding();
                    }
                }
            } else if (EmuUtil.isTextAt("SSND", byArray, n4)) {
                long l5 = EmuUtil.getInt4BE(byArray, n4 + 8);
                if (EmuUtil.getInt4BE(byArray, n4 + 12) != 0L) {
                    AudioFile.throwUnsupportedEncoding();
                }
                l2 = (long)(n4 + 16) + l5;
                if (l4 > 0L) {
                    int n5 = (n2 + 7) / 8;
                    l3 = l4 * (long)n5 * (long)n3;
                } else {
                    l3 = l - 16L - l5;
                }
            }
            if (l2 > 0L && l3 > 0L && n > 0) {
                pCMDataInfo = AudioFile.createPCMDataInfo(n, n2, n3, true, bl2, byArray2, randomAccessFile, inputStream, l2, l3);
                break;
            }
            if (l % 2L != 0L) {
                ++l;
            }
            n4 += (int)l;
        }
        return pCMDataInfo;
    }

    private static PCMDataInfo processAU(byte[] byArray, byte[] byArray2, RandomAccessFile randomAccessFile, InputStream inputStream) throws IOException {
        long l = EmuUtil.getInt4BE(byArray, 4);
        long l2 = EmuUtil.getInt4BE(byArray, 8);
        long l3 = EmuUtil.getInt4BE(byArray, 12);
        long l4 = EmuUtil.getInt4BE(byArray, 16);
        long l5 = EmuUtil.getInt4BE(byArray, 20);
        if (l3 < 2L || l3 > 5L) {
            AudioFile.throwUnsupportedEncoding();
        }
        int n = ((int)l3 - 1) * 8;
        AudioFile.checkFormat(l4, n, l5);
        return AudioFile.createPCMDataInfo((int)l4, n, (int)l5, true, true, byArray2, randomAccessFile, inputStream, l, l2);
    }

    private static PCMDataInfo processFile(byte[] byArray, byte[] byArray2, RandomAccessFile randomAccessFile, InputStream inputStream) throws IOException {
        PCMDataInfo pCMDataInfo = null;
        if (EmuUtil.isTextAt("FORM", byArray, 0)) {
            if (EmuUtil.isTextAt("AIFF", byArray, 8)) {
                pCMDataInfo = AudioFile.processAIF(false, byArray, byArray2, randomAccessFile, inputStream);
            } else if (EmuUtil.isTextAt("AIFC", byArray, 8)) {
                pCMDataInfo = AudioFile.processAIF(true, byArray, byArray2, randomAccessFile, inputStream);
            }
        } else if (EmuUtil.isTextAt(".snd", byArray, 0)) {
            pCMDataInfo = AudioFile.processAU(byArray, byArray2, randomAccessFile, inputStream);
        }
        if (EmuUtil.isTextAt("RIFF", byArray, 0) && EmuUtil.isTextAt("WAVE", byArray, 8)) {
            pCMDataInfo = AudioFile.processWAV(byArray, byArray2, randomAccessFile, inputStream);
        }
        return pCMDataInfo;
    }

    private static PCMDataInfo processWAV(byte[] byArray, byte[] byArray2, RandomAccessFile randomAccessFile, InputStream inputStream) throws IOException {
        long l;
        PCMDataInfo pCMDataInfo = null;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        int n = 0;
        int n2 = 12;
        for (long i = EmuUtil.getInt4LE(byArray, 4) - 4L; i > 8L && n2 + 8 < byArray.length; i -= l) {
            l = EmuUtil.getInt4LE(byArray, n2 + 4) + 8L;
            if (EmuUtil.isTextAt("fmt ", byArray, n2) && l >= 24L) {
                if (EmuUtil.getWord(byArray, n2 + 8) != 1) {
                    AudioFile.throwUnsupportedEncoding();
                }
                n = EmuUtil.getWord(byArray, n2 + 10);
                l4 = EmuUtil.getInt4LE(byArray, n2 + 12);
                l5 = EmuUtil.getWord(byArray, n2 + 22);
                AudioFile.checkFormat(l4, l5, n);
            } else if (EmuUtil.isTextAt("data", byArray, n2) && l >= 8L) {
                l2 = n2 + 8;
                l3 = l - 8L;
            }
            if (l2 > 0L && l3 > 0L && l4 > 0L) {
                pCMDataInfo = AudioFile.createPCMDataInfo((int)l4, (int)l5, n, l5 > 8L, false, byArray2, randomAccessFile, inputStream, l2, l3);
                break;
            }
            n2 += (int)l;
        }
        return pCMDataInfo;
    }

    private static void throwUnsupportedEncoding() throws IOException {
        throw new IOException("Die in der Datei verwendete Kodierung der Audiodaten wird nicht unterst\u00fctzt.");
    }

    private static void throwUnsupportedFileSuffix() throws IOException {
        throw new IOException("Dateiformat nicht unterst\u00fctzt!\n\nUnterst\u00fctzte Dateiendungen sind:\n  *.aif; *.aifc; *.aiff; *.au; *.wav\n\nSowie die gleichen mit GZip komprimiert:\n  *.aif.gz; *.aifc.gz; *.aiff.gz; *.au.gz; *.wav.gz");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeAIF(PCMDataSource pCMDataSource, File file, boolean bl) throws IOException {
        long l = AudioFile.calcDataLen(pCMDataSource);
        BufferedOutputStream bufferedOutputStream = null;
        try {
            PCMConverterInputStream pCMConverterInputStream = new PCMConverterInputStream(pCMDataSource, true, !bl);
            bufferedOutputStream = new BufferedOutputStream(EmuUtil.createOptionalGZipOutputStream(file));
            EmuUtil.writeASCII(bufferedOutputStream, "FORM");
            EmuUtil.writeInt4BE(bufferedOutputStream, bl ? l + 74L : l + 42L);
            EmuUtil.writeASCII(bufferedOutputStream, bl ? "AIFC" : "AIFF");
            if (bl) {
                EmuUtil.writeASCII(bufferedOutputStream, "FVER");
                EmuUtil.writeInt4BE(bufferedOutputStream, 4L);
                EmuUtil.writeInt4BE(bufferedOutputStream, -1568648896L);
            }
            EmuUtil.writeASCII(bufferedOutputStream, "COMM");
            EmuUtil.writeInt4BE(bufferedOutputStream, bl ? 37L : 18L);
            EmuUtil.writeInt2BE(bufferedOutputStream, pCMDataSource.getChannels());
            EmuUtil.writeInt4BE(bufferedOutputStream, pCMDataSource.getFrameCount());
            EmuUtil.writeInt2BE(bufferedOutputStream, pCMConverterInputStream.getSampleSizeInBits());
            AudioFile.writeFloat10BE(bufferedOutputStream, pCMDataSource.getFrameRate());
            if (bl) {
                EmuUtil.writeASCII(bufferedOutputStream, "sowt");
                ((OutputStream)bufferedOutputStream).write(14);
                EmuUtil.writeASCII(bufferedOutputStream, "not compressed");
                ((OutputStream)bufferedOutputStream).write(0);
            }
            EmuUtil.writeASCII(bufferedOutputStream, "SSND");
            EmuUtil.writeInt4BE(bufferedOutputStream, l + 8L);
            EmuUtil.writeInt4BE(bufferedOutputStream, 0L);
            EmuUtil.writeInt4BE(bufferedOutputStream, 0L);
            while (l > 0L) {
                ((OutputStream)bufferedOutputStream).write(pCMConverterInputStream.read());
                --l;
            }
            ((OutputStream)bufferedOutputStream).close();
            bufferedOutputStream = null;
        }
        catch (Throwable throwable) {
            EmuUtil.closeSilent(bufferedOutputStream);
            throw throwable;
        }
        EmuUtil.closeSilent(bufferedOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeAU(PCMDataSource pCMDataSource, File file) throws IOException {
        BufferedOutputStream bufferedOutputStream = null;
        try {
            long l;
            PCMConverterInputStream pCMConverterInputStream = new PCMConverterInputStream(pCMDataSource, true, true);
            int n = pCMConverterInputStream.getSampleSizeInBits();
            bufferedOutputStream = new BufferedOutputStream(EmuUtil.createOptionalGZipOutputStream(file));
            EmuUtil.writeASCII(bufferedOutputStream, ".snd");
            EmuUtil.writeInt4BE(bufferedOutputStream, 24L);
            EmuUtil.writeInt4BE(bufferedOutputStream, l);
            EmuUtil.writeInt4BE(bufferedOutputStream, (n + 7) / 8 + 1);
            EmuUtil.writeInt4BE(bufferedOutputStream, pCMDataSource.getFrameRate());
            EmuUtil.writeInt4BE(bufferedOutputStream, pCMDataSource.getChannels());
            for (l = AudioFile.calcDataLen(pCMDataSource); l > 0L; --l) {
                ((OutputStream)bufferedOutputStream).write(pCMConverterInputStream.read());
            }
            ((OutputStream)bufferedOutputStream).close();
            bufferedOutputStream = null;
        }
        catch (Throwable throwable) {
            EmuUtil.closeSilent(bufferedOutputStream);
            throw throwable;
        }
        EmuUtil.closeSilent(bufferedOutputStream);
    }

    private static void writeFloat10BE(OutputStream outputStream, long l) throws IOException {
        int n = Float.floatToIntBits(l);
        int n2 = n & 0xF0000000 | n >> 7 & 0x1F0000 | 0x8000 | n >> 8 & Short.MAX_VALUE;
        EmuUtil.writeInt4BE(outputStream, n2);
        for (int i = 0; i < 6; ++i) {
            outputStream.write(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeWAV(PCMDataSource pCMDataSource, File file) throws IOException {
        BufferedOutputStream bufferedOutputStream = null;
        try {
            long l;
            int n = pCMDataSource.getSampleSizeInBits();
            PCMConverterInputStream pCMConverterInputStream = new PCMConverterInputStream(pCMDataSource, n > 8, false);
            n = pCMConverterInputStream.getSampleSizeInBits();
            int n2 = pCMDataSource.getChannels();
            int n3 = pCMDataSource.getFrameRate();
            int n4 = (n + 7) / 8 * n2;
            bufferedOutputStream = new BufferedOutputStream(EmuUtil.createOptionalGZipOutputStream(file));
            EmuUtil.writeASCII(bufferedOutputStream, "RIFF");
            EmuUtil.writeInt4LE(bufferedOutputStream, l + 36L);
            EmuUtil.writeASCII(bufferedOutputStream, "WAVEfmt ");
            EmuUtil.writeInt4LE(bufferedOutputStream, 16L);
            EmuUtil.writeInt2LE(bufferedOutputStream, 1);
            EmuUtil.writeInt2LE(bufferedOutputStream, n2);
            EmuUtil.writeInt4LE(bufferedOutputStream, n3);
            EmuUtil.writeInt4LE(bufferedOutputStream, n3 * n4);
            EmuUtil.writeInt2LE(bufferedOutputStream, n4);
            EmuUtil.writeInt2LE(bufferedOutputStream, n);
            EmuUtil.writeASCII(bufferedOutputStream, "data");
            EmuUtil.writeInt4LE(bufferedOutputStream, l);
            for (l = AudioFile.calcDataLen(pCMDataSource); l > 0L; --l) {
                ((OutputStream)bufferedOutputStream).write(pCMConverterInputStream.read());
            }
            ((OutputStream)bufferedOutputStream).close();
            bufferedOutputStream = null;
        }
        catch (Throwable throwable) {
            EmuUtil.closeSilent(bufferedOutputStream);
            throw throwable;
        }
        EmuUtil.closeSilent(bufferedOutputStream);
    }

    private AudioFile() {
    }

    public static class Info
    implements PCMDataInfo {
        private int frameRate;
        private int sampleSizeInBits;
        private int channels;
        private boolean dataSigned;
        private boolean bigEndian;
        private long frameCount;

        public Info(int n, int n2, int n3, boolean bl, boolean bl2, long l) {
            this.frameRate = n;
            this.sampleSizeInBits = n2;
            this.channels = n3;
            this.dataSigned = bl;
            this.bigEndian = bl2;
            this.frameCount = l;
        }

        @Override
        public int getChannels() {
            return this.channels;
        }

        @Override
        public int getFrameRate() {
            return this.frameRate;
        }

        @Override
        public long getFrameCount() {
            return this.frameCount;
        }

        @Override
        public int getSampleSizeInBits() {
            return this.sampleSizeInBits;
        }

        @Override
        public boolean isBigEndian() {
            return this.bigEndian;
        }

        @Override
        public boolean isSigned() {
            return this.dataSigned;
        }
    }
}

