/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.audio;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.sound.sampled.Mixer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jkcemu.audio.AudioFrm;
import jkcemu.audio.AudioIO;
import jkcemu.audio.AudioIOObserver;
import jkcemu.audio.AudioInFile;
import jkcemu.audio.AudioOut;
import jkcemu.audio.VolumeBar;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuThread;

public abstract class AbstractAudioIOComponent
extends JPanel
implements ActionListener,
AudioIOObserver {
    protected AudioFrm audioFrm;
    protected EmuThread emuThread;
    protected JLabel labelFrameRate;
    protected JLabel labelMixer;
    protected JLabel labelFormat;
    protected JComboBox<Object> comboFrameRate;
    protected JComboBox<String> comboMixer;
    protected JTextField fldFormat;
    protected VolumeBar volumeBar;
    protected JButton btnEnable;
    protected JButton btnDisable;

    public AbstractAudioIOComponent(AudioFrm audioFrm, EmuThread emuThread) {
        this.audioFrm = audioFrm;
        this.emuThread = emuThread;
    }

    protected boolean doAction(ActionEvent actionEvent) {
        boolean bl = true;
        Object object = actionEvent.getSource();
        if (object == this.btnEnable) {
            this.doEnable();
        } else if (object == this.btnDisable) {
            this.doDisable();
        } else if (object instanceof AbstractButton) {
            this.updFieldsEnabled();
        } else {
            bl = false;
        }
        return bl;
    }

    protected abstract void doEnable();

    protected abstract void doDisable();

    protected int getSelectedFrameRate() {
        return this.audioFrm.getSelectedFrameRate(this.comboFrameRate);
    }

    protected Mixer getSelectedMixer() {
        return this.audioFrm.getSelectedMixer(this.comboMixer);
    }

    protected abstract void updFieldsEnabled();

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.doAction(actionEvent);
    }

    @Override
    public void fireFinished(AudioIO audioIO, final String string) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractAudioIOComponent.this.doDisable();
                if (string != null) {
                    AbstractAudioIOComponent.this.showErrorDlg(string);
                }
            }
        });
    }

    @Override
    public void fireProgressUpdate(AudioInFile audioInFile) {
    }

    @Override
    public void fireRecordingStatusChanged(AudioOut audioOut) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractAudioIOComponent.this.updFieldsEnabled();
            }
        });
    }

    @Override
    public void setVolumeLimits(int n, int n2) {
        if (this.volumeBar != null) {
            this.volumeBar.setVolumeLimits(n, n2);
        }
    }

    @Override
    public void updVolume(int n) {
        if (this.volumeBar != null) {
            this.volumeBar.updVolume(n);
        }
    }

    private void showErrorDlg(String string) {
        if (string != null) {
            BaseDlg.showErrorDlg((Component)this, string);
        }
    }
}

