#define FALSE                   0
#define TRUE                    1
#define NO                      0
#define YES                     1
#define FWRD                    0
#define BACK                    1
#define OFF                     0
#define ON                      1

typedef struct {
	int openflag;
	int saveflag;

	int win;
	int vbar;
	int hbar;

	char tit[20];
	MAZEMAP map;
} MAZEWIN;

#define MAZEWIN_NUM   5
#define BAR_SIZE     16

#define MAZE_SIZE_X  20
#define MAZE_SIZE_Y  20
#define MAZE_SIZE_X_MAX  32
#define MAZE_SIZE_Y_MAX  32
#define MAZE_BLOCK_LEN 700
#define MAZE_BLOCK_HEI 300
#define MAZE_BLOCK_LEN_DSP 20
#define MAZE_BLOCK_PLATE 4


#define MALLOCFUNC(x) TL_malloc(x);
#define FREEFUNC(x)   TL_free(x);


#define INPUT_KINDS     10
#define WALL_WALL       0
#define WALL_PASS       1
#define WALL_DOOR       2
#define WALL_INVISIBLE  3
#define WALL_DELETE     4
#define INPUT_KIND_WALL 0..4

#define FLOOR_FLOOR     5
#define FLOOR_CEILING   6
#define FLOOR_NUMBER    7
#define FLOOR_DELFLOOR  8
#define FLOOR_DELCEILING 9
#define INPUT_KIND_FLOOR 5..9


/* mazemng.c */
void InsertWall(MAZEMAP *mz,int bx,int by,int dir,int wal,int pas);
void ClearMaze(MAZEMAP *mz);
void SetFloor(MAZEMAP *mz,int bx,int by);
void ResetFloor(MAZEMAP *mz,int bx,int by);
void SetCeiling(MAZEMAP *mz,int bx,int by);
void ResetCeiling(MAZEMAP *mz,int bx,int by);
void SetNumber(MAZEMAP *mz,int bx,int by,int n);
void ResizeMaze(MAZEMAP *mz,int nx,int ny);


/* prinmapw.c */
void MazeClearMapWin(char *egb);
void MazeDrawMapWin
    (char *egb,MAZEMAP *mz,int lx,int ly,int x1,int y1,int x2,int y2,int l);
void DrawOneFloorCeiling
      (char *egb,MAZEMAP *mz,int sx,int sy,int cx,int cy,int l);
void DrawOneFloorNumber
     (char *egb,MAZEMAP *mz,int sx,int sy,int cx,int cy,int l);


/* fileio.c */
int LoadMazeData(MAZEMAP *mz,char *fname);
int SaveMazeData(MAZEMAP *mz,char *fname);
void PutExt(char *fname,char *ext);
unsigned FileSize(FILE *fp);


/* Question.c */
int YesOrNo(int basobj,char *msg,char *yesbtn,char *nobtn);
int Confirm(int basobj,char *msg,char *btn);


/* sindow.c */
int CheckOpenWindow();
int OpenNewWindow(int neu);


/* window.c */
void ResetWindow(int winn);
void ResetWindowScrollBar(int winn);
