		.386p
		ASSUME	CS:CODE,DS:DATA

		PUBLIC	RotGtoV,RotGtoVFast,RotGtoVHq
		PUBLIC	RotVtoG,RotVtoGFast,RotVtoGHq
		PUBLIC	Move3D

DATA		SEGMENT
		EXTRN	FX_sintbl:DWORD,FX_costbl:DWORD,FX_tantbl:DWORD
		EXTRN	FX_asintbl:DWORD,FX_acostbl:DWORD,FX_atantbl:DWORD
DATA		ENDS



;EAX:angle    result  All Registers except ESI will be destroyed.
GETHQ		MACRO	TBL
		AND	EAX,0FFFFH
		MOV	EDI,EAX
		SHR	EAX,6
		MOV	ECX,[TBL+EAX*4]
		MOV	EDX,[TBL+EAX*4+4]
		SHL	EAX,6

		;X2-X1=64  (Y2-Y1)*(X-X1)/64 +Y1
		SUB	EDX,ECX		;EDX=Y2-Y1
		SUB	EAX,EDI		;EAX=(X1-X)*-1
		NEG	EAX		;   = X-X1
		IMUL	EDX		;EAX:EDX=(X-X1)(Y2-Y1)
		SHRD	EAX,EDX,6	;EAX=(X-X1)(Y2-Y1)/64
		ADD	EAX,ECX		;EAX=(X-X1)(Y2-Y1)/64+Y1
		ENDM





;[#SIN]:FixedPointSin  [#COS]:FixedPointCos  [#RESULTX]:WORK
;ESI:Xpointer   EDI:Ypointer    (EAX,EBX)
RotMac	MACRO	SINPTR,COSPTR
		MOV	EAX,[ESI]
		MOV	EDX,[COSPTR]
		IMUL	EDX
		MOV	EBX,EAX
		MOV	ECX,EDX
		MOV	EAX,[EDI]
		MOV	EDX,[SINPTR]
		IMUL	EDX
		SUB	EBX,EAX
		SBB	ECX,EDX
		SHRD	EBX,ECX,16
		MOV	[#RESULTX],EBX

		MOV	EAX,[ESI]
		MOV	EDX,[SINPTR]
		IMUL	EDX
		MOV	EBX,EAX
		MOV	ECX,EDX
		MOV	EAX,[EDI]
		MOV	EDX,[COSPTR]
		IMUL	EDX
		ADD	EBX,EAX
		ADC	ECX,EDX
		SHRD	EBX,ECX,16

		MOV	EAX,[#RESULTX]
		ENDM


CODE		SEGMENT
		ALIGN	4
RotGtoV		PROC
#SITPTR		EQU	ESP+56
#SRCPTR		EQU	ESP+52
#DSTPTR		EQU	ESP+48
#NPOINT		EQU	ESP+44
#RETADR		EQU	ESP+40
#ESI		EQU	ESP+36
#EDI		EQU	ESP+32
#EBX		EQU	ESP+28
#ESPOFS		EQU	28
#SINH		EQU	ESP+24
#COSH		EQU	ESP+20
#SINP		EQU	ESP+16
#COSP		EQU	ESP+12
#SINB		EQU	ESP+8
#COSB		EQU	ESP+4
#RESULTX	EQU	ESP

		PUSH	ESI
		PUSH	EDI
		PUSH	EBX
		SUB	ESP,#ESPOFS

		MOV	EAX,[#NPOINT]
		AND	EAX,EAX
		JE	#EXIT

		MOV	ESI,[#SITPTR]
		MOV	EAX,[ESI]
		NEG	EAX
		AND	EAX,0FFFFH
		SHR	EAX,6
		MOV	EDX,[FX_sintbl+EAX*4]
		MOV	[#SINH],EDX
		MOV	EDX,[FX_costbl+EAX*4]
		MOV	[#COSH],EDX

		MOV	EAX,[ESI+4]
		NEG	EAX
		AND	EAX,0FFFFH
		SHR	EAX,6
		MOV	EDX,[FX_sintbl+EAX*4]
		MOV	[#SINP],EDX
		MOV	EDX,[FX_costbl+EAX*4]
		MOV	[#COSP],EDX

		MOV	EAX,[ESI+8]
		NEG	EAX
		AND	EAX,0FFFFH
		SHR	EAX,6
		MOV	EDX,[FX_sintbl+EAX*4]
		MOV	[#SINB],EDX
		MOV	EDX,[FX_costbl+EAX*4]
		MOV	[#COSB],EDX


#LOOP0:		MOV	ESI,[#SRCPTR]		;XPTR
		LEA	EDI,[ESI+8]		;ZPTR
		RotMac	#SINH,#COSH
		MOV	ESI,[#DSTPTR]
		MOV	[ESI  ],EAX
		MOV	[ESI+8],EBX

		MOV	ESI,[#DSTPTR]
		ADD	ESI,8			;Z'PTR
		MOV	EDI,[#SRCPTR]
		ADD	EDI,4			;YPTR
		RotMac	#SINP,#COSP
		MOV	[ESI],EAX
		MOV	EDI,[#DSTPTR]
		MOV	[EDI+4],EBX

		MOV	ESI,[#DSTPTR]		;X'PTR
		LEA	EDI,[ESI+4]		;Y'PTR
		RotMac	#SINB,#COSB
		MOV	[ESI],EAX
		MOV	[EDI],EBX

		ADD	DWORD PTR [#SRCPTR],12
		ADD	DWORD PTR [#DSTPTR],12
		DEC	DWORD PTR [#NPOINT]
		JNE	#LOOP0

#EXIT:		ADD	ESP,#ESPOFS
		POP	EBX
		POP	EDI
		POP	ESI
		RET
RotGtoV		ENDP





		ALIGN	4
RotGtoVFast	PROC
#SITPTR		EQU	ESP+56
#SRCPTR		EQU	ESP+52
#DSTPTR		EQU	ESP+48
#NPOINT		EQU	ESP+44
#RETADR		EQU	ESP+40
#ESI		EQU	ESP+36
#EDI		EQU	ESP+32
#EBX		EQU	ESP+28
#ESPOFS		EQU	28
#SINH		EQU	ESP+24
#COSH		EQU	ESP+20
#SINP		EQU	ESP+16
#COSP		EQU	ESP+12
#SINB		EQU	ESP+8
#COSB		EQU	ESP+4
#RESULTX	EQU	ESP

		PUSH	ESI
		PUSH	EDI
		PUSH	EBX
		SUB	ESP,#ESPOFS

		MOV	EAX,[#NPOINT]
		AND	EAX,EAX
		JE	#EXIT

		CLD			;Ô
		MOV	ESI,[#SITPTR]
		LODSD
		NEG	EAX
		MOV	[#SINH],EAX
		LODSD
		MOV	[#COSH],EAX

		LODSD
		NEG	EAX
		MOV	[#SINP],EAX
		LODSD
		MOV	[#COSP],EAX

		LODSD
		NEG	EAX
		MOV	[#SINB],EAX
		LODSD
		MOV	[#COSB],EAX

#LOOP0:		MOV	ESI,[#SRCPTR]		;XPTR
		LEA	EDI,[ESI+8]		;ZPTR
		RotMac	#SINH,#COSH
		MOV	ESI,[#DSTPTR]
		MOV	[ESI  ],EAX
		MOV	[ESI+8],EBX

		MOV	ESI,[#DSTPTR]
		ADD	ESI,8			;Z'PTR
		MOV	EDI,[#SRCPTR]
		ADD	EDI,4			;YPTR
		RotMac	#SINP,#COSP
		MOV	[ESI],EAX
		MOV	EDI,[#DSTPTR]
		MOV	[EDI+4],EBX

		MOV	ESI,[#DSTPTR]		;X'PTR
		LEA	EDI,[ESI+4]		;Y'PTR
		RotMac	#SINB,#COSB
		MOV	[ESI],EAX
		MOV	[EDI],EBX

		ADD	DWORD PTR [#SRCPTR],12
		ADD	DWORD PTR [#DSTPTR],12
		DEC	DWORD PTR [#NPOINT]
		JNE	#LOOP0

#EXIT:		ADD	ESP,#ESPOFS
		POP	EBX
		POP	EDI
		POP	ESI
		RET
RotGtoVFast	ENDP





		ALIGN	4
RotGtoVHq	PROC
#SITPTR		EQU	ESP+56
#SRCPTR		EQU	ESP+52
#DSTPTR		EQU	ESP+48
#NPOINT		EQU	ESP+44
#RETADR		EQU	ESP+40
#ESI		EQU	ESP+36
#EDI		EQU	ESP+32
#EBX		EQU	ESP+28
#ESPOFS		EQU	28
#SINH		EQU	ESP+24
#COSH		EQU	ESP+20
#SINP		EQU	ESP+16
#COSP		EQU	ESP+12
#SINB		EQU	ESP+8
#COSB		EQU	ESP+4
#RESULTX	EQU	ESP

		PUSH	ESI
		PUSH	EDI
		PUSH	EBX
		SUB	ESP,#ESPOFS

		MOV	EAX,[#NPOINT]
		AND	EAX,EAX
		JE	#EXIT

		MOV	ESI,[#SITPTR]
		MOV	EAX,[ESI]
		NEG	EAX
		GETHQ	FX_sintbl
		MOV	[#SINH],EAX
		MOV	EAX,[ESI]
		NEG	EAX
		GETHQ	FX_costbl
		MOV	[#COSH],EAX

		MOV	EAX,[ESI+4]
		NEG	EAX
		GETHQ	FX_sintbl
		MOV	[#SINP],EAX
		MOV	EAX,[ESI+4]
		NEG	EAX
		GETHQ	FX_costbl
		MOV	[#COSP],EAX

		MOV	EAX,[ESI+8]
		NEG	EAX
		GETHQ	FX_sintbl
		MOV	[#SINB],EAX
		MOV	EAX,[ESI+8]
		NEG	EAX
		GETHQ	FX_costbl
		MOV	[#COSB],EAX


#LOOP0:		MOV	ESI,[#SRCPTR]		;XPTR
		LEA	EDI,[ESI+8]		;ZPTR
		RotMac	#SINH,#COSH
		MOV	ESI,[#DSTPTR]
		MOV	[ESI  ],EAX
		MOV	[ESI+8],EBX

		MOV	ESI,[#DSTPTR]
		ADD	ESI,8			;Z'PTR
		MOV	EDI,[#SRCPTR]
		ADD	EDI,4			;YPTR
		RotMac	#SINP,#COSP
		MOV	[ESI],EAX
		MOV	EDI,[#DSTPTR]
		MOV	[EDI+4],EBX

		MOV	ESI,[#DSTPTR]		;X'PTR
		LEA	EDI,[ESI+4]		;Y'PTR
		RotMac	#SINB,#COSB
		MOV	[ESI],EAX
		MOV	[EDI],EBX

		ADD	DWORD PTR [#SRCPTR],12
		ADD	DWORD PTR [#DSTPTR],12
		DEC	DWORD PTR [#NPOINT]
		JNE	#LOOP0

#EXIT:		ADD	ESP,#ESPOFS
		POP	EBX
		POP	EDI
		POP	ESI
		RET
RotGtoVHq	ENDP






		ALIGN	4
RotVtoG		PROC
#SITPTR		EQU	ESP+56
#SRCPTR		EQU	ESP+52
#DSTPTR		EQU	ESP+48
#NPOINT		EQU	ESP+44
#RETADR		EQU	ESP+40
#ESI		EQU	ESP+36
#EDI		EQU	ESP+32
#EBX		EQU	ESP+28
#ESPOFS		EQU	28
#SINH		EQU	ESP+24
#COSH		EQU	ESP+20
#SINP		EQU	ESP+16
#COSP		EQU	ESP+12
#SINB		EQU	ESP+8
#COSB		EQU	ESP+4
#RESULTX	EQU	ESP

		PUSH	ESI
		PUSH	EDI
		PUSH	EBX
		SUB	ESP,#ESPOFS

		MOV	EAX,[#NPOINT]
		AND	EAX,EAX
		JE	#EXIT

		MOV	ESI,[#SITPTR]
		MOV	EAX,[ESI]
		AND	EAX,0FFFFH
		SHR	EAX,6
		MOV	EDX,[FX_sintbl+EAX*4]
		MOV	[#SINH],EDX
		MOV	EDX,[FX_costbl+EAX*4]
		MOV	[#COSH],EDX

		MOV	EAX,[ESI+4]
		AND	EAX,0FFFFH
		SHR	EAX,6
		MOV	EDX,[FX_sintbl+EAX*4]
		MOV	[#SINP],EDX
		MOV	EDX,[FX_costbl+EAX*4]
		MOV	[#COSP],EDX

		MOV	EAX,[ESI+8]
		AND	EAX,0FFFFH
		SHR	EAX,6
		MOV	EDX,[FX_sintbl+EAX*4]
		MOV	[#SINB],EDX
		MOV	EDX,[FX_costbl+EAX*4]
		MOV	[#COSB],EDX


#LOOP0:		MOV	ESI,[#SRCPTR]		;XPTR
		LEA	EDI,[ESI+4]		;YPTR
		RotMac	#SINB,#COSB		;BANK
		MOV	ESI,[#DSTPTR]
		MOV	[ESI  ],EAX
		MOV	[ESI+4],EBX

		MOV	ESI,[#SRCPTR]
		ADD	ESI,8			;ZPTR
		MOV	EDI,[#DSTPTR]
		ADD	EDI,4			;Y'PTR
		RotMac	#SINP,#COSP		;PITCH
		MOV	EDI,[#DSTPTR]
		MOV	[EDI+8],EAX
		MOV	[EDI+4],EBX

		MOV	ESI,[#DSTPTR]		;X'PTR
		LEA	EDI,[ESI+8]		;Z'PTR
		RotMac	#SINH,#COSH		;HEADING
		MOV	[ESI],EAX
		MOV	[EDI],EBX

		ADD	DWORD PTR [#SRCPTR],12
		ADD	DWORD PTR [#DSTPTR],12
		DEC	DWORD PTR [#NPOINT]
		JNE	#LOOP0

#EXIT:		ADD	ESP,#ESPOFS
		POP	EBX
		POP	EDI
		POP	ESI
		RET
RotVtoG		ENDP




		ALIGN	4
RotVtoGFast	PROC
#SITPTR		EQU	ESP+56
#SRCPTR		EQU	ESP+52
#DSTPTR		EQU	ESP+48
#NPOINT		EQU	ESP+44
#RETADR		EQU	ESP+40
#ESI		EQU	ESP+36
#EDI		EQU	ESP+32
#EBX		EQU	ESP+28
#ESPOFS		EQU	28
#SINH		EQU	ESP+24
#COSH		EQU	ESP+20
#SINP		EQU	ESP+16
#COSP		EQU	ESP+12
#SINB		EQU	ESP+8
#COSB		EQU	ESP+4
#RESULTX	EQU	ESP

		PUSH	ESI
		PUSH	EDI
		PUSH	EBX
		SUB	ESP,#ESPOFS

		MOV	EAX,[#NPOINT]
		AND	EAX,EAX
		JE	#EXIT

		CLD			;Ô
		MOV	ESI,[#SITPTR]
		LODSD
		MOV	[#SINH],EAX
		LODSD
		MOV	[#COSH],EAX

		LODSD
		MOV	[#SINP],EAX
		LODSD
		MOV	[#COSP],EAX

		LODSD
		MOV	[#SINB],EAX
		LODSD
		MOV	[#COSB],EAX


#LOOP0:		MOV	ESI,[#SRCPTR]		;XPTR
		LEA	EDI,[ESI+4]		;YPTR
		RotMac	#SINB,#COSB		;BANK
		MOV	ESI,[#DSTPTR]
		MOV	[ESI  ],EAX
		MOV	[ESI+4],EBX

		MOV	ESI,[#SRCPTR]
		ADD	ESI,8			;ZPTR
		MOV	EDI,[#DSTPTR]
		ADD	EDI,4			;Y'PTR
		RotMac	#SINP,#COSP		;PITCH
		MOV	EDI,[#DSTPTR]
		MOV	[EDI+8],EAX
		MOV	[EDI+4],EBX

		MOV	ESI,[#DSTPTR]		;X'PTR
		LEA	EDI,[ESI+8]		;Z'PTR
		RotMac	#SINH,#COSH		;HEADING
		MOV	[ESI],EAX
		MOV	[EDI],EBX

		ADD	DWORD PTR [#SRCPTR],12
		ADD	DWORD PTR [#DSTPTR],12
		DEC	DWORD PTR [#NPOINT]
		JNE	#LOOP0

#EXIT:		ADD	ESP,#ESPOFS
		POP	EBX
		POP	EDI
		POP	ESI
		RET
RotVtoGFast	ENDP






		ALIGN	4
RotVtoGHq	PROC
#SITPTR		EQU	ESP+56
#SRCPTR		EQU	ESP+52
#DSTPTR		EQU	ESP+48
#NPOINT		EQU	ESP+44
#RETADR		EQU	ESP+40
#ESI		EQU	ESP+36
#EDI		EQU	ESP+32
#EBX		EQU	ESP+28
#ESPOFS		EQU	28
#SINH		EQU	ESP+24
#COSH		EQU	ESP+20
#SINP		EQU	ESP+16
#COSP		EQU	ESP+12
#SINB		EQU	ESP+8
#COSB		EQU	ESP+4
#RESULTX	EQU	ESP

		PUSH	ESI
		PUSH	EDI
		PUSH	EBX
		SUB	ESP,#ESPOFS

		MOV	EAX,[#NPOINT]
		AND	EAX,EAX
		JE	#EXIT

		MOV	ESI,[#SITPTR]
		MOV	EAX,[ESI]
		GETHQ	FX_sintbl
		MOV	[#SINH],EAX
		MOV	EAX,[ESI]
		GETHQ	FX_costbl
		MOV	[#COSH],EAX

		MOV	EAX,[ESI+4]
		GETHQ	FX_sintbl
		MOV	[#SINP],EAX
		MOV	EAX,[ESI+4]
		GETHQ	FX_costbl
		MOV	[#COSP],EAX

		MOV	EAX,[ESI+8]
		GETHQ	FX_sintbl
		MOV	[#SINB],EAX
		MOV	EAX,[ESI+8]
		GETHQ	FX_costbl
		MOV	[#COSB],EAX


#LOOP0:		MOV	ESI,[#SRCPTR]		;XPTR
		LEA	EDI,[ESI+4]		;YPTR
		RotMac	#SINB,#COSB		;BANK
		MOV	ESI,[#DSTPTR]
		MOV	[ESI  ],EAX
		MOV	[ESI+4],EBX

		MOV	ESI,[#SRCPTR]
		ADD	ESI,8			;ZPTR
		MOV	EDI,[#DSTPTR]
		ADD	EDI,4			;Y'PTR
		RotMac	#SINP,#COSP		;PITCH
		MOV	EDI,[#DSTPTR]
		MOV	[EDI+8],EAX
		MOV	[EDI+4],EBX

		MOV	ESI,[#DSTPTR]		;X'PTR
		LEA	EDI,[ESI+8]		;Z'PTR
		RotMac	#SINH,#COSH		;HEADING
		MOV	[ESI],EAX
		MOV	[EDI],EBX

		ADD	DWORD PTR [#SRCPTR],12
		ADD	DWORD PTR [#DSTPTR],12
		DEC	DWORD PTR [#NPOINT]
		JNE	#LOOP0

#EXIT:		ADD	ESP,#ESPOFS
		POP	EBX
		POP	EDI
		POP	ESI
		RET
RotVtoGHq	ENDP







		ALIGN	4
Move3D		PROC
#VECTOR		EQU	ESP+32
#SRCPTR		EQU	ESP+28
#DSTPTR		EQU	ESP+24
#NPOINT		EQU	ESP+20
#RETADR		EQU	ESP+16
#ESI		EQU	ESP+12
#EDI		EQU	ESP+8
#EBX		EQU	ESP+4
#ES		EQU	ESP

		PUSH	ESI
		PUSH	EDI
		PUSH	EBX
		PUSH	ES

		PUSH	DS
		POP	ES

		MOV	EAX,[#NPOINT]
		AND	EAX,EAX
		JE	#EXIT

		MOV	ESI,[#SRCPTR]
		MOV	EDI,[#DSTPTR]

		MOV	EDX,[#VECTOR]
		MOV	EAX,[EDX]
		MOV	EBX,[EDX+4]
		MOV	EDX,[EDX+8]

		CMP	ESI,EDI
		JE	#SamePtr

#LOOP0:		MOV	ECX,3
		REP	MOVSD
		ADD	[EDI-12],EAX
		ADD	[EDI-8],EBX
		ADD	[EDI-4],EDX
		DEC	DWORD PTR [#NPOINT]
		JNE	#LOOP0

#EXIT:		POP	ES
		POP	EBX
		POP	EDI
		POP	ESI
		RET



#SamePtr:	MOV	ECX,[#NPOINT]

#L00:		ADD	[ESI  ],EAX
		ADD	[ESI+4],EBX
		ADD	[ESI+8],EDX
		ADD	ESI,12
		LOOP	#L00

		POP	ES
		POP	EBX
		POP	EDI
		POP	ESI
		RET
Move3D		ENDP

CODE		ENDS
		END
