#include <stdio.h>
#include <stdlib.h>

#include "UTIL.h"

int *LoadBinaryFile(const char fn[])
{
	FILE *fp=NULL;
	int *dat=NULL;

	fp=fopen(fn,"rb");
	if(NULL!=fp)
	{
		unsigned int sz=0;
		fseek(fp,0,SEEK_END);
		sz=ftell(fp);
		fseek(fp,0,SEEK_SET);
		dat=(int *)malloc(sz);
		fread(dat,1,sz,fp);
		fclose(fp);
	}
	return dat;
}

void FreeBinaryFile(int *t3d)
{
	free(t3d);
}


LAXIS *LoadLax(const char fn[])
{
	FILE *fp=fopen(fn,"rb");
	if(NULL!=fp)
	{
		LAXIS *lax=malloc(sizeof(LAXIS));

		char buf[8];
		fread(buf,1,8,fp);		// Skip label.
		fread(lax,1,36,fp);		// 9 integers.

		int drwSize;
		int strSize;
		fread(&drwSize,1,4,fp);
		fread(&strSize,1,4,fp);

		lax->drw=malloc(drwSize);
		fread(lax->drw,1,drwSize,fp);

		lax->str=malloc(strSize);
		fread(lax->str,1,strSize,fp);

		return lax;
	}
	return NULL;
}

void FreeLax(LAXIS *lax)
{
	if(NULL!=lax)
	{
		free(lax->drw);
		free(lax->str);
		free(lax);
	}
}

