#include <egb.h>
#include <mos.h>
#include <snd.h>

#include "egbctrl.h"



int egbCtrl_videoOut=0;

static char EGB_work[EgbWorkSize],mos[MosWorkSize],snd[16384];

void StartTBIOS(void)
{
	int i;

	EGB_init(EGB_work,EgbWorkSize);

	SND_init(snd);

	// My 2MX somehow mutes FM and PCM every time I reboot.
	SND_elevol_init();
	SND_elevol_mute(3);
	for(i=0; i<6; ++i)
	{
		SND_volume_change(i,127);
	}
	for(i=64; i<72; ++i)
	{
		SND_volume_change(i,127);
	}

	SND_eup_init();
	SND_rs_midi_init();

	MOS_start(mos,MosWorkSize);
	MOS_disp(0);
}

void EndTBIOS(void)
{
	SND_rs_midi_end();
	SND_eup_end();

	MOS_end();
	SND_end();
}

static void ClearScreen(void)
{
	EGB_writePage(EGB_work,0);
	EGB_clearScreen(EGB_work);
	EGB_writePage(EGB_work,1);
	EGB_clearScreen(EGB_work);
}

void SetUpEGB320x240_320x240(void)
{
	ClearScreen();

	int scrnMode=10;
	if(0!=egbCtrl_videoOut)
	{
		scrnMode=11;
	}

	EGB_resolution(EGB_work,0,scrnMode);
	EGB_resolution(EGB_work,1,scrnMode);

	EGB_writePage(EGB_work,0);
	EGB_displayStart(EGB_work,0,0,0);
	EGB_displayStart(EGB_work,2,2,2);
	EGB_displayStart(EGB_work,3,320,240);
	EGB_clearScreen(EGB_work);

	EGB_writePage(EGB_work,1);
	EGB_displayStart(EGB_work,0,0,0);
	EGB_displayStart(EGB_work,2,2,2);
	EGB_displayStart(EGB_work,3,320,240);
	EGB_clearScreen(EGB_work);

	EGB_displayPage(EGB_work,1,2);
}

void SetUpEGB256x256_256x256(void)
{
	ClearScreen();

	int scrnMode=5;
	if(0!=egbCtrl_videoOut)
	{
		scrnMode=7;
	}

	EGB_resolution(EGB_work,0,scrnMode);
	EGB_resolution(EGB_work,1,scrnMode);

	EGB_writePage(EGB_work,0);
	EGB_displayStart(EGB_work,0,64,0);
	EGB_displayStart(EGB_work,2,2,2);
	EGB_displayStart(EGB_work,3,256,256);
	EGB_clearScreen(EGB_work);

	EGB_writePage(EGB_work,1);
	EGB_displayStart(EGB_work,0,64,0);
	EGB_displayStart(EGB_work,2,2,2);
	EGB_displayStart(EGB_work,3,256,256);
	EGB_clearScreen(EGB_work);

	EGB_displayPage(EGB_work,1,2);
}

void HideBuffers(void)
{
	EGB_displayPage(EGB_work,0,0);
}

void ShowBuffer(int page)
{
	EGB_displayPage(EGB_work,page,1<<page);
}

int CheckButtonPress(void)
{
	int ibt,imx,imy;
	MOS_rdpos(&ibt,&imx,&imy);
	if(0!=(ibt&3))
	{
		return 1;
	}

	int pad;
	SND_joy_in_2(0,&pad);
	if((0xf0&pad)!=0xf0)
	{
		return 1;
	}

	return 0;
}
