		.386p
		ASSUME	CS:CODE
		INCLUDE YGHASM.H

		PUBLIC	YGH_pset,YGH_psets

;EAX,EBX:X,Y   EDX:color   EBX will be destroyed
ONEPSET		MACRO	ODW,ADR
		IMUL	EBX,ODW
		ADD	EBX,ADR
		MOV	ES:[EBX+EAX*2],DX
		ENDM



CODE		SEGMENT
		ALIGN	4
YGH_pset	PROC
#Y		EQU	ESP+24
#X		EQU	ESP+20
#PAGE		EQU	ESP+16
#RETADR		EQU	ESP+12
#EBX		EQU	ESP+8
#EDI		EQU	ESP+4
#ES		EQU	ESP

		PUSH	EBX
		PUSH	EDI
		PUSH	ES

		MOV	EDI,[#PAGE]

		MOV	EAX,[#X]
		MOV	EBX,[#Y]

		CMP	EAX,[EDI+YGH_VX1]
		JL	#EXIT
		CMP	EBX,[EDI+YGH_VY1]
		JL	#EXIT
		CMP	EAX,[EDI+YGH_VX2]
		JG	#EXIT
		CMP	EBX,[EDI+YGH_VY2]
		JG	#EXIT

		MOV	EDX,[EDI+YGH_SEG]
		MOV	ES,DX
		MOV	EDX,[EDI+YGH_COL]
		ONEPSET	[EDI+YGH_ODW],[EDI+YGH_ADR]

#EXIT:		POP	ES
		POP	EDI
		POP	EBX
		MOV	EAX,0
		RET
YGH_pset	ENDP




ONESTEP		MACRO
		LOCAL	J01
		MOV	EAX,[ESI]
		MOV	EBX,[ESI+4]

		CMP	EAX,[#VX1]
		JL	J01
		CMP	EBX,[#VY1]
		JL	J01
		CMP	EAX,[#VX2]
		JG	J01
		CMP	EBX,[#VY2]
		JG	J01
		IMUL	EBX,[#ODW]
		ADD	EBX,[#ADR]
		MOV	ES:[EBX+EAX*2],DX

J01:		ADD	ESI,8
		ENDM


		ALIGN	4
YGH_psets	PROC
#PNT		EQU	ESP+48
#PAGE		EQU	ESP+44
#RETADR		EQU	ESP+40
#EBX		EQU	ESP+36
#EDI		EQU	ESP+32
#ESI		EQU	ESP+28
#ES		EQU	ESP+24
#ESPOFS		EQU	24
#ADR		EQU	ESP+20
#ODW		EQU	ESP+16
#VX1		EQU	ESP+12
#VY1		EQU	ESP+8
#VX2		EQU	ESP+4
#VY2		EQU	ESP

		PUSH	EBX
		PUSH	EDI
		PUSH	ESI
		PUSH	ES
		SUB	ESP,#ESPOFS

		MOV	ESI,[#PNT]
		MOV	ECX,[ESI]		;ECX:Number of Points
		AND	ECX,ECX
		JE	#EXIT
		LEA	ESI,[ESI+4]		;ESI:Pointer to (x,y)

		MOV	EDI,[#PAGE]
		MOV	EAX,[EDI+YGH_VX1]
		MOV	[#VX1],EAX
		MOV	EAX,[EDI+YGH_VY1]
		MOV	[#VY1],EAX
		MOV	EAX,[EDI+YGH_VX2]
		MOV	[#VX2],EAX
		MOV	EAX,[EDI+YGH_VY2]
		MOV	[#VY2],EAX
		MOV	EAX,[EDI+YGH_ODW]
		MOV	[#ODW],EAX
		MOV	EAX,[EDI+YGH_ADR]
		MOV	[#ADR],EAX
		MOV	EAX,[EDI+YGH_SEG]
		MOV	ES,AX
		MOV	EDX,[EDI+YGH_COL]	;EDI

		MOV	EDI,ECX
		AND	EDI,7
		JMP	CS:[#JTBL + EDI*4]
		ALIGN	4
#JTBL		DD  OFFSET #L00,OFFSET #L01,OFFSET #L02,OFFSET #L03
		DD  OFFSET #L04,OFFSET #L05,OFFSET #L06,OFFSET #L07
#L00:		ONESTEP	;EAX,EBX will be destroyed
#L07:		ONESTEP
#L06:		ONESTEP
#L05:		ONESTEP
#L04:		ONESTEP
#L03:		ONESTEP
#L02:		ONESTEP
#L01:		ONESTEP
		SUB	ECX,8
		JG	#L00

#EXIT:		ADD	ESP,#ESPOFS
		POP	ES
		POP	ESI
		POP	EDI
		POP	EBX
		MOV	EAX,0
		RET
YGH_psets	ENDP

CODE		ENDS
		END
