#pragma On(Align_all_labels)
#pragma On(Align_labels)

#include <concorde.h>
#include <tomahawk.h>
#include <airforce.h>

#define INF 8192
#define clip(x1,y1,x2,y2,x) ((y2)-(y1))*((x)-(x1))/((x2)-(x1))+(y1)
#define Yabs(a) ((a)>=0 ? (a) : -(a))

extern int *AL_area,AL_ed[4];

static void AL_Horizon_fill(PAGE *p,int *rc,int c);
static int AL_Horizontal_line(int *x1,int *y1,int *x2,int *y2,int *rc);
static void AL_Horizon_getArea(int *pnt,int x1,int y1,int x2,int y2,int *rc);



/*
     sit[0]  h     c[0]  Ground Color
     sit[1]  p     c[1]  Sky Color
     sit[2]  b     
*/
int AL_Horizon(PAGE *p,int *sit,int *rc,int *c,PRJSCRN *pr)
{
	int pnt[20];
	int sx,sy,rx,ry;
	int x1,y1,x2,y2;
	int bsin,bcos;

	if(sit[1]>14563)  /* 80xȏ̎ */
	{
		AL_Horizon_fill(p,rc,c[1]);
		return 0;
	}
	else if(sit[1]< -14563)  /* 80xȉ̎ */
	{
		AL_Horizon_fill(p,rc,c[0]);
		return 0;
	}

	bsin=FxSinHq(sit[2]);
	bcos=FxCosHq(sit[2]);

	sx=(*pr).prj.cx-MulSinHq(MulTanHq((*pr).prj.mag,sit[1]),sit[2]);
	sy=(*pr).prj.cy+MulCosHq(MulTanHq((*pr).prj.mag,sit[1]),sit[2]);

	rx=sx+MulCosHq(INF,sit[2]);
	ry=sy+MulSinHq(INF,sit[2]);

	if(sx==rx)
	{
		if(bsin>0)
		{
			YGH_color(p,c[0]);
			if(sx>=rc[0])YGH_filledBox(p,rc[0],rc[1],sx,rc[3]);
			YGH_color(p,c[1]);
			if(sx<=rc[2])YGH_filledBox(p,sx,rc[1],rc[2],rc[3]);
		}
		else
		{
			YGH_color(p,c[1]);
			if(sx>=rc[0])YGH_filledBox(p,rc[0],rc[1],sx,rc[3]);
			YGH_color(p,c[0]);
			if(sx<=rc[2])YGH_filledBox(p,sx,rc[1],rc[2],rc[3]);
		}
		return 0;
	}

	if(sy==ry)
	{
		if(bcos>0)
		{
			YGH_color(p,c[1]);
			if(sy>=rc[1])YGH_filledBox(p,rc[0],rc[1],rc[2],sy);
			YGH_color(p,c[0]);
			if(sy<=rc[3])YGH_filledBox(p,rc[0],sy,rc[2],rc[3]);
		}
		else
		{
			YGH_color(p,c[0]);
			if(sy>=rc[1])YGH_filledBox(p,rc[0],rc[1],rc[2],sy);
			YGH_color(p,c[1]);
			if(sy<=rc[3])YGH_filledBox(p,rc[0],sy,rc[2],rc[3]);
		}
		return 0;
	}

	x1=rx;
	y1=ry;
	x2=sx;
	y2=sy;
	if(AL_Horizontal_line(&x1,&y1,&x2,&y2,rc))
	{
		if(sit[1]>0)AL_Horizon_fill(p,rc,c[1]);
		else        AL_Horizon_fill(p,rc,c[0]);
		return 0;
	}

	YGH_color(p,c[1]);
	if(Yabs(x2-x1)>Yabs(y2-y1))
	{
		YGH_line(p,x1,y1  ,x2,y2  );
		YGH_line(p,x1,y1+1,x2,y2+1);
		YGH_line(p,x1,y1-1,x2,y2-1);
	}
	else
	{
		YGH_line(p,x1  ,y1,x2  ,y2);
		YGH_line(p,x1+1,y1,x2+1,y2);
		YGH_line(p,x1-1,y1,x2-1,y2);
	}

	AL_Horizon_getArea(pnt,x2,y2,x1,y1,rc);
	YGH_color(p,c[1]);
	YGH_triangleArea(p,AL_area,AL_ed,pnt);
	YGH_areaPaint(p,AL_area,AL_ed);

	AL_Horizon_getArea(pnt,x1,y1,x2,y2,rc);
	YGH_color(p,c[0]);
	YGH_triangleArea(p,AL_area,AL_ed,pnt);
	YGH_areaPaint(p,AL_area,AL_ed);

	return 0;
}





static void AL_Horizon_fill(PAGE *p,int *rc,int c)
{
	YGH_color(p,c);
	YGH_filledBox(p,rc[0],rc[1],rc[2],rc[3]);
}


static int AL_Horizontal_line(int *x1,int *y1,int *x2,int *y2,int *rc)
{
	int a,b,c,d;

	if(_abs(*x2-*x1)>_abs(*y2-*y1))
	{
		if(*x1>*x2)
		{
			a=rc[2];  b=clip(*x1,*y1,*x2,*y2,rc[2]);
			c=rc[0];  d=clip(*x1,*y1,*x2,*y2,rc[0]);
		}
		else
		{
			a=rc[0];  b=clip(*x1,*y1,*x2,*y2,rc[0]);
			c=rc[2];  d=clip(*x1,*y1,*x2,*y2,rc[2]);
		}

		if(b<rc[1])
		{
			a=clip(*y1,*x1,*y2,*x2,rc[1]);
			b=rc[1];
		}
		else if(b>rc[3])
		{
			a=clip(*y1,*x1,*y2,*x2,rc[3]);
			b=rc[3];
		}

		if(d<rc[1])
		{
			c=clip(*y1,*x1,*y2,*x2,rc[1]);
			d=rc[1];
		}
		else if(d>rc[3])
		{
			c=clip(*y1,*x1,*y2,*x2,rc[3]);
			d=rc[3];
		}
	}
	else
	{
		if(*y1>*y2)
		{
			a=clip(*y1,*x1,*y2,*x2,rc[3]);  b=rc[3];
			c=clip(*y1,*x1,*y2,*x2,rc[1]);  d=rc[1];
		}
		else
		{
			a=clip(*y1,*x1,*y2,*x2,rc[1]);  b=rc[1];
			c=clip(*y1,*x1,*y2,*x2,rc[3]);  d=rc[3];
		}

		if(a<rc[0])
		{
			a=rc[0];
			b=clip(*x1,*y1,*x2,*y2,rc[0]);
		}
		else if(a>rc[2])
		{
			a=rc[2];
			b=clip(*x1,*y1,*x2,*y2,rc[2]);
		}

		if(c<rc[0])
		{
			c=rc[0];
			d=clip(*x1,*y1,*x2,*y2,rc[0]);
		}
		else if(c>rc[2])
		{
			c=rc[2];
			d=clip(*x1,*y1,*x2,*y2,rc[2]);
		}
	}

	if(a<rc[0] || rc[2]<a || b<rc[1] || rc[3]<b)return 1;
	if(c<rc[0] || rc[2]<c || d<rc[1] || rc[3]<d)return 1;
	if(a==c && b==d)return 1;
	*x1=a;
	*y1=b;
	*x2=c;
	*y2=d;
	return 0;
}


static void AL_Horizon_getArea(int *pnt,int x1,int y1,int x2,int y2,int *rc)
{
	int i,x,y;

	x=x1; y=y1; pnt[1]=x; pnt[2]=y;
	for(i=1; i<6; i++)
	{
		if(y==rc[1] && x< rc[2])
		{
			pnt[i*2+1]=rc[2];
			pnt[i*2+2]=rc[1];
			if(x2==rc[2])break;
		}
		else if(x==rc[2] && y< rc[3])
		{
			pnt[i*2+1]=rc[2];
			pnt[i*2+2]=rc[3];
			if(y2==rc[3])break;
		}
		else if(y==rc[3] && x> rc[0])
		{
			pnt[i*2+1]=rc[0];
			pnt[i*2+2]=rc[3];
			if(x2==rc[0])break;
		}
		else if(x==rc[0] && y> rc[1])
		{
			pnt[i*2+1]=rc[0];
			pnt[i*2+2]=rc[1];
			if(y2==rc[1])break;
		}
		x=pnt[i*2+1];
		y=pnt[i*2+2];
	}
	i++;
	pnt[i*2+1]=x2;
	pnt[i*2+2]=y2;
	pnt[0]=i+1;
}
