
; See geometry.asm for data format.
CUBE_DATA			FCB			8		; 8 Vertices
					FDB			-120,-120,-120
					FDB			 120,-120,-120
					FDB			 120, 120,-120
					FDB			-120, 120,-120
					FDB			-120,-120, 120
					FDB			 120,-120, 120
					FDB			 120, 120, 120
					FDB			-120, 120, 120
					FCB			12		; 12 edges
					FCB			0,1, 1,2, 2,3, 3,0
					FCB			0,4, 1,5, 2,6, 3,7
					FCB			4,5, 5,6, 6,7, 7,4

CUBE_VTX_TFMBUF		FDB			-100,-100,-100
					FDB			 100,-100,-100
					FDB			 100, 100,-100
					FDB			-100, 100,-100
					FDB			-100,-100, 100
					FDB			 100,-100, 100
					FDB			 100, 100, 100
					FDB			-100, 100, 100

CUBE_DEMO_VRAMADDR	FDB		0
CUBE_DEMO_VX		FCB		8
CUBE_DEMO_CTR		FCB		0



RENDER_CUBE			PSHS	A,B,X,Y,U

					LEAX	CUBE_DATA,PCR
					STX		TO_SCREEN_GEOMDATAADDR,PCR
					LEAX	CUBE_VTX_TFMBUF,PCR
					STX		TO_SCREEN_TFMBUFADDR,PCR

					LDU		#COMMON_LINEBUFPTR
					STU		CALL_LINEDDA_SUBCPU_DATAADDR,PCR

					LDX		CUBE_DEMO_VRAMADDR,PCR
					STX		,U++

					LDA		#80
					STA		,U+		; 80 bytes per line

					LDA		#1
					STA		,U+		; Needs to be one.

					LEAY	0,U
					CLR		,U+		; Number of lines

					STU		TO_SCREEN_LINEOUTADDR,PCR

					LBSR	TO_SCREEN

					LDA		TO_SCREEN_NUMLINE,PCR
					STA		,Y

					LBSR	CALL_LINEDDA_SUBCPU ; CALL_CLS_AND_LINEDDA_SUBCPU
RENDER_CUBE_END
					PULS	A,B,X,Y,U
					RTS

