MAZE_DEMO_VRAMADDR	FDB		0
MAZE_DEMO_CTR		FCB		0
MAZE_DEMO_PHASE		FCB		0
MAZE_DEMO_LOOPCTR	FCB		0


					EXPORT	MAZE_DEMO_LOOP
					EXPORT	RENDER_MAZE_BEGIN
					EXPORT	RENDER_MAZE
					EXPORT	RENDER_MAZE_FLUSH


MAZE_DEMO			PSHS	A,B,X,Y,U,CC
					ORCC	#$40

					BSR		MAZE_DEMO_INIT
MAZE_DEMO_LOOP		LBSR	MAZE_DEMO_ONESTEP
					LDA		$FD04
					BITA	#2
					BEQ		MAZE_DEMO_LOOP_OUT
					LDA		MAZE_DEMO_LOOPCTR,PCR
					CMPA	#2
					BCS		MAZE_DEMO_LOOP

					BSR		MAZE_DEMO_CLEANUP
MAZE_DEMO_LOOP_OUT
					PULS	A,B,X,Y,U,CC
					RTS



MAZE_DEMO_INIT		PSHS	A,B,X,Y,U

					LDA		#21
					STA		MAZEDATA_NUM_LINE,PCR

					CLR		MAZE_DEMO_CTR,PCR
					CLR		MAZE_DEMO_LOOPCTR,PCR

					LBSR	INSTALL_LINEDDA_IN_SUBCPU
					LBSR	INSTALL_CLEAR_BITPLANE_IN_SUBCPU

					LBSR	CLEAR_SCREEN


					CLR		MAZE_DEMO_PHASE,PCR


					LDX		#0
					STX		TO_SCREEN_TRANS3D_VIEWX,PCR
					STX		TO_SCREEN_TRANS3D_VIEWY,PCR
					STX		TO_SCREEN_TRANS3D_VIEWZ,PCR
					CLR		TO_SCREEN_TRANS3D_VIEWH,PCR
					CLR		TO_SCREEN_TRANS3D_VIEWP,PCR
					CLR		TO_SCREEN_TRANS3D_VIEWB,PCR


					LDX		#$4000
					STX		MAZE_DEMO_VRAMADDR,PCR

					CLR		$FD38
					CLR		$FD39
					CLR		$FD3A
					CLR		$FD3B
					CLR		$FD3C
					CLR		$FD3D
					CLR		$FD3E
					CLR		$FD3F
					PULS	A,B,X,Y,U,PC


MAZE_DEMO_CLEANUP	
					LBSR	CLEAR_SCREEN
					CLRA
					LDX		#$FD38
					STA		,X+
					INCA
					STA		,X+
					INCA
					STA		,X+
					INCA
					STA		,X+
					INCA
					STA		,X+
					INCA
					STA		,X+
					INCA
					STA		,X+
					INCA
					STA		,X+
					INCA

					RTS


MAZE_DEMO_ONESTEP	PSHS	A,B,X,Y,U
					LBSR		MAZE_DEMO_MAIN


					LDA		MAZE_DEMO_PHASE,PCR
					BEQ		MAZE_DEMO_MOVE_PHASE0
					DECA
					BEQ		MAZE_DEMO_MOVE_PHASE1
					DECA
					BEQ		MAZE_DEMO_MOVE_PHASE2
					DECA
					BEQ		MAZE_DEMO_MOVE_PHASE3
					DECA
					LBEQ		MAZE_DEMO_MOVE_PHASE4
					DECA
					LBEQ		MAZE_DEMO_MOVE_PHASE5

					LBRA		MAZE_DEMO_ONESTEP_END

MAZE_DEMO_MOVE_PHASE0
					LDD		TO_SCREEN_TRANS3D_VIEWZ,PCR
					SUBD	#25
					STD		TO_SCREEN_TRANS3D_VIEWZ,PCR
					CMPD	#-350
					LBGT	MAZE_DEMO_ONESTEP_END
					LDD		#50
					STD		TO_SCREEN_TRANS3D_VIEWX,PCR
					LDD		#0
					STD		TO_SCREEN_TRANS3D_VIEWZ,PCR
					LDA		#64
					STA		TO_SCREEN_TRANS3D_VIEWH,PCR
					INC		MAZE_DEMO_PHASE,PCR
					LBRA		MAZE_DEMO_ONESTEP_END

MAZE_DEMO_MOVE_PHASE1
					LDD		TO_SCREEN_TRANS3D_VIEWX,PCR
					SUBD	#25
					STD		TO_SCREEN_TRANS3D_VIEWX,PCR
					BGT		MAZE_DEMO_ONESTEP_END
					INC		MAZE_DEMO_PHASE,PCR

					LDA		MAZE_DEMO_LOOPCTR,PCR
					BEQ		MAZE_DEMO_ONESTEP_END
					LDA		#14						; Turn off the door for the 2nd loop
					STA		MAZEDATA_NUM_LINE,PCR
					BRA		MAZE_DEMO_ONESTEP_END

MAZE_DEMO_MOVE_PHASE2
					LDA		TO_SCREEN_TRANS3D_VIEWH,PCR
					SUBA	#16
					STA		TO_SCREEN_TRANS3D_VIEWH,PCR
					BNE		MAZE_DEMO_ONESTEP_END
					INC		MAZE_DEMO_PHASE,PCR
					BRA		MAZE_DEMO_ONESTEP_END

MAZE_DEMO_MOVE_PHASE3
					LDD		TO_SCREEN_TRANS3D_VIEWZ,PCR
					SUBD	#25
					STD		TO_SCREEN_TRANS3D_VIEWZ,PCR
					CMPD	#-350
					BGT		MAZE_DEMO_ONESTEP_END
					LDD		#-50
					STD		TO_SCREEN_TRANS3D_VIEWX,PCR
					LDD		#0
					STD		TO_SCREEN_TRANS3D_VIEWZ,PCR
					LDA		#-64
					STA		TO_SCREEN_TRANS3D_VIEWH,PCR
					INC		MAZE_DEMO_PHASE,PCR

					INC		MAZE_DEMO_LOOPCTR,PCR	; Getting out of the door.  Loop count must be incremented here rather than in PHASE5

					BRA		MAZE_DEMO_ONESTEP_END

MAZE_DEMO_MOVE_PHASE4
					LDD		TO_SCREEN_TRANS3D_VIEWX,PCR
					ADDD	#25
					STD		TO_SCREEN_TRANS3D_VIEWX,PCR
					BNE		MAZE_DEMO_ONESTEP_END
					INC		MAZE_DEMO_PHASE,PCR
					BRA		MAZE_DEMO_ONESTEP_END

MAZE_DEMO_MOVE_PHASE5
					LDA		TO_SCREEN_TRANS3D_VIEWH,PCR
					ADDA	#16
					STA		TO_SCREEN_TRANS3D_VIEWH,PCR
					BNE		MAZE_DEMO_ONESTEP_END

					CLR		MAZE_DEMO_PHASE,PCR

					BRA		MAZE_DEMO_ONESTEP_END


MAZE_DEMO_ONESTEP_END
					INC		MAZE_DEMO_CTR,PCR
					PULS	A,B,X,Y,U,PC




MAZE_DEMO_MAIN		PSHS	A,B,X,Y,U

					LBSR	RENDER_MAZE_BEGIN
					LBSR	RENDER_MAZE
					LBSR	RENDER_MAZE_FLUSH

					LDX		MAZE_DEMO_VRAMADDR,PCR

					; Due to hardware problem, Blue Plane is not healthy.
					; Avoid Blue Plane in Mode 0
					LDB		#4
					LDA		#5
					CMPX	#$4000
					BEQ		MAZE_DEMO_GREEN_ON ; To draw on Red.  Turn on Green
MAZE_DEMO_RED_ON		STB		$FD39	' 001
					STA		$FD3A	' 010
					STA		$FD3B	' 011
					CLR		$FD3C	' 100
					STB		$FD3D	' 101
					STA		$FD3E	' 110
					STA		$FD3F	' 111
					BRA		MAZE_DEMO_LOOP_PALETTE_DONE
MAZE_DEMO_GREEN_ON	STB		$FD39	' 001
					CLR		$FD3A	' 010
					STB		$FD3B	' 011
					STA		$FD3C	' 100
					STA		$FD3D	' 101
					STA		$FD3E	' 110
					STA		$FD3F	' 111


MAZE_DEMO_LOOP_PALETTE_DONE
					LEAX	$4000,X
					CMPX	#$8000
					BCS		MAZE_DEMO_LOOP_NEXTVRAM
					BEQ		MAZE_DEMO_LOOP_NEXTVRAM
					LDX		#0
MAZE_DEMO_LOOP_NEXTVRAM
					STX		MAZE_DEMO_VRAMADDR,PCR

					; Avoid Blue Plane
					CMPX	#0
					BNE		MAZE_DEMO_LOOP_MOVE
					LDX		#$4000
					STX		MAZE_DEMO_VRAMADDR,PCR

MAZE_DEMO_LOOP_MOVE

MAZE_DEMO_MAIN_END	PULS	A,B,X,Y,U
					RTS



RENDER_MAZE_BEGIN
					LDX		#320
					STX		TO_SCREEN_PERS_CX,PCR
					LDX		#100
					STX		TO_SCREEN_PERS_CY,PCR
					LDA		#8
					STA		TO_SCREEN_PERS_XSHIFT,PCR
					LDA		#7
					STA		TO_SCREEN_PERS_YSHIFT,PCR


					LDX		#0
					STX		TO_SCREEN_WX0,PCR
					STX		TO_SCREEN_WY0
					LDX		#639
					STX		TO_SCREEN_WX1,PCR
					LDX		#199
					STX		TO_SCREEN_WY1,PCR

					LDX		#10
					STX		TO_SCREEN_NEARZ,PCR

					LDU		#COMMON_LINEBUFPTR

					LDX		MAZE_DEMO_VRAMADDR,PCR
					STX		,U++

					LDA		#80
					STA		,U+		; 80 bytes per line

					LDA		#1
					STA		,U+		; Needs to be one.

					CLR		,U+

					RTS



RENDER_MAZE			PSHS	A,B,X,Y,U

					LDD		#0
					STD		TO_SCREEN_TRANS3D_OBJX,PCR
					STD		TO_SCREEN_TRANS3D_OBJY,PCR
					STD		TO_SCREEN_TRANS3D_OBJZ,PCR
					STD		TO_SCREEN_TRANS3D_OBJH,PCR
					STA		TO_SCREEN_TRANS3D_OBJB,PCR

					LEAX	MAZEDATA,PCR
					STX		TO_SCREEN_GEOMDATAADDR,PCR
					LEAX	MAZEDATA_VTX_TFMBUF,PCR
					STX		TO_SCREEN_TFMBUFADDR,PCR

					LDU		#COMMON_LINEBUFPTR
					LEAY	4,U

					LEAU	5,U
					LDA		,Y
					LDB		#6
					MUL
					LEAU	D,U
					STU		TO_SCREEN_LINEOUTADDR,PCR

					LBSR	TO_SCREEN

					LDA		TO_SCREEN_NUMLINE,PCR
					ADDA	,Y
					STA		,Y

					PULS	A,B,X,Y,U
					RTS



RENDER_MAZE_FLUSH
					LDU		#COMMON_LINEBUFPTR
					STU		CALL_LINEDDA_SUBCPU_DATAADDR,PCR
					LBSR	CALL_CLS_AND_LINEDDA_SUBCPU
					RTS



